/* -*- pse-c -*-
 *-----------------------------------------------------------------------------
 * Filename: psb_intregs.h
 *-----------------------------------------------------------------------------
 * INTEL CONFIDENTIAL
 * Copyright (2002-2008) Intel Corporation All Rights Reserved.
 * The source code contained or described herein and all documents related to
 * the source code ("Material") are owned by Intel Corporation or its suppliers
 * or licensors. Title to the Material remains with Intel Corporation or its
 * suppliers and licensors. The Material contains trade secrets and proprietary
 * and confidential information of Intel or its suppliers and licensors. The
 * Material is protected by worldwide copyright and trade secret laws and
 * treaty provisions. No part of the Material may be used, copied, reproduced,
 * modified, published, uploaded, posted, transmitted, distributed, or
 * disclosed in any way without Intel's prior express written permission.
 * 
 * No license under any patent, copyright, trade secret or other intellectual
 * property right is granted to or conferred upon you by disclosure or
 * delivery of the Materials, either expressly, by implication, inducement,
 * estoppel or otherwise. Any license under such intellectual property rights
 * must be express and approved by Intel in writing.
 * 
 * 
 *-----------------------------------------------------------------------------
 * Description:
 *  This file contains the interrupt related register definition  and
 *  macros for the PLB platform. 
 *-----------------------------------------------------------------------------
 */

#ifndef _REGS_H_
#define _REGS_H_

/*-----------------------------------------------------------------------------
 * SGX, VDC, and MSVDX interrupt registers
 ----------------------------------------------------------------------------*/
//#define SGX_BASE 0x40000

#define PSB_MMIO_RESOURCE        0

#define PSB_VDC_OFFSET           0x00000000
#define PSB_VDC_SIZE             0x000080000
#define PSB_SGX_OFFSET           0x00040000
#define PSB_SGX_SIZE             0x8000
#define PSB_MSVDX_OFFSET         0x00050000
#define PSB_MSVDX_SIZE           0x1000

/* bits in PSB_CR_EVENT_STATUS */
#define PSB_DPM_3D_MEM_FREE    (1<<0)
#define PSB_OUT_OF_MEM_MT      (1<<1)
#define PSB_OUT_OF_MEM_GBL     (1<<2)
#define PSB_REACHED_MEM_THRESH (1<<3)
#define PSB_TA_TERMINATE       (1<<12)
#define PSB_TA_FINISHED        (1<<13)
#define PSB_PIXELBE_END_RENDER (1<<18)
#define PSB_DPM_TA_MEM_FREE    (1<<24)
#define PSB_DPM_OUT_OF_MEM_ZLS (1<<25)
#define PSB_TWOD_COMPLETE      (1<<27)
#define PSB_TA_DPM_FAULT       (1<<28)

#define PSB_BIF_REQ_FAULT      (1<<4)
#define PSB_TRIG_DL            (1<<5)
#define PSB_TRIG_3D            (1<<6)
#define PSB_TRIG_TA            (1<<7)

#define PSB_CR_EVENT_HOST_ENABLE2               0x0110
#define PSB_CR_EVENT_HOST_CLEAR2                0x0114
#define PSB_CR_EVENT_STATUS2                    0x0118

#define PSB_CR_EVENT_HOST_ENABLE                0x0130
#define PSB_CR_EVENT_HOST_CLEAR                 0x0134
#define PSB_CR_EVENT_STATUS                     0x012C

#define PSB_MTX_EVENT_HOST_ENABLE               0x0610
#define PSB_MTX_EVENT_CLEAR                     0x060C
#define PSB_MTX_EVENT_STATUS                    0x0608

/*-----------------------------------------------------------------------------
 * Memory mapped I/O Registers Definitions
 *---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 * Instruction and Interrupt Control Registers (01000h - 02FFFh)
 *---------------------------------------------------------------------------*/
#define HWSTAM            0x02098  /* Hardware Status Mask */
#define IER               0x020A0  /* Interrupt Enable */
#define IIR               0x020A4  /* Interrupt Identity */
#define IMR               0x020A8  /* Interrupt Mask */
#define ISR               0x020AC  /* Interrupt Status */

#define PIPEA_STAT             0x70024  /* Pipe A Display Status */
#define PIPEB_STAT             0x71024  /* Pipe B Display Status */

#define VBLANK_CLEAR		(1<<1)
#define VSYNC_PIPEB_FLAG	(1<<5)
#define VSYNC_PIPEA_FLAG	(1<<7)
#define VBLANK_INTERRUPT_ENABLE (1<<17)
#define IRQ_SGX_FLAG		(1<<18)
#define IRQ_MSVDX_FLAG       	(1<<19)

#define PSB_WVDC32(_val, _offs) \
  iowrite32(_val, priv->vdc_reg + (_offs))
#define PSB_RVDC32(_offs) \
  ioread32(priv->vdc_reg + (_offs))
#define PSB_WSGX32(_val, _offs) \
  iowrite32(_val, priv->sgx_reg + (_offs))
#define PSB_RSGX32(_offs) \
  ioread32(priv->sgx_reg + (_offs))
#define PSB_WMSVDX32(_val, _offs) \
  iowrite32(_val, priv->msvdx_reg + (_offs))
#define PSB_RMSVDX32(_offs) \
  ioread32(priv->msvdx_reg + (_offs))

#endif /* _REGS_H_ */
