package com.test.testinstallerproxy;

import androidx.appcompat.app.AppCompatActivity;

import android.content.Intent;
import android.content.IntentFilter;
import android.content.Context;
import android.content.BroadcastReceiver;
import android.content.ComponentName;

import static android.content.pm.PackageInstaller.STATUS_PENDING_USER_ACTION;
import static android.content.pm.PackageInstaller.STATUS_SUCCESS;
import static android.content.pm.PackageInstaller.STATUS_FAILURE;
import static android.content.pm.PackageInstaller.STATUS_FAILURE_BLOCKED;
import static android.content.pm.PackageInstaller.STATUS_FAILURE_ABORTED;
import static android.content.pm.PackageInstaller.STATUS_FAILURE_INVALID;
import static android.content.pm.PackageInstaller.STATUS_FAILURE_CONFLICT;
import static android.content.pm.PackageInstaller.STATUS_FAILURE_STORAGE;
import static android.content.pm.PackageInstaller.STATUS_FAILURE_INCOMPATIBLE;

import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.os.Parcelable;

import android.net.Uri;

import android.util.Log;

import java.io.File;

public class MainActivity extends AppCompatActivity {

    private static final String TAG = "TestInstallerProxy";

    private static final String ACTION_INSTALL =
	"hk.topicon.utility.packageinstallerproxy.UPDATE";
    private static final String ACTION_REMOVE =
	"hk.topicon.utility.packageinstallerproxy.REMOVE";
    private static final String ACTION_INSTALL_CBK =
	"hk.topicon.utility.packageinstallerproxy.UPDATE_CBK";
    private static final String ACTION_REMOVE_CBK =
	"hk.topicon.utility.packageinstallerproxy.REMOVE_CBK";

    public static final String RESTART_ACTIVITY_KEY = "restart_activity";
    public static final String GRANT_PERMISSION_KEY = "grant_permission";
    public static final String CALLBACK_ID_KEY = "callback_id";
    public static final String INSTALL_STATUS_KEY = "install_status";
    public static final String INSTALL_MSG_KEY =  "install_msg";
    public static final String PACKAGE_NAME_KEY = "package_name";

    private static final ComponentName PROXY =
	new ComponentName("hk.topicon.utility.packageinstallerproxy",
			  "hk.topicon.utility.packageinstallerproxy.PackageInstallerService");

    private static final File TEST_APK = new File("/sdcard/Test.apk");
    private static final String TEST_PKG = "com.test.package";
    private static final ComponentName TEST_APK_COMP =
	new ComponentName("com.test.package",
			  "com.test.package.main");

    private final Handler HANDLER = new Handler();

    private final int CALLBACK_ID = Process.myTid();

    private final BroadcastReceiver CALLBACK_RECEIVER =
	new BroadcastReceiver() {
	    @Override
	    public void onReceive(Context context, Intent intent) {

		if(intent == null)
		    return;

		final String ACTION = intent.getAction();

		Log.d(TAG, "onReceive : " + ACTION);
		
		final int ID = intent.getIntExtra(CALLBACK_ID_KEY, -1);

		if(ID == CALLBACK_ID) {
		    String pkg_name = intent.getStringExtra(PACKAGE_NAME_KEY);
		    int status = intent.getIntExtra(INSTALL_STATUS_KEY,
						    STATUS_FAILURE);
		    String msg = intent.getStringExtra(INSTALL_MSG_KEY);

		    Log.d(TAG, ACTION + " for " + pkg_name +
			  " , status : " + status + " , msg : " + msg);
		}
	    }
	};

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

	IntentFilter filter = new IntentFilter();
	filter.addAction(ACTION_INSTALL_CBK);
	filter.addAction(ACTION_REMOVE_CBK);
	Log.d(TAG, "register callback, id : " + CALLBACK_ID);
	registerReceiver(CALLBACK_RECEIVER, filter);
	

	// Test installation without permissions
	//HANDLER.post(() -> testInstall(false, false, CALLBACK_ID));

	// Test installation with permissions
	//HANDLER.post(() -> testInstall(true, false, CALLBACK_ID));

	// Test installation with permission and restart
	//HANDLER.post(() -> testInstall(true, true, CALLBACK_ID));

	// Test removal
	HANDLER.post(() -> testRemoval(CALLBACK_ID, TEST_PKG));
    }

    private void testInstall(boolean grant_perm, boolean to_restart,
			     int callback_id) {

	Log.d(TAG, "testInstall, grant_perm : " + grant_perm +
	      " , to_restart : " + to_restart +
	      " , callback_id : " + callback_id);

	Uri data = Uri.fromFile(TEST_APK);
	Intent intent = new Intent(ACTION_INSTALL, data);
	intent.setComponent(PROXY);

	if(to_restart)
	    intent.putExtra(RESTART_ACTIVITY_KEY, (Parcelable) TEST_APK_COMP);

	if(grant_perm)
	    intent.putExtra(GRANT_PERMISSION_KEY, true);

	if(callback_id >= 0)
	    intent.putExtra(CALLBACK_ID_KEY, callback_id);

	startService(intent);
    }

    private void testRemoval(int callback_id, String pkg) {
	Intent intent = new Intent(ACTION_REMOVE);
	intent.setComponent(PROXY);
	intent.putExtra(PACKAGE_NAME_KEY, pkg);
	if(callback_id >= 0)
	    intent.putExtra(CALLBACK_ID_KEY, callback_id);
	startService(intent);
    }

    @Override
    protected void onDestroy() {
	Log.d(TAG, "onDestroy");
	unregisterReceiver(CALLBACK_RECEIVER);
	super.onDestroy();
    }
}
