#pragma once
#include "afxwin.h"
#include "afxcmn.h"

#define SETTINGS_PACKS 4
// CPanelSettings dialog
class CDcDcUsbDlg;

class CPanelSettings : public CDialog
{
	DECLARE_DYNAMIC(CPanelSettings)

public:
	CPanelSettings(CDcDcUsbDlg* mainDlg, CWnd* pParent = NULL);   // standard constructor
	virtual ~CPanelSettings();

// Dialog Data
	enum { IDD = IDD_DIALOG_SETTINGS };

public:
	void LoadValues(bool visual);
	void AddPackage(unsigned long address, unsigned long length, HArray* parray);

	static CString ConvertOneValue(unsigned char* buffer, int nLen, int nIndex, int nReadMode, double dMultiplier);
	static bool ReadOneValue(CString str, int nReadMode, double dMultiplier, int len, unsigned char &c1, unsigned char &c2);

	void SendValue(int msg_no, CString str);
	void resetAll(bool visual);

	int getLoadStatus();
protected:
	bool writeIniToDevice();

	CDcDcUsbDlg* m_pMainDlg;
	bool m_bPackagesArrived[SETTINGS_PACKS];
	unsigned char m_chPackages[SETTINGS_PACKS*16];

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButtonLoaddefval();
	CComboBox m_comboMessage;
	CEdit m_editMessage;
	CStatic m_sUnit;
	CStatic m_sComment;
	afx_msg void OnBnClickedButtonSendsettings();
	virtual BOOL OnInitDialog();
	CButton m_bSend;
	afx_msg void OnCbnSelchangeComboMessage();
	afx_msg void OnBnClickedButtonReadsettings();
	afx_msg void OnBnClickedButtonWritesettings();
	CProgressCtrl m_progressRW;
	CStatic m_staticRW;
};
