// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the NUCUPSLIB_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// NUCUPSLIB_API functions as being imported from a DLL, whereas this DLL sees symbols
// defined with this macro as being exported.
#ifdef NUCUPSLIB_EXPORTS
#define NUCUPSLIB_API __declspec(dllexport)
#else
#define NUCUPSLIB_API __declspec(dllimport)
#endif

#define DCMD_SPI_WRITE_DATA_VOL_VOUT	0x30
#define DCMD_SPI_INC_VOL_WIPER_VOUT		0x32
#define DCMD_SPI_DEC_VOL_WIPER_VOUT		0x33
#define DCMD_RELOAD_PARAMS_ON_FLY		0x03

#define SIZEOFSTR(a) (sizeof(a)/sizeof(char*)) //get the size of STATE_MACHINE_... with SIZEOFSTR(STATE_MACHINE_...)

extern "C" NUCUPSLIB_API const char* STATE_MACHINE_UPS[14];//state machine UPS
extern "C" NUCUPSLIB_API const char* STATE_MACHINE_AFE[8];//state machine AFE
extern "C" NUCUPSLIB_API const char* STATE_MACHINE_CHG[16];//state machine Charger
extern "C" NUCUPSLIB_API const char* STATE_MACHINE_DTCT[16];//state machine Detect
extern "C" NUCUPSLIB_API const char* STATE_MACHINE_LOWP[4];//state machine low power states

extern "C" NUCUPSLIB_API unsigned char nucupsOpenDeviceHandler(unsigned int timer);//open device handler. timer sets the refresh period in miliseconds (3 or 5 messages will be sent in this period deending from debug mode) IMPORTANT: the handler can be kept open to notice any NUC-UPS plugged in
extern "C" NUCUPSLIB_API void nucupsCloseDeviceHandler();//close device handler
extern "C" NUCUPSLIB_API void getNUCUpsDevicePath(char* path);//Get opened device path @param path - recommended length 1024, will return empty string if no device opened

extern "C" NUCUPSLIB_API unsigned char isNUCUpsConnected();//0=not connected, 1=normal state,2=loading settings from device,3=saving settings from pc,4=saving settings from file

extern "C" NUCUPSLIB_API unsigned char getNUCUpsMode();//get NUC-UPS mode: 0=Dumb, 1=Automotive

extern "C" NUCUPSLIB_API unsigned int  getNUCUpsInputFlags();//get NUC-UPS input flags
extern "C" NUCUPSLIB_API unsigned int  getNUCUpsOutputFlags();//get NUC-UPS output flags
extern "C" NUCUPSLIB_API unsigned int  getNUCUpsChargerFlags();//get NUC-UPS charger flags
extern "C" NUCUPSLIB_API unsigned int  getNUCUpsStateFlags();//get NUC-UPS state flags
extern "C" NUCUPSLIB_API unsigned int  getNUCUpsShutdownFlags();//get NUC-UPS shutdown flags

extern "C" NUCUPSLIB_API float getNUCUpsVIn();//get NUC-UPS Input Voltage
extern "C" NUCUPSLIB_API float getNUCUpsIOut();//get NUC-UPS Output Current
extern "C" NUCUPSLIB_API float getNUCUpsVOut();//get NUC-UPS Output voltage
extern "C" NUCUPSLIB_API float getNUCUpsVBats(int i);//get NUC-UPS battery voltages
extern "C" NUCUPSLIB_API float getNUCUpsTemperature(int i);//get NUC-UPS battery temperature
extern "C" NUCUPSLIB_API unsigned char getNUCUpsCellBalanceOn(int i);//get NUC-UPS balanced battery (discharged)
extern "C" NUCUPSLIB_API unsigned char getNUCUpsCellDetected(int i);//get NUC-UPS battery detected
extern "C" NUCUPSLIB_API float getNUCUpsVIgnition();//get NUC-UPS Ignition Voltage
extern "C" NUCUPSLIB_API float getNUCUpsPOut();//get NUC-UPS Output Power
extern "C" NUCUPSLIB_API float getNUCUpsVBat();//get NUC-UPS Bat voltage
extern "C" NUCUPSLIB_API float getNUCUpsVPack();//get NUC-UPS Pack voltage
extern "C" NUCUPSLIB_API float getNUCUpsIChgDchg();//get NUC-UPS Charge/Discharge current

extern "C" NUCUPSLIB_API unsigned int getNUCUpsSpecConsts(unsigned int type, unsigned int index);//get NUC-UPS special constants

extern "C" NUCUPSLIB_API unsigned char getNUCUpsVerMajor();//get NUC-UPS major version of the firmware
extern "C" NUCUPSLIB_API unsigned char getNUCUpsVerMinor();//get NUC-UPS minor version of the firmware

extern "C" NUCUPSLIB_API unsigned char getNUCUpsState();//0 - not connected, 1 - running from battery, 2 - from vin, 3 - from USB

extern "C" NUCUPSLIB_API void setNUCUpsDBGMode(unsigned char dbg);//set dbg mode 
extern "C" NUCUPSLIB_API unsigned char getNUCUpsDbgByte(int i);//get NUC-UPS debug bytes - valid only after setNUCUpsDBGMode(1)
extern "C" NUCUPSLIB_API unsigned char getNUCUpsDbg2Byte(int i);//get NUC-UPS debug bytes - valid only after setNUCUpsDBGMode(1)
extern "C" NUCUPSLIB_API unsigned char getNUCUpsDbg3Byte(int i);//get NUC-UPS debug bytes - valid only after setNUCUpsDBGMode(1)

extern "C" NUCUPSLIB_API unsigned int  getNUCUpsTimer(unsigned int cnt);//get NUC-UPS timer
extern "C" NUCUPSLIB_API unsigned int  getNUCUpsStateMachines(unsigned int cnt);//get NUC-UPS internal state machines 0=UPS 1=AFE 2=Charger 3=Detect 4=Batterymanager
extern "C" NUCUPSLIB_API unsigned int  getNUCUpsChgTimer(unsigned int cnt);//get NUC-UPS charger timers

extern "C" NUCUPSLIB_API unsigned char getNUCUpsChargeEndedCondition();//get NUC-UPS charge ended
extern "C" NUCUPSLIB_API unsigned char getNUCUpsBatteryLevel();//get NUC-UPS battery level (percents 0-100)
extern "C" NUCUPSLIB_API unsigned int getNUCUpsCPUUsage();//get NUC-UPS CPU usage

extern "C" NUCUPSLIB_API void restartNUCUps();//restart NUC-UPS 
extern "C" NUCUPSLIB_API void restartNUCUpsInBootloaderMode();//restart NUC-UPS in bootloader mode

extern "C" NUCUPSLIB_API void setNUCUpsCommand1Byte(unsigned char command, unsigned char value);//NUC-UPS direct commands (for debugging)
extern "C" NUCUPSLIB_API void setNUCUpsCommand2Byte(unsigned char command, unsigned int  value);//NUC-UPS direct commands (for debugging)
extern "C" NUCUPSLIB_API void setNUCUpsBuffer(int len, unsigned char* values);//NUC-UPS direct commands (for debugging)

///////////////////////////////////////////////////////////////
extern "C" NUCUPSLIB_API unsigned int getNUCUpsMaxVariableCnt();//get NUC-UPS maximum variable count
extern "C" NUCUPSLIB_API unsigned char getNUCUpsVariableData(unsigned int cnt, char* name, char* value, char* unit, char* comment);//get NUC-UPS variable data
extern "C" NUCUPSLIB_API void startNUCUpsLoadingSettings(unsigned char to_file, unsigned char compare_with_old);//start loading data from device
extern "C" NUCUPSLIB_API unsigned char getNUCUpsLoadingSettingsState();//get load settings current state: 0-64 - steps, 100=success, 0xF1-0xFF=failure
extern "C" NUCUPSLIB_API unsigned char setNUCUpsVariableData(unsigned int cnt, char* value);//set NUC-UPS variable data for a given variable 
extern "C" NUCUPSLIB_API void startNUCUpsSaveSettings(unsigned char from_file);//start saving data to device
extern "C" NUCUPSLIB_API unsigned char getNUCUpsSaveSettingsState();//get saving current state: 0-64 - steps, 100=success, 0xF1-0xFF=failure

