// QMultiplexerDlg.cpp : implementation file
//

#include "stdafx.h"
#include "QMultiplexer.h"
#include "QMultiplexerDlg.h"
#include "VideoQualityDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

VOID Dbg( CHAR* pszStr, ... )
{
	char szData[ MAX_PATH ] = "[SC] ";

	va_list args;

	va_start( args, pszStr );

	_vsnprintf( szData + 5, sizeof( szData ) - 1, pszStr, args );

	va_end( args );

    strcat( szData, "\n" );

	OutputDebugString( szData );
}

// INITIALIZE STATIC CLASS VARIABLE 
//
CHAR CQMultiplexerDlg::s_sz_dlg_title[ MAX_PATH ] = { 0 };

CRect CQMultiplexerDlg::s_rect_slipts_display[ 4 * 4 ] = { 0 };

BYTE CQMultiplexerDlg::s_n_splits_division = 2;

ULONG CQMultiplexerDlg::s_n_max_device_count = 0;

ULONG CQMultiplexerDlg::s_n_device_count = 0;

CQMultiplexerDlg* CQMultiplexerDlg::s_pCQMultiplexerDlgMainDlg = 0;

//  FORMAT CHANGED CALLBACK FUNCTION
//
QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, ULONG nVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
	CQMultiplexerDlg* pMainDlg = CQMultiplexerDlg::s_pCQMultiplexerDlgMainDlg;

	ULONG nChannelNum = (ULONG)pUserData;

	// OUTPUT FORMAT CHANGED MESSAGE
	//
	CHAR strVideoInput[ MAX_PATH ] = { 0 };

	CHAR strAudioInput[ MAX_PATH ] = { 0 };

	CHAR strFrameType[ MAX_PATH ] = { 0 }; 

    UINT nVH = 0;
            
    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); pMainDlg->m_oMenuInfo[ nChannelNum ].nSourceType = 4;	}
 	
	if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); pMainDlg->m_oMenuInfo[ nChannelNum ].nSourceType = 5; }
	
	if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );  pMainDlg->m_oMenuInfo[ nChannelNum ].nSourceType = 0; }

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" ); pMainDlg->m_oMenuInfo[ nChannelNum ].nSourceType = 1; }
	
	if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" ); pMainDlg->m_oMenuInfo[ nChannelNum ].nSourceType = 2; }
	
	if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" ); pMainDlg->m_oMenuInfo[ nChannelNum ].nSourceType = 3; }
	
    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" ); pMainDlg->m_oMenuInfo[ nChannelNum ].nSourceType = 6; }
	
	if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" ); pMainDlg->m_oMenuInfo[ nChannelNum ].nSourceType = 7; }

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}
	
	if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" );}

	if ( nVideoHeight == 1080 ) { pMainDlg->m_oMenuInfo[ nChannelNum ].nResolutionType = 0; }

	if ( nVideoHeight == 720 ) { pMainDlg->m_oMenuInfo[ nChannelNum ].nResolutionType = 1; }

	if ( nVideoHeight == 576 ) { pMainDlg->m_oMenuInfo[ nChannelNum ].nResolutionType = 2; }

	if ( nVideoHeight == 480 ) { pMainDlg->m_oMenuInfo[ nChannelNum ].nResolutionType = 3; }

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " );; }

	pMainDlg->m_strFormatChangedOutput[ nChannelNum ].Format( "INFO : %d x %d%s @%d FPS , %d CH x %d BITS x %d HZ ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s",

																			nVideoWidth,

																			nVH,

																			strFrameType,

																			nVideoFrameRate,

																			nAudioChannels,

																			nAudioBitsPerSample,

																			nAudioSampleFrequency,

																			strVideoInput,

																			strAudioInput );

    // NO SOURCE
    //
    if ( nVideoWidth == 0 && 
		
		 nVideoHeight == 0 &&

		 nVideoFrameRate == 0 &&

		 nAudioChannels == 0 &&

		 nAudioBitsPerSample == 0 &&

		 nAudioSampleFrequency == 0 ) {

		pMainDlg->m_bNoSignal[ nChannelNum ] = TRUE;

		pMainDlg->m_oChannelWindow_LIVE[ nChannelNum ].ShowWindow( FALSE );

		pMainDlg->m_oChannelWindows_BKGND[ nChannelNum ].ShowWindow( TRUE );	
	}
    else {

		pMainDlg->m_bNoSignal[ nChannelNum ] = FALSE;

		pMainDlg->m_oChannelWindow_LIVE[ nChannelNum ].ShowWindow( TRUE );

		pMainDlg->m_oChannelWindows_BKGND[ nChannelNum ].ShowWindow( FALSE );	
    }

    return QCAP_RT_OK;
}  

// NO SIGNAL DETEACTED CALLBACK FUNCTION
//
QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	CQMultiplexerDlg* pMainDlg = CQMultiplexerDlg::s_pCQMultiplexerDlgMainDlg;

	ULONG nCannelNumber = (ULONG)pUserData;

	Dbg("No Signal Detected  \n");

	pMainDlg->m_bNoSignal[ nCannelNumber ] = TRUE;

	pMainDlg->m_oChannelWindow_LIVE[ nCannelNumber ].ShowWindow( FALSE );

	pMainDlg->m_oChannelWindows_BKGND[ nCannelNumber ].ShowWindow( TRUE );

	return QCAP_RT_OK;
}

// SIGNAL REMOVED CALLBACK FUNCTION
//
QRETURN on_process_signal_removed(PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData)
{
	CQMultiplexerDlg* pMainDlg = CQMultiplexerDlg::s_pCQMultiplexerDlgMainDlg;

	ULONG nCannelNumber = (ULONG)pUserData;

	Dbg(" Signal Removed \n");

	pMainDlg->m_bNoSignal[ nCannelNumber ] = TRUE;

	pMainDlg->m_oChannelWindow_LIVE[ nCannelNumber ].ShowWindow( FALSE );

	pMainDlg->m_oChannelWindows_BKGND[ nCannelNumber ].ShowWindow( TRUE );

    return QCAP_RT_OK;
}

// PREVIEW VIDEO CALLBACK FUNCTION
//
QRETURN on_process_preview_video_buffer(PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{	
	CQMultiplexerDlg* pMainDlg = CQMultiplexerDlg::s_pCQMultiplexerDlgMainDlg;

	ULONG nChannelNum = (ULONG)pUserData;

    return QCAP_RT_OK;
}

// PREVIEW AUDIO CALLBACK FUNCTION
//
QRETURN on_process_preview_audio_buffer(PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    return QCAP_RT_OK;
}

/////////////////////////////////////////////////////////////////////////////
// CQMultiplexerDlg dialog

CQMultiplexerDlg::CQMultiplexerDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CQMultiplexerDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CQMultiplexerDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CQMultiplexerDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CQMultiplexerDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CQMultiplexerDlg, CDialog)
	//{{AFX_MSG_MAP(CQMultiplexerDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_WM_ERASEBKGND()
	ON_COMMAND(IDR_MENU_CSOURC_HDMI, OnMenuCsourcHdmi)
	ON_COMMAND(IDR_MENU_CSOURC_COMPONENTS, OnMenuCsourcComponents)
	ON_COMMAND(IDR_MENU_CSOURC_SVIDEO, OnMenuCsourcSvideo)
	ON_COMMAND(IDR_MENU_CSOURC_COMPOSITE, OnMenuCsourcComposite)
	ON_COMMAND(IDR_MENU_CSOURC_DVID, OnMenuCsourcDvid)
	ON_COMMAND(IDR_MENU_CSOURC_DVIA, OnMenuCsourcDvia)
	ON_COMMAND(IDR_MENU_CSOURC_SDI, OnMenuCsourcSdi)
	ON_COMMAND(IDR_MENU_CSOURC_AUTO, OnMenuCsourcAuto)
	ON_COMMAND(ID_MENU_STANDARD_NTSC, OnMenuStandardNtsc)
	ON_COMMAND(IDR_MENU_STANDARD_PAL, OnMenuStandardPal)
	ON_COMMAND(IDR_MENU_RESOLUTION_1920X1080, OnMenuResolution1920x1080)
	ON_COMMAND(IDR_MENU_RESOLUTION_1280X720, OnMenuResolution1280x720)
	ON_COMMAND(IDR_MENU_RESOLUTION_720X576, OnMenuResolution720x576)
	ON_COMMAND(IDR_MENU_RESOLUTION_720X480, OnMenuResolution720x480)
	ON_COMMAND(IDR_MENU_STREAM_1_START_RECODE, OnMenuStream1StartRecode)
	ON_COMMAND(IDR_MENU_STREAM_1_STOP_RECODE, OnMenuStream1StopRecode)
	ON_COMMAND(IDR_MENU_STREAM_2_START_RECODE, OnMenuStream2StartRecode)
	ON_COMMAND(IDR_MENU_STREAM_2_STOP_RECODE, OnMenuStream2StopRecode)
	ON_COMMAND(IDR_MENU_STREAM_3_START_RECODE, OnMenuStream3StartRecode)
	ON_COMMAND(IDR_MENU_STREAM_3_STOP_RECODE, OnMenuStream3StopRecode)
	ON_COMMAND(IDR_MENU_AUDIO_TURN_OFF, OnMenuAudioTurnOff)
	ON_COMMAND(IDR_MENU_AUDIO_TURN_ON, OnMenuAudioTurnOn)
	ON_COMMAND(IDR_MENU_SAVE_BITMAP, OnMenuSaveBitmap)
	ON_COMMAND(IDR_MENU_SAVE_JPEG, OnMenuSaveJpeg)
	ON_COMMAND(IDC_RADIO_INPUT_EMBEDDED_AUDIO, OnRadioInputEmbeddedAudio)
	ON_COMMAND(IDC_RADIO_INPUT_LINEIN, OnRadioInputLinein)
	ON_COMMAND(IDR_MENU_SET_VIDEO_CONFIG, OnMenuSetVideoConfig)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CQMultiplexerDlg message handlers

BOOL CQMultiplexerDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here

	// INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}
	// INITIALIZE USER INTERFACE RESOURCE
	//
	{	AMESDK_CAPTURE_DEVICE_ENUMERATION(	NULL, &CQMultiplexerDlg::s_n_device_count,  NULL, NULL, NULL, NULL, NULL, NULL );		// AUTOMATLLY GET DEVICE COUNT

		if ( CQMultiplexerDlg::s_n_device_count ) {

			if ( CQMultiplexerDlg::s_n_device_count <= (2*2) ){ CQMultiplexerDlg::s_n_max_device_count = 4; CQMultiplexerDlg::s_n_splits_division = 2; }		// GET GRID'S X NUMBER
			
			else if ( CQMultiplexerDlg::s_n_device_count <= (3*3) ) { CQMultiplexerDlg::s_n_max_device_count = 9; CQMultiplexerDlg::s_n_splits_division = 3; }
			
			else if ( CQMultiplexerDlg::s_n_device_count <= (4*4) ) { CQMultiplexerDlg::s_n_max_device_count = 16; CQMultiplexerDlg::s_n_splits_division = 4; }
		}
		else {

			CQMultiplexerDlg::s_n_max_device_count = QC_DEFAULT_MAX_CHANNEL_NUM;	
			
			CQMultiplexerDlg::s_n_splits_division = QC_DEFAULT_GRID_DIVISIONS;		// GET GRID'S X NUMBER
		}

		// INITILIZE DEVICE SOURCE
		//
		for ( ULONG i = 0; i < 4 * 4; i++ ) {

			m_hVideoDevice[ i ] = 0;

			m_oMenuInfo[ i ].nSourceType = 0xFF;

			m_oMenuInfo[ i ].nResolutionType = 0xFF;

			m_oMenuInfo[ i ].nStandardType = 0xFF;

			m_oMenuInfo[ i ].nRecordType1 = 1;		// POSITIONS

			m_oMenuInfo[ i ].nRecordType2 = 1;

			m_oMenuInfo[ i ].nRecordType3 = 1;

			m_oMenuInfo[ i ].nAudioType = 0;

			m_oMenuInfo[ i ].nAudioInput = 0;

			m_bNoSignal[ i ] = FALSE;
		}

		m_hCloneCapDev = 0;

		m_nAudioPlayChannel = -1;

		m_nWndState = 0x00000000;		// 0 = SPLIT, 1 = FULL SCREEN

		m_nWndowLayoutType = 0;			// 0 = NORMAL TYPE, 1 = MUX 2x2 TYPE

		m_nMainWindowNum = 0;			// WHEN MAIN WINDOW OF MUX TYPE

		m_nCurRBntNum = -1;

		m_nSharpness = 128;

		m_nSaturation = 128;

		m_nHue = 128;

		m_nConstrast = 128;

		m_nBrightness = 128;

		pYUVCopy = (BYTE*)HeapAlloc( GetProcessHeap(), HEAP_ZERO_MEMORY, 1920*1080*2 );

		pRGB = (BYTE*)HeapAlloc( GetProcessHeap(), HEAP_ZERO_MEMORY, 1920*1080*4 );

		// CString INITILIZE
		//
		::GetModuleFileName( 0, m_strRecordPath.GetBufferSetLength( MAX_PATH + 1 ), MAX_PATH );			// SET PATH
		
		m_strRecordPath.ReleaseBuffer();

		ULONG nPos;

		nPos = m_strRecordPath.ReverseFind('\\');
		
		m_strRecordPath = m_strRecordPath.Left( nPos );		// GET PATH		

		// CREATE AND MAINTIN LAYOUT
		//		
		SetWindowPos( NULL, 0, 0, GetSystemMetrics( SM_CXSCREEN ), GetSystemMetrics( SM_CYSCREEN ), SWP_NOMOVE );		// SET THE SIZE OF MAIN DIALOG
		
		SetWindowPos( &CWnd::wndTop,0, 0, 0, 0, SWP_NOSIZE );		// SET THE LOCATION OF MAIN DIALOG

		m_oControlPanelDlg.Create( IDD_CONTROL_DIALOG, this );		// CREATE AND INITIALIZE CCONTROLPANEL

		CRect oControlDlgRect; m_oControlPanelDlg.GetWindowRect( &oControlDlgRect );		// SET THE SIZE OF MAIN DIALOG

		ULONG cx, cy;
		
		cx = oControlDlgRect.right - oControlDlgRect.left;

		cy = oControlDlgRect.bottom - oControlDlgRect.top;
		
		m_oControlPanelDlg.SetWindowPos( &CWnd::wndTop, GetSystemMetrics( SM_CXSCREEN ) / 2 - cx / 2, ( GetSystemMetrics( SM_CYSCREEN ) / 2 - cy / 2 ) + (  GetSystemMetrics( SM_CYSCREEN ) / 2 - cy / 2 ), 0, 0, SWP_NOSIZE );		// SET THE LOCATION OF MAIN DIALOG

		m_oControlPanelDlg.ShowWindow( TRUE );

		
		CHAR szStr[ MAX_PATH ] = { 0 };

		for ( i = 0; i < CQMultiplexerDlg::s_n_max_device_count; i++ ) {			

			CQMultiplexerDlg::s_rect_slipts_display[ i ] = GetSplitWndPos_CQMultiplexerDlg(	i,
									
																							CQMultiplexerDlg::s_n_splits_division,
									
																							GetSystemMetrics( SM_CXSCREEN ),
									
																							GetSystemMetrics( SM_CYSCREEN ) );

			sprintf( szStr, "MyChannelWindow#LIVE#%02d", i + 1 );

			m_oChannelWindow_LIVE[ i ].Create(	NULL,

												szStr,

												WS_CHILD | WS_VISIBLE | WS_BORDER,

												CQMultiplexerDlg::s_rect_slipts_display[ i ],

												this,

												i + 0x00000001,

												NULL );	

			sprintf( szStr, "MyChannelWindow#BKGND#%02d", i + 1 );
			
			m_oChannelWindows_BKGND[ i ].Create(	NULL,
													
													szStr,
													
													WS_CHILD | WS_VISIBLE | WS_BORDER,
													
													CQMultiplexerDlg::s_rect_slipts_display[ i ],
													
													this,
													
													i + 0x10000001,
													
													NULL );		// BACKGROUND WINDOW

			
			m_oChannelWindow_LIVE[ i ].ShowWindow( TRUE );

			m_oChannelWindows_BKGND[ i ].ShowWindow( FALSE );
		}		
		
		sprintf( CQMultiplexerDlg::s_sz_dlg_title, "  Multiplexer Control Panel %s", QC_DEFAULT_SOFTWARE_VERSION );		// SET THE CAPTION OF THE DIALOG

		m_oControlPanelDlg.SetWindowText( CQMultiplexerDlg::s_sz_dlg_title );

		s_pCQMultiplexerDlgMainDlg = this;
		
		HwInitialize();		// INITIALIZE DEVICE RESOURCE
	}

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CQMultiplexerDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CQMultiplexerDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


BOOL CQMultiplexerDlg::HwInitialize()
{
	// CREATE AND INITIALIZE DEVICE
	//
	PVOID params[ 4 * 4 ] = { 0 };

	// CALLBACK FUNCTION
	//	
	PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB[ 4 * 4 ] = { 0 };

	PF_VIDEO_PREVIEW_CALLBACK m_pPreviewVideoCB[ 4 * 4 ] = { 0 };

	PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB[ 4 * 4 ] = { 0 };

	PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB[ 4 * 4 ] = { 0 };

	PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB[ 4 * 4 ] = { 0 };

	// ACCORDING TO DEVICE
	//
	for ( ULONG i = 0; i < CQMultiplexerDlg::s_n_max_device_count; i++  ) {

		params[ i ] = (PVOID)(i);

		// CREATE CAPTURE DEVICE
		//
		QCAP_CREATE( "SA7160 PCI", i, m_oChannelWindow_LIVE[ i ].m_hWnd, &m_hVideoDevice[ i ] );

		if ( m_hVideoDevice[ i ] == 0 ) { continue;  }
		
		// REGISTER FORMAT CHANGED CALLBACK FUNCTION
		// 
		m_pFormatChangedCB[ i ] = on_process_format_changed;

		QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice[ i ], m_pFormatChangedCB[ i ], params[ i ] );

		// REGISTER PREVIEW VIDEO CALLBACK FUNCTION
		// 
		m_pPreviewVideoCB[ i ] = on_process_preview_video_buffer;

		QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], m_pPreviewVideoCB[ i ], params[ i ] );

		// REGISTER PREVIEW AUDIO CALLBACK FUNCTION
		//
		m_pPreviewAudioCB[ i ] = on_process_preview_audio_buffer;

		QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], m_pPreviewAudioCB[ i ], params[ i ] );

		// REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
		//
		m_pNoSignalDetectedCB[ i ] = on_process_no_signal_detected;

		QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice[ i ], m_pNoSignalDetectedCB[ i ], params[ i ] );

		// REGISTER SIGNAL REMOVED CALLBACK FUNCTION
		//
		m_pSignalRemovedCB[ i ] =  on_process_signal_removed;

		QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice[ i ], m_pSignalRemovedCB[ i ], params[ i ] );

		// RUN DEVICE
		//
		QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], 0 );

		QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );

		QCAP_RUN( m_hVideoDevice[ i ] );
	}

	return TRUE;
}

BOOL CQMultiplexerDlg::HwUnInitialize()
{
	if( m_hCloneCapDev != 0 ) {

		QCAP_STOP( m_hCloneCapDev );

		QCAP_DESTROY( m_hCloneCapDev );

		m_hCloneCapDev = NULL;
	}

	for ( ULONG i = 0; i < CQMultiplexerDlg::s_n_max_device_count; i++ ) {
		
		QCAP_STOP( m_hVideoDevice[ i ] );

		QCAP_DESTROY( m_hVideoDevice[ i ] );

		m_hVideoDevice[ i ] = NULL;
	}

	HeapFree( GetProcessHeap(), HEAP_ZERO_MEMORY, pRGB );

	HeapFree( GetProcessHeap(), HEAP_ZERO_MEMORY, pYUVCopy );
	
	return TRUE;
}

void CQMultiplexerDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

	// UNINITIALIZE DEVICE RESOURCE
	//
	{	HwUnInitialize();
	}

	// UNINITIALIZE USER INTERFACE
	//
	for ( ULONG i = 0; i < CQMultiplexerDlg::s_n_max_device_count; i++ ) {

		if ( m_oChannelWindow_LIVE[ i ].m_hWnd ) { m_oChannelWindow_LIVE[ i ].DestroyWindow(); }

		if ( m_oChannelWindows_BKGND[ i ].m_hWnd ) { m_oChannelWindows_BKGND[ i ].DestroyWindow(); }
	}	

	// UNINITIALIZE COM RESOURCE
	//
	{	CoUninitialize();
	}	
}

// CALCULATE EACH WINDOW LOCATION
//
CRect CQMultiplexerDlg::GetSplitWndPos_CQMultiplexerDlg( ULONG  nWindowNumber , ULONG nGridDivisions, ULONG nRendererWidth, ULONG nRendererHeight )
{
	CHAR szStr[ MAX_PATH ] = { 0 };

	ULONG nSplitsWidth = nRendererWidth / nGridDivisions;
			
	ULONG nSplitsHeight = nRendererHeight / nGridDivisions ; 

	ULONG nMaxChannel = nGridDivisions * nGridDivisions;

	ULONG x = nWindowNumber / nGridDivisions;

	ULONG y = nWindowNumber % nGridDivisions;

	ULONG top = nSplitsWidth * y;
				
	ULONG left = nSplitsHeight * x;

	ULONG bottom = top + nSplitsWidth;

	ULONG right = left + nSplitsHeight;
			
	return CRect( top, left, bottom, right );
}

BOOL CQMultiplexerDlg::OnEraseBkgnd(CDC* pDC) 
{
	// TODO: Add your message handler code here and/or call default

	return CDialog::OnEraseBkgnd(pDC);
}

BOOL CQMultiplexerDlg::OnLButtonDown_CChannelWindow( ULONG nChannelNum, UINT nFlags, CPoint point )
{
	CHAR szStr[ MAX_PATH ] = { 0 };

	CRect rect; 

	if ( m_oChannelWindow_LIVE[ MIRROR_CHANNEL ].m_hWnd ) {		// m_oChannelWindow_LIVE[ i ] HAVE BEEN CREATED BY US?

		m_oChannelWindow_LIVE[ nChannelNum ].GetClientRect( &rect );

		m_oChannelWindow_LIVE[ nChannelNum ].SetParent( CWnd::GetDesktopWindow() );				
								
		m_oChannelWindows_BKGND[ nChannelNum ].SetParent( CWnd::GetDesktopWindow() );

		m_oChannelWindow_LIVE[ MIRROR_CHANNEL ].SetParent( CWnd::GetDesktopWindow() );

		m_oChannelWindow_LIVE[ nChannelNum ].SetParent( this );
								
		m_oChannelWindows_BKGND[ nChannelNum ].SetParent( this );

		m_oChannelWindow_LIVE[ MIRROR_CHANNEL ].SetParent( this );		
	}	

	if ( ( nChannelNum & 0xF0000000 ) ==  0x00000000 ) {		// LIVE WINDOW		
		
		if ( m_nWndState ) {		// FULL TO SPLIT SCREEN

			for ( ULONG i = 0; i < CQMultiplexerDlg::s_n_max_device_count; i++ ) {

				if ( i ==  nChannelNum ) {

					// CHANGE MAIN WINDOW, IF MUX MODE IS APPLIED
					//
					if ( m_nWndowLayoutType == 1 ) { 

						CRect oSwapRect = NULL;

						oSwapRect = CQMultiplexerDlg::s_rect_slipts_display[ i ];

						CQMultiplexerDlg::s_rect_slipts_display[ i ] = CRect( 0 , 0 , (GetSystemMetrics( SM_CXSCREEN ) / 4) * 3 , GetSystemMetrics( SM_CYSCREEN ) );	

						CQMultiplexerDlg::s_rect_slipts_display[ m_nMainWindowNum ] = oSwapRect;	

						m_oChannelWindow_LIVE[ m_nMainWindowNum ].MoveWindow( CQMultiplexerDlg::s_rect_slipts_display[ m_nMainWindowNum ] );

						m_oChannelWindows_BKGND[ m_nMainWindowNum ].MoveWindow( CQMultiplexerDlg::s_rect_slipts_display[ m_nMainWindowNum ] );

						m_nMainWindowNum = (BYTE)i;					
					}

					m_oChannelWindow_LIVE[ i ].MoveWindow( CQMultiplexerDlg::s_rect_slipts_display[ i ] );

					m_oChannelWindows_BKGND[ i ].MoveWindow( CQMultiplexerDlg::s_rect_slipts_display[ i ] );

					QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );

					m_nAudioPlayChannel = -1;

					m_oMenuInfo[ i ].nAudioType = 0;

					m_oControlPanelDlg.SetWindowText( CQMultiplexerDlg::s_sz_dlg_title );
				}
				else {

					m_oChannelWindow_LIVE[ i ].ShowWindow( TRUE );

					m_oChannelWindows_BKGND[ i ].ShowWindow( FALSE );
				}

				if ( ( nChannelNum < s_n_max_device_count ) && ( m_nWndowLayoutType == 0x02 ) ) {

					CQMultiplexerDlg::s_rect_slipts_display[ MIRROR_CHANNEL ] = CRect( ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) , (GetSystemMetrics( SM_CYSCREEN ) / 2) , (GetSystemMetrics( SM_CXSCREEN )) , (GetSystemMetrics( SM_CYSCREEN )) );	

					m_oChannelWindow_LIVE[ MIRROR_CHANNEL ].MoveWindow( CQMultiplexerDlg::s_rect_slipts_display[ MIRROR_CHANNEL ] );

					m_oChannelWindows_BKGND[ MIRROR_CHANNEL ].MoveWindow( CQMultiplexerDlg::s_rect_slipts_display[ MIRROR_CHANNEL ] );									
				}
			}			
			
			m_nWndState = 0;
		}		
		else {		// SPLIT TO FULL SCREEN		
			
			if ( m_nWndowLayoutType == 0x02 &&  nChannelNum == MIRROR_CHANNEL ) { return TRUE; }		// MIRROR WINDOW NOT TO CHANGE

			if ( m_nWndowLayoutType == 0x02 ) {

				CQMultiplexerDlg::s_rect_slipts_display[ MIRROR_CHANNEL ] = CRect(	( ( GetSystemMetrics( SM_CXSCREEN ) / 8 ) * 5 ),
					
																					( ( GetSystemMetrics( SM_CYSCREEN ) / 8 ) * 5 ),
																		
																					( ( GetSystemMetrics( SM_CXSCREEN ) / 8 ) * 7 ),
																		
																					( ( GetSystemMetrics( SM_CYSCREEN ) / 8 ) * 7 ) );	

				m_oChannelWindow_LIVE[ MIRROR_CHANNEL ].MoveWindow( CQMultiplexerDlg::s_rect_slipts_display[ MIRROR_CHANNEL ] );

				m_oChannelWindows_BKGND[ MIRROR_CHANNEL ].MoveWindow( CQMultiplexerDlg::s_rect_slipts_display[ MIRROR_CHANNEL ] );				
			}

			CRect rect( 0 , 0 , GetSystemMetrics( SM_CXSCREEN ), GetSystemMetrics( SM_CYSCREEN ) );			

			for ( ULONG i = 0; i < CQMultiplexerDlg::s_n_max_device_count; i++ ) {

				if ( i ==  nChannelNum ) {

					m_oChannelWindow_LIVE[ i ].MoveWindow( rect );
					
					m_oChannelWindows_BKGND[ i ].MoveWindow( rect );	

					QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );
					
					m_nAudioPlayChannel = i;

					m_oMenuInfo[ i ].nAudioType = 1;

					sprintf( szStr, "%s, Channel Number = %d, Tuen on Audio", CQMultiplexerDlg::s_sz_dlg_title, ( i + 1 ) );					
					
					m_oControlPanelDlg.SetWindowText( szStr );
				}
				else {

					m_oChannelWindow_LIVE[ i ].ShowWindow( FALSE );

					m_oChannelWindows_BKGND[ i ].ShowWindow( FALSE );
				}
			}
			
			m_nWndState = 1;
		}		
	}

	return TRUE;
}

BOOL CQMultiplexerDlg::SetCurrentWindowLayout_CControlPanel( BYTE nGridCount, BYTE nWindowLayoutType )
{
	CQMultiplexerDlg::s_n_splits_division = nGridCount;

	m_nWndowLayoutType = nWindowLayoutType;

	CHAR szStr[ MAX_PATH ] = { 0 };

	ULONG nMaxChannel = nGridCount * nGridCount;

	CQMultiplexerDlg::s_n_max_device_count = nMaxChannel;

	//	DESTROY CLONE DEVICE
	//
	if ( m_hCloneCapDev != 0 )
	{
		QCAP_STOP( m_hCloneCapDev );

		QCAP_DESTROY( m_hCloneCapDev );

		m_hCloneCapDev = 0;
	}

	for ( BYTE i = 0; i < 4 * 4; i++ ) {

		if ( nWindowLayoutType == 1 ) {		// MUX 2x2 LAYOUT
				
			CQMultiplexerDlg::s_rect_slipts_display[ 0 ] = CRect( 0 , 0 , (GetSystemMetrics( SM_CXSCREEN ) / 4) * 3 , GetSystemMetrics( SM_CYSCREEN ) );	

			CQMultiplexerDlg::s_rect_slipts_display[ 1 ] = CRect( (GetSystemMetrics( SM_CXSCREEN ) / 4) * 3 , 0 , GetSystemMetrics( SM_CXSCREEN ) , (GetSystemMetrics( SM_CYSCREEN ) / 3) * 1 );	

			CQMultiplexerDlg::s_rect_slipts_display[ 2 ] = CRect( (GetSystemMetrics( SM_CXSCREEN ) / 4) * 3 , (GetSystemMetrics( SM_CYSCREEN ) / 3) * 1 , GetSystemMetrics( SM_CXSCREEN ), (GetSystemMetrics( SM_CYSCREEN ) / 3) * 2 );	

			CQMultiplexerDlg::s_rect_slipts_display[ 3 ] = CRect( (GetSystemMetrics( SM_CXSCREEN ) / 4) * 3 , (GetSystemMetrics( SM_CYSCREEN ) / 3) * 2 , GetSystemMetrics( SM_CXSCREEN ), GetSystemMetrics( SM_CYSCREEN ) );	
		}
		else if ( nWindowLayoutType == 0 ) {		// NORMAL LAYOUT
				
			CQMultiplexerDlg::s_rect_slipts_display[ i ] = GetSplitWndPos_CQMultiplexerDlg( i , nGridCount, GetSystemMetrics( SM_CXSCREEN ), GetSystemMetrics( SM_CYSCREEN ) );			
		}
		else if ( nWindowLayoutType == 2 ) {		// MUX 3x3 LAYOUT
	
			CQMultiplexerDlg::s_rect_slipts_display[ 0 ] = CRect( 0 , 0 , ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) , ( GetSystemMetrics( SM_CYSCREEN ) / 2 ) );	

			CQMultiplexerDlg::s_rect_slipts_display[ 1 ] = CRect( ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) + 0  , 0 , ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) + ( ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) / 2 ) , ( (GetSystemMetrics( SM_CYSCREEN ) / 2) / 2 ) );	

			CQMultiplexerDlg::s_rect_slipts_display[ 2 ] = CRect( ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) + ( (GetSystemMetrics( SM_CXSCREEN ) / 2) / 2 ) , 0 , GetSystemMetrics( SM_CXSCREEN ) , ( (GetSystemMetrics( SM_CYSCREEN ) / 2) / 2 ) );

			CQMultiplexerDlg::s_rect_slipts_display[ 3 ] = CRect( ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) + 0 , ( (GetSystemMetrics( SM_CYSCREEN ) / 2) / 2 ) , ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) + ( (GetSystemMetrics( SM_CXSCREEN ) / 2) / 2 ), ( GetSystemMetrics( SM_CYSCREEN ) / 2 ) );	

			CQMultiplexerDlg::s_rect_slipts_display[ 4 ] = CRect( ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) + ( ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) / 2 ) , ( (GetSystemMetrics( SM_CYSCREEN ) / 2) / 2 )  , ( GetSystemMetrics( SM_CXSCREEN ) ), ( GetSystemMetrics( SM_CYSCREEN ) / 2 ) );	

			CQMultiplexerDlg::s_rect_slipts_display[ 5 ] = CRect( 0 , (GetSystemMetrics( SM_CYSCREEN ) / 2), ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) / 2, (GetSystemMetrics( SM_CYSCREEN ) / 2) + ( (GetSystemMetrics( SM_CYSCREEN ) / 2) /2 ) );

			CQMultiplexerDlg::s_rect_slipts_display[ 6 ] = CRect( ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) / 2 , (GetSystemMetrics( SM_CYSCREEN ) / 2) , ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) , (GetSystemMetrics( SM_CYSCREEN ) / 2) + ( (GetSystemMetrics( SM_CYSCREEN ) / 2) /2 ) );

			CQMultiplexerDlg::s_rect_slipts_display[ 7 ] = CRect( 0, (GetSystemMetrics( SM_CYSCREEN ) / 2) + ((GetSystemMetrics( SM_CYSCREEN ) / 2)/2) , ( (GetSystemMetrics( SM_CXSCREEN ) / 2) / 2) , (GetSystemMetrics( SM_CYSCREEN )) );	

			CQMultiplexerDlg::s_rect_slipts_display[ 8 ] = CRect( ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) / 2, (GetSystemMetrics( SM_CYSCREEN ) / 2) + ((GetSystemMetrics( SM_CYSCREEN ) / 2) / 2 ) , (GetSystemMetrics( SM_CXSCREEN ) / 2) , (GetSystemMetrics( SM_CYSCREEN )) );	

			CQMultiplexerDlg::s_rect_slipts_display[ 9 ] = CRect( ( GetSystemMetrics( SM_CXSCREEN ) / 2 ) , (GetSystemMetrics( SM_CYSCREEN ) / 2) , (GetSystemMetrics( SM_CXSCREEN )) , (GetSystemMetrics( SM_CYSCREEN )) );

		}		
			
		if ( m_oChannelWindow_LIVE[ i ].m_hWnd ) {		// m_oChannelWindow_LIVE[ i ] HAVE BEEN CREATED BY US?
		
			m_oChannelWindow_LIVE[ i ].MoveWindow( &CQMultiplexerDlg::s_rect_slipts_display[ i ], TRUE );

			m_oChannelWindows_BKGND[ i ].MoveWindow( &CQMultiplexerDlg::s_rect_slipts_display[ i ], TRUE );
		}
		else {

			sprintf( szStr, "MyChannelWindow#LIVE#%02d", i + 1 );
		
			m_oChannelWindow_LIVE[ i ].Create(	NULL,

												szStr,

												WS_CHILD | WS_VISIBLE | WS_BORDER,

												CQMultiplexerDlg::s_rect_slipts_display[ i ],

												this,

												i + 0x00000001,

												NULL );	

			sprintf( szStr, "MyChannelWindow#BKGND#%02d", i + 1 );
			
			m_oChannelWindows_BKGND[ i ].Create(	NULL,
													
													szStr,
													
													WS_CHILD | WS_VISIBLE | WS_BORDER,
													
													CQMultiplexerDlg::s_rect_slipts_display[ i ],
													
													this,
													
													i + 0x10000001,
													
													NULL );		// BACKGROUND WINDOW
		}

		if ( i < nMaxChannel || 

			( nWindowLayoutType == 2 && i == MIRROR_CHANNEL ) ) {		// SPACIAL CASE MUX3X3, 10 NOT TO BE EQUAL 3x3
		
			m_oChannelWindow_LIVE[ i ].ShowWindow( TRUE );

			m_oChannelWindows_BKGND[ i ].ShowWindow( FALSE );
		
			if ( m_bNoSignal[ i ] ) {

				m_oChannelWindow_LIVE[ i ].ShowWindow( FALSE );

				m_oChannelWindows_BKGND[ i ].ShowWindow( TRUE );
			}			

			//	CREATE CLONE DEVICE
			//
			if ( nWindowLayoutType == 2 && i == MIRROR_CHANNEL ) {
				
				if( m_hVideoDevice[ 0 ] != 0 ) {

					QCAP_CREATE_CLONE( m_hVideoDevice[ 0 ], m_oChannelWindow_LIVE[ MIRROR_CHANNEL ].GetSafeHwnd(), &m_hCloneCapDev );

					if ( m_hCloneCapDev != 0 ) {
						
						QCAP_RUN( m_hCloneCapDev );

						QCAP_SET_AUDIO_VOLUME( m_hCloneCapDev, 0 );
					}
				}
			}
		}
		else {

			m_oChannelWindow_LIVE[ i ].ShowWindow( FALSE );

			m_oChannelWindows_BKGND[ i ].ShowWindow( FALSE );
		}
	}

	sprintf( CQMultiplexerDlg::s_sz_dlg_title, "  Multiplexer Control Panel %s", QC_DEFAULT_SOFTWARE_VERSION );

	SetWindowText( CQMultiplexerDlg::s_sz_dlg_title );

	UpdateWindow();		
	
	return TRUE;
}

BOOL CQMultiplexerDlg::OnRButtonDown_CChannelWindow( ULONG nChannelNum, CPoint point, CWnd *pWnd )
{
	CRect rect;
	
	pWnd->GetClientRect( &rect );

	m_nCurRBntNum = nChannelNum;
	
	// INITIALIZE POP MENU
	//		
	CMenu menu_main;

	menu_main.LoadMenu( IDR_MENU_MAIN );		
	
	CMenu *menu_top_level = menu_main.GetSubMenu( 0 );		// TOP-LEVEL, ORDER 0~Nth SUBMENU	
	
	// SET EACH SUBMENU TO GET DEFAULT ITEM
	//	
	
	//////////////////////////////////////////////////////////		

	// SOURCE
	menu_top_level->GetSubMenu( 0 )->CheckMenuItem( m_oMenuInfo[ nChannelNum ].nSourceType, MF_BYPOSITION | MF_CHECKED );	// checked
			
	menu_top_level->GetSubMenu( 0 )->SetDefaultItem( m_oMenuInfo[ nChannelNum ].nSourceType, TRUE ); 
			
	menu_top_level->GetSubMenu( 0 )->EnableMenuItem( m_oMenuInfo[ nChannelNum ].nSourceType, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );	// diable
	
	//////////////////////////////////////////////////////////		

	// CHANGE THE CHANNEL OF STANDARD
	menu_top_level->EnableMenuItem( 1, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );	// diable

	// CHANGE THE CHANNEL OF RESOLUTION	
	menu_top_level->EnableMenuItem( 2, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );	// diable

	// NTSC
	if ( m_oMenuInfo[ nChannelNum ].nStandardType == 0x00 ) { menu_top_level->GetSubMenu( 2 )->EnableMenuItem( 2, MF_BYPOSITION | MF_DISABLED | MF_GRAYED ); }
		
	// PAL
	if ( m_oMenuInfo[ nChannelNum ].nStandardType == 0x01 ) { menu_top_level->GetSubMenu( 2 )->EnableMenuItem( 3, MF_BYPOSITION | MF_DISABLED | MF_GRAYED ); }

	//////////////////////////////////////////////////////////		

	// RECORDING.STREAM1
	menu_top_level->GetSubMenu( 3 )->GetSubMenu( 0 )->CheckMenuItem( m_oMenuInfo[ nChannelNum ].nRecordType1, MF_BYPOSITION | MF_CHECKED );	// checked
			
	menu_top_level->GetSubMenu( 3 )->GetSubMenu( 0 )->SetDefaultItem( m_oMenuInfo[ nChannelNum ].nRecordType1, TRUE ); 
			
	menu_top_level->GetSubMenu( 3 )->GetSubMenu( 0 )->EnableMenuItem( m_oMenuInfo[ nChannelNum ].nRecordType1, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );	// diable

	// RECORDING.STREAM2
	menu_top_level->GetSubMenu( 3 )->GetSubMenu( 1 )->CheckMenuItem( m_oMenuInfo[ nChannelNum ].nRecordType2, MF_BYPOSITION | MF_CHECKED );	// checked
			
	menu_top_level->GetSubMenu( 3 )->GetSubMenu( 1 )->SetDefaultItem( m_oMenuInfo[ nChannelNum ].nRecordType2, TRUE ); 
			
	menu_top_level->GetSubMenu( 3 )->GetSubMenu( 1 )->EnableMenuItem( m_oMenuInfo[ nChannelNum ].nRecordType2, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );	// diable

	// RECORDING.STREAM3
	menu_top_level->GetSubMenu( 3 )->GetSubMenu( 2 )->CheckMenuItem( m_oMenuInfo[ nChannelNum ].nRecordType3, MF_BYPOSITION | MF_CHECKED );	// checked
			
	menu_top_level->GetSubMenu( 3 )->GetSubMenu( 2 )->SetDefaultItem( m_oMenuInfo[ nChannelNum ].nRecordType3, TRUE ); 
			
	menu_top_level->GetSubMenu( 3 )->GetSubMenu( 2 )->EnableMenuItem( m_oMenuInfo[ nChannelNum ].nRecordType3, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );	// diable

	//////////////////////////////////////////////////////////		

	// AUDIO ENABLE		
	menu_top_level->GetSubMenu( 4 )->CheckMenuItem( m_oMenuInfo[ nChannelNum ].nAudioType, MF_BYPOSITION | MF_CHECKED );	// checked
			
	menu_top_level->GetSubMenu( 4 )->SetDefaultItem( m_oMenuInfo[ nChannelNum ].nAudioType, TRUE ); 
			
	menu_top_level->GetSubMenu( 4 )->EnableMenuItem( m_oMenuInfo[ nChannelNum ].nAudioType, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );	// diable

	//////////////////////////////////////////////////////////
	
	// AUDIO INPUT	
	menu_top_level->GetSubMenu( 6 )->CheckMenuItem( m_oMenuInfo[ nChannelNum ].nAudioInput, MF_BYPOSITION | MF_CHECKED );	// checked
			
	menu_top_level->GetSubMenu( 6 )->SetDefaultItem( m_oMenuInfo[ nChannelNum ].nAudioInput, TRUE ); 
			
	menu_top_level->GetSubMenu( 6 )->EnableMenuItem( m_oMenuInfo[ nChannelNum ].nAudioInput, MF_BYPOSITION | MF_DISABLED | MF_GRAYED );	// diable

	//////////////////////////////////////////////////////////		

	menu_top_level->TrackPopupMenu( TPM_LEFTBUTTON | TPM_LEFTALIGN , point.x, point.y, this );

	menu_main.DestroyMenu();  

	return TRUE;
}

void CQMultiplexerDlg::OnMenuCsourcHdmi() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - HDMI" );

	BOOL b_is_success = FALSE;

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000002, m_nCurRBntNum );

}

void CQMultiplexerDlg::OnMenuCsourcComponents() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - Components" );

	BOOL b_is_success = FALSE;

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000004, m_nCurRBntNum );
}

void CQMultiplexerDlg::OnMenuCsourcSvideo() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - Svideo" );

	BOOL b_is_success = FALSE;

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000001, m_nCurRBntNum );
}

void CQMultiplexerDlg::OnMenuCsourcComposite() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - Composite" );

	BOOL b_is_success = FALSE;

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000000, m_nCurRBntNum );
}

void CQMultiplexerDlg::OnMenuCsourcDvid() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - Dvid" );

	BOOL b_is_success = FALSE;

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000003, m_nCurRBntNum );
}

void CQMultiplexerDlg::OnMenuCsourcDvia() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - Dvia" );

	BOOL b_is_success = FALSE;

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000005, m_nCurRBntNum );
}

void CQMultiplexerDlg::OnMenuCsourcSdi() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - Sdi" );

	BOOL b_is_success = FALSE;

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000006, m_nCurRBntNum );
}

void CQMultiplexerDlg::OnMenuCsourcAuto() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - Auto" );

	BOOL b_is_success = FALSE;

	b_is_success = OnMenuItemDown_ChangeSource( 0x00000007, m_nCurRBntNum );	
}

BOOL CQMultiplexerDlg::OnMenuItemDown_ChangeSource( ULONG nType, ULONG nChannelNum )
{
	ULONG nErrCode = 0;
	
	CHAR szStr[ MAX_PATH ] = { 0 };	

	nErrCode = QCAP_SET_VIDEO_INPUT( m_hVideoDevice[ nChannelNum ], nType );		

	if ( nType == 0x00000000 ) { m_oMenuInfo[ nChannelNum ].nSourceType = 4; }		// item'th position

	//SVDIDEO
	if ( nType == 0x00000001 ) { m_oMenuInfo[ nChannelNum ].nSourceType = 5; } 

	//HDMI
	if ( nType == 0x00000002 ) { m_oMenuInfo[ nChannelNum ].nSourceType = 0; } 

	if ( nType == 0x00000003 ) { m_oMenuInfo[ nChannelNum ].nSourceType = 1; } 

	if ( nType == 0x00000004 ) { m_oMenuInfo[ nChannelNum ].nSourceType = 2; } 

	if ( nType == 0x00000005 ) { m_oMenuInfo[ nChannelNum ].nSourceType = 3; } 

	if ( nType == 0x00000006 ) { m_oMenuInfo[ nChannelNum ].nSourceType = 6; } 

	if ( nType == 0x00000007 ) { m_oMenuInfo[ nChannelNum ].nSourceType = 7; } 

	sprintf( szStr, "%s, Channel Number = %d, Input Source = %d", CQMultiplexerDlg::s_sz_dlg_title, ( nChannelNum + 1 ), nType );
			
	m_oControlPanelDlg.SetWindowText( szStr );
	
	return ( nErrCode ) ? FALSE : TRUE;
}

void CQMultiplexerDlg::OnMenuStandardNtsc() 
{

	Dbg( "Trigger - NTSC" );

	BOOL b_is_success = FALSE;

	b_is_success = OnMenuItemDown_ChangeStandard( 0x00000001, m_nCurRBntNum );
}

void CQMultiplexerDlg::OnMenuStandardPal() 
{
	// TODO: Add your command handler code here

	Dbg( "Trigger - PAL" );

	BOOL b_is_success = FALSE;

	b_is_success = OnMenuItemDown_ChangeStandard( 0x00000010, m_nCurRBntNum );
}

BOOL CQMultiplexerDlg::OnMenuItemDown_ChangeStandard( ULONG nType, ULONG nChannelNum )
{
	ULONG nErrCode = 0;
	
	CHAR szStr[ MAX_PATH ] = { 0 };

	ULONG n_color_space_type = MAKEFOURCC('Y', 'U', 'Y', '2');

	ULONG n_bit_count = 16;

	nErrCode = AMESDK_SET_STANDARD( (ULONG)m_hVideoDevice[ nChannelNum ], nType );

	if ( nType == 0x01 ) {		// NTSC

		if ( m_oMenuInfo[ nChannelNum ].nResolutionType == 0x00 ) {
		
			AMESDK_SET_FORMAT( (ULONG)m_hVideoDevice[ nChannelNum ], n_color_space_type, 1920, 1080, n_bit_count, 29.970 );
			
			m_oMenuInfo[ nChannelNum ].nResolutionType = 0x00;
		}

		if ( m_oMenuInfo[ nChannelNum ].nResolutionType == 0x01 ) {

			AMESDK_SET_FORMAT( (ULONG)m_hVideoDevice[ nChannelNum ], n_color_space_type, 1280, 720, n_bit_count, 29.970 );
			
			m_oMenuInfo[ nChannelNum ].nResolutionType = 0x01;
		}

		if ( m_oMenuInfo[ nChannelNum ].nResolutionType == 0x02 ) {

			AMESDK_SET_FORMAT( (ULONG)m_hVideoDevice[ nChannelNum ], n_color_space_type, 720, 480, n_bit_count, 29.970 );
			
			m_oMenuInfo[ nChannelNum ].nResolutionType = 0x03;
		}

		m_oMenuInfo[ nChannelNum ].nStandardType = 0x00; 			// menu item position
	}
	
	if ( nType == 0x10 ) {		// PAL

		if ( m_oMenuInfo[ nChannelNum ].nResolutionType == 0x00 ) {

			AMESDK_SET_FORMAT( (ULONG)m_hVideoDevice[ nChannelNum ], n_color_space_type, 1920, 1080, n_bit_count, 25.000 );
			
			m_oMenuInfo[ nChannelNum ].nResolutionType = 0x00;
		}
		if ( m_oMenuInfo[ nChannelNum ].nResolutionType == 0x01 ) {

			AMESDK_SET_FORMAT( (ULONG)m_hVideoDevice[ nChannelNum ], n_color_space_type, 1280, 720, n_bit_count, 25.000 );
			
			m_oMenuInfo[ nChannelNum ].nResolutionType = 0x01;
		}
		if ( m_oMenuInfo[ nChannelNum ].nResolutionType == 0x03 ) {

			AMESDK_SET_FORMAT( (ULONG)m_hVideoDevice[ nChannelNum ], n_color_space_type, 720, 576, n_bit_count, 25.000 );
			
			m_oMenuInfo[ nChannelNum ].nResolutionType = 0x02;
		}

		m_oMenuInfo[ nChannelNum ].nStandardType = 0x01;		//menu item position	
	}

	sprintf( szStr, "%s, Channel Number = %d, Input nResolutionType = %d", CQMultiplexerDlg::s_sz_dlg_title, ( nChannelNum + 1 ), nType );
			
	m_oControlPanelDlg.SetWindowText( szStr );

	return TRUE;
}

void CQMultiplexerDlg::OnMenuResolution1920x1080() 
{

}

void CQMultiplexerDlg::OnMenuResolution1280x720() 
{
	// TODO: Add your command handler code here
	
}

void CQMultiplexerDlg::OnMenuResolution720x576() 
{
	// TODO: Add your command handler code here
	
}

void CQMultiplexerDlg::OnMenuResolution720x480() 
{
	// TODO: Add your command handler code here
	
}

void CQMultiplexerDlg::OnMenuStream1StartRecode() 
{
	// TODO: Add your command handler code here
	
 	CQMultiplexerDlg* pMainDlg = (CQMultiplexerDlg* )AfxGetMainWnd();

	pMainDlg->OnButtonRecordStart1AVI_CControlPanel( m_nCurRBntNum );
}

void CQMultiplexerDlg::OnMenuStream1StopRecode() 
{
	// TODO: Add your command handler code here
	
 	CQMultiplexerDlg* pMainDlg = (CQMultiplexerDlg* )AfxGetMainWnd();

	pMainDlg->OnButtonRecordStop1AVI_CControlPanel( m_nCurRBntNum );
}

void CQMultiplexerDlg::OnMenuStream2StartRecode() 
{
	// TODO: Add your command handler code here
 	CQMultiplexerDlg* pMainDlg = (CQMultiplexerDlg* )AfxGetMainWnd();

	pMainDlg->OnButtonRecordStart2AVI_CControlPanel( m_nCurRBntNum );
}

void CQMultiplexerDlg::OnMenuStream2StopRecode() 
{
	// TODO: Add your command handler code here
 	CQMultiplexerDlg* pMainDlg = (CQMultiplexerDlg* )AfxGetMainWnd();

	pMainDlg->OnButtonRecordStop2AVI_CControlPanel( m_nCurRBntNum );	
}

void CQMultiplexerDlg::OnMenuStream3StartRecode() 
{
	// TODO: Add your command handler code here
 	CQMultiplexerDlg* pMainDlg = (CQMultiplexerDlg* )AfxGetMainWnd();

	pMainDlg->OnButtonRecordStart3AVI_CControlPanel( m_nCurRBntNum );	
}

void CQMultiplexerDlg::OnMenuStream3StopRecode() 
{
	// TODO: Add your command handler code here
 	CQMultiplexerDlg* pMainDlg = (CQMultiplexerDlg* )AfxGetMainWnd();

	pMainDlg->OnButtonRecordStop3AVI_CControlPanel( m_nCurRBntNum );		
}

BOOL CQMultiplexerDlg::OnButtonRecordStart1AVI_CControlPanel( ULONG nChannelNum )
{
	m_oMenuInfo[ nChannelNum ].nRecordType1 = 0;

	CString strFullPathName;

	strFullPathName.Format( _T("%s\\unname_%d_1_1920x1080_12M.avi"), m_strRecordPath, nChannelNum + 1 );

	// UNLOCK BUFFER		
	ULONG nStrlen = strFullPathName.GetLength();

	CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

	if ( m_hVideoDevice[ nChannelNum ] != 0 ) {

		QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice[ nChannelNum ], 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_OFF );

		QCAP_START_RECORD( m_hVideoDevice[ nChannelNum ], 0, psz);
	}

	// LOCK BUFFER
	strFullPathName.ReleaseBuffer();

	return TRUE;
}

BOOL CQMultiplexerDlg::OnButtonRecordStop1AVI_CControlPanel( ULONG nChannelNum )
{

	m_oMenuInfo[ nChannelNum ].nRecordType1 = 1;

	if ( m_hVideoDevice[ nChannelNum ] != 0) {

		QCAP_STOP_RECORD( m_hVideoDevice[ nChannelNum ], 0 );
	}

	return TRUE;
}

BOOL CQMultiplexerDlg::OnButtonRecordStart2AVI_CControlPanel( ULONG nChannelNum )
{
	m_oMenuInfo[ nChannelNum ].nRecordType2 = 0;

	CString strFullPathName;

	strFullPathName.Format( _T("%s\\unname_%d_2_960x480_6M.avi"), m_strRecordPath, nChannelNum + 1 );

	// UNLOCK BUFFER		
	ULONG nStrlen = strFullPathName.GetLength();

	CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

	if ( m_hVideoDevice[ nChannelNum ] != 0 ) {

		QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice[ nChannelNum ], 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_2 );

		QCAP_START_RECORD( m_hVideoDevice[ nChannelNum ], 1, psz);
	}

	// LOCK BUFFER
	strFullPathName.ReleaseBuffer();

	return TRUE;
}

BOOL CQMultiplexerDlg::OnButtonRecordStop2AVI_CControlPanel( ULONG nChannelNum )
{
	m_oMenuInfo[ nChannelNum ].nRecordType2 = 1;

	if ( m_hVideoDevice[ nChannelNum ] != 0) {

		QCAP_STOP_RECORD( m_hVideoDevice[ nChannelNum ], 1 );
	}

	return TRUE;
}

BOOL CQMultiplexerDlg::OnButtonRecordStart3AVI_CControlPanel( ULONG nChannelNum )
{
	m_oMenuInfo[ nChannelNum ].nRecordType3 = 0;

	CString strFullPathName;

	strFullPathName.Format( _T("%s\\unname_%d_3_480x240_2M.avi"), m_strRecordPath, nChannelNum + 1 );

	// UNLOCK BUFFER		
	ULONG nStrlen = strFullPathName.GetLength();

	CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

	if ( m_hVideoDevice[ nChannelNum ] != 0 ) {

		QCAP_SET_VIDEO_RECORD_PROPERTY( m_hVideoDevice[ nChannelNum ], 2, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_H264, QCAP_RECORD_MODE_CBR, 8000, 2 * 1024 * 1024, 30, 0, 0, QCAP_DOWNSCALE_MODE_1_4 );

		QCAP_START_RECORD( m_hVideoDevice[ nChannelNum ], 2, psz);
	}

	// LOCK BUFFER
	strFullPathName.ReleaseBuffer();

	return TRUE;
}

BOOL CQMultiplexerDlg::OnButtonRecordStop3AVI_CControlPanel( ULONG nChannelNum )
{
	m_oMenuInfo[ nChannelNum ].nRecordType3 = 1;

	if ( m_hVideoDevice[ nChannelNum ] != 0) {

		QCAP_STOP_RECORD( m_hVideoDevice[ nChannelNum ], 2 );	
	}

	return TRUE;
}

void CQMultiplexerDlg::OnMenuAudioTurnOff() 
{
	// TODO: Add your command handler code here

	CHAR szStr[ MAX_PATH ] = "";

	m_nAudioPlayChannel = m_nCurRBntNum;

	for ( ULONG i = 0 ; i < CQMultiplexerDlg::s_n_max_device_count; i++ ) {

		if ( i == m_nAudioPlayChannel ) {
			
			QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );
			
			m_oMenuInfo[ i ].nAudioType = 0;
		}
	}
}

void CQMultiplexerDlg::OnMenuAudioTurnOn() 
{
	CHAR szStr[ MAX_PATH ] = "";
	
	// TODO: Add your command handler code here
	m_nAudioPlayChannel = m_nCurRBntNum;

	for ( ULONG i = 0 ; i < CQMultiplexerDlg::s_n_max_device_count; i++ ) {

		if ( i == m_nAudioPlayChannel ) {

			QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );
			
			m_oMenuInfo[ i ].nAudioType = 1;
		}
	}
}

void CQMultiplexerDlg::OnMenuSaveBitmap() 
{
	// TODO: Add your command handler code here

	CHAR szFilter[ MAX_PATH ] = "BMP(*.bmp)";

	CFileDialog fd( FALSE, "bmp", TEXT("Unnamed"), OFN_HIDEREADONLY, szFilter, this );
 
	if( fd.DoModal() == IDOK ) {
	  
	  CString szFileName = fd.GetPathName(); CHAR* psz = (CHAR*)(LPCTSTR)szFileName;
	  
	  QCAP_SNAPSHOT_BMP( m_hVideoDevice[ m_nCurRBntNum ], psz );
	  
	  Dbg( "szFileName = <%s>", szFileName );
	}
}

void CQMultiplexerDlg::OnMenuSaveJpeg() 
{
	// TODO: Add your command handler code here

	CHAR szFilter[ MAX_PATH ] = "JPG(*.jpg)";

	CFileDialog fd( FALSE, "jpg", TEXT("Unnamed"), OFN_HIDEREADONLY, szFilter, this );
 
	if( fd.DoModal() == IDOK ) {
	  
	  CString szFileName = fd.GetPathName(); CHAR* psz = (CHAR*)(LPCTSTR)szFileName;
	  
	  QCAP_SNAPSHOT_JPG( m_hVideoDevice[ m_nCurRBntNum ], psz, 100 );
	  
	  Dbg( "szFileName = <%s>", szFileName );
	}	
}

void CQMultiplexerDlg::OnRadioInputEmbeddedAudio() 
{
	// TODO: Add your command handler code here
	ULONG nErrorCode = 1;
	
	nErrorCode = QCAP_SET_AUDIO_INPUT( m_hVideoDevice[ m_nCurRBntNum ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

	if ( nErrorCode == 0 ) { m_oMenuInfo[ m_nCurRBntNum ].nAudioInput = 0; }
	
	else { AfxMessageBox( _T("Error"), MB_ABORTRETRYIGNORE | MB_ICONSTOP); }
}

void CQMultiplexerDlg::OnRadioInputLinein() 
{
	// TODO: Add your command handler code here
	
	ULONG nErrorCode = 1;
	
	nErrorCode = QCAP_SET_AUDIO_INPUT( m_hVideoDevice[ m_nCurRBntNum ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

	if ( nErrorCode == 0 ) { m_oMenuInfo[ m_nCurRBntNum ].nAudioInput = 1; }
	
	else { AfxMessageBox( _T("Error"), MB_ABORTRETRYIGNORE | MB_ICONSTOP); }
}

void CQMultiplexerDlg::OnMenuSetVideoConfig() 
{
	// TODO: Add your control notification handler code here
	
	OnButtonVideoQuality_CQMultiplexerDlg();
}


BOOL CQMultiplexerDlg::OnButtonVideoQuality_CQMultiplexerDlg() 
{
	// TODO: Add your control notification handler code here
	
	if( m_hVideoDevice[ m_nCurRBntNum ] == 0 ) { return FALSE; }

	CVideoQualityDlg dlg( this );

	INT_PTR nResponse = -1;

	nResponse = dlg.DoModal();

	return TRUE;
}
