// AnalogDeviceAudioGraph.h: interface for the CAnalogDeviceAudioGraph class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_ANALOGDEVICEAUDIOGRAPH_H__61EACED7_0E49_424A_AAC0_241D12EF7791__INCLUDED_)
#define AFX_ANALOGDEVICEAUDIOGRAPH_H__61EACED7_0E49_424A_AAC0_241D12EF7791__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Graph.h"

class CAnalogDeviceAudioGraph : public CGraph  
{
public:

	CAnalogDeviceAudioGraph();

	virtual ~CAnalogDeviceAudioGraph();

public:

	// DEBUGGING FUNCTIONS
	//
	VOID					  SC_DEBUG( CHAR * fmt, ... );

	// MEMBER FUNCTIONS
	//
	BOOL					  Close( BOOL bDumpDebugMessage = TRUE );

	BOOL					  Create( PWSTR pwszDevName, PF_BUFFER_CALLBACK pBufferCBs[ 32 ], PVOID pUserDatas[ 32 ] );

	// MEMBER VARIABLES
	// 
	IBaseFilter *             m_pCaptureSourceBaseFilters[ 32 ];

	IBaseFilter *             m_pSampleGrabberBaseFilters[ 32 ];

	IAMStreamConfig *		  m_pAMStreamConfigs[ 32 ];

	CSampleGrabber			  m_oSampleGrabbers[ 32 ];
	
	ISampleGrabber * 		  m_pSampleGrabbers[ 32 ];
};

#endif // !defined(AFX_ANALOGDEVICEAUDIOGRAPH_H__61EACED7_0E49_424A_AAC0_241D12EF7791__INCLUDED_)
