#ifndef QCAP_BCB_H
#define QCAP_BCB_H

// BCB 2014 SUPPORT
// 
#undef QCAP_EXT_API 

#define QCAP_EXT_API

#define QCAP_EXPORT __stdcall

// RESULT OF FUNCTION
//
typedef enum {

	QCAP_RS_SUCCESSFUL						= 0x00000000,

	QCAP_RS_ERROR_GENERAL					= 0x00000001,

	QCAP_RS_ERROR_OUT_OF_MEMORY				= 0x00000002,

	QCAP_RS_ERROR_OUT_OF_RESOURCE			= 0x00000003,

	QCAP_RS_ERROR_INVALID_DEVICE			= 0x00000004,

	QCAP_RS_ERROR_INVALID_PARAMETER			= 0x00000005,

	QCAP_RS_ERROR_NON_SUPPORT				= 0x00000006,

	QCAP_RS_ERROR_TIMEOUT					= 0x00000007,

	QCAP_RS_ERROR_INVALID_ANIMATION_SCRIPT	= 0x00000008,

	QCAP_RS_ERROR_NO_SIGNAL_DETECTED		= 0x00000009,

	QCAP_RS_ERROR_NEED_MORE_DATA			= 0x0000000A,

	QCAP_RS_ERROR_CONNECT_FAIL				= 0x0000000B,

} QRESULT;

// RETURN OF CALLBACK
//
typedef enum {

	QCAP_RT_OK					= 0x00000000,
	
	QCAP_RT_FAIL				= 0x00000001,

	QCAP_RT_SKIP_RECORD_NUM_00	= 0x00010002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_RECORD_NUM_01	= 0x00020002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_RECORD_NUM_02	= 0x00040002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_RECORD_NUM_03	= 0x00080002, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_SKIP_DISPLAY		= 0x00000004, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK / 
											  //
											  //		  PF_VIDEO_BROADCAST_CLIENT_CALLBACK / PF_AUDIO_BROADCAST_CLIENT_CALLBACK / 
											  //
											  //		  PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK / PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK /
											  //
											  //		  PF_VIDEO_DECODER_FILE_CALLBACK / PF_AUDIO_DECODER_FILE_CALLBACK
											  
	QCAP_RT_SKIP_CLONE_DISPLAY	= 0x00000008, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_00	= 0x01000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_01	= 0x02000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_02	= 0x04000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

	QCAP_RT_RESET_RECORD_NUM_03	= 0x08000010, // ONLY FOR PF_VIDEO_PREVIEW_CALLBACK / PF_AUDIO_PREVIEW_CALLBACK

} QRETURN;

// DEVICE ENUMERATION TYPE
//
enum {

	QCAP_ENUM_TYPE_DEVICE_NAME		= 0,

	QCAP_ENUM_TYPE_SERIAL_NUMBER	= 1,
};

// INPUT VIDEO SOURCE
//
enum {

	QCAP_INPUT_TYPE_COMPOSITE	 = 0,

	QCAP_INPUT_TYPE_SVIDEO		 = 1,

	QCAP_INPUT_TYPE_HDMI		 = 2,

	QCAP_INPUT_TYPE_DVI_D		 = 3,

	QCAP_INPUT_TYPE_COMPONENTS	 = 4,

	QCAP_INPUT_TYPE_YCBCR		 = 4,

	QCAP_INPUT_TYPE_DVI_A		 = 5,

	QCAP_INPUT_TYPE_RGB			 = 5,

	QCAP_INPUT_TYPE_VGA			 = 5,

	QCAP_INPUT_TYPE_SDI			 = 6,

	QCAP_INPUT_TYPE_DISPLAY_PORT = 8,

	QCAP_INPUT_TYPE_AUTO		 = 7,
};

// INPUT AUDIO SOURCE
//
enum {	

	QCAP_INPUT_TYPE_EMBEDDED_AUDIO			= 0,

	QCAP_INPUT_TYPE_LINE_IN					= 1,

	QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE	= 2,

	QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN		= 3,
};

// VIDEO STANDARD TYPE
//
enum {	

	QCAP_STANDARD_TYPE_NTSC_M		= 0x00000001,

	QCAP_STANDARD_TYPE_NTSC_M_J		= 0x00000002,

	QCAP_STANDARD_TYPE_NTSC_433		= 0x00000004,

	QCAP_STANDARD_TYPE_PAL_M		= 0x00000200,

	QCAP_STANDARD_TYPE_PAL_60		= 0x00000800,

	QCAP_STANDARD_TYPE_PAL_B		= 0x00000010,

	QCAP_STANDARD_TYPE_PAL_D		= 0x00000020,

	QCAP_STANDARD_TYPE_PAL_G		= 0x00000040,

	QCAP_STANDARD_TYPE_PAL_H		= 0x00000080,

	QCAP_STANDARD_TYPE_PAL_I		= 0x00000100,

	QCAP_STANDARD_TYPE_PAL_N		= 0x00000400,

	QCAP_STANDARD_TYPE_PAL_N_COMBO	= 0x00100000,

	QCAP_STANDARD_TYPE_AUTO			= 0x80000000, // DEFAULT, [P.S. SC310N8/N16            (CX2581 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC290N4/SC390N4/N8/N16 (AH8400 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC2B0N4/SC3B0N4/N8/N16 (TW5864 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC3A0N4/N8/N16         (FH8735 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
												  //
												  //		  [P.S. SC3C0N4/N8/N16         (MZ0380 PCI) DON'T SUPPORT AUTO STANDARD DETECTION]
};

// VIDEO DEINTERLACE TYPE
//
enum {	

	QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING			  = 0x00000000, // DEFAULT

	QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE	  = 0x00000001,

	QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE	  = 0x00000002,

	QCAP_SOFTWARE_DEINTERLACE_TYPE_MEDICAL_RGB_REPACK = 0x00000003,
};

// COLORSPACE TYPE
//
enum {

	QCAP_COLORSPACE_TYEP_RGB24	= 0,		  //   0xBBGGRR -> R0 G0 B0 R1 G1 B1 R2 G2 B2 ... >>

	QCAP_COLORSPACE_TYEP_BGR24	= 1,		  //   0xRRGGBB -> B0 G0 R0 B1 G1 R1 B2 G2 R2 ... >>

	QCAP_COLORSPACE_TYEP_ARGB32	= 2,		  // 0xAABBGGRR -> R0 G0 B0 A0 R1 G1 B1 A1 R2 G2 B2 A2 ... >>

	QCAP_COLORSPACE_TYEP_ABGR32	= 3,		  // 0xAARRGGBB -> B0 G0 R0 A0 B1 G1 R1 A1 B2 G2 R2 A2 ... >>

	QCAP_COLORSPACE_TYEP_YUY2	= 0x32595559, // 0x32595559 -> MAKEFOURCC('Y', 'U', 'Y', '2')

	QCAP_COLORSPACE_TYEP_UYVY	= 0x59565955, // 0x59565955 -> MAKEFOURCC('U', 'Y', 'V', 'Y')

	QCAP_COLORSPACE_TYEP_YV12	= 0x32315659, // 0x32315659 -> MAKEFOURCC('Y', 'V', '1', '2')

	QCAP_COLORSPACE_TYEP_I420	= 0x30323449, // 0x30323449 -> MAKEFOURCC('I', '4', '2', '0')

	QCAP_COLORSPACE_TYEP_H264	= 0x34363248, // 0x34363248 -> MAKEFOURCC('H', '2', '6', '4')
};

// ENCODER TYPE (RECORD PROPERTY)
//
enum {

	QCAP_ENCODER_TYPE_SOFTWARE			= 0,

	QCAP_ENCODER_TYPE_HARDWARE			= 1, // IT IS ONLY USED FOR HARDWARE COMPRESSION CAPTURE CARD, SUCH AS SC580 & SC590 & SC5A0

	QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK	= 2,

	QCAP_ENCODER_TYPE_AMD_STREAM		= 3, // DEVELOPING ...

	QCAP_ENCODER_TYPE_NVIDIA_CUDA		= 4,

	QCAP_ENCODER_TYPE_NVIDIA_NVENC		= 5, // DEVELOPING ...
};

// ENCODER VIDEO FORMAT (RECORD PROPERTY)
//
enum {

	QCAP_ENCODER_FORMAT_MPEG2		=  1,

	QCAP_ENCODER_FORMAT_H264		=  0,

	QCAP_ENCODER_FORMAT_H264_3D		=  2, // H264 MVC (STEREOSCOPIC 3D)

	QCAP_ENCODER_FORMAT_H264_VC		=  3, // H264 SVC (MULTIPLE TEMPORAL SCALABILITY)

	QCAP_ENCODER_FORMAT_RAW			=  4,
};

// ENCODER AUDIO FORMAT (RECORD PROPERTY)
//
enum {

	QCAP_ENCODER_FORMAT_PCM			= 0,

	QCAP_ENCODER_FORMAT_AAC			= 1,

	QCAP_ENCODER_FORMAT_AAC_RAW		= 1,

	QCAP_ENCODER_FORMAT_AAC_ADTS	= 2,
};

// RECORD PROFILE (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_PROFILE_BASELINE	         = 0, // DEFAULT

	QCAP_RECORD_PROFILE_MAIN		         = 1,

	QCAP_RECORD_PROFILE_HIGH		         = 2,

	QCAP_RECORD_PROFILE_CONSTRAINED_BASELINE = 3,

	QCAP_RECORD_PROFILE_CONSTRAINED_HIGH     = 4,
};

// RECORD LEVEL (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_LEVEL_1		= 10,

	QCAP_RECORD_LEVEL_1B	=  9,

	QCAP_RECORD_LEVEL_11	= 11,

	QCAP_RECORD_LEVEL_12	= 12,

	QCAP_RECORD_LEVEL_13	= 13,

	QCAP_RECORD_LEVEL_2		= 20,

	QCAP_RECORD_LEVEL_21	= 21,

	QCAP_RECORD_LEVEL_22	= 22,

	QCAP_RECORD_LEVEL_3		= 30,

	QCAP_RECORD_LEVEL_31	= 31,

	QCAP_RECORD_LEVEL_32	= 32,

	QCAP_RECORD_LEVEL_4		= 40,

	QCAP_RECORD_LEVEL_41	= 41, // DEFAULT

	QCAP_RECORD_LEVEL_42	= 42,

	QCAP_RECORD_LEVEL_50	= 50,

	QCAP_RECORD_LEVEL_51	= 51,

	QCAP_RECORD_LEVEL_52	= 52,
};

// RECORD ENTROPY (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_ENTROPY_CAVLC	= 0, // DEFAULT

	QCAP_RECORD_ENTROPY_CABAC	= 1,
};

// RECORD COMPLEXITY (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_COMPLEXITY_0	= 0, // BEST SPEED, DEFAULT

	QCAP_RECORD_COMPLEXITY_1	= 1,

	QCAP_RECORD_COMPLEXITY_2	= 2,

	QCAP_RECORD_COMPLEXITY_3	= 3,

	QCAP_RECORD_COMPLEXITY_4	= 4,

	QCAP_RECORD_COMPLEXITY_5	= 5,

	QCAP_RECORD_COMPLEXITY_6	= 6, // BEST QUALITY
};

// RECORD MODE (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_MODE_VBR	= 0,

	QCAP_RECORD_MODE_CBR	= 1,

	QCAP_RECORD_MODE_ABR	= 2,

	QCAP_RECORD_MODE_CQP	= 3, // DEVELOPING ...
};

// DOWNSCALE MODE (RECORD PROPERTY)
// 
enum {

	QCAP_DOWNSCALE_MODE_OFF	= 0, // (1920, 1080) * (1 / 1) = (1920, 1080)

	QCAP_DOWNSCALE_MODE_2_3	= 1, // (1920, 1080) * (2 / 3) = (1280,  720)

	QCAP_DOWNSCALE_MODE_1_2	= 2, // (1920, 1080) * (1 / 2) = ( 960,  540)

	QCAP_DOWNSCALE_MODE_1_4	= 3, // (1920, 1080) * (1 / 4) = ( 480,  270)
};

// RECORD FLAG (RECORD PROPERTY)
//
enum {

	QCAP_RECORD_FLAG_FULL						= 0x00000007,

	QCAP_RECORD_FLAG_FILE						= 0x00000001,

	QCAP_RECORD_FLAG_ENCODE						= 0x00000002,

	QCAP_RECORD_FLAG_DISPLAY					= 0x00000004,

	QCAP_RECORD_FLAG_DECODE						= 0x00000008,

	QCAP_RECORD_FLAG_VIDEO_ONLY					= 0x00000010,

	QCAP_RECORD_FLAG_AUDIO_ONLY					= 0x00000020,

	QCAP_RECORD_FLAG_VIDEO_USE_IDEAL_TIMESTAMP	= 0x00000040,

	QCAP_RECORD_FLAG_AUDIO_USE_IDEAL_TIMESTAMP	= 0x00000080,

	QCAP_RECORD_FLAG_INGNORE_FORMAT_CHANGED		= 0x00000100,
};

// BROADCAST FLAG (BROADCAST PROPERTY)
//
enum {

	QCAP_BROADCAST_FLAG_FULL	            = 0x00000007,

	QCAP_BROADCAST_FLAG_NETWORK	            = 0x00000001,

	QCAP_BROADCAST_FLAG_ENCODE	            = 0x00000002,

	QCAP_BROADCAST_FLAG_DISPLAY	            = 0x00000004,

	QCAP_BROADCAST_FLAG_DECODE	            = 0x00000008,

	QCAP_BROADCAST_FLAG_VIDEO_ONLY			= 0x00000010,

	QCAP_BROADCAST_FLAG_AUDIO_ONLY			= 0x00000020,
};

// BROADCAST PROTOCOL (BROADCAST PROPERTY)
//
enum {

	QCAP_BROADCAST_PROTOCOL_UDP	 = 0x00000000,

	QCAP_BROADCAST_PROTOCOL_TCP	 = 0x00000001, // BPS >= 12MBPS, SUGGEST TO SUE QCAP_BROADCAST_PROTOCOL_TCP

	QCAP_BROADCAST_PROTOCOL_HTTP = 0x00000002,
};

// OSD FONT STYLE (OSD PROPERTY)
//
enum {

    QCAP_FONT_STYLE_REGULAR     = 0x00000000,
    
	QCAP_FONT_STYLE_BOLD        = 0x00000001,
    
	QCAP_FONT_STYLE_ITALIC      = 0x00000002,
    
	QCAP_FONT_STYLE_BOLDITALIC  = 0x00000003,
    
	QCAP_FONT_STYLE_UNDERLINE   = 0x00000004,
    
	QCAP_FONT_STYLE_STRIKEOUT   = 0x00000008,
};

// OSD SEQUENCE STYLE (OSD PROPERTY)
//
enum {

	//  GENERAL DEVICE: FOREMOST -> PREVIEW CALLBACK -> BEFORE_ENCODE -> RECORDING (ENCODING) -> AFTERMOST
	//
	// SHARE RECORDING: FOREMOST -> RECORDING (ENCODING) -> AFTERMOST
	//
	// SHARE STREAMING: FOREMOST -> STREAMING (ENCODING) -> AFTERMOST
	//
	//  VIRTUAL CAMERA: FOREMOST -> AFTERMOST -> SHARING
	//
	//   FILE PLAYBACK: PLAYBACK (DECODING) -> FOREMOST -> DECODER CALLBACK -> AFTERMOST
	//
	QCAP_SEQUENCE_STYLE_FOREMOST		= 0x00000000,

    QCAP_SEQUENCE_STYLE_BEFORE_ENCODE	= 0x00000001, // IT IS ONLY USED FOR GENERAL DEVICE
    
	QCAP_SEQUENCE_STYLE_AFTERMOST		= 0x00000002,
};

// DECODER TYPE (PLAYBACK PROPERTY)
//
enum {

	QCAP_DECODER_TYPE_SOFTWARE			= 0,

	QCAP_DECODER_TYPE_HARDWARE			= 1, // DEVELOPING ...

	QCAP_DECODER_TYPE_INTEL_MEDIA_SDK	= 2, // DEVELOPING ...

	QCAP_DECODER_TYPE_AMD_STREAM		= 3, // DEVELOPING ...

	QCAP_DECODER_TYPE_NVIDIA_CUDA		= 4, // DEVELOPING ...

	QCAP_DECODER_TYPE_NVIDIA_NVENC		= 5, // DEVELOPING ...
};

// 3D STEREO BUFFER TYPE
//
enum {

	QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE		= 0,

	QCAP_3D_STEREO_BUFFER_TOP_BOTTOM		= 1,

	QCAP_3D_STEREO_BUFFER_LINE_BY_LINE		= 2,
};

// 3D STEREO DISPLAY MODE
//
enum {

	QCAP_3D_STEREO_DISPLAY_MODE_SIDE_BY_SIDE	= 0,

	QCAP_3D_STEREO_DISPLAY_MODE_TOP_BOTTOM		= 1,

	QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE	= 2,

	QCAP_3D_STEREO_DISPLAY_MODE_LEFT_ONLY		= 3,

	QCAP_3D_STEREO_DISPLAY_MODE_RIGHT_ONLY		= 4,
};

// CALLBACK FUNCTION TYPES //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
typedef QRETURN (QCAP_EXPORT *PF_NO_SIGNAL_DETECTED_CALLBACK)( PVOID pDevice /*IN*/, ULONG nVideoInput /*IN*/, ULONG nAudioInput /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SIGNAL_REMOVED_CALLBACK)( PVOID pDevice /*IN*/, ULONG nVideoInput /*IN*/, ULONG nAudioInput /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_FORMAT_CHANGED_CALLBACK)( PVOID pDevice /*IN*/, ULONG nVideoInput /*IN*/, ULONG nAudioInput /*IN*/, ULONG nVideoWidth /*IN*/, ULONG nVideoHeight /*IN*/, BOOL bVideoIsInterleaved /*IN*/, double dVideoFrameRate /*IN*/, ULONG nAudioChannels /*IN*/, ULONG nAudioBitsPerSample /*IN*/, ULONG nAudioSampleFrequency /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SNAPSHOT_DONE_CALLBACK)( PVOID pDevice /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SNAPSHOT_STREAM_CALLBACK)( PVOID pDevice /*IN*/, CHAR * pszFilePathName /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_RECORD_DONE_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SHARE_RECORD_DONE_CALLBACK)( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK)( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK)( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszProperty /*IN*/, CHAR * pszValue /*OUT*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszProperty /*IN*/, CHAR * pszValue /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_CONNECTED_CALLBACK)( PVOID pClient /*IN*/, ULONG nVideoWidth /*IN*/, ULONG nVideoHeight /*IN*/, BOOL bVideoIsInterleaved /*IN*/, double dVideoFrameRate /*IN*/, ULONG nAudioChannels /*IN*/, ULONG nAudioBitsPerSample /*IN*/, ULONG nAudioSampleFrequency /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK)( PVOID pClient /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK)( PVOID pClient /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK)( PVOID pClient /*IN*/, CHAR * pszFilePathName /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK)( PVOID pServer /*IN*/, UINT iProNum /*IN*/, ULONG nEncoderFormat /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, ULONG nFrameRate /*IN*/, ULONG nRecordMode /*IN*/, ULONG nQuality /*IN*/, ULONG nBitRate /*IN*/, ULONG nGOP /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK)( PVOID pServer /*IN*/, UINT iProNum /*IN*/, ULONG nEncoderFormat /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, ULONG nBitRate /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK)( PVOID pCamera /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK)( PVOID pCamera /*IN*/, CHAR * pszFilePathName /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_FILE_SNAPSHOT_DONE_CALLBACK)( PVOID pFile /*IN*/, CHAR * pszFilePathName /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_FILE_SNAPSHOT_STREAM_CALLBACK)( PVOID pFile /*IN*/, CHAR * pszFilePathName /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_PREVIEW_CALLBACK)( PVOID pDevice /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_PREVIEW_CALLBACK)( PVOID pDevice /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_HARDWARE_ENCODER_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, BOOL bIsKeyFrame /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_RECORD_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, BOOL bIsKeyFrame /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_RECORD_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_MEDIA_RECORD_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, BOOL bIsKeyFrame /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_MX_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, UINT iTrackNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_MEDIA_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, UINT iTrackNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, BOOL bIsKeyFrame /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, BOOL bIsKeyFrame /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, double dSampleTime /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, UINT iChNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_FILE_CALLBACK)( PVOID pFile /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_VIDEO_DECODER_3D_FILE_CALLBACK)( PVOID pFile /*IN*/, UINT iChNum /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

typedef QRETURN (QCAP_EXPORT *PF_AUDIO_DECODER_FILE_CALLBACK)( PVOID pFile /*IN*/, double dSampleTime /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, PVOID pUserData /*IN*/ );

// CALLBACK FUNCTIONS PART.I (EVENT) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( PVOID pDevice /*IN*/, PF_NO_SIGNAL_DETECTED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( PVOID pDevice /*IN*/, PF_SIGNAL_REMOVED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( PVOID pDevice /*IN*/, PF_FORMAT_CHANGED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK( PVOID pDevice /*IN*/, PF_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_RECORD_DONE_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_RECORD_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK( UINT iRecNum /*IN*/, PF_SHARE_RECORD_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK( UINT iRecNum /*IN*/, PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK( PVOID pServer /*IN*/, PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK( PVOID pServer /*IN*/, PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_CONNECTED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK( PVOID pServer /*IN*/, PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK( PVOID pServer /*IN*/, PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK( PVOID pCamera /*IN*/, PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK( PVOID pFile /*IN*/, PF_FILE_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// CALLBACK FUNCTIONS PART.II (DATA) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( PVOID pDevice /*IN*/, PF_VIDEO_PREVIEW_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( PVOID pDevice /*IN*/, PF_AUDIO_PREVIEW_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_VIDEO_HARDWARE_ENCODER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// CALLBACK FUNCTIONS PART.III (DATA) ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK( PVOID pDevice /*IN*/, PF_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK( UINT iRecNum /*IN*/, PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK( PVOID pCamera /*IN*/, PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK( PVOID pFile /*IN*/, PF_FILE_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// CALLBACK FUNCTIONS PART.IIII (DATA) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_RECORD_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_VIDEO_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_RECORD_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_AUDIO_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_MEDIA_RECORD_CALLBACK( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_MEDIA_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ ); // ONLY FOR TS & FLV FILE FORMAT

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_VIDEO_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_MX_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_MEDIA_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ ); // ONLY FOR TS & FLV FILE FORMAT

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK( UINT iRecNum /*IN*/, PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_VIDEO_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_AUDIO_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK( PVOID pClient /*IN*/, PF_VIDEO_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK( PVOID pClient /*IN*/, PF_AUDIO_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK( PVOID pClient /*IN*/, PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK( PVOID pClient /*IN*/, PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK( PVOID pClient /*IN*/, PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK( PVOID pFile /*IN*/, PF_VIDEO_DECODER_FILE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK( PVOID pFile /*IN*/, PF_VIDEO_DECODER_3D_FILE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT QCAP_EXPORT QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK( PVOID pFile /*IN*/, PF_AUDIO_DECODER_FILE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// SYSTEM FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VERSION)( ULONG * pMajorVersion /*OUT*/, ULONG * pMinorVersion /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_SYSTEM_CONFIGURATION)( BOOL   bEnableMultipleUsersAccess = TRUE,				/*IN*/ // If true, qcap will alllow multiple users to access the device.

															    BOOL   bEnableVideoPreviewDevice = TRUE,				/*IN*/ // If true, the video capture device will be enabled.

															    BOOL   bEnableAudioPreviewDevice = TRUE,				/*IN*/ // If true, the audio capture device will be enabled.

															    BOOL   bEnableVideoHardwareMainEncoderDevice = TRUE,	/*IN*/ // If true, the main hardware encoder will be enabled.

															    BOOL   bEnableVideoHardwareSubEncoderDevice = TRUE,		/*IN*/ // If true, the sub hardware encoder will be enabled.

															    ULONG  nAutoInputDetectionTimeout = 3000,				/*IN*/ // The parameter allows you to specify the timeout duration of the auto input detection, default is 3sec.

															    BOOL   bEnableSCF = FALSE,								/*IN*/ // If true, the SCF file recording function will be turned on.
															   
															    CHAR * pszDB3 = NULL,									/*IN*/ // The parameter allows you to specify the file path of SQL database.
															   
															    BOOL   bEnableAsyncBackgroundSnapshot = FALSE,			/*IN*/ // If true, snapshot function will be moved into another thread. 
															   
															    BOOL   bEnableEnhancedVideoRenderer = TRUE,				/*IN*/ // If true, QCAP will enable the DirectShow's Enhanced Video Renderer Filter.
															   
															    BOOL   bEnableSystemTimeCallback = FALSE,				/*IN*/ // If true, the preview's and encoder's callbacks will return one local system time at dSampleTime.
															   
															    BOOL   bEnableFileRepairFunction = TRUE,				/*IN*/ // If true, the recording file will own self-repaired ability.
															   
															    ULONG  bEnableNewRTSPLibrary = TRUE,					/*IN*/ // If true, we will use new rtsp lib to repalce old one after 1.1.0.130.0
																
																CHAR * pszWebServerRootFolderPath = NULL,				/*IN*/ // The parameter allows you to specify the web server's root folder path.

																CHAR * pszWebServerIP = NULL );							/*IN*/ // The parameter allows you to specify the web server's ip address.

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_QUERY_ENCODER_TYPE_CAP)( ULONG nEncoderType /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_QUERY_DECODER_TYPE_CAP)( ULONG nDecoderType /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_QUERY_ENCODER_STATUS)( ULONG nEncoderType /*IN*/, ULONG * pExistInstances /*OUT*/ );

// DEVICE FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DEVICE_ENUMERATION)( ULONGLONG * * ppVideoDeviceList /*OUT*/, ULONG * pVideoDeviceSize /*OUT*/, ULONGLONG * * ppVideoEncoderDeviceList /*OUT*/, ULONG * pVideoEncoderDeviceSize /*OUT*/, ULONGLONG * * ppAudioDeviceList /*OUT*/, ULONG * pAudioDeviceSize /*OUT*/, ULONGLONG * * ppAudioEncoderDeviceList /*OUT*/, ULONG * pAudioEncoderDeviceSize /*OUT*/, ULONG nDeviceEnumType = QCAP_ENUM_TYPE_DEVICE_NAME /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_DEVICE_ENUMERATION_ITEM_INFO)( UINT iDevNum /*IN*/, ULONGLONG * pDeviceList /*IN*/, ULONG * pDeviceInfoH /*OUT*/, ULONG * pDeviceInfoL /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE)( CHAR * pszDevName /*IN*/, UINT iDevNum /*IN*/, HWND hAttachedWindow /*IN*/, PVOID * ppDevice /*OUT*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/ );

// DEVICE NAME TABLE:
//
// "DC1150 USB" IS FOR PD652, PD652.3D
//
// "QP0204 USB" IS FOR PD5A0
//
// "UB658G USB" IS FOR UB658
//
// "CY3014 USB" IS FOR UB530
//
// "TW6802 PCI" IS FOR SC200, SC300, SC230, SC330
//
// "CX2581 PCI" IS FOR SC310, SC340
//
// "CX2385 PCI" IS FOR SC350
//
// "AH8400 PCI" IS FOR SC290, SC390
//
// "FH8735 PCI" IS FOR SC2A0, SC3A0
//
// "TW5864 PCI" IS FOR SC2B0, SC3B0
//
// "MZ0380 PCI" IS FOR SC3C0
//
// "SA7160 PCI" IS FOR SC500, SC510, TB510
//
// "FH8735 PCI" IS FOR SC580
//
// "TW2809 PCI" IS FOR SC590
//
// "QP0203 PCI" IS FOR SC540, SC5A0
//
// "MZ0380 PCI" IS FOR SC3C0, SC5C0
//
//     "CAMERA" IS FOR GENERAL USB CAMERA
//
//  "SOUNDCARD" IS FOR GENERAL SOUND CARD

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY)( PVOID pDevice /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RUN)( PVOID pDevice /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP)( PVOID pDevice /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_INPUT)( PVOID pDevice /*IN*/, ULONG * pInput /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_INPUT)( PVOID pDevice /*IN*/, ULONG nInput /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_INPUT)( PVOID pDevice /*IN*/, ULONG * pInput /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_INPUT)( PVOID pDevice /*IN*/, ULONG nInput /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_STANDARD)( PVOID pDevice /*IN*/, ULONG * pStandard /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_STANDARD)( PVOID pDevice /*IN*/, ULONG nStandard /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_CURRENT_CONTENT_PROTECTION_STATUS)( PVOID pDevice /*IN*/, ULONG * pStatus /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT)( PVOID pDevice /*IN*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, BOOL * pIsInterleaved /*OUT*/, double * pFrameRate /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_CURRENT_INPUT_FORMAT)( PVOID pDevice /*IN*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_DEFAULT_OUTPUT_FORMAT)( PVOID pDevice /*IN*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, BOOL * pIsInterleaved /*OUT*/, double * pFrameRate /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_DEFAULT_OUTPUT_FORMAT)( PVOID pDevice /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BOOL bIsInterleaved /*IN*/, double dFrameRate /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_DEFAULT_OUTPUT_FORMAT)( PVOID pDevice /*IN*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_DEFAULT_OUTPUT_FORMAT)( PVOID pDevice /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_DEINTERLACE_TYPE)( PVOID pDevice /*IN*/, ULONG * pType /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_DEINTERLACE_TYPE)( PVOID pDevice /*IN*/, ULONG nType /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_DEINTERLACE)( PVOID pDevice /*IN*/, BOOL * pEnable /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_DEINTERLACE)( PVOID pDevice /*IN*/, BOOL bEnable /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_REGION_DISPLAY)( PVOID pDevice /*IN*/, ULONG * pCropX /*OUT*/, ULONG * pCropY /*OUT*/, ULONG * pCropW /*OUT*/, ULONG * pCropH /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_REGION_DISPLAY)( PVOID pDevice /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_MIRROR)( PVOID pDevice /*IN*/, BOOL * pHorizontalMirror /*OUT*/, BOOL * pVerticalMirror /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_MIRROR)( PVOID pDevice /*IN*/, BOOL bHorizontalMirror /*IN*/, BOOL bVerticalMirror /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_BRIGHTNESS)( PVOID pDevice /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_BRIGHTNESS)( PVOID pDevice /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_CONTRAST)( PVOID pDevice /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_CONTRAST)( PVOID pDevice /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_HUE)( PVOID pDevice /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_HUE)( PVOID pDevice /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SATURATION)( PVOID pDevice /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SATURATION)( PVOID pDevice /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARPNESS)( PVOID pDevice /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARPNESS)( PVOID pDevice /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_PREVIEW_PROPERTY_EX)( PVOID pDevice /*IN*/, ULONG * pDownscaleMode /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_PREVIEW_PROPERTY_EX)( PVOID pDevice /*IN*/, ULONG nDownscaleMode /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, ULONG * pDownscaleMode /*OUT*/, ULONG * pPostSkipFrameRate /*OUT*/, ULONG * pPostAvgFrameRate /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nEncoderFormat /*IN*/,  ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  ULONG   nDownscaleMode /*IN*/,  ULONG   nPostSkipFrameRate /*IN*/ , ULONG   nPostAvgFrameRate /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pRecordProfile /*OUT*/, ULONG * pRecordLevel /*OUT*/, ULONG * pRecordEntropy /*OUT*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pBFrames /*OUT*/, BOOL * pIsInterleaved /*OUT*/, ULONG * pSlices /*OUT*/, ULONG * pLayers /*OUT*/, ULONG * pSceneCut /*OUT*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, ULONG * pCropX /*OUT*/, ULONG * pCropY /*OUT*/, ULONG * pCropW /*OUT*/, ULONG * pCropH /*OUT*/, ULONG * pDownscaleMode /*OUT*/, ULONG * pPostSkipFrameRate /*OUT*/, ULONG * pPostAvgFrameRate /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nEncoderFormat /*IN*/,  ULONG   nRecordProfile /*IN*/ , ULONG   nRecordLevel /*IN*/ , ULONG   nRecordEntropy /*IN*/ , ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nBFrames /*IN*/ , BOOL   bIsInterleaved /*IN*/ , ULONG   nSlices /*IN*/ , ULONG   nLayers /*IN*/ , ULONG   nSceneCut /*IN*/,  ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  ULONG   nCropX /*IN*/,  ULONG   nCropY /*IN*/,  ULONG   nCropW /*IN*/,  ULONG   nCropH /*IN*/,  ULONG   nDownscaleMode /*IN*/,  ULONG   nPostSkipFrameRate /*IN*/ , ULONG   nPostAvgFrameRate /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG nProperty /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG nProperty /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_VOLUME)( PVOID pDevice /*IN*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_VOLUME)( PVOID pDevice /*IN*/, ULONG nVolume /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_DEVICE_CUSTOM_PROPERTY)( PVOID pDevice /*IN*/, ULONG nProperty /*IN*/, ULONG * pValue /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_DEVICE_CUSTOM_PROPERTY)( PVOID pDevice /*IN*/, ULONG nProperty /*IN*/, ULONG nValue /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_DEVICE_CUSTOM_PROPERTY_EX)( PVOID pDevice /*IN*/, ULONG nProperty /*IN*/, BYTE * pValue /*OUT*/, ULONG nBytes /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX)( PVOID pDevice /*IN*/, ULONG nProperty /*IN*/, BYTE * pValue /*IN*/, ULONG nBytes /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK)( PVOID pDevice /*IN*/, PF_NO_SIGNAL_DETECTED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK)( PVOID pDevice /*IN*/, PF_SIGNAL_REMOVED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_FORMAT_CHANGED_CALLBACK)( PVOID pDevice /*IN*/, PF_FORMAT_CHANGED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK)( PVOID pDevice /*IN*/, PF_VIDEO_PREVIEW_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK)( PVOID pDevice /*IN*/, PF_AUDIO_PREVIEW_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_VIDEO_HARDWARE_ENCODER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// LOCK/UNLOCK FUNCTIONS (SUPPORT LABVIEW 2010/2012 DEVELOPER) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COPY_VIDEO_PREVIEW_BUFFER)( PVOID pDevice /*IN*/, double * pSampleTime /*OUT*/, BYTE * pFrameBuffer /*OUT*/, ULONG * pFrameBufferLen /*IN/OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COPY_AUDIO_PREVIEW_BUFFER)( PVOID pDevice /*IN*/, double * pSampleTime /*OUT*/, BYTE * pFrameBuffer /*OUT*/, ULONG * pFrameBufferLen /*IN/OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_LOCK_VIDEO_PREVIEW_BUFFER)( PVOID pDevice /*IN*/, double * pSampleTime /*OUT*/, BYTE * * ppFrameBuffer /*OUT*/, ULONG * pFrameBufferLen /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_UNLOCK_VIDEO_PREVIEW_BUFFER)( PVOID pDevice /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_LOCK_AUDIO_PREVIEW_BUFFER)( PVOID pDevice /*IN*/, double * pSampleTime /*OUT*/, BYTE * * ppFrameBuffer /*OUT*/, ULONG * pFrameBufferLen /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_UNLOCK_AUDIO_PREVIEW_BUFFER)( PVOID pDevice /*IN*/ );

// SNAPSHOT FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BMP)( PVOID pDevice /*IN*/, CHAR * pszFilePathName /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_JPG)( PVOID pDevice /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BMP_EX)( PVOID pDevice /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_JPG_EX)( PVOID pDevice /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK)( PVOID pDevice /*IN*/, PF_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK)( PVOID pDevice /*IN*/, PF_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// CHANNEL RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS CHANNEL RECORDING) (RECNUM: 0 ~ 3) /////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_RECORD_PROPERTY)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, ULONG * pDownscaleMode /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_RECORD_PROPERTY)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  ULONG   nDownscaleMode /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_RECORD_PROPERTY_EX)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pRecordProfile /*OUT*/ /*DEFAULT = BASELINE*/, ULONG * pRecordLevel /*OUT*/ /*DEFAULT = 41*/, ULONG * pRecordEntropy /*OUT*/ /*DEFAULT = CAVLC*/, ULONG * pRecordComplexity /*OUT*/ /*DEFAULT = 0*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pBFrames /*OUT*/ /*DEFAULT = 0*/, BOOL * pIsInterleaved /*OUT*/ /*DEFAULT = FALSE*/, ULONG * pSlices /*OUT*/ /*DEFAULT = 0*/, ULONG * pLayers /*OUT*/ /*DEFAULT = 0*/, ULONG * pSceneCut /*OUT*/ /*DEFAULT = 0*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, ULONG * pCropX /*OUT*/, ULONG * pCropY /*OUT*/, ULONG * pCropW /*OUT*/, ULONG * pCropH /*OUT*/, ULONG * pDstW /*OUT*/, ULONG * pDstH /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_RECORD_PROPERTY_EX)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nRecordProfile /*IN*/  /*DEFAULT = BASELINE*/, ULONG   nRecordLevel /*IN*/  /*DEFAULT = 41*/, ULONG   nRecordEntropy /*IN*/  /*DEFAULT = CAVLC*/, ULONG   nRecordComplexity /*IN*/  /*DEFAULT = 0*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nBFrames /*IN*/  /*DEFAULT = 0*/, BOOL   bIsInterleaved /*IN*/  /*DEFAULT = FALSE*/, ULONG   nSlices /*IN*/  /*DEFAULT = 0*/, ULONG   nLayers /*IN*/  /*DEFAULT = 0*/, ULONG   nSceneCut /*IN*/  /*DEFAULT = 0*/, ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  ULONG   nCropX /*IN*/,  ULONG   nCropY /*IN*/,  ULONG   nCropW /*IN*/,  ULONG   nCropH /*IN*/,  ULONG   nDstW /*IN*/,  ULONG   nDstH /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_RECORD_PROPERTY)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_RECORD_PROPERTY)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_RECORD_PROPERTY_EX)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pBitRate /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_RECORD_PROPERTY_EX)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nBitRate /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_RECORD_SOFTWARE_ENCODER_PROPERTY)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_RECORD_SOFTWARE_ENCODER_PROPERTY)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_CLONE_RECORD)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, CHAR * pszFilePathNameA /*IN*/, CHAR * pszFilePathNameB /*IN*/, DWORD dwFlags = QCAP_RECORD_FLAG_FULL /*IN*/, double dVideoDelayTime = 0.0 /*IN*/, double dAudioDelayTime = 0.0 /*IN*/, double dSegmentDurationTime = 0.0 /*IN*/, ULONG nSegmentDurationSizeKB = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_RECORD)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, DWORD dwFlags = QCAP_RECORD_FLAG_FULL /*IN*/, double dVideoDelayTime = 0.0 /*IN*/, double dAudioDelayTime = 0.0 /*IN*/, double dSegmentDurationTime = 0.0 /*IN*/, ULONG nSegmentDurationSizeKB = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_RECORD)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESUME_RECORD)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_PAUSE_RECORD)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_RECORD_DONE_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_RECORD_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_RECORD_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_VIDEO_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_RECORD_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_AUDIO_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_MEDIA_RECORD_CALLBACK)( PVOID pDevice /*IN*/, UINT iRecNum /*IN*/, PF_MEDIA_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// CLONE FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_CLONE)( PVOID pDevice /*IN*/, HWND hAttachedWindow /*IN*/, PVOID * ppCloneDevice /*OUT*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/ );

// OSD FUNCTIONS (SUPPORT MULTIPLE-LAYERS OSD OBJECTS) (OSDNUM: 0 ~ 127) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_OSD_TEXT_BOUNDARY)( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_TEXT)( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_PICTURE)( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nTransparent /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_BUFFER)( PVOID pDevice /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

// MULTIPLE CHANNELS SYNCHRONIZED RECORDING FUNCTIONS (SYNCHRONIZED RECORDING) //////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_SYNCHRONIZED_RECORD)( ULONG nFileArgs /*IN*/, CHAR * pszFilePathName1 /*IN*/, PVOID pDevice1 /*IN*/, UINT iRecNum1 /*IN*/, 
															   
                                                                                         CHAR * pszFilePathName2 /*IN*/, PVOID pDevice2 /*IN*/, UINT iRecNum2 /*IN*/, ... );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_SYNCHRONIZED_RECORD)( BOOL bIsAsync /*IN*/, ULONG nMilliseconds /*IN*/, ULONG nFileArgs /*IN*/, PVOID pDevice1 /*IN*/, UINT iRecNum1 /*IN*/, 
															  
                                                                                                                                          PVOID pDevice2 /*IN*/, UINT iRecNum2 /*IN*/, ... );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESUME_SYNCHRONIZED_RECORD)( ULONG nFileArgs /*IN*/, PVOID pDevice1 /*IN*/, UINT iRecNum1 /*IN*/, 
															   
                                                                                          PVOID pDevice2 /*IN*/, UINT iRecNum2 /*IN*/, ... );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_PAUSE_SYNCHRONIZED_RECORD)( ULONG nFileArgs /*IN*/, PVOID pDevice1 /*IN*/, UINT iRecNum1 /*IN*/, 
															   
                                                                                         PVOID pDevice2 /*IN*/, UINT iRecNum2 /*IN*/, ... );
// SYNCHRONIZED RECORDING EXAMPLE
//
// QCAP_START_SYNCHRONIZED_RECORD( 4, "SR_CH01.MP4", pDevices[ 0 ], 0, 
//
//								      "SR_CH02.MP4", pDevices[ 1 ], 0, 
//
//								      "SR_CH03.MP4", pDevices[ 2 ], 0, 
//
//								      "SR_CH04.MP4", pDevices[ 3 ], 0 );
//
// QCAP_STOP_SYNCHRONIZED_RECORD( TRUE, 0, 4, pDevices[ 0 ], 0, 
//
//										      pDevices[ 1 ], 0, 
//
//										      pDevices[ 2 ], 0, 
//
//										      pDevices[ 3 ], 0 );

// SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 31) ////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY)( UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, double * pFrameRate /*OUT*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, HWND * pAttachedWindow = NULL /*OUT*/, BOOL * pThumbDraw = NULL /*OUT*/, BOOL * pMaintainAspectRatio = NULL /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY)( UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nColorSpaceType /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  double   dFrameRate /*IN*/,  ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  HWND   hAttachedWindow = NULL /*IN*/,  BOOL   bThumbDraw = FALSE /*IN*/, BOOL   bMaintainAspectRatio = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY_EX)( UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, double * pFrameRate /*OUT*/, ULONG * pRecordProfile /*OUT*/ /*DEFAULT = BASELINE*/, ULONG * pRecordLevel /*OUT*/ /*DEFAULT = 41*/, ULONG * pRecordEntropy /*OUT*/ /*DEFAULT = CAVLC*/, ULONG * pRecordComplexity /*OUT*/ /*DEFAULT = 0*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pBFrames /*OUT*/ /*DEFAULT = 0*/, BOOL * pIsInterleaved /*OUT*/ /*DEFAULT = FALSE*/, ULONG * pSlices /*OUT*/ /*DEFAULT = 0*/, ULONG * pLayers /*OUT*/ /*DEFAULT = 0*/, ULONG * pSceneCut /*OUT*/ /*DEFAULT = 0*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, HWND * pAttachedWindow = NULL /*OUT*/, BOOL * pThumbDraw = NULL /*OUT*/, BOOL * pMaintainAspectRatio = NULL /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY_EX)( UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nColorSpaceType /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  double   dFrameRate /*IN*/,  ULONG   nRecordProfile /*IN*/  /*DEFAULT = BASELINE*/, ULONG   nRecordLevel /*IN*/  /*DEFAULT = 41*/, ULONG   nRecordEntropy /*IN*/  /*DEFAULT = CAVLC*/, ULONG   nRecordComplexity /*IN*/  /*DEFAULT = 0*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nBFrames /*IN*/  /*DEFAULT = 0*/, BOOL   bIsInterleaved /*IN*/  /*DEFAULT = FALSE*/, ULONG   nSlices /*IN*/  /*DEFAULT = 0*/, ULONG   nLayers /*IN*/  /*DEFAULT = 0*/, ULONG   nSceneCut /*IN*/  /*DEFAULT = 0*/, ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  HWND   hAttachedWindow = NULL /*IN*/,  BOOL   bThumbDraw = FALSE /*IN*/, BOOL   bMaintainAspectRatio = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY)( UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY)( UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/,  ULONG   nVolume /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY_EX)( UINT iRecNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY_EX)( UINT iRecNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nVolume /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_SHARE_RECORD_SOFTWARE_ENCODER_PROPERTY)( UINT iRecNum /*IN*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_SOFTWARE_ENCODER_PROPERTY)( UINT iRecNum /*IN*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER)( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX)( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, BOOL bForceKeyFrame = FALSE /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER)( UINT iRecNum /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX)( UINT iRecNum /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER)( UINT iRecNum /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, ULONG bIsKeyFrame /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_SHARE_RECORD_COMPRESSION_BUFFER)( UINT iRecNum /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_SHARE_RECORD)( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, DWORD dwFlags = QCAP_RECORD_FLAG_FULL /*IN*/, double dVideoDelayTime = 0.0 /*IN*/, double dAudioDelayTime = 0.0 /*IN*/, double dSegmentDurationTime = 0.0 /*IN*/, ULONG nSegmentDurationSizeKB = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_SHARE_RECORD)( UINT iRecNum /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESUME_SHARE_RECORD)( UINT iRecNum /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_PAUSE_SHARE_RECORD)( UINT iRecNum /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_SHARE_RECORD_BMP)( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_SHARE_RECORD_JPG)( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_SHARE_RECORD_BMP_EX)( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_SHARE_RECORD_JPG_EX)( UINT iRecNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY)( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_SHARE_RECORD_TEXT)( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_SHARE_RECORD_PICTURE)( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nTransparent /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_SHARE_RECORD_BUFFER)( UINT iRecNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK)( UINT iRecNum /*IN*/, PF_SHARE_RECORD_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK)( UINT iRecNum /*IN*/, PF_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK)( UINT iRecNum /*IN*/, PF_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, PF_VIDEO_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, PF_AUDIO_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, PF_MEDIA_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, PF_VIDEO_DECODER_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, PF_AUDIO_DECODER_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// VIDEO 3D SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 31) ///////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER)( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nStereoBufferType = QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER_EX)( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nStereoBufferType = QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER)( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER_EX)( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER)( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER_EX)( UINT iRecNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER)( UINT iRecNum /*IN*/, ULONG nStereoDisplayMode = QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE /*IN*/, BOOL bLeftRightSwap = FALSE /*IN*/, BOOL bForceKeyFrame = FALSE /*IN*/, double dSampleTime = 0.0 /*IN*/ );

// AUDIO MIXING SHARE RECORDING FUNCTIONS (SUPPORT MULTIPLE-STREAMS SHARE RECORDING) (RECNUM: 0 ~ 31) (TRACKNUM: 0 ~ 3) //////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX)( UINT iRecNum /*IN*/, ULONG * pTracks /*OUT*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX)( UINT iRecNum /*IN*/, ULONG   nTracks /*IN*/,  ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nVolume /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER)( UINT iRecNum /*IN*/, UINT iTrackNum /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_SHARE_RECORD_UNCOMPRESSION_BUFFER)( UINT iRecNum /*IN*/, UINT iTrackNum /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_SHARE_RECORD_COMPRESSION_BUFFER)( UINT iRecNum /*IN*/, UINT iTrackNum /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, PF_AUDIO_MX_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK)( UINT iRecNum /*IN*/, PF_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// BROADCASTING SERVER FUNCTIONS (SHARE STREAMING TX FUNCTIONS) (SVRNUM: 0 ~ 63) ////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_BROADCAST_RTSP_SERVER)( UINT iSvrNum /*IN*/, ULONG nTotalSessions /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/, ULONG nNetworkPort_RTSP = 554 /*IN*/, ULONG nNetworkPort_RTSPOverHTTP = 0 /*IN*/ /*DEFAULT = TURN OFF*/, BOOL bEnableMulticasting = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_BROADCAST_RTMP_SERVER)( UINT iSvrNum /*IN*/, ULONG nTotalSessions /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/, ULONG nNetworkPort_RTMP = 1935 /*IN*/, ULONG nNetworkPort_RTMPOverHTTP = 0 /*IN*/ /*DEFAULT = TURN OFF*/, CHAR * pszServerName = NULL /*IN*/ /*DEFAULT = "flvplayback"*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_BROADCAST_RTMP_SERVER_EX)( UINT iSvrNum /*IN*/, ULONG nTotalSessions /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/, ULONG nNetworkPort_RTMP = 1935 /*IN*/, ULONG nNetworkPort_RTMPOverHTTP = 0 /*IN*/ /*DEFAULT = TURN OFF*/, CHAR * pszServerName = NULL /*IN*/ /*DEFAULT = "flvplayback"*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER)( UINT iSvrNum /*IN*/, CHAR * pszURL /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER_EX)( UINT iSvrNum /*IN*/, CHAR * pszURL /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_BROADCAST_MMS_WEB_PORTAL_SERVER)( UINT iSvrNum /*IN*/, CHAR * pszURL /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszAccount = NULL /*IN*/, CHAR * pszPassword = NULL /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_BROADCAST_HLS_SERVER)( UINT iSvrNum /*IN*/, ULONG nTotalSessions /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszWebServerRootFolderPath /*IN*/, CHAR * pszSubFolderPath /*IN*/, ULONG nSegmentDuration = 1000 /*IN*/, CHAR * pszWebServerIP = NULL /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_BROADCAST_SERVER)( PVOID pServer /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_BROADCAST_SERVER)( PVOID pServer /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_BROADCAST_SERVER)( PVOID pServer /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_SESSION_BROADCAST_SERVER_PROPERTY)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * * ppszSessionName /*OUT*/, ULONG * pVideoDelayLiveDuration /*OUT*/, ULONG * pAudioDelayLiveDuration /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_SESSION_BROADCAST_SERVER_PROPERTY)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszSessionName /*IN*/ /*DEFAULT = "session%d.mpg"*/, ULONG nVideoDelayLiveDuration /*IN*/, ULONG nAudioDelayLiveDuration /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PVOID pDevice /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE_EX)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PVOID pDevice /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, double * pFrameRate /*OUT*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, HWND * pAttachedWindow = NULL /*OUT*/, BOOL * pThumbDraw = NULL /*OUT*/, BOOL * pMaintainAspectRatio = NULL /*OUT*/, DWORD * pFlags = NULL /*OUT*/                    );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nColorSpaceType /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  double   dFrameRate /*IN*/,  ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  HWND   hAttachedWindow = NULL /*IN*/,  BOOL   bThumbDraw = FALSE /*IN*/, BOOL   bMaintainAspectRatio = FALSE /*IN*/, DWORD  dwFlags = QCAP_BROADCAST_FLAG_FULL /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY_EX)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, double * pFrameRate /*OUT*/, ULONG * pRecordProfile /*OUT*/ /*DEFAULT = BASELINE*/, ULONG * pRecordLevel /*OUT*/ /*DEFAULT = 41*/, ULONG * pRecordEntropy /*OUT*/ /*DEFAULT = CAVLC*/, ULONG * pRecordComplexity /*OUT*/ /*DEFAULT = 0*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/, ULONG * pBFrames /*OUT*/ /*DEFAULT = 0*/, BOOL * pIsInterleaved /*OUT*/ /*DEFAULT = FALSE*/, ULONG * pSlices /*OUT*/ /*DEFAULT = 0*/, ULONG * pLayers /*OUT*/ /*DEFAULT = 0*/, ULONG * pSceneCut /*OUT*/ /*DEFAULT = 0*/, ULONG * pAspectRatioX /*OUT*/, ULONG * pAspectRatioY /*OUT*/, HWND * pAttachedWindow = NULL /*OUT*/, BOOL * pThumbDraw = NULL /*OUT*/, BOOL * pMaintainAspectRatio = NULL /*OUT*/, DWORD * pFlags = NULL /*OUT*/                    );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY_EX)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nColorSpaceType /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  double   dFrameRate /*IN*/,  ULONG   nRecordProfile /*IN*/  /*DEFAULT = BASELINE*/, ULONG   nRecordLevel /*IN*/  /*DEFAULT = 41*/, ULONG   nRecordEntropy /*IN*/  /*DEFAULT = CAVLC*/, ULONG   nRecordComplexity /*IN*/  /*DEFAULT = 0*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/,  ULONG   nBFrames /*IN*/  /*DEFAULT = 0*/, BOOL   bIsInterleaved /*IN*/  /*DEFAULT = FALSE*/, ULONG   nSlices /*IN*/  /*DEFAULT = 0*/, ULONG   nLayers /*IN*/  /*DEFAULT = 0*/, ULONG   nSceneCut /*IN*/  /*DEFAULT = 0*/, ULONG   nAspectRatioX /*IN*/,  ULONG   nAspectRatioY /*IN*/,  HWND   hAttachedWindow = NULL /*IN*/,  BOOL   bThumbDraw = FALSE /*IN*/, BOOL   bMaintainAspectRatio = FALSE /*IN*/, DWORD  dwFlags = QCAP_BROADCAST_FLAG_FULL /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/,  ULONG   nVolume /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY_EX)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG * pEncoderType /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY_EX)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG   nEncoderType /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nVolume /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_BROADCAST_SERVER_SOFTWARE_ENCODER_PROPERTY)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG * pRecordMode /*OUT*/, ULONG * pQuality /*OUT*/, ULONG * pBitRate /*OUT*/, ULONG * pGOP /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_BROADCAST_SERVER_SOFTWARE_ENCODER_PROPERTY)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG   nRecordMode /*IN*/,  ULONG   nQuality /*IN*/,  ULONG   nBitRate /*IN*/,  ULONG   nGOP /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/, BOOL bClearDelayLive = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, BOOL bForceKeyFrame = FALSE /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/, BOOL bClearDelayLive = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/, BOOL bClearDelayLive = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/, BOOL bClearDelayLive = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, ULONG bIsKeyFrame /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/, BOOL bClearDelayLive = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_BROADCAST_SERVER_COMPRESSION_BUFFER)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/, BOOL bClearDelayLive = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BROADCAST_SERVER_BMP)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BROADCAST_SERVER_JPG)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BROADCAST_SERVER_BMP_EX)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BROADCAST_SERVER_JPG_EX)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_BROADCAST_SERVER_TEXT)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_BROADCAST_SERVER_PICTURE)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nTransparent /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_BROADCAST_SERVER_BUFFER)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer /*IN*/, PF_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK)( PVOID pServer /*IN*/, PF_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_VIDEO_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_AUDIO_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, PF_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// VIDEO 3D BROADCASTING SERVER FUNCTIONS (SHARE STREAMING TX FUNCTIONS) (SVRNUM: 0 ~ 63) /////////////////////////////////////////////////////////////////////////////////////////////////////////
//
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nStereoBufferType = QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER_EX)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nStereoBufferType = QCAP_3D_STEREO_BUFFER_SIDE_BY_SIDE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER_EX)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER_EX)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_BROADCAST_SERVER_UNCOMPRESSION_BUFFER)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, ULONG nStereoDisplayMode = QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE /*IN*/, BOOL bLeftRightSwap = FALSE /*IN*/, BOOL bForceKeyFrame = FALSE /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/, BOOL bClearDelayLive = FALSE /*IN*/ );

// AUDIO MIXING BROADCASTING SERVER FUNCTIONS (SHARE STREAMING TX FUNCTIONS) (SVRNUM: 0 ~ 63) /////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_BROADCAST_SERVER_UNCOMPRESSION_BUFFER)( PVOID pServer /*IN*/, UINT iSessionNum /*IN*/, double dSampleTime = 0.0 /*IN*/ /*HLS NEED IT*/, BOOL bClearDelayLive = FALSE /*IN*/ );

// BROADCASTING RTSP SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_RTSP_SERVER( 0, 4 /*4 CHANNELS*/, &pServer, "root", "root", 554 );
//
//         CH01 URL -> rtsp://root:root@127.0.0.1:554/session0.mpg
//
//         CH02 URL -> rtsp://root:root@127.0.0.1:554/session1.mpg
//
//         CH03 URL -> rtsp://root:root@127.0.0.1:554/session2.mpg
//
//         CH04 URL -> rtsp://root:root@127.0.0.1:554/session3.mpg
// 
// STEP#02 QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 0 /*CH01*/, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 1 /*CH02*/, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 2 /*CH03*/, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( pServer, 3 /*CH04*/, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 480, 270, 30, QCAP_RECORD_MODE_CBR, 8000, 1000000, 30, 0, 0, NULL, FALSE, QCAP_BROADCAST_FLAG_NETWORK | QCAP_BROADCAST_FLAG_ENCODE );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 0 /*CH01*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 1 /*CH02*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 2 /*CH03*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( pServer, 3 /*CH04*/, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 0 );
//
// STEP#03 QCAP_START_BROADCAST_SERVER( pServer );
//
// STEP#04 QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 0 /*CH01*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferA, nFrameBufferLenA );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 1 /*CH02*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferB, nFrameBufferLenB );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 2 /*CH03*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferC, nFrameBufferLenC );
//
//         QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 3 /*CH04*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferD, nFrameBufferLenD );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 0 /*CH01*/, pFrameBufferA, nFrameBufferLenA );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 1 /*CH02*/, pFrameBufferB, nFrameBufferLenB );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 2 /*CH03*/, pFrameBufferC, nFrameBufferLenC );
//
//         QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pServer, 3 /*CH04*/, pFrameBufferD, nFrameBufferLenD );
//
// STEP#05 QCAP_STOP_BROADCAST_SERVER( pServer );
//
// STEP#06 QCAP_DRSTROY_BROADCAST_SERVER( pServer );

// BROADCASTING RTMP SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_RTMP_SERVER( 0, 4 /*4 CHANNELS*/, &pServer, NULL, NULL, 1935 );
//
//         CH01 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session0.mpg (HERE, xxx.xxx.xxx.xxx IS YOUR WEB SERVER ADDRESS)
//
//         CH02 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session1.mpg
//
//         CH03 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session2.mpg
//
//         CH04 URL -> rtmp://xxx.xxx.xxx.xxx:1935/flvplayback/session3.mpg

// BROADCASTING HLS SERVER EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_HLS_SERVER( 0, 4 /*4 CHANNELS*/, &pServer, "C:\\AppServ\\www\\", "hls\\", 3000 ); // HERE, C:\\AppServ\\www\\ IS YOUR WEB SERVER ROOT FOLDER, hls\\ is SUB FOLDER TO SAVE HLS FILES
//
//         CH01 URL -> http://xxx.xxx.xxx.xxx/hls/session0.m3u8 (HERE, xxx.xxx.xxx.xxx IS YOUR WEB SERVER ADDRESS)
//
//         CH02 URL -> http://xxx.xxx.xxx.xxx/hls/session1.m3u8
//
//         CH03 URL -> http://xxx.xxx.xxx.xxx/hls/session2.m3u8
//
//         CH04 URL -> http://xxx.xxx.xxx.xxx/hls/session3.m3u8

// BROADCASTING CLIENT FUNCTIONS (SHARE STREAMING RX FUNCTIONS) (CLINUM: 0 ~ 63) ////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_BROADCAST_CLIENT)( UINT iCliNum /*IN*/, CHAR * pszURL /*IN*/, PVOID * ppClient /*OUT*/, ULONG nDecoderType /*IN*/, HWND hAttachedWindow = NULL /*IN*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_BROADCAST_CLIENT)( PVOID pClient /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_BROADCAST_CLIENT)( PVOID pClient /*IN*/, ULONG nProtocol = QCAP_BROADCAST_PROTOCOL_UDP /*IN*/, ULONG nReconnectionTimeout = 3000 /*IN*/, ULONG nDelayQueueDuration = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_BROADCAST_CLIENT)( PVOID pClient /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY)( PVOID pClient /*IN*/, ULONG * pCropX /*OUT*/, ULONG * pCropY /*OUT*/, ULONG * pCropW /*OUT*/, ULONG * pCropH /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY)( PVOID pClient /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_BROADCAST_CLIENT_MIRROR)( PVOID pClient /*IN*/, BOOL * pHorizontalMirror /*OUT*/, BOOL * pVerticalMirror /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_BROADCAST_CLIENT_MIRROR)( PVOID pClient /*IN*/, BOOL bHorizontalMirror /*IN*/, BOOL bVerticalMirror /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_BROADCAST_CLIENT_VOLUME)( PVOID pClient /*IN*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME)( PVOID pClient /*IN*/, ULONG nVolume /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_BROADCAST_CLIENT_RECORD)( PVOID pClient /*IN*/, CHAR * pszFilePathName /*IN*/, double dVideoDelayTime = 0.0 /*IN*/, double dAudioDelayTime = 0.0 /*IN*/, double dSegmentDurationTime = 0.0 /*IN*/, ULONG nSegmentDurationSizeKB = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_BROADCAST_CLIENT_RECORD)( PVOID pClient /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESUME_BROADCAST_CLIENT_RECORD)( PVOID pClient /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_PAUSE_BROADCAST_CLIENT_RECORD)( PVOID pClient /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP)( PVOID pClient /*IN*/, CHAR * pszFilePathName /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG)( PVOID pClient /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP_EX)( PVOID pClient /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG_EX)( PVOID pClient /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY)( PVOID pClient /*IN*/, UINT iOsdNum /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_BROADCAST_CLIENT_TEXT)( PVOID pClient /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_BROADCAST_CLIENT_PICTURE)( PVOID pClient /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nTransparent /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER)( PVOID pClient /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_BROADCAST_CLIENT_CUSTOM_PROPERTY)( PVOID pClient /*IN*/, CHAR * pszProperty /*IN*/, CHAR * pszValue /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_BROADCAST_CLIENT_CUSTOM_PROPERTY)( PVOID pClient /*IN*/, CHAR * pszProperty /*IN*/, CHAR * pszValue /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK)( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_CONNECTED_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK)( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_RECORD_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK)( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK)( PVOID pClient /*IN*/, PF_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, PF_VIDEO_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, PF_AUDIO_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, PF_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, PF_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// 3D BROADCASTING CLIENT FUNCTIONS (3D SHARE STREAMING RX FUNCTIONS) (CLINUM: 0 ~ 63) ////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_3D_BROADCAST_CLIENT)( UINT iCliNum /*IN*/, CHAR * pszURL /*IN*/, PVOID * ppClient /*OUT*/, ULONG nDecoderType /*IN*/, HWND hAttachedWindowL = NULL /*IN*/, BOOL bThumbDrawL = FALSE /*IN*/, BOOL bMaintainAspectRatioL = FALSE /*IN*/, HWND hAttachedWindowR = NULL /*IN*/, BOOL bThumbDrawR = FALSE /*IN*/, BOOL bMaintainAspectRatioR = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE)( PVOID pClient /*IN*/, ULONG * pStereoDisplayMode /*OUT*/, BOOL * pLeftRightSwap /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE)( PVOID pClient /*IN*/, ULONG nStereoDisplayMode = QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE /*IN*/, BOOL bLeftRightSwap = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK)( PVOID pClient /*IN*/, PF_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// BROADCASTING CLIENT EXAMPLE:
//
// STEP#01 QCAP_CREATE_BROADCAST_CLIENT( 0, "rtsp://root:root@127.0.0.1:554/session0.mpg", &pClient, QCAP_DECODER_TYPE_SOFTWARE, hWindow, TRUE );
//
// STEP#02 QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK( pClient, on_process_video_stream, this );
//
//         QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK( pClient, on_process_audio_stream, this );
//
// STEP#03 QCAP_START_BROADCAST_CLIENT( pClient );
//
// STEP#04 QCAP_STOP_BROADCAST_CLIENT( pClient );
//
// STEP#05 QCAP_DESTROY_BROADCAST_CLIENT( pClient );

// COMMUNICATION SERVER FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_COMMUNICATION_ONVIF_SERVER)( ULONG nTotalVideoSources /*IN*/, ULONG nTotalAudioSources /*IN*/, ULONG nTotalVideoEncoders /*IN*/, ULONG nTotalAudioEncoders /*IN*/, ULONG nTotalProfiles /*IN*/, PVOID * ppServer /*OUT*/, CHAR * pszManufacturer = NULL /*IN*/, CHAR * pszModel = NULL /*IN*/, CHAR * pszFirmwareVersion = NULL /*IN*/, CHAR * pszSerialNumber = NULL /*IN*/, CHAR * pszHardwareID = NULL /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_COMMUNICATION_SERVER)( PVOID pServer /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_COMMUNICATION_SERVER)( PVOID pServer /*IN*/, ULONG nNetworkPort_ONVIF = 8001 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_COMMUNICATION_SERVER)( PVOID pServer /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_SERVER_VIDEO_SOURCE)( PVOID pServer /*IN*/, UINT iVidSrcNum /*IN*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, ULONG * pFrameRate /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_SERVER_VIDEO_SOURCE)( PVOID pServer /*IN*/, UINT iVidSrcNum /*IN*/, ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  ULONG   nFrameRate /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_SERVER_AUDIO_SOURCE)( PVOID pServer /*IN*/, UINT iAudSrcNum /*IN*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_SERVER_AUDIO_SOURCE)( PVOID pServer /*IN*/, UINT iAudSrcNum /*IN*/, ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_SERVER_VIDEO_ENCODER)( PVOID pServer /*IN*/, UINT iVidEncNum /*IN*/, UINT * pVidSrcNum /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pFrameRate_Min /*OUT*/, ULONG * pFrameRate_Max /*OUT*/, ULONG * pFrameRate_Default /*OUT*/, ULONG * pRecordMode_Min /*OUT*/, ULONG * pRecordMode_Max /*OUT*/, ULONG * pRecordMode_Default /*OUT*/, ULONG * pQuality_Min /*OUT*/, ULONG * pQuality_Max /*OUT*/, ULONG * pQuality_Default /*OUT*/, ULONG * pBitRate_Min /*OUT*/, ULONG * pBitRate_Max /*OUT*/, ULONG * pBitRate_Default /*OUT*/, ULONG * pGOP_Min /*OUT*/, ULONG * pGOP_Max /*OUT*/, ULONG * pGOP_Default /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_SERVER_VIDEO_ENCODER)( PVOID pServer /*IN*/, UINT iVidEncNum /*IN*/, UINT   iVidSrcNum /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nFrameRate_Min /*IN*/,  ULONG   nFrameRate_Max /*IN*/,  ULONG   nFrameRate_Default /*IN*/,  ULONG   nRecordMode_Min /*IN*/,  ULONG   nRecordMode_Max /*IN*/,  ULONG   nRecordMode_Default /*IN*/,  ULONG   nQuality_Min /*IN*/,  ULONG   nQuality_Max /*IN*/,  ULONG   nQuality_Default /*IN*/,  ULONG   nBitRate_Min /*IN*/,  ULONG   nBitRate_Max /*IN*/,  ULONG   nBitRate_Default /*IN*/,  ULONG   nGOP_Min /*IN*/,  ULONG   nGOP_Max /*IN*/,  ULONG   nGOP_Default /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_SERVER_AUDIO_ENCODER)( PVOID pServer /*IN*/, UINT iAudEncNum /*IN*/, UINT * pAudSrcNum /*OUT*/, ULONG * pEncoderFormat /*OUT*/, ULONG * pBitRate_Min /*OUT*/, ULONG * pBitRate_Max /*OUT*/, ULONG * pBitRate_Default /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_SERVER_AUDIO_ENCODER)( PVOID pServer /*IN*/, UINT iAudEncNum /*IN*/, UINT   iAudSrcNum /*IN*/,  ULONG   nEncoderFormat /*IN*/,  ULONG   nBitRate_Min /*IN*/,  ULONG   nBitRate_Max /*IN*/,  ULONG   nBitRate_Default /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_COMMUNICATION_SERVER_PROFILE)( PVOID pServer /*IN*/, UINT iProNum /*IN*/, CHAR * * ppszURL /*OUT*/, UINT * pVidEncNum /*OUT*/, UINT * pAudEncNum /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_COMMUNICATION_SERVER_PROFILE)( PVOID pServer /*IN*/, UINT iProNum /*IN*/, CHAR *   pszURL /*IN*/,   UINT   iVidEncNum /*IN*/,  UINT   iAudEncNum /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK)( PVOID pServer /*IN*/, PF_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK)( PVOID pServer /*IN*/, PF_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// COMMUNICATION CLIENT FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//

// ANIMATION FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_ANIMATION_CLIP)( CHAR * pszAniFileName /*IN*/, PVOID * ppClip /*OUT*/, ULONG * pTotalFrames /*OUT*/, ULONG * pTotalSprites /*OUT*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_ANIMATION_CLIP)( PVOID pClip /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_ANIMATION_CLIP)( PVOID pClip /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_ANIMATION_CLIP)( PVOID pClip /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STEP_ANIMATION_CLIP)( PVOID pClip /*IN*/, UINT * pFrameNum /*OUT*/, BYTE * * ppFrameBuffer /*OUT*/, ULONG * pFrameBufferLen /*OUT*/, BOOL bClearBackground = TRUE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SEEK_ANIMATION_CLIP)( PVOID pClip /*IN*/, UINT iFrameNum /*IN*/, BYTE * * ppFrameBuffer /*OUT*/, ULONG * pFrameBufferLen /*OUT*/, BOOL bClearBackground = TRUE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY)( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, UINT iFrameNum /*IN*/, INT * pPositionX /*OUT*/, INT * pPositionY /*OUT*/, INT * pScaleW /*OUT*/, INT * pScaleH /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY)( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, UINT iFrameNum /*IN*/, INT nPositionX /*IN*/, INT nPositionY /*IN*/, INT nScaleW /*IN*/, INT nScaleH /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY)( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, UINT iFrameNum /*IN*/, double * pAlpha /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY)( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, UINT iFrameNum /*IN*/, double nAlpha /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_PICTURE)( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, CHAR * pszFilePathName /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER)( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, BOOL bCloneCopy = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER_EX)( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, BOOL bCloneCopy = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE)( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, PVOID pDevice /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, BOOL bCloneCopy = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE_EX)( PVOID pClip /*IN*/, UINT iSpriteNum /*IN*/, PVOID pDevice /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/, BOOL bCloneCopy = FALSE /*IN*/ );

// ANIMATION EXAMPLE:
//
// STEP#01 QCAP_CREATE_ANIMATION_CLIP( "EXAMPLE.FADEOUT.XML", &pClip, &nFrames, &nSprites, &nColorSpaceType, &nWidth, &nHeight );
//
// STEP#02 QCAP_START_ANIMATION_CLIP( pClip );
//
// STEP#03 QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER( pClip, 0 /*CH01*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferA, nFrameBufferLenA );
// 
//         QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( pClip, 1 /*CH02*/, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, pFrameBufferB, nFrameBufferLenB );
//
// STEP#04 QCAP_STEP_ANIMATION_CLIP( pClip, &iFrameNum, &pFrameBuffer, &nFrameBufferLen, TRUE );
//
// STEP#05 QCAP_STOP_ANIMATION_CLIP( pClip );
//
// STEP#06 QCAP_DESTROY_ANIMATION_CLIP( pClip );

// VIRTUAL CAMERA FUNCTIONS (CAMNUM: 0 ~ 63) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_VIRTUAL_CAMERA)( UINT iCamNum /*IN*/, PVOID * ppCamera /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_VIRTUAL_CAMERA)( PVOID pCamera /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_VIRTUAL_CAMERA_PROPERTY)( PVOID pCamera /*IN*/, ULONG * pColorSpaceType /*OUT*/, ULONG * pWidth /*OUT*/, ULONG * pHeight /*OUT*/, double * pFrameRate /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_VIRTUAL_CAMERA_PROPERTY)( PVOID pCamera /*IN*/, ULONG   nColorSpaceType /*IN*/,  ULONG   nWidth /*IN*/,  ULONG   nHeight /*IN*/,  double   dFrameRate /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_VIRTUAL_CAMERA_PROPERTY)( PVOID pCamera /*IN*/, ULONG * pChannels /*OUT*/, ULONG * pBitsPerSample /*OUT*/, ULONG * pSampleFrequency /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_VIRTUAL_CAMERA_PROPERTY)( PVOID pCamera /*IN*/, ULONG   nChannels /*IN*/,  ULONG   nBitsPerSample /*IN*/,  ULONG   nSampleFrequency /*IN*/  );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER)( PVOID pCamera /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX)( PVOID pCamera /*IN*/, ULONG nColorSpaceType /*IN*/, ULONG nWidth /*IN*/, ULONG nHeight /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER)( PVOID pCamera /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX)( PVOID pCamera /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, double dSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_VIRTUAL_CAMERA)( PVOID pCamera /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_VIRTUAL_CAMERA)( PVOID pCamera /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP)( PVOID pCamera /*IN*/, CHAR * pszFilePathName /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG)( PVOID pCamera /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP_EX)( PVOID pCamera /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG_EX)( PVOID pCamera /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY)( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT)( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_VIRTUAL_CAMERA_PICTURE)( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nTransparent /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER)( PVOID pCamera /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK)( PVOID pCamera /*IN*/, PF_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK)( PVOID pCamera /*IN*/, PF_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// AUDIO MIXING VIRTUAL CAMERA FUNCTIONS (CAMNUM: 0 ~ 63) ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER)( PVOID pCamera /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER)( PVOID pCamera /*IN*/, double dSampleTime = 0.0 /*IN*/ );

// FILE PLAYBACK FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_OPEN_FILE)( CHAR * pszFileName /*IN*/, PVOID * ppFile /*OUT*/, ULONG nDecoderType /*IN*/, ULONG * pVideoEncoderFormat /*OUT*/, ULONG * pVideoWidth /*OUT*/, ULONG * pVideoHeight /*OUT*/, double * pVideoFrameRate /*OUT*/, ULONG * pAudioEncoderFormat /*OUT*/, ULONG * pAudioChannels /*OUT*/, ULONG * pAudioBitsPerSample /*OUT*/, ULONG * pAudioSampleFrequency /*OUT*/, double * pTotalDurationTimes /*OUT*/, ULONG * pTotalVideoFrames /*OUT*/, ULONG * pTotalAudioFrames /*OUT*/, HWND hAttachedWindow /*IN*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_FILE)( PVOID pFile /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_PLAY_FILE)( PVOID pFile /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_PAUSE_FILE)( PVOID pFile /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_FILE)( PVOID pFile /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_FILE_POSITION)( PVOID pFile /*IN*/, double * pSampleTime /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_FILE_POSITION)( PVOID pFile /*IN*/, double dSampleTime /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_FILE_PLAYBACK_SPEED)( PVOID pFile /*IN*/, double * pSpeed /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_FILE_PLAYBACK_SPEED)( PVOID pFile /*IN*/, double dSpeed /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_FILE_REGION_DISPLAY)( PVOID pFile /*IN*/, ULONG * pCropX /*OUT*/, ULONG * pCropY /*OUT*/, ULONG * pCropW /*OUT*/, ULONG * pCropH /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_FILE_REGION_DISPLAY)( PVOID pFile /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_FILE_MIRROR)( PVOID pFile /*IN*/, BOOL * pHorizontalMirror /*OUT*/, BOOL * pVerticalMirror /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_FILE_MIRROR)( PVOID pFile /*IN*/, BOOL bHorizontalMirror /*IN*/, BOOL bVerticalMirror /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_FILE_VOLUME)( PVOID pFile /*IN*/, ULONG * pVolume /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_AUDIO_FILE_VOLUME)( PVOID pFile /*IN*/, ULONG nVolume /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_FILE_BMP)( PVOID pFile /*IN*/, CHAR * pszFilePathName /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_FILE_JPG)( PVOID pFile /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_FILE_BMP_EX)( PVOID pFile /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SNAPSHOT_FILE_JPG_EX)( PVOID pFile /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nCropX /*IN*/, ULONG nCropY /*IN*/, ULONG nCropW /*IN*/, ULONG nCropH /*IN*/, ULONG nDstW /*IN*/, ULONG nDstH /*IN*/, ULONG nQuality /*IN*/, BOOL bIsAsync = TRUE /*IN*/, ULONG nMilliseconds = 0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_OSD_FILE_TEXT_BOUNDARY)( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, ULONG * pBoundaryWidth /*OUT*/, ULONG * pBoundaryHeight /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_FILE_TEXT)( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszString /*IN*/, CHAR * pszFontFamilyName /*IN*/, ULONG nFontStyle /*IN*/, ULONG nFontSize /*IN*/, DWORD dwFontColor /*IN*/, DWORD dwBackgroundColor /*IN*/, ULONG nTransparent /*IN*/, INT nTextStartPosX = 0 /*IN*/, INT nTextStartPosY = 0 /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_FILE_PICTURE)( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, CHAR * pszFilePathName /*IN*/, ULONG nTransparent /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_OSD_FILE_BUFFER)( PVOID pFile /*IN*/, UINT iOsdNum /*IN*/, INT x /*IN*/, INT y /*IN*/, INT w /*IN*/, INT h /*IN*/, ULONG nColorSpaceType /*IN*/, BYTE * pFrameBuffer /*IN*/, ULONG nFrameWidth /*IN*/, ULONG nFrameHeight /*IN*/, ULONG nFramePitch /*IN*/, ULONG nTransparent /*IN*/, DWORD dwKeyColor = 0xFFFFFFFF /*IN*/, ULONG nKeyColorThreshold = 25 /*IN*/ /*0 ~ 128*/, BYTE * pMaskBuffer = NULL /*IN*/, ULONG nSequenceStyle = QCAP_SEQUENCE_STYLE_FOREMOST /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK)( PVOID pFile /*IN*/, PF_FILE_SNAPSHOT_DONE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK)( PVOID pFile /*IN*/, PF_FILE_SNAPSHOT_STREAM_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK)( PVOID pFile /*IN*/, PF_VIDEO_DECODER_FILE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK)( PVOID pFile /*IN*/, PF_AUDIO_DECODER_FILE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// SCF FILE PLAYBACK FUNCTIONS //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SCF_FILE_ENUMERATION)( UINT iChNum /*IN*/, double dStartSearchTime /*IN*/, double dStopSearchTime /*IN*/, ULONG * pFileSizeHigh /*OUT*/, ULONG * pFileSizeLow /*OUT*/, double * pFileStartTime /*OUT*/, double * pFileStopTime /*OUT*/, double * pVideoStartTime /*OUT*/, double * pVideoStopTime /*OUT*/, double * pAudioStartTime /*OUT*/, double * pAudioStopTime /*OUT*/, ULONG * pVideoEncoderFormat /*OUT*/, ULONG * pVideoWidth /*OUT*/, ULONG * pVideoHeight /*OUT*/, double * pVideoFrameRate /*OUT*/, ULONG * pAudioEncoderFormat /*OUT*/, ULONG * pAudioChannels /*OUT*/, ULONG * pAudioBitsPerSample /*OUT*/, ULONG * pAudioSampleFrequency /*OUT*/, double * pTotalDurationTimes /*OUT*/, ULONG * pTotalVideoFrames /*OUT*/, ULONG * pTotalAudioFrames /*OUT*/, BOOL bNext = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_OPEN_SCF_FILE)( UINT iChNum /*IN*/, PVOID * ppFile /*OUT*/, ULONG nDecoderType /*IN*/, HWND hAttachedWindow /*IN*/, BOOL bThumbDraw = FALSE /*IN*/, BOOL bMaintainAspectRatio = FALSE /*IN*/, double dStartSampleTime = 0.0 /*IN*/, double dStopSampleTime = 0.0 /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_SCF_FILE_TIMER)( UINT iChNum /*IN*/, BOOL bEnableGlobalTimer /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_PLAY_GLOBAL_SCF_FILE)();

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_PAUSE_GLOBAL_SCF_FILE)();

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_GLOBAL_SCF_FILE)();

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_GLOBAL_SCF_FILE_POSITION)( double * pSampleTime /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_GLOBAL_SCF_FILE_POSITION)( double dSampleTime /*IN*/ );

// 3D FILE PLAYBACK FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_OPEN_3D_FILE)( CHAR * pszFileName /*IN*/, PVOID * ppFile /*OUT*/, BOOL * pIs3D /*OUT*/, ULONG nDecoderType /*IN*/, ULONG * pVideoEncoderFormat /*OUT*/, ULONG * pVideoWidth /*OUT*/, ULONG * pVideoHeight /*OUT*/, double * pVideoFrameRate /*OUT*/, ULONG * pAudioEncoderFormat /*OUT*/, ULONG * pAudioChannels /*OUT*/, ULONG * pAudioBitsPerSample /*OUT*/, ULONG * pAudioSampleFrequency /*OUT*/, double * pTotalDurationTimes /*OUT*/, ULONG * pTotalVideoFrames /*OUT*/, ULONG * pTotalAudioFrames /*OUT*/, HWND hAttachedWindowL        /*IN*/, BOOL bThumbDrawL = FALSE /*IN*/, BOOL bMaintainAspectRatioL = FALSE /*IN*/, HWND hAttachedWindowR = NULL /*IN*/, BOOL bThumbDrawR = FALSE /*IN*/, BOOL bMaintainAspectRatioR = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_3D_FILE_DISPLAY_MODE)( PVOID pFile /*IN*/, ULONG * pStereoDisplayMode /*OUT*/, BOOL * pLeftRightSwap /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_VIDEO_3D_FILE_DISPLAY_MODE)( PVOID pFile /*IN*/, ULONG nStereoDisplayMode = QCAP_3D_STEREO_DISPLAY_MODE_LINE_BY_LINE /*IN*/, BOOL bLeftRightSwap = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK)( PVOID pFile /*IN*/, PF_VIDEO_DECODER_3D_FILE_CALLBACK pCB /*IN*/, PVOID pUserData /*IN*/ );

// FILE EDITING FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_VIDEO_FILE_STREAM_BUFFER)( PVOID pFile /*IN*/, UINT iFrameNum /*IN*/, BYTE * pStreamBuffer /*OUT*/, ULONG * pStreamBufferLen /*IN/OUT*/, BOOL * pIsKeyFrame /*OUT*/, double * pSampleTime /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_FILE_STREAM_BUFFER)( PVOID pFile /*IN*/, UINT iFrameNum /*IN*/, BYTE * pStreamBuffer /*OUT*/, ULONG * pStreamBufferLen /*IN/OUT*/, double * pSampleTime /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_EXPORT_FILE)( PVOID pFile /*IN*/, double dStartSampleTime /*IN*/, double dStopSampleTime /*IN*/, CHAR * pszExportedFileName /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_MERGE_FILES)( CHAR * pszFrontEndFileName /*IN*/, CHAR * pszBackEndFileName /*IN*/, CHAR * pszMergedFileName /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_MERGE_FILES_EX)( CHAR * pszMergedFileName /*IN*/, ULONG nFileArgs /*IN*/, CHAR * pszSourceFileName1 /*IN*/, CHAR * pszSourceFileName2 /*IN*/, ... );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_BUILD_VIDEO_ON_DEMAND_FILE)( CHAR * pszOriginalFileName /*IN*/, CHAR * pszVideoOnDemandFileName /*IN*/ );

// FILE REPAIR FUNCTIONS ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DIAGNOSE_FILE)( CHAR * pszFileName /*IN*/, BOOL * pIsHealthy /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_REPAIR_FILE)( CHAR * pszBadFileName /*IN*/, CHAR * pszRepairedFileName /*IN*/ );

// CD&DVD BURNING FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CREATE_BURNING_DRIVE)( CHAR cDriveName /*IN*/, CHAR * pVolumeName /*IN*/, PVOID * ppDrive /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_DESTROY_BURNING_DRIVE)( PVOID pDrive /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_START_BURNING_DRIVE)( PVOID pDrive /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_STOP_BURNING_DRIVE)( PVOID pDrive /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_UNLOAD_DISC)( PVOID pDrive /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_LOAD_DISC)( PVOID pDrive /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_DISC_INFO)( PVOID pDrive /*IN*/, BOOL * pIsDiscBlank /*OUT*/, BOOL * pIsDiscWriteable /*OUT*/, DWORD * pDiscType /*OUT*/, ULONGLONG * pDiscRemainCapability /*OUT*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_ERASE_DISC)( PVOID pDrive /*IN*/ );

// BURNING EXAMPLE (BETA VERSION):
// 
// STEP#01 QCAP_CREATE_BURNING_DRIVE( 'E', "TEST", &pDrive );
//
// STEP#02 QCAP_START_BURNING_DRIVE( pDrive );
// 
// STEP#03 QCAP_START_RECORD( pDevice, 0, "E:\\CH01.TS" );
// 
// STEP#04 QCAP_STOP_RECORD( pDevice, 0, FALSE, INFINE ); // NOTE!! WAITIING FILE CLOSE
// 
// STEP#05 QCAP_STOP_BURNING_DRIVE( pDrive );
// 
// STEP#06 QCAP_UNLOAD_DISC( pDrive );
// 
// STEP#07 QCAP_DESTROY_BURNING_DRIVE( pDrive );

// CAMERA FUNCTIONS /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CAMERA_ENUMERATION)( CHAR * * ppszCameraDevName /*OUT*/, BOOL bNext = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_DEFAULT_CAMERA)( CHAR * pszCameraDevName /*IN*/ );

// SOUNCARD FUNCTIONS ///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SOUNDCARD_ENUMERATION)( CHAR * * ppszSoundCardDevName /*OUT*/, BOOL bNext = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_SET_DEFAULT_SOUNDCARD)( CHAR * pszMicrophoneDevName /*IN*/, CHAR * pszLineInDevName /*IN*/ );

// SOUNCARD EXAMPLE:
// 
// STEP#01 QCAP_CREATE( "SOUNDCARD", 0, hWindow, &pDevice, TRUE );
// 
// STEP#02 QCAP_SET_AUDIO_INPUT( pDevice, QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN );
// 
// STEP#03 QCAP_RUN( pDevice );
// 
// STEP#04 QCAP_STOP( pDevice );
// 
// STEP#05 QCAP_DESTROY( pDevice );

// HELPER FUNCTIONS PART.1 (ENCODER) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_H264_BUFFER_LAYER_ID)( BYTE * pStreamBuffer /*IN*/, ULONG nStreamBufferLen /*IN*/, ULONG * pLayerID /*OUT*/ );

// HELPER FUNCTIONS PART.2 (VIDEO) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YUY2_TO_ABGR32)( BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BYTE bAlpah = 0x00 /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YV12_TO_ABGR32)( BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BYTE bAlpah = 0x00 /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YUY2_TO_BGR24)(  BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YV12_TO_BGR24)(  BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_COLORSPACE_YUY2_TO_YV12)(   BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BOOL bHorizontalMirror = FALSE /*IN*/, BOOL bVerticalMirror = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_CONVERT_3D_STEREO_BUFFER)( ULONG nColorSpaceType /*IN*/, ULONG nSrcStereoDisplayMode /*IN*/, BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, ULONG nDstStereoDisplayMode /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, BOOL bLeftRightSwap = FALSE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESIZE_VIDEO_BUFFER)( ULONG nColorSpaceType /*IN*/, BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_ROTATE_VIDEO_BUFFER_BOUNDARY)( ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG * pDstWidth /*OUT*/, ULONG * pDstHeight /*OUT*/, double dAngle /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_ROTATE_VIDEO_BUFFER)( ULONG nColorSpaceType /*IN*/, BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcWidth /*IN*/, ULONG nSrcHeight /*IN*/, ULONG nSrcPitch /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG nDstWidth /*IN*/, ULONG nDstHeight /*IN*/, ULONG nDstPitch /*IN*/, double dAngle /*IN*/, BYTE * pSrcTempFrameBuffer = NULL /*IN*/, BYTE * pDstTempFrameBuffer = NULL /*IN*/, BOOL bClearBackground = TRUE /*IN*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_LOAD_PICTURE_BUFFER)( CHAR * pszFilePathName /*IN*/, ULONG * pColorSpaceType /*OUT*/, BYTE * pFrameBuffer /*OUT*/, ULONG * pFrameBufferSize /*IN/OUT*/, ULONG * pFrameWidth /*OUT*/, ULONG * pFrameHeight /*OUT*/, ULONG * pFramePitch /*OUT*/ );

// HELPER FUNCTIONS PART.3 (AUDIO) //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_GET_AUDIO_BUFFER_VOLUME_DB)( BYTE * pFrameBuffer /*IN*/, ULONG nFrameBufferLen /*IN*/, ULONG nChannels /*IN*/, ULONG nBitsPerSample /*IN*/, ULONG nSampleFrequency /*IN*/, UINT iChNum /*IN*/, double * pVolumeDB /*OUT*/ /*RANGE = -100 ~ 0 (DB)*/ );

QCAP_EXT_API QRESULT (QCAP_EXPORT * QCAP_RESAMPLE_AUDIO_BUFFER)( BYTE * pSrcFrameBuffer /*IN*/, ULONG nSrcFrameBufferLen /*IN*/, ULONG nSrcChannels /*IN*/, ULONG nSrcBitsPerSample /*IN*/, ULONG nSrcSampleFrequency /*IN*/, BYTE * pDstFrameBuffer /*OUT*/, ULONG * pDstFrameBufferLen /*IN/OUT*/, ULONG nDstChannels /*IN*/, ULONG nDstBitsPerSample /*IN*/, ULONG nDstSampleFrequency /*IN*/ );

// HELPER FUNCTIONS (FOR .NET DEVELOPER) ////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// 
QCAP_EXT_API ULONGLONG QCAP_EXPORT QCAP_HELPER_OBJPTR( PVOID pObj /*IN*/ );

#define GET_FUNCTION_ADDRESS( HANDLE_NAME )\
		GET_SYSTEM_FUNCTIONS_ADDRESS( HANDLE_NAME );\
		GET_DEVICE_FUNCTIONS_ADDRESS( HANDLE_NAME );\
		GET_CALLBACK_FUNCTIONS_I_ADDRESS( HANDLE_NAME );\
		GET_CALLBACK_FUNCTIONS_II_ADDRESS( HANDLE_NAME );\
		GET_CALLBACK_FUNCTIONS_III_ADDRESS( HANDLE_NAME );\
		GET_CALLBACK_FUNCTIONS_IIII_ADDRESS( HANDLE_NAME );\

#define GET_SYSTEM_FUNCTIONS_ADDRESS( HANDLE_NAME )\
		(PVOID)QCAP_GET_VERSION = GetProcAddress( HANDLE_NAME, "QCAP_GET_VERSION" );\
		(PVOID)QCAP_SET_SYSTEM_CONFIGURATION = GetProcAddress( HANDLE_NAME, "QCAP_SET_SYSTEM_CONFIGURATION" );\
		(PVOID)QCAP_QUERY_ENCODER_TYPE_CAP = GetProcAddress( HANDLE_NAME, "QCAP_QUERY_ENCODER_TYPE_CAP" );\
		(PVOID)QCAP_QUERY_DECODER_TYPE_CAP = GetProcAddress( HANDLE_NAME, "QCAP_QUERY_DECODER_TYPE_CAP" );\
		(PVOID)QCAP_QUERY_ENCODER_STATUS = GetProcAddress( HANDLE_NAME, "QCAP_QUERY_ENCODER_STATUS" );\

#define GET_DEVICE_FUNCTIONS_ADDRESS( HANDLE_NAME )\
		(PVOID)QCAP_DEVICE_ENUMERATION = GetProcAddress( HANDLE_NAME, "QCAP_DEVICE_ENUMERATION" );\
		(PVOID)QCAP_GET_DEVICE_ENUMERATION_ITEM_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_DEVICE_ENUMERATION_ITEM_INFO" );\
		(PVOID)QCAP_CREATE = GetProcAddress( HANDLE_NAME, "QCAP_CREATE" );\
		(PVOID)QCAP_DESTROY = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY" );\
		(PVOID)QCAP_RUN = GetProcAddress( HANDLE_NAME, "QCAP_RUN" );\
		(PVOID)QCAP_STOP = GetProcAddress( HANDLE_NAME, "QCAP_STOP" );\
		(PVOID)QCAP_GET_VIDEO_INPUT = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_INPUT" );\
		(PVOID)QCAP_SET_VIDEO_INPUT = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_INPUT" );\
		(PVOID)QCAP_GET_AUDIO_INPUT = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_INPUT" );\
		(PVOID)QCAP_SET_AUDIO_INPUT = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_INPUT" );\
		(PVOID)QCAP_GET_VIDEO_STANDARD = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_STANDARD" );\
		(PVOID)QCAP_SET_VIDEO_STANDARD = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_STANDARD" );\
		(PVOID)QCAP_GET_VIDEO_CURRENT_CONTENT_PROTECTION_STATUS = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_CURRENT_CONTENT_PROTECTION_STATUS" );\
		(PVOID)QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_CURRENT_INPUT_FORMAT" );\
		(PVOID)QCAP_GET_AUDIO_CURRENT_INPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_CURRENT_INPUT_FORMAT" );\
		(PVOID)QCAP_GET_VIDEO_DEFAULT_OUTPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_DEFAULT_OUTPUT_FORMAT" );\
		(PVOID)QCAP_SET_VIDEO_DEFAULT_OUTPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_DEFAULT_OUTPUT_FORMAT" );\
		(PVOID)QCAP_GET_AUDIO_DEFAULT_OUTPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_DEFAULT_OUTPUT_FORMAT" );\
		(PVOID)QCAP_SET_AUDIO_DEFAULT_OUTPUT_FORMAT = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_DEFAULT_OUTPUT_FORMAT" );\
		(PVOID)QCAP_GET_VIDEO_DEINTERLACE_TYPE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_DEINTERLACE_TYPE" );\
		(PVOID)QCAP_SET_VIDEO_DEINTERLACE_TYPE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_DEINTERLACE_TYPE" );\
		(PVOID)QCAP_GET_VIDEO_DEINTERLACE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_DEINTERLACE" );\
		(PVOID)QCAP_SET_VIDEO_DEINTERLACE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_DEINTERLACE" );\
		(PVOID)QCAP_GET_VIDEO_REGION_DISPLAY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_REGION_DISPLAY" );\
		(PVOID)QCAP_SET_VIDEO_REGION_DISPLAY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_REGION_DISPLAY" );\
		(PVOID)QCAP_GET_VIDEO_MIRROR = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_MIRROR" );\
		(PVOID)QCAP_SET_VIDEO_MIRROR = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_MIRROR" );\
		(PVOID)QCAP_GET_VIDEO_BRIGHTNESS = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BRIGHTNESS" );\
		(PVOID)QCAP_SET_VIDEO_BRIGHTNESS = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BRIGHTNESS" );\
		(PVOID)QCAP_GET_VIDEO_CONTRAST = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_CONTRAST" );\
		(PVOID)QCAP_SET_VIDEO_CONTRAST = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_CONTRAST" );\
		(PVOID)QCAP_GET_VIDEO_HUE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_HUE" );\
		(PVOID)QCAP_SET_VIDEO_HUE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_HUE" );\
		(PVOID)QCAP_GET_VIDEO_SATURATION = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SATURATION" );\
		(PVOID)QCAP_SET_VIDEO_SATURATION = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SATURATION" );\
		(PVOID)QCAP_GET_VIDEO_SHARPNESS = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARPNESS" );\
		(PVOID)QCAP_SET_VIDEO_SHARPNESS = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARPNESS" );\
		(PVOID)QCAP_GET_VIDEO_PREVIEW_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_PREVIEW_PROPERTY_EX" );\
		(PVOID)QCAP_SET_VIDEO_PREVIEW_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_PREVIEW_PROPERTY_EX" );\
		(PVOID)QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY" );\
		(PVOID)QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY" );\
		(PVOID)QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX" );\
		(PVOID)QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX" );\
		(PVOID)QCAP_GET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY" );\
		(PVOID)QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_HARDWARE_ENCODER_VIDEOCOMPRESSION_PROPERTY" );\
		(PVOID)QCAP_GET_AUDIO_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_VOLUME" );\
		(PVOID)QCAP_SET_AUDIO_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_VOLUME" );\
		(PVOID)QCAP_GET_DEVICE_CUSTOM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_DEVICE_CUSTOM_PROPERTY" );\
		(PVOID)QCAP_SET_DEVICE_CUSTOM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_DEVICE_CUSTOM_PROPERTY" );\
		(PVOID)QCAP_GET_DEVICE_CUSTOM_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_DEVICE_CUSTOM_PROPERTY_EX" );\
		(PVOID)QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_DEVICE_CUSTOM_PROPERTY_EX" );\

#define GET_CALLBACK_FUNCTIONS_I_ADDRESS( HANDLE_NAME )\
		(PVOID)QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK" );\
		(PVOID)QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK" );\
		(PVOID)QCAP_REGISTER_FORMAT_CHANGED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FORMAT_CHANGED_CALLBACK" );\

#define GET_CALLBACK_FUNCTIONS_II_ADDRESS( HANDLE_NAME )\
		(PVOID)QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK" );\
		(PVOID)QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK" );\
		(PVOID)QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK" );\
		(PVOID)QCAP_COPY_VIDEO_PREVIEW_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_COPY_VIDEO_PREVIEW_BUFFER" );\
		(PVOID)QCAP_COPY_AUDIO_PREVIEW_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_COPY_AUDIO_PREVIEW_BUFFER" );\
		(PVOID)QCAP_LOCK_VIDEO_PREVIEW_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_LOCK_VIDEO_PREVIEW_BUFFER" );\
		(PVOID)QCAP_UNLOCK_VIDEO_PREVIEW_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_UNLOCK_VIDEO_PREVIEW_BUFFER" );\
		(PVOID)QCAP_LOCK_AUDIO_PREVIEW_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_LOCK_AUDIO_PREVIEW_BUFFER" );\
		(PVOID)QCAP_UNLOCK_AUDIO_PREVIEW_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_UNLOCK_AUDIO_PREVIEW_BUFFER" );\
		(PVOID)QCAP_SNAPSHOT_BMP = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BMP" );\
		(PVOID)QCAP_SNAPSHOT_JPG = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_JPG" );\
		(PVOID)QCAP_SNAPSHOT_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BMP_EX" );\
		(PVOID)QCAP_SNAPSHOT_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_JPG_EX" );\
		(PVOID)QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SNAPSHOT_DONE_CALLBACK" );\

#define GET_CALLBACK_FUNCTIONS_III_ADDRESS( HANDLE_NAME )\
		(PVOID)QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SNAPSHOT_STREAM_CALLBACK" );\
		(PVOID)QCAP_GET_VIDEO_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_RECORD_PROPERTY" );\
		(PVOID)QCAP_SET_VIDEO_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_RECORD_PROPERTY" );\
		(PVOID)QCAP_GET_VIDEO_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_RECORD_PROPERTY_EX" );\
		(PVOID)QCAP_SET_VIDEO_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_RECORD_PROPERTY_EX" );\
		(PVOID)QCAP_GET_AUDIO_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_RECORD_PROPERTY" );\
		(PVOID)QCAP_SET_AUDIO_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_RECORD_PROPERTY" );\
		(PVOID)QCAP_GET_AUDIO_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_RECORD_PROPERTY_EX" );\
		(PVOID)QCAP_SET_AUDIO_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_RECORD_PROPERTY_EX" );\
		(PVOID)QCAP_GET_VIDEO_RECORD_SOFTWARE_ENCODER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_RECORD_SOFTWARE_ENCODER_PROPERTY" );\
		(PVOID)QCAP_SET_VIDEO_RECORD_SOFTWARE_ENCODER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_RECORD_SOFTWARE_ENCODER_PROPERTY" );\
		(PVOID)QCAP_START_CLONE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_CLONE_RECORD" );\
		(PVOID)QCAP_START_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_RECORD" );\
		(PVOID)QCAP_STOP_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_STOP_RECORD" );\
		(PVOID)QCAP_RESUME_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_RESUME_RECORD" );\
		(PVOID)QCAP_PAUSE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_PAUSE_RECORD" );\
		(PVOID)QCAP_REGISTER_RECORD_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_RECORD_DONE_CALLBACK" );\

#define GET_CALLBACK_FUNCTIONS_IIII_ADDRESS( HANDLE_NAME )\
		(PVOID)QCAP_REGISTER_VIDEO_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_RECORD_CALLBACK" );\
		(PVOID)QCAP_REGISTER_AUDIO_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_RECORD_CALLBACK" );\
		(PVOID)QCAP_REGISTER_MEDIA_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_MEDIA_RECORD_CALLBACK" );\
		(PVOID)QCAP_CREATE_CLONE = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_CLONE" );\
		(PVOID)QCAP_GET_OSD_TEXT_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_TEXT_BOUNDARY" );\
		(PVOID)QCAP_SET_OSD_TEXT = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_TEXT" );\
		(PVOID)QCAP_SET_OSD_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_PICTURE" );\
		(PVOID)QCAP_SET_OSD_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BUFFER" );\
		(PVOID)QCAP_START_SYNCHRONIZED_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_SYNCHRONIZED_RECORD" );\
		(PVOID)QCAP_STOP_SYNCHRONIZED_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_STOP_SYNCHRONIZED_RECORD" );\
		(PVOID)QCAP_RESUME_SYNCHRONIZED_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_RESUME_SYNCHRONIZED_RECORD" );\
		(PVOID)QCAP_PAUSE_SYNCHRONIZED_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_PAUSE_SYNCHRONIZED_RECORD" );\
		(PVOID)QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY" );\
		(PVOID)QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY" );\
		(PVOID)QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARE_RECORD_PROPERTY_EX" );\
		(PVOID)QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY_EX" );\
		(PVOID)QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY" );\
		(PVOID)QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY" );\
		(PVOID)QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_SHARE_RECORD_PROPERTY_EX" );\
		(PVOID)QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY_EX" );\
		(PVOID)QCAP_GET_VIDEO_SHARE_RECORD_SOFTWARE_ENCODER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_SHARE_RECORD_SOFTWARE_ENCODER_PROPERTY" );\
		(PVOID)QCAP_SET_VIDEO_SHARE_RECORD_SOFTWARE_ENCODER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_SOFTWARE_ENCODER_PROPERTY" );\
		(PVOID)QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX" );\
		(PVOID)QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER_EX" );\
		(PVOID)QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_SHARE_RECORD_COMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_AUDIO_SHARE_RECORD_COMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_SHARE_RECORD_COMPRESSION_BUFFER" );\
		(PVOID)QCAP_START_SHARE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_SHARE_RECORD" );\
		(PVOID)QCAP_STOP_SHARE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_STOP_SHARE_RECORD" );\
		(PVOID)QCAP_RESUME_SHARE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_RESUME_SHARE_RECORD" );\
		(PVOID)QCAP_PAUSE_SHARE_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_PAUSE_SHARE_RECORD" );\
		(PVOID)QCAP_SNAPSHOT_SHARE_RECORD_BMP = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_SHARE_RECORD_BMP" );\
		(PVOID)QCAP_SNAPSHOT_SHARE_RECORD_JPG = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_SHARE_RECORD_JPG" );\
		(PVOID)QCAP_SNAPSHOT_SHARE_RECORD_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_SHARE_RECORD_BMP_EX" );\
		(PVOID)QCAP_SNAPSHOT_SHARE_RECORD_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_SHARE_RECORD_JPG_EX" );\
		(PVOID)QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_SHARE_RECORD_TEXT_BOUNDARY" );\
		(PVOID)QCAP_SET_OSD_SHARE_RECORD_TEXT = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_SHARE_RECORD_TEXT" );\
		(PVOID)QCAP_SET_OSD_SHARE_RECORD_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_SHARE_RECORD_PICTURE" );\
		(PVOID)QCAP_SET_OSD_SHARE_RECORD_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_SHARE_RECORD_BUFFER" );\
		(PVOID)QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SHARE_RECORD_DONE_CALLBACK" );\
		(PVOID)QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_DONE_CALLBACK" );\
		(PVOID)QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_SHARE_RECORD_SNAPSHOT_STREAM_CALLBACK" );\
		(PVOID)QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_SHARE_RECORD_CALLBACK" );\
		(PVOID)QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_SHARE_RECORD_CALLBACK" );\
		(PVOID)QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_MEDIA_SHARE_RECORD_CALLBACK" );\
		(PVOID)QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_SHARE_RECORD_CALLBACK" );\
		(PVOID)QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_SHARE_RECORD_CALLBACK" );\
		(PVOID)QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_STEREO_UNCOMPRESSION_BUFFER_EX" );\
		(PVOID)QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER_EX" );\
		(PVOID)QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER_EX" );\
		(PVOID)QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_GET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX" );\
		(PVOID)QCAP_SET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_SHARE_RECORD_PROPERTY_EX" );\
		(PVOID)QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_SHARE_RECORD_MIXING_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_AUDIO_MX_SHARE_RECORD_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_SHARE_RECORD_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_AUDIO_MX_SHARE_RECORD_COMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_SHARE_RECORD_COMPRESSION_BUFFER" );\
		(PVOID)QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_MX_SHARE_RECORD_CALLBACK" );\
		(PVOID)QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_MX_SHARE_RECORD_CALLBACK" );\
		(PVOID)QCAP_CREATE_BROADCAST_RTSP_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_RTSP_SERVER" );\
		(PVOID)QCAP_CREATE_BROADCAST_RTMP_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_RTMP_SERVER" );\
		(PVOID)QCAP_CREATE_BROADCAST_RTMP_SERVER_EX = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_RTMP_SERVER_EX" );\
		(PVOID)QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER" );\
		(PVOID)QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER_EX = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER_EX" );\
		(PVOID)QCAP_CREATE_BROADCAST_MMS_WEB_PORTAL_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_MMS_WEB_PORTAL_SERVER" );\
		(PVOID)QCAP_CREATE_BROADCAST_HLS_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_HLS_SERVER" );\
		(PVOID)QCAP_DESTROY_BROADCAST_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_BROADCAST_SERVER" );\
		(PVOID)QCAP_START_BROADCAST_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_START_BROADCAST_SERVER" );\
		(PVOID)QCAP_STOP_BROADCAST_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_STOP_BROADCAST_SERVER" );\
		(PVOID)QCAP_GET_SESSION_BROADCAST_SERVER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_SESSION_BROADCAST_SERVER_PROPERTY" );\
		(PVOID)QCAP_SET_SESSION_BROADCAST_SERVER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_SESSION_BROADCAST_SERVER_PROPERTY" );\
		(PVOID)QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE = GetProcAddress( HANDLE_NAME, "QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE" );\
		(PVOID)QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_SESSION_BROADCAST_SERVER_SOURCE_EX" );\
		(PVOID)QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY" );\
		(PVOID)QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY" );\
		(PVOID)QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_SERVER_PROPERTY_EX" );\
		(PVOID)QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY_EX" );\
		(PVOID)QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY" );\
		(PVOID)QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY" );\
		(PVOID)QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BROADCAST_SERVER_PROPERTY_EX" );\
		(PVOID)QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY_EX" );\
		(PVOID)QCAP_GET_VIDEO_BROADCAST_SERVER_SOFTWARE_ENCODER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_SERVER_SOFTWARE_ENCODER_PROPERTY" );\
		(PVOID)QCAP_SET_VIDEO_BROADCAST_SERVER_SOFTWARE_ENCODER_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_SERVER_SOFTWARE_ENCODER_PROPERTY" );\
		(PVOID)QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX" );\
		(PVOID)QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER_EX" );\
		(PVOID)QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_SERVER_COMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_AUDIO_BROADCAST_SERVER_COMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_SERVER_COMPRESSION_BUFFER" );\
		(PVOID)QCAP_SNAPSHOT_BROADCAST_SERVER_BMP = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_SERVER_BMP" );\
		(PVOID)QCAP_SNAPSHOT_BROADCAST_SERVER_JPG = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_SERVER_JPG" );\
		(PVOID)QCAP_SNAPSHOT_BROADCAST_SERVER_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_SERVER_BMP_EX" );\
		(PVOID)QCAP_SNAPSHOT_BROADCAST_SERVER_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_SERVER_JPG_EX" );\
		(PVOID)QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_BROADCAST_SERVER_TEXT_BOUNDARY" );\
		(PVOID)QCAP_SET_OSD_BROADCAST_SERVER_TEXT = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_SERVER_TEXT" );\
		(PVOID)QCAP_SET_OSD_BROADCAST_SERVER_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_SERVER_PICTURE" );\
		(PVOID)QCAP_SET_OSD_BROADCAST_SERVER_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_SERVER_BUFFER" );\
		(PVOID)QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_SERVER_GET_CUSTOM_PROPERTY_CALLBACK" );\
		(PVOID)QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_SERVER_SET_CUSTOM_PROPERTY_CALLBACK" );\
		(PVOID)QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_DONE_CALLBACK" );\
		(PVOID)QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_SERVER_SNAPSHOT_STREAM_CALLBACK" );\
		(PVOID)QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_BROADCAST_SERVER_CALLBACK" );\
		(PVOID)QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_BROADCAST_SERVER_CALLBACK" );\
		(PVOID)QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_BROADCAST_SERVER_CALLBACK" );\
		(PVOID)QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_BROADCAST_SERVER_CALLBACK" );\
		(PVOID)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_STEREO_UNCOMPRESSION_BUFFER_EX" );\
		(PVOID)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_L_UNCOMPRESSION_BUFFER_EX" );\
		(PVOID)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_R_UNCOMPRESSION_BUFFER_EX" );\
		(PVOID)QCAP_SET_VIDEO_3D_BROADCAST_SERVER_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_SERVER_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_BROADCAST_SERVER_MIXING_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_AUDIO_MX_BROADCAST_SERVER_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_BROADCAST_SERVER_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_CREATE_BROADCAST_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BROADCAST_CLIENT" );\
		(PVOID)QCAP_DESTROY_BROADCAST_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_BROADCAST_CLIENT" );\
		(PVOID)QCAP_START_BROADCAST_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_START_BROADCAST_CLIENT" );\
		(PVOID)QCAP_STOP_BROADCAST_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_STOP_BROADCAST_CLIENT" );\
		(PVOID)QCAP_GET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY" );\
		(PVOID)QCAP_SET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_CLIENT_REGION_DISPLAY" );\
		(PVOID)QCAP_GET_VIDEO_BROADCAST_CLIENT_MIRROR = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_BROADCAST_CLIENT_MIRROR" );\
		(PVOID)QCAP_SET_VIDEO_BROADCAST_CLIENT_MIRROR = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_BROADCAST_CLIENT_MIRROR" );\
		(PVOID)QCAP_GET_AUDIO_BROADCAST_CLIENT_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BROADCAST_CLIENT_VOLUME" );\
		(PVOID)QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_BROADCAST_CLIENT_VOLUME" );\
		(PVOID)QCAP_START_BROADCAST_CLIENT_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_START_BROADCAST_CLIENT_RECORD" );\
		(PVOID)QCAP_STOP_BROADCAST_CLIENT_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_STOP_BROADCAST_CLIENT_RECORD" );\
		(PVOID)QCAP_RESUME_BROADCAST_CLIENT_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_RESUME_BROADCAST_CLIENT_RECORD" );\
		(PVOID)QCAP_PAUSE_BROADCAST_CLIENT_RECORD = GetProcAddress( HANDLE_NAME, "QCAP_PAUSE_BROADCAST_CLIENT_RECORD" );\
		(PVOID)QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP" );\
		(PVOID)QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG" );\
		(PVOID)QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_CLIENT_BMP_EX" );\
		(PVOID)QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_BROADCAST_CLIENT_JPG_EX" );\
		(PVOID)QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_BROADCAST_CLIENT_TEXT_BOUNDARY" );\
		(PVOID)QCAP_SET_OSD_BROADCAST_CLIENT_TEXT = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_CLIENT_TEXT" );\
		(PVOID)QCAP_SET_OSD_BROADCAST_CLIENT_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_CLIENT_PICTURE" );\
		(PVOID)QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_BROADCAST_CLIENT_BUFFER" );\
		(PVOID)QCAP_GET_BROADCAST_CLIENT_CUSTOM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_BROADCAST_CLIENT_CUSTOM_PROPERTY" );\
		(PVOID)QCAP_SET_BROADCAST_CLIENT_CUSTOM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_BROADCAST_CLIENT_CUSTOM_PROPERTY" );\
		(PVOID)QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_CONNECTED_CALLBACK" );\
		(PVOID)QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_RECORD_DONE_CALLBACK" );\
		(PVOID)QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_DONE_CALLBACK" );\
		(PVOID)QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_BROADCAST_CLIENT_SNAPSHOT_STREAM_CALLBACK" );\
		(PVOID)QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_BROADCAST_CLIENT_CALLBACK" );\
		(PVOID)QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_BROADCAST_CLIENT_CALLBACK" );\
		(PVOID)QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_BROADCAST_CLIENT_CALLBACK" );\
		(PVOID)QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_BROADCAST_CLIENT_CALLBACK" );\
		(PVOID)QCAP_CREATE_3D_BROADCAST_CLIENT = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_3D_BROADCAST_CLIENT" );\
		(PVOID)QCAP_GET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE" );\
		(PVOID)QCAP_SET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_BROADCAST_CLIENT_DISPLAY_MODE" );\
		(PVOID)QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_3D_BROADCAST_CLIENT_CALLBACK" );\
		(PVOID)QCAP_CREATE_COMMUNICATION_ONVIF_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_COMMUNICATION_ONVIF_SERVER" );\
		(PVOID)QCAP_DESTROY_COMMUNICATION_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_COMMUNICATION_SERVER" );\
		(PVOID)QCAP_START_COMMUNICATION_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_START_COMMUNICATION_SERVER" );\
		(PVOID)QCAP_STOP_COMMUNICATION_SERVER = GetProcAddress( HANDLE_NAME, "QCAP_STOP_COMMUNICATION_SERVER" );\
		(PVOID)QCAP_GET_COMMUNICATION_SERVER_VIDEO_SOURCE = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_SERVER_VIDEO_SOURCE" );\
		(PVOID)QCAP_SET_COMMUNICATION_SERVER_VIDEO_SOURCE = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_SERVER_VIDEO_SOURCE" );\
		(PVOID)QCAP_GET_COMMUNICATION_SERVER_AUDIO_SOURCE = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_SERVER_AUDIO_SOURCE" );\
		(PVOID)QCAP_SET_COMMUNICATION_SERVER_AUDIO_SOURCE = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_SERVER_AUDIO_SOURCE" );\
		(PVOID)QCAP_GET_COMMUNICATION_SERVER_VIDEO_ENCODER = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_SERVER_VIDEO_ENCODER" );\
		(PVOID)QCAP_SET_COMMUNICATION_SERVER_VIDEO_ENCODER = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_SERVER_VIDEO_ENCODER" );\
		(PVOID)QCAP_GET_COMMUNICATION_SERVER_AUDIO_ENCODER = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_SERVER_AUDIO_ENCODER" );\
		(PVOID)QCAP_SET_COMMUNICATION_SERVER_AUDIO_ENCODER = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_SERVER_AUDIO_ENCODER" );\
		(PVOID)QCAP_GET_COMMUNICATION_SERVER_PROFILE = GetProcAddress( HANDLE_NAME, "QCAP_GET_COMMUNICATION_SERVER_PROFILE" );\
		(PVOID)QCAP_SET_COMMUNICATION_SERVER_PROFILE = GetProcAddress( HANDLE_NAME, "QCAP_SET_COMMUNICATION_SERVER_PROFILE" );\
		(PVOID)QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_VIDEO_SETUP_CALLBACK" );\
		(PVOID)QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_COMMUNICATION_SERVER_PROFILE_AUDIO_SETUP_CALLBACK" );\
		(PVOID)QCAP_CREATE_ANIMATION_CLIP = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_ANIMATION_CLIP" );\
		(PVOID)QCAP_DESTROY_ANIMATION_CLIP = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_ANIMATION_CLIP" );\
		(PVOID)QCAP_START_ANIMATION_CLIP = GetProcAddress( HANDLE_NAME, "QCAP_START_ANIMATION_CLIP" );\
		(PVOID)QCAP_STOP_ANIMATION_CLIP = GetProcAddress( HANDLE_NAME, "QCAP_STOP_ANIMATION_CLIP" );\
		(PVOID)QCAP_STEP_ANIMATION_CLIP = GetProcAddress( HANDLE_NAME, "QCAP_STEP_ANIMATION_CLIP" );\
		(PVOID)QCAP_SEEK_ANIMATION_CLIP = GetProcAddress( HANDLE_NAME, "QCAP_SEEK_ANIMATION_CLIP" );\
		(PVOID)QCAP_GET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY" );\
		(PVOID)QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY" );\
		(PVOID)QCAP_GET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY" );\
		(PVOID)QCAP_SET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY" );\
		(PVOID)QCAP_SET_ANIMATION_CLIP_SPRITE_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_PICTURE" );\
		(PVOID)QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER" );\
		(PVOID)QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_BUFFER_EX" );\
		(PVOID)QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE" );\
		(PVOID)QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE_EX" );\
		(PVOID)QCAP_CREATE_VIRTUAL_CAMERA = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_VIRTUAL_CAMERA" );\
		(PVOID)QCAP_DESTROY_VIRTUAL_CAMERA = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_VIRTUAL_CAMERA" );\
		(PVOID)QCAP_GET_VIDEO_VIRTUAL_CAMERA_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_VIRTUAL_CAMERA_PROPERTY" );\
		(PVOID)QCAP_SET_VIDEO_VIRTUAL_CAMERA_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_VIRTUAL_CAMERA_PROPERTY" );\
		(PVOID)QCAP_GET_AUDIO_VIRTUAL_CAMERA_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_VIRTUAL_CAMERA_PROPERTY" );\
		(PVOID)QCAP_SET_AUDIO_VIRTUAL_CAMERA_PROPERTY = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_VIRTUAL_CAMERA_PROPERTY" );\
		(PVOID)QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX" );\
		(PVOID)QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER_EX" );\
		(PVOID)QCAP_START_VIRTUAL_CAMERA = GetProcAddress( HANDLE_NAME, "QCAP_START_VIRTUAL_CAMERA" );\
		(PVOID)QCAP_STOP_VIRTUAL_CAMERA = GetProcAddress( HANDLE_NAME, "QCAP_STOP_VIRTUAL_CAMERA" );\
		(PVOID)QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP" );\
		(PVOID)QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG" );\
		(PVOID)QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP_EX" );\
		(PVOID)QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG_EX" );\
		(PVOID)QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_VIRTUAL_CAMERA_TEXT_BOUNDARY" );\
		(PVOID)QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT" );\
		(PVOID)QCAP_SET_OSD_VIRTUAL_CAMERA_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_VIRTUAL_CAMERA_PICTURE" );\
		(PVOID)QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_VIRTUAL_CAMERA_BUFFER" );\
		(PVOID)QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_DONE_CALLBACK" );\
		(PVOID)QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIRTUAL_CAMERA_SNAPSHOT_STREAM_CALLBACK" );\
		(PVOID)QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_MIXING_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_MX_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER" );\
		(PVOID)QCAP_OPEN_FILE = GetProcAddress( HANDLE_NAME, "QCAP_OPEN_FILE" );\
		(PVOID)QCAP_DESTROY_FILE = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_FILE" );\
		(PVOID)QCAP_PLAY_FILE = GetProcAddress( HANDLE_NAME, "QCAP_PLAY_FILE" );\
		(PVOID)QCAP_PAUSE_FILE = GetProcAddress( HANDLE_NAME, "QCAP_PAUSE_FILE" );\
		(PVOID)QCAP_STOP_FILE = GetProcAddress( HANDLE_NAME, "QCAP_STOP_FILE" );\
		(PVOID)QCAP_GET_FILE_POSITION = GetProcAddress( HANDLE_NAME, "QCAP_GET_FILE_POSITION" );\
		(PVOID)QCAP_SET_FILE_POSITION = GetProcAddress( HANDLE_NAME, "QCAP_SET_FILE_POSITION" );\
		(PVOID)QCAP_GET_FILE_PLAYBACK_SPEED = GetProcAddress( HANDLE_NAME, "QCAP_GET_FILE_PLAYBACK_SPEED" );\
		(PVOID)QCAP_SET_FILE_PLAYBACK_SPEED = GetProcAddress( HANDLE_NAME, "QCAP_SET_FILE_PLAYBACK_SPEED" );\
		(PVOID)QCAP_GET_VIDEO_FILE_REGION_DISPLAY = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_FILE_REGION_DISPLAY" );\
		(PVOID)QCAP_SET_VIDEO_FILE_REGION_DISPLAY = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_FILE_REGION_DISPLAY" );\
		(PVOID)QCAP_GET_VIDEO_FILE_MIRROR = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_FILE_MIRROR" );\
		(PVOID)QCAP_SET_VIDEO_FILE_MIRROR = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_FILE_MIRROR" );\
		(PVOID)QCAP_GET_AUDIO_FILE_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_FILE_VOLUME" );\
		(PVOID)QCAP_SET_AUDIO_FILE_VOLUME = GetProcAddress( HANDLE_NAME, "QCAP_SET_AUDIO_FILE_VOLUME" );\
		(PVOID)QCAP_SNAPSHOT_FILE_BMP = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_FILE_BMP" );\
		(PVOID)QCAP_SNAPSHOT_FILE_JPG = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_FILE_JPG" );\
		(PVOID)QCAP_SNAPSHOT_FILE_BMP_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_FILE_BMP_EX" );\
		(PVOID)QCAP_SNAPSHOT_FILE_JPG_EX = GetProcAddress( HANDLE_NAME, "QCAP_SNAPSHOT_FILE_JPG_EX" );\
		(PVOID)QCAP_GET_OSD_FILE_TEXT_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_OSD_FILE_TEXT_BOUNDARY" );\
		(PVOID)QCAP_SET_OSD_FILE_TEXT = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_FILE_TEXT" );\
		(PVOID)QCAP_SET_OSD_FILE_PICTURE = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_FILE_PICTURE" );\
		(PVOID)QCAP_SET_OSD_FILE_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_SET_OSD_FILE_BUFFER" );\
		(PVOID)QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK" );\
		(PVOID)QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_FILE_SNAPSHOT_STREAM_CALLBACK" );\
		(PVOID)QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK" );\
		(PVOID)QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK" );\
		(PVOID)QCAP_SCF_FILE_ENUMERATION = GetProcAddress( HANDLE_NAME, "QCAP_SCF_FILE_ENUMERATION" );\
		(PVOID)QCAP_OPEN_SCF_FILE = GetProcAddress( HANDLE_NAME, "QCAP_OPEN_SCF_FILE" );\
		(PVOID)QCAP_SET_SCF_FILE_TIMER = GetProcAddress( HANDLE_NAME, "QCAP_SET_SCF_FILE_TIMER" );\
		(PVOID)QCAP_PLAY_GLOBAL_SCF_FILE = GetProcAddress( HANDLE_NAME, "QCAP_PLAY_GLOBAL_SCF_FILE" );\
		(PVOID)QCAP_PAUSE_GLOBAL_SCF_FILE = GetProcAddress( HANDLE_NAME, "QCAP_PAUSE_GLOBAL_SCF_FILE" );\
		(PVOID)QCAP_STOP_GLOBAL_SCF_FILE = GetProcAddress( HANDLE_NAME, "QCAP_STOP_GLOBAL_SCF_FILE" );\
		(PVOID)QCAP_GET_GLOBAL_SCF_FILE_POSITION = GetProcAddress( HANDLE_NAME, "QCAP_GET_GLOBAL_SCF_FILE_POSITION" );\
		(PVOID)QCAP_SET_GLOBAL_SCF_FILE_POSITION = GetProcAddress( HANDLE_NAME, "QCAP_SET_GLOBAL_SCF_FILE_POSITION" );\
		(PVOID)QCAP_OPEN_3D_FILE = GetProcAddress( HANDLE_NAME, "QCAP_OPEN_3D_FILE" );\
		(PVOID)QCAP_GET_VIDEO_3D_FILE_DISPLAY_MODE = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_3D_FILE_DISPLAY_MODE" );\
		(PVOID)QCAP_SET_VIDEO_3D_FILE_DISPLAY_MODE = GetProcAddress( HANDLE_NAME, "QCAP_SET_VIDEO_3D_FILE_DISPLAY_MODE" );\
		(PVOID)QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK = GetProcAddress( HANDLE_NAME, "QCAP_REGISTER_VIDEO_DECODER_3D_FILE_CALLBACK" );\
		(PVOID)QCAP_GET_VIDEO_FILE_STREAM_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_GET_VIDEO_FILE_STREAM_BUFFER" );\
		(PVOID)QCAP_GET_AUDIO_FILE_STREAM_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_FILE_STREAM_BUFFER" );\
		(PVOID)QCAP_EXPORT_FILE = GetProcAddress( HANDLE_NAME, "QCAP_EXPORT_FILE" );\
		(PVOID)QCAP_MERGE_FILES = GetProcAddress( HANDLE_NAME, "QCAP_MERGE_FILES" );\
		(PVOID)QCAP_MERGE_FILES_EX = GetProcAddress( HANDLE_NAME, "QCAP_MERGE_FILES_EX" );\
		(PVOID)QCAP_BUILD_VIDEO_ON_DEMAND_FILE = GetProcAddress( HANDLE_NAME, "QCAP_BUILD_VIDEO_ON_DEMAND_FILE" );\
		(PVOID)QCAP_DIAGNOSE_FILE = GetProcAddress( HANDLE_NAME, "QCAP_DIAGNOSE_FILE" );\
		(PVOID)QCAP_REPAIR_FILE = GetProcAddress( HANDLE_NAME, "QCAP_REPAIR_FILE" );\
		(PVOID)QCAP_CREATE_BURNING_DRIVE = GetProcAddress( HANDLE_NAME, "QCAP_CREATE_BURNING_DRIVE" );\
		(PVOID)QCAP_DESTROY_BURNING_DRIVE = GetProcAddress( HANDLE_NAME, "QCAP_DESTROY_BURNING_DRIVE" );\
		(PVOID)QCAP_START_BURNING_DRIVE = GetProcAddress( HANDLE_NAME, "QCAP_START_BURNING_DRIVE" );\
		(PVOID)QCAP_STOP_BURNING_DRIVE = GetProcAddress( HANDLE_NAME, "QCAP_STOP_BURNING_DRIVE" );\
		(PVOID)QCAP_UNLOAD_DISC = GetProcAddress( HANDLE_NAME, "QCAP_UNLOAD_DISC" );\
		(PVOID)QCAP_LOAD_DISC = GetProcAddress( HANDLE_NAME, "QCAP_LOAD_DISC" );\
		(PVOID)QCAP_GET_DISC_INFO = GetProcAddress( HANDLE_NAME, "QCAP_GET_DISC_INFO" );\
		(PVOID)QCAP_ERASE_DISC = GetProcAddress( HANDLE_NAME, "QCAP_ERASE_DISC" );\
		(PVOID)QCAP_CAMERA_ENUMERATION = GetProcAddress( HANDLE_NAME, "QCAP_CAMERA_ENUMERATION" );\
		(PVOID)QCAP_SET_DEFAULT_CAMERA = GetProcAddress( HANDLE_NAME, "QCAP_SET_DEFAULT_CAMERA" );\
		(PVOID)QCAP_SOUNDCARD_ENUMERATION = GetProcAddress( HANDLE_NAME, "QCAP_SOUNDCARD_ENUMERATION" );\
		(PVOID)QCAP_SET_DEFAULT_SOUNDCARD = GetProcAddress( HANDLE_NAME, "QCAP_SET_DEFAULT_SOUNDCARD" );\
		(PVOID)QCAP_GET_H264_BUFFER_LAYER_ID = GetProcAddress( HANDLE_NAME, "QCAP_GET_H264_BUFFER_LAYER_ID" );\
		(PVOID)QCAP_COLORSPACE_YUY2_TO_ABGR32 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YUY2_TO_ABGR32" );\
		(PVOID)QCAP_COLORSPACE_YV12_TO_ABGR32 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YV12_TO_ABGR32" );\
		(PVOID)QCAP_COLORSPACE_YUY2_TO_BGR24 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YUY2_TO_BGR24" );\
		(PVOID)QCAP_COLORSPACE_YV12_TO_BGR24 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YV12_TO_BGR24" );\
		(PVOID)QCAP_COLORSPACE_YUY2_TO_YV12 = GetProcAddress( HANDLE_NAME, "QCAP_COLORSPACE_YUY2_TO_YV12" );\
		(PVOID)QCAP_CONVERT_3D_STEREO_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_CONVERT_3D_STEREO_BUFFER" );\
		(PVOID)QCAP_RESIZE_VIDEO_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_RESIZE_VIDEO_BUFFER" );\
		(PVOID)QCAP_GET_ROTATE_VIDEO_BUFFER_BOUNDARY = GetProcAddress( HANDLE_NAME, "QCAP_GET_ROTATE_VIDEO_BUFFER_BOUNDARY" );\
		(PVOID)QCAP_ROTATE_VIDEO_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_ROTATE_VIDEO_BUFFER" );\
		(PVOID)QCAP_LOAD_PICTURE_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_LOAD_PICTURE_BUFFER" );\
		(PVOID)QCAP_GET_AUDIO_BUFFER_VOLUME_DB = GetProcAddress( HANDLE_NAME, "QCAP_GET_AUDIO_BUFFER_VOLUME_DB" );\
		(PVOID)QCAP_RESAMPLE_AUDIO_BUFFER = GetProcAddress( HANDLE_NAME, "QCAP_RESAMPLE_AUDIO_BUFFER" );\

#endif
