﻿// AnimationFactoryDlg.cpp : implementation file
//

#include "stdafx.h"
#include "AnimationFactory.h"
#include "AnimationFactoryDlg.h"
#include <math.h>
#include <iostream>
#include <fstream>
using namespace std;

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg dialog

VOID SC_DEBUG( TCHAR * fmt, ... )
{
	TCHAR pszDebugDumpMessage[ 256 ] = "[QC] ";

	va_list marker;

	va_start( marker, fmt );

	vsprintf( pszDebugDumpMessage + 5, fmt, marker );

	va_end( marker );

	strcat( pszDebugDumpMessage, "\n" );

	OutputDebugString( pszDebugDumpMessage );
}

CAnimationFactoryDlg * g_pAnimationFactoryDlg = NULL;

QRETURN on_video_decoder_file_callback( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	return QCAP_RT_OK;
}

QRETURN on_audio_decoder_file_callback( PVOID pFile, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	return QCAP_RT_OK;
}

QRETURN on_snapshot_done_callback( PVOID pFile, CHAR * pszFilePathName, PVOID pUserData )
{
	return QCAP_RT_OK;
}

QRETURN on_no_signal_detected_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] = 0;

	g_pAnimationFactoryDlg->m_dDeviceVideoFrameRates[ i ] = 0.0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannels[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSamples[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequencys[ i ] = 0;

	SC_DEBUG( "on_no_signal_detected_callback( %d )", i );

	return QCAP_RT_OK;
}

QRETURN on_no_signal_removed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] = 0;

	g_pAnimationFactoryDlg->m_dDeviceVideoFrameRates[ i ] = 0.0;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannels[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSamples[ i ] = 0;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequencys[ i ] = 0;

	SC_DEBUG( "on_no_signal_removed_callback( %d )", i );

	return QCAP_RT_OK;
}    

QRETURN on_format_changed_callback( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample, ULONG nAudioSampleFrequency, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);

	if ( g_pAnimationFactoryDlg == NULL ) { return QCAP_RT_OK; }

	if ( g_pAnimationFactoryDlg->GetSafeHwnd() == NULL ) { return QCAP_RT_OK; }

	UINT nVH = 0;

	if ( nVideoInput == 0 ) { sprintf( g_pAnimationFactoryDlg->strVideoInput[ i ], "COMPOSITE" ); }
 	
	if ( nVideoInput == 1 ) { sprintf( g_pAnimationFactoryDlg->strVideoInput[ i ], "SVIDEO" ); }
	
	if ( nVideoInput == 2 ) { sprintf( g_pAnimationFactoryDlg->strVideoInput[ i ], "HDMI" ); }

    if ( nVideoInput == 3 ) { sprintf( g_pAnimationFactoryDlg->strVideoInput[ i ], "DVI_D" ); }
	
	if ( nVideoInput == 4 ) { sprintf( g_pAnimationFactoryDlg->strVideoInput[ i ], "COMPONENTS (YCBCR)" ); }
	
	if ( nVideoInput == 5 ) { sprintf( g_pAnimationFactoryDlg->strVideoInput[ i ], "DVI_A(RGB & VGA)" ); }
	
    if ( nVideoInput == 6 ) { sprintf( g_pAnimationFactoryDlg->strVideoInput[ i], "SDI" ); }
	
	if ( nVideoInput == 7 ) { sprintf( g_pAnimationFactoryDlg->strVideoInput[ i ], "AUTO" ); }

    if ( nAudioInput == 0 ) { sprintf( g_pAnimationFactoryDlg->strAudioInput[ i ], "EMBEDDED_AUDIO" ); }
	
	if ( nAudioInput == 1 ) { sprintf( g_pAnimationFactoryDlg->strAudioInput[ i ], "LINE_IN" ); }

	if ( nAudioInput == 2 ) { sprintf( g_pAnimationFactoryDlg->strAudioInput[ i ], "SOUNDCARD_MICROPHONE" ); }
	
	if ( nAudioInput == 3 ) { sprintf( g_pAnimationFactoryDlg->strAudioInput[ i ], "SOUNDCARD_LINE_IN" ); }

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( g_pAnimationFactoryDlg->strFrameType[ i ], "I" ); } else { sprintf( g_pAnimationFactoryDlg->strFrameType[ i ], "P" ); }
	
	g_pAnimationFactoryDlg->m_strFormatChangedOutput[ i ].Format( "FMT: %dX%d%s@%2.3f / %dX%dX%d, INPUT: %s / %s, CB:",

													nVideoWidth,

													nVH,

													g_pAnimationFactoryDlg->strFrameType[ i ],

													dVideoFrameRate,

													nAudioChannels,

													nAudioBitsPerSample,

													nAudioSampleFrequency,

													g_pAnimationFactoryDlg->strVideoInput[ i ],

													g_pAnimationFactoryDlg->strAudioInput[ i ] );

	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ] = nVideoWidth;

	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ] = nVideoHeight;

	g_pAnimationFactoryDlg->m_bDeviceVideoIsInterleaved[ i ] = bVideoIsInterleaved;

	g_pAnimationFactoryDlg->m_dDeviceVideoFrameRates[ i ] = dVideoFrameRate;

	g_pAnimationFactoryDlg->m_nDeviceAudioChannels[ i ] = nAudioChannels;

	g_pAnimationFactoryDlg->m_nDeviceAudioBitsPerSamples[ i ] = nAudioBitsPerSample;

	g_pAnimationFactoryDlg->m_nDeviceAudioSampleFrequencys[ i ] = nAudioSampleFrequency;

	SC_DEBUG( "on_format_changed_callback( %d, %d, %d, %d, %d, %d )", i, nVideoWidth, nVideoHeight, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

    // NO SOURCE
    //
    if ( nVideoWidth == 0 && 
		
		 nVideoHeight == 0 &&

		 nAudioChannels == 0 &&

		 nAudioBitsPerSample == 0 &&

		 nAudioSampleFrequency == 0 ) {

		g_pAnimationFactoryDlg->m_bNoSignal[ i ] = TRUE;		
	}
    else {

		g_pAnimationFactoryDlg->m_bNoSignal[ i ] = FALSE;	

    }
	return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);
	
	//[CB]
	//
	if ( g_pAnimationFactoryDlg->m_pDevices[ 0 ] != 0 && i == 0 ) { 

			g_pAnimationFactoryDlg->m_bVideoPreviewCB_0 = TRUE;

			g_pAnimationFactoryDlg->Video_CB_Count_0++;
	}
	if ( g_pAnimationFactoryDlg->m_pDevices[ 1 ] != 0 && i == 1 ) { 

			g_pAnimationFactoryDlg->m_bVideoPreviewCB_1 = TRUE; 

			g_pAnimationFactoryDlg->Video_CB_Count_1++;
	}

	//[Cal Snapshot FPS]
	//
	SYSTEMTIME s_system_times; GetLocalTime( &s_system_times );

	ULONGLONG n_system_time = 0; SystemTimeToFileTime( &s_system_times, (FILETIME *)(&n_system_time) );

	double d_system_time = (ULONG)(n_system_time / 10000) / 1000.0;

	if( g_pAnimationFactoryDlg->g_n_video_frame_number[ i ]++ == 0 ) {

			g_pAnimationFactoryDlg->g_d_video_start_sample_time[ i ] = d_system_time;
	}
	g_pAnimationFactoryDlg->g_d_video_stop_sample_time[ i ] = d_system_time;

	//[Broadcast Buffer]
	//
	EnterCriticalSection( &g_pAnimationFactoryDlg->m_hNetworkServerAccessCriticalSections[ i ] );

	if( g_pAnimationFactoryDlg->m_nNetworkServerStates[ i ] >= 0x00000001 ) {

		g_pAnimationFactoryDlg->m_nNetworkServerStates[ i ] = 0x00000003;

		QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( g_pAnimationFactoryDlg->m_hNetworkServer[ i ], 
															  i, 
															  QCAP_COLORSPACE_TYEP_YUY2, 
															  g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ], 
															  g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ], 
															  pFrameBuffer, 
															  nFrameBufferLen );
	}	
	LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hNetworkServerAccessCriticalSections[ i ] );

	//[Share Reocrd Buffer]
	//
	if( i == 0 ) {

		EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );

		if( g_pAnimationFactoryDlg->m_nShareRecordState > 0x00000000 ) {

			UINT   iFrameNum = 0;

			BYTE * pClipFrameBuffer = NULL;

			ULONG  nClipFrameBufferLen = 0;

			if( g_pAnimationFactoryDlg->m_pClip ) {

				if( (g_pAnimationFactoryDlg->m_iClipCurrentFrame + 1) < 
				
					(g_pAnimationFactoryDlg->m_nClipFrames) ) {

					QCAP_STEP_ANIMATION_CLIP( g_pAnimationFactoryDlg->m_pClip, &iFrameNum, &pClipFrameBuffer, &nClipFrameBufferLen );

					g_pAnimationFactoryDlg->m_iClipCurrentFrame = iFrameNum;
				}
			}		
			if( pClipFrameBuffer ) {

				QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, QCAP_COLORSPACE_TYEP_YUY2,

																	g_pAnimationFactoryDlg->m_nClipWidth, 
																 
																	g_pAnimationFactoryDlg->m_nClipHeight, 
																	 
																	pClipFrameBuffer, 
																	 
																	nClipFrameBufferLen );

				QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER( g_pAnimationFactoryDlg->m_pVirtualCamera, 

																	QCAP_COLORSPACE_TYEP_YUY2,

																	g_pAnimationFactoryDlg->m_nClipWidth, 
																 
																	g_pAnimationFactoryDlg->m_nClipHeight, 
																 
																	pClipFrameBuffer, 
																 
																	nClipFrameBufferLen );
			}
			else {

				QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, QCAP_COLORSPACE_TYEP_YUY2, 
					
																	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ], 
																	 
																	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ], 
																	 
																	pFrameBuffer, 
																	 
																	nFrameBufferLen );

				QCAP_SET_VIDEO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER( g_pAnimationFactoryDlg->m_pVirtualCamera, 

																	QCAP_COLORSPACE_TYEP_YUY2,

																	g_pAnimationFactoryDlg->m_nDeviceVideoWidths[ i ], 
																 
																	g_pAnimationFactoryDlg->m_nDeviceVideoHeights[ i ], 
																 
																	pFrameBuffer, 
																 
																	nFrameBufferLen );
			}
		}	
		LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );
	}
    return QCAP_RT_OK;
}

QRETURN on_audio_preview_callback( PVOID pDevice, double dSampleTime, BYTE * pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData )
{
	ULONG i = (ULONG)(pUserData);
	
	//[CB]
	//
	if( g_pAnimationFactoryDlg->m_pDevices[ 0 ] != 0 && i == 0 ) { 

		g_pAnimationFactoryDlg->m_bAudioPreviewCB_0 = TRUE; 

		g_pAnimationFactoryDlg->Audio_CB_Count_0++;
	}
	if( g_pAnimationFactoryDlg->m_pDevices[ 1 ] != 0 && i == 1 ) { 

		g_pAnimationFactoryDlg->m_bAudioPreviewCB_1 = TRUE; 

		g_pAnimationFactoryDlg->Audio_CB_Count_1++;
	}

	//[Broadcast Buffer]
	//
	EnterCriticalSection( &g_pAnimationFactoryDlg->m_hNetworkServerAccessCriticalSections[ i ] );
	
	if( g_pAnimationFactoryDlg->m_nNetworkServerStates[ i ] >= 0x00000003 ) {

		QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( g_pAnimationFactoryDlg->m_hNetworkServer[ i ], 
															  i, 
															  pFrameBuffer,
															  nFrameBufferLen );
	}	
	LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hNetworkServerAccessCriticalSections[ i ] );

	//[Share Record Buffer]
	//
	EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );

	if( i == g_pAnimationFactoryDlg->m_nShareRecordActiveChannel ) {

		if( g_pAnimationFactoryDlg->m_nShareRecordState > 0x00000000 ) {

			QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, 
															  pFrameBuffer, 
															  nFrameBufferLen );

			QCAP_SET_AUDIO_VIRTUAL_CAMERA_UNCOMPRESSION_BUFFER( g_pAnimationFactoryDlg->m_pVirtualCamera, 
																pFrameBuffer, 
																nFrameBufferLen );
		}	
	}
	LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );
	
//	return (QRETURN)(QCAP_RT_SKIP_DISPLAY | QCAP_RT_SKIP_CLONE_DISPLAY);

	return QCAP_RT_OK;
}

CAnimationFactoryDlg::CAnimationFactoryDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAnimationFactoryDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAnimationFactoryDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAnimationFactoryDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAnimationFactoryDlg)

	//Window
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_0, m_statChannelWindow0);
	DDX_Control(pDX, IDC_STATIC_CHANNEL_WINDOW_1, m_statChannelWindow1);
	DDX_Control(pDX, IDC_STATIC_CLONE_WINDOW_0, m_statShowCloneVideo_0);
	DDX_Control(pDX, IDC_STATIC_CLONE_WINDOW_1, m_statShowCloneVideo_1);
	DDX_Control(pDX, IDC_STATIC_SHARE_WINDOW, m_statShareWindow);
	DDX_Control(pDX, IDC_STATIC_FILE_PLAYER_WINDOW, m_statfileplayerWindow);

	//Device
	DDX_Control(pDX, IDC_CHECK_THUMB_DRAW_0, m_checkThumbDRAW_0);
	DDX_Control(pDX, IDC_CHECK_THUMB_DRAW_1, m_checkThumbDRAW_1);
	DDX_Control(pDX, IDC_CHECK_MAINTAIN_ASPECT_RATIO_0, m_checkMaintain_Aspect_Ratio_0);


	DDX_Control(pDX, IDC_CHECK_MAINTAIN_ASPECT_RATIO_1, m_checkMaintain_Aspect_Ratio_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_DEINTERLACE_TYPE_0, m_combol_video_Deinterlace_Type_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_DEINTERLACE_TYPE_1, m_combol_video_Deinterlace_Type_1);

	DDX_Control(pDX, IDC_COMBO_VIDEO_INPUT_0, m_combol_video_input_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_INPUT_2, m_combol_video_input_1);
	DDX_Control(pDX, IDC_COMBO_AUDIO_INPUT_0, m_combol_audio_input_0);
	DDX_Control(pDX, IDC_COMBO_AUDIO_INPUT_2, m_combol_audio_input_1);

	DDX_Control(pDX, IDC_BUTTON_FORMAT_SET_0, m_btnCreate_0);
	DDX_Control(pDX, IDC_BUTTON_FORMAT_SET_1, m_btnCreate_1);
	DDX_Control(pDX, IDC_BUTTON_FORMAT_DESTROY_0, m_btnDestroy_0);
	DDX_Control(pDX, IDC_BUTTON_FORMAT_DESTROY_1, m_btnDestroy_1);
	DDX_Control(pDX, IDC_STATIC_DEVICE_FORMAT_INFOMATION_0, m_editDeviceFormatInformation_0);
	DDX_Control(pDX, IDC_STATIC_DEVICE_FORMAT_INFOMATION_1, m_editDeviceFormatInformation_1);
	DDX_Control(pDX, IDC_BUTTON_CREATE_CLONE_0, m_btnStartClone_0);
	DDX_Control(pDX, IDC_BUTTON_CREATE_CLONE_1, m_btnStartClone_1);
	DDX_Control(pDX, IDC_BUTTON_CREATE_DESTROY_0, m_btnStopClone_0);
	DDX_Control(pDX, IDC_BUTTON_CREATE_DESTROY_1, m_btnStopClone_1);

	DDX_Control(pDX, IDC_CHECK_DISPLAY_AUDIO_0, m_check_Audio_Display_0);
	DDX_Control(pDX, IDC_CHECK_DISPLAY_AUDIO_1, m_check_Audio_Display_1);

	//Channel Record
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_ENCODERTYPE_0, m_combol_video_Record_Property_EncoderType_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_ENCODERTYPE_1, m_combol_video_Record_Property_EncoderType_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_ENCODERFORMAT_0, m_combol_video_Record_Property_EncoderFormat_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_ENCODERFORMAT_1, m_combol_video_Record_Property_EncoderFormat_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_RECORDPROFILE_0, m_combol_video_Record_Property_RecordProfile_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_RECORDPROFILE_1, m_combol_video_Record_Property_RecordProfile_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_RECORDLEVEL_0, m_combol_video_Record_Property_RecordLevel_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_RECORDLEVEL_1, m_combol_video_Record_Property_RecordLevel_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_RECORDENTROPY_0, m_combol_video_Record_Property_RecordEntropy_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_RECORDENTROPY_1, m_combol_video_Record_Property_RecordEntropy_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_RECORDCOMPLEXITY_0, m_combol_video_Record_Property_RecordComplexity_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_RECORDCOMPLEXITY_1, m_combol_video_Record_Property_RecordComplexity_1);	
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_RECORDMODE_0, m_combol_video_Record_Property_RecordMode_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_RECORDMODE_1, m_combol_video_Record_Property_RecordMode_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_QUALITY_0, m_combol_video_Record_Property_Quality_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_QUALITY_1, m_combol_video_Record_Property_Quality_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_BITRATE_0, m_combol_video_Record_Property_BitRate_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_RECORD_PROERTY_BITRATE_1, m_combol_video_Record_Property_BitRate_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_ASPECT_RATIO_X_0, m_edit_Video_Record_Proerty_AspectRatio_X_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_ASPECT_RATIO_X_1, m_edit_Video_Record_Proerty_AspectRatio_X_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_ASPECT_RATIO_Y_0, m_edit_Video_Record_Proerty_AspectRatio_Y_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_ASPECT_RATIO_Y_1, m_edit_Video_Record_Proerty_AspectRatio_Y_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_GOP_0, m_edit_Video_Record_Proerty_GOP_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_GOP_1, m_edit_Video_Record_Proerty_GOP_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_B_FRAME_0, m_edit_Video_Record_Proerty_BFrame_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_B_FRAME_1, m_edit_Video_Record_Proerty_BFrame_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_INTERLEAVED_0, m_edit_Video_Record_Proerty_Interleaved_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_INTERLEAVED_1, m_edit_Video_Record_Proerty_Interleaved_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_CROP_X_0, m_edit_Video_Record_Proerty_CropX_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_CROP_X_1, m_edit_Video_Record_Proerty_CropX_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_CROP_Y_0, m_edit_Video_Record_Proerty_CropY_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_CROP_Y_1, m_edit_Video_Record_Proerty_CropY_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_CROP_W_0, m_edit_Video_Record_Proerty_CropW_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_CROP_W_1, m_edit_Video_Record_Proerty_CropW_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_CROP_H_0, m_edit_Video_Record_Proerty_CropH_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_CROP_H_1, m_edit_Video_Record_Proerty_CropH_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_DST_W_0, m_edit_Video_Record_Proerty_DstW_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_DST_W_1, m_edit_Video_Record_Proerty_DstW_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_DST_H_0, m_edit_Video_Record_Proerty_DstH_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_PROERTY_DST_H_1, m_edit_Video_Record_Proerty_DstH_1);
	DDX_Control(pDX, IDC_COMBO_AUDIO_RECORD_PROERTY_ENCODERTYPE_0, m_combol_Audio_Record_Property_EncoderType_0);
	DDX_Control(pDX, IDC_COMBO_AUDIO_RECORD_PROERTY_ENCODERTYPE_1, m_combol_Audio_Record_Property_EncoderType_1);
	DDX_Control(pDX, IDC_COMBO_AUDIO_RECORD_PROERTY_ENCODERFORMAT_0, m_combol_Audio_Record_Property_EncoderFormat_0);
	DDX_Control(pDX, IDC_COMBO_AUDIO_RECORD_PROERTY_ENCODERFORMAT_1, m_combol_Audio_Record_Property_EncoderFormat_1);
	DDX_Control(pDX, IDC_COMBO_START_RECORD_FILEPATHNAME_0, m_combol_Start_Record_FilePathName_0);
	DDX_Control(pDX, IDC_COMBO_START_RECORD_FILEPATHNAME_1, m_combol_Start_Record_FilePathName_1);
	DDX_Control(pDX, IDC_BUTTON_START_RECORD_0, m_btnRecordStart_0);
	DDX_Control(pDX, IDC_BUTTON_START_RECORD_1, m_btnRecordStart_1);
	DDX_Control(pDX, IDC_BUTTON_STOP_RECORD_0, m_btnRecordStop_0);
	DDX_Control(pDX, IDC_BUTTON_STOP_RECORD_1, m_btnRecordStop_1);	
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_DELAY_TIME_0, m_edit_Video_Record_Delay_Time_0);
	DDX_Control(pDX, IDC_EDIT_AUDIO_RECORD_DELAY_TIME_1, m_edit_Audio_Record_Delay_Time_1);	
	DDX_Control(pDX, IDC_EDIT_AUDIO_RECORD_DELAY_TIME_0, m_edit_Audio_Record_Delay_Time_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_RECORD_DELAY_TIME_1, m_edit_Video_Record_Delay_Time_1);
	
	//Share Record
	DDX_Control(pDX, IDC_COMBO_VIDEO_SHARE_RECORD_PROERTY_ENCODERTYPE, m_combol_video_Share_Record_Property_EncoderType);
	DDX_Control(pDX, IDC_COMBO_VIDEO_SHARE_RECORD_PROERTY_ENCODERFORMAT, m_combol_video_Share_Record_Property_EncoderFormat);
	DDX_Control(pDX, IDC_COMBO_VIDEO_SHARE_RECORD_PROERTY_RECORDPROFILE, m_combol_video_Share_Record_Property_RecordProfile);
	DDX_Control(pDX, IDC_COMBO_VIDEO_SHARE_RECORD_PROERTY_RECORDLEVEL, m_combol_video_Share_Record_Property_RecordLevel);
	DDX_Control(pDX, IDC_COMBO_VIDEO_SHARE_RECORD_PROERTY_RECORDENTROPY, m_combol_video_Share_Record_Property_RecordEntropy);
	DDX_Control(pDX, IDC_COMBO_VIDEO_SHARE_RECORD_PROERTY_RECORDCOMPLEXITY, m_combol_video_Share_Record_Property_RecordComplexity);
	DDX_Control(pDX, IDC_COMBO_VIDEO_SHARE_RECORD_PROERTY_RECORDMODE, m_combol_video_Share_Record_Property_RecordMode);
	DDX_Control(pDX, IDC_COMBO_VIDEO_SHARE_RECORD_PROERTY_QUALITY, m_combol_video_Share_Record_Property_Quality);
	DDX_Control(pDX, IDC_COMBO_VIDEO_SHARE_RECORD_PROERTY_BITRATE, m_combol_video_Share_Record_Property_BitRate);
	DDX_Control(pDX, IDC_EDIT_VIDEO_SHARE_RECORD_PROERTY_ASPECT_RATIO_X, m_edit_Video_Share_Record_Proerty_AspectRatio_X);
	DDX_Control(pDX, IDC_EDIT_VIDEO_SHARE_RECORD_PROERTY_ASPECT_RATIO_Y, m_edit_Video_Share_Record_Proerty_AspectRatio_Y);
	DDX_Control(pDX, IDC_EDIT_VIDEO_SHARE_RECORD_PROERTY_GOP, m_edit_Video_Share_Record_Proerty_GOP);
	DDX_Control(pDX, IDC_EDIT_VIDEO_SHARE_RECORD_PROERTY_B_FRAME, m_edit_Video_Share_Record_Proerty_BFrame);
	DDX_Control(pDX, IDC_EDIT_VIDEO_SHARE_RECORD_PROERTY_INTERLEAVED, m_edit_Video_Share_Record_Proerty_Interleaved);
	DDX_Control(pDX, IDC_COMBO_AUDIO_SHARE_RECORD_PROERTY_ENCODERTYPE, m_combol_Audio_Share_Record_Property_EncoderType);
	DDX_Control(pDX, IDC_COMBO_AUDIO_SHARE_RECORD_PROERTY_ENCODERFORMAT, m_combol_Audio_Share_Record_Property_EncoderFormat);
	DDX_Control(pDX, IDC_COMBO_START_SHARE_RECORD_FILEPATHNAME, m_combol_Share_Record_FilePathName);
	DDX_Control(pDX, IDC_BUTTON_START_SHARE_RECORD, m_btnShareRecordStart);
	DDX_Control(pDX, IDC_BUTTON_STOP_SHARE_RECORD, m_btnShareRecordStop);
	DDX_Control(pDX, IDC_CHECK_SHARE_RECORD_THUMB_DRAW, m_checkShareRecordThumbDRAW);
	DDX_Control(pDX, IDC_CHECK_SHARE_RECORD_MAINTAIN_ASPECT_RATIO, m_checkShareRecordMaintain_Aspect_Ratio);
	DDX_Control(pDX, IDC_EDIT_SHARE_RECORD_VIDEO_DELAY_TIME, m_edit_Share_Record_Video_Delay_Time);
	DDX_Control(pDX, IDC_EDIT_SHARE_RECORD_AUDIO_DELAY_TIME, m_edit_Share_Record_Audio_Delay_Time);

	//Broadcast
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_ENCODERTYPE_0, m_combol_video_Broadcast_Server_Property_EncoderType_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_ENCODERTYPE_1, m_combol_video_Broadcast_Server_Property_EncoderType_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_ENCODERFORMAT_0, m_combol_video_Broadcast_Server_Property_EncoderFormat_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_ENCODERFORMAT_1, m_combol_video_Broadcast_Server_Property_EncoderFormat_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_RECORDPROFILE_0, m_combol_video_Broadcast_Server_Property_RecordProfile_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_RECORDPROFILE_1, m_combol_video_Broadcast_Server_Property_RecordProfile_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_RECORDLEVEL_0, m_combol_video_Broadcast_Server_Property_RecordLevel_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_RECORDLEVEL_1, m_combol_video_Broadcast_Server_Property_RecordLevel_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_RECORDENTROPY_0, m_combol_video_Broadcast_Server_Property_RecordEntropy_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_RECORDENTROPY_1, m_combol_video_Broadcast_Server_Property_RecordEntropy_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_RECORDCOMPLEXITY_0, m_combol_video_Broadcast_Server_Property_RecordComplexity_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_RECORDCOMPLEXITY_1, m_combol_video_Broadcast_Server_Property_RecordComplexity_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_RECORDMODE_0, m_combol_video_Broadcast_Server_Property_RecordMode_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_RECORDMODE_1, m_combol_video_Broadcast_Server_Property_RecordMode_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_QUALITY_0, m_combol_video_Broadcast_Server_Property_Quality_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_QUALITY_1, m_combol_video_Broadcast_Server_Property_Quality_1);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_BITRATE_0, m_combol_video_Broadcast_Server_Property_BitRate_0);
	DDX_Control(pDX, IDC_COMBO_VIDEO_BROADCAST_SERVER_PROERTY_BITRATE_1, m_combol_video_Broadcast_Server_Property_BitRate_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_BROADCAST_SERVER_PROERTY_ASPECT_RATIO_X_0, m_edit_Video_Broadcast_Server_Proerty_AspectRatio_X_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_BROADCAST_SERVER_PROERTY_ASPECT_RATIO_X_1, m_edit_Video_Broadcast_Server_Proerty_AspectRatio_X_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_BROADCAST_SERVER_PROERTY_ASPECT_RATIO_Y_0, m_edit_Video_Broadcast_Server_Proerty_AspectRatio_Y_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_BROADCAST_SERVER_PROERTY_ASPECT_RATIO_Y_1, m_edit_Video_Broadcast_Server_Proerty_AspectRatio_Y_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_BROADCAST_SERVER_PROERTY_GOP_0, m_edit_Video_Broadcast_Server_Proerty_GOP_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_BROADCAST_SERVER_PROERTY_GOP_1, m_edit_Video_Broadcast_Server_Proerty_GOP_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_BROADCAST_SERVER_PROERTY_B_FRAME_0, m_edit_Video_Broadcast_Server_Proerty_BFrame_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_BROADCAST_SERVER_PROERTY_B_FRAME_1, m_edit_Video_Broadcast_Server_Proerty_BFrame_1);
	DDX_Control(pDX, IDC_EDIT_VIDEO_BROADCAST_SERVER_PROERTY_INTERLEAVED_0, m_edit_Video_Broadcast_Server_Proerty_Interleaved_0);
	DDX_Control(pDX, IDC_EDIT_VIDEO_BROADCAST_SERVER_PROERTY_INTERLEAVED_1, m_edit_Video_Broadcast_Server_Proerty_Interleaved_1);
	DDX_Control(pDX, IDC_COMBO_AUDIO_BROADCAST_SERVER_PROERTY_ENCODERTYPE_0, m_combol_Audio_Broadcast_Server_Property_EncoderType_0);
	DDX_Control(pDX, IDC_COMBO_AUDIO_BROADCAST_SERVER_PROERTY_ENCODERTYPE_1, m_combol_Audio_Broadcast_Server_Property_EncoderType_1);
	DDX_Control(pDX, IDC_COMBO_AUDIO_BROADCAST_SERVER_PROERTY_ENCODERFORMAT_0, m_combol_Audio_Broadcast_Server_Property_EncoderFormat_0);
	DDX_Control(pDX, IDC_COMBO_AUDIO_BROADCAST_SERVER_PROERTY_ENCODERFORMAT_1, m_combol_Audio_Broadcast_Server_Property_EncoderFormat_1);
	DDX_Control(pDX, IDC_EDIT_URL_ADDRESS_0, m_edit_URL_ADDRESS_0);
	DDX_Control(pDX, IDC_EDIT_URL_ADDRESS_1, m_edit_URL_ADDRESS_1);
	DDX_Control(pDX, IDC_COMBO_BROADCAST_SERVER_SELECT_0, m_combol_Broadcast_Server_Type_Select_0);
	DDX_Control(pDX, IDC_COMBO_BROADCAST_SERVER_SELECT_1, m_combol_Broadcast_Server_Type_Select_1);
	DDX_Control(pDX, IDC_BUTTON_START_SERVER_0, m_btnBroadcastServerStart_0);
	DDX_Control(pDX, IDC_BUTTON_START_SERVER_1, m_btnBroadcastServerStart_1);
	DDX_Control(pDX, IDC_BUTTON_STOP_SERVER_0, m_btnBroadcastServerStop_0);
	DDX_Control(pDX, IDC_BUTTON_STOP_SERVER_1, m_btnBroadcastServerStop_1);

	//Virtual Camera
	DDX_Control(pDX, IDC_BUTTON_START_VIRTAUL_CAMERA, m_btnVirtualCameraStart);
	DDX_Control(pDX, IDC_BUTTON_STOP_VIRTUAL_CAMERA, m_btnVirtualCameraStop);
	DDX_Control(pDX, IDC_PROGRESS_TIME, m_progTimeBar);
	DDX_Control(pDX, IDC_STATIC_VIRTUAL_CAMERA_DISPLAY_WINDOW, m_statVirtualCameraWindow);
	DDX_Control(pDX, IDC_BUTTON_START_VIRTAUL_CAMERA_DISPLAY, m_btnVirtualCameraStartDisplay);
	DDX_Control(pDX, IDC_BUTTON_STOP_VIRTUAL_CAMERA_DISPLAY, m_btnVirtualCameraStopDisplay);
	DDX_Control(pDX, IDC_CHECK_VIRTUAL_CAMERA_THUMB_DRAW, m_checkVirtualCameraThumbDRAW);
	DDX_Control(pDX, IDC_CHECK_VIRTUAL_CAMERA_MAINTAIN_ASPECT_RATIO, m_checkVirtualCameraMaintain_Aspect_Ratio);

	//Channel Snapshot& OSD
	DDX_Control(pDX, IDC_BUTTON_OSD_TEXT_0, m_bOSDTEXT_0);
	DDX_Control(pDX, IDC_BUTTON_OSD_PICTURE_0, m_bOSDPICT_0);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT_BMP_0, m_bSNAPBMP_0);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT_JPG_0, m_bSNAPJPG_0);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT_BMP_EX_0, m_bSNAPBMP_EX_0);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT_JPG_EX_0, m_bSNAPJPG_EX_0);
	DDX_Control(pDX, IDC_BUTTON_OSD_TEXT_1, m_bOSDTEXT_1);
	DDX_Control(pDX, IDC_BUTTON_OSD_PICTURE_1, m_bOSDPICT_1);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT_BMP_1, m_bSNAPBMP_1);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT_JPG_1, m_bSNAPJPG_1);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT_BMP_EX_1, m_bSNAPBMP_EX_1);
	DDX_Control(pDX, IDC_BUTTON_SNAPSHOT_JPG_EX_1, m_bSNAPJPG_EX_1);

	//VIRTUAL CAMERA Snapshot& OSD
	DDX_Control(pDX, IDC_BUTTON_VIRTUAL_CAMERA_OSD_TEXT, m_bOSDTEXT_VIRTUAL_CAMERA);
	DDX_Control(pDX, IDC_BUTTON_VIRTUAL_CAMERA_OSD_PICTURE, m_bOSDPICT_VIRTUAL_CAMERA);
	DDX_Control(pDX, IDC_BUTTON_VIRTUAL_CAMERA_SNAPSHOT_BMP, m_bSNAPBMP_VIRTUAL_CAMERA);
	DDX_Control(pDX, IDC_BUTTON_VIRTUAL_CAMERA_SNAPSHOT_JPG, m_bSNAPJPG_VIRTUAL_CAMERA);
	DDX_Control(pDX, IDC_BUTTON_VIRTUAL_CAMERA_SNAPSHOT_BMP_EX, m_bSNAPBMP_EX_VIRTUAL_CAMERA);
	DDX_Control(pDX, IDC_BUTTON_VIRTUAL_CAMERA_SNAPSHOT_JPG_EX, m_bSNAPJPG_EX_VIRTUAL_CAMERA);

	//FILE PLAY
	DDX_Control(pDX, IDC_BUTTON_FILE_PLAYER_ANALYSIS, m_bANALYSIS_FILE_PLAY);
	DDX_Control(pDX, IDC_BUTTON_FILE_PLAYER_OSD_TEXT, m_bOSDTEXT_FILE_PLAY);
	DDX_Control(pDX, IDC_BUTTON_FILE_PLAYER_OSD_PICTURE, m_bOSDPICT_FILE_PLAY);
	DDX_Control(pDX, IDC_BUTTON_FILE_PLAYER_SNAPSHOT_BMP, m_bSNAPSHOT_FILE_PLAY);
	DDX_Control(pDX, IDC_BUTTON_FILE_PLAYER_SNAPSHOT_JPG, m_bSNAPJPG_FILE_PLAY);
	DDX_Control(pDX, IDC_BUTTON_FILE_PLAYER_SNAPSHOT_BMP_EX, m_bSNAPBMP_EX_FILE_PLAY);
	DDX_Control(pDX, IDC_BUTTON_FILE_PLAYER_SNAPSHOT_JPG_EX, m_bSNAPJPG_EX_FILE_PLAY);
	DDX_Control(pDX, IDC_BUTTON_FILE_PLAYER_SPEED_FAST, m_bSPEED_ADD_FILE_PLAY);
	DDX_Control(pDX, IDC_BUTTON_FILE_PLAYER_SPEED_SLOW, m_bSPEED_REDUCE_FILE_PLAY);
	DDX_Control(pDX, IDC_BUTTON_FILE_PLAYER_PAUSE, m_bPAUSE_FILE_PLAY);
	DDX_Control(pDX, IDC_BUTTON_FILE_PLAYER_STOP, m_bSTOP_FILE_PLAY);
	DDX_Control(pDX, IDC_BUTTON_FILE_PLAYER_PLAY, m_bPLAY_FILE_PLAY);
	//}}AFX_DATA_MAP			

}

BEGIN_MESSAGE_MAP(CAnimationFactoryDlg, CDialog)
	//{{AFX_MSG_MAP(CAnimationFactoryDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_STATIC_CHANNEL_WINDOW_0, OnClickedChannelWindow0)
	ON_BN_CLICKED(IDC_STATIC_CHANNEL_WINDOW_1, OnClickedChannelWindow1)
	ON_WM_TIMER()
	ON_WM_VSCROLL()
	ON_WM_HSCROLL()

	//Device
	ON_BN_CLICKED(IDC_BUTTON_FORMAT_SET_0, &CAnimationFactoryDlg::OnBnClickedButtonFormatSet0)
	ON_BN_CLICKED(IDC_BUTTON_FORMAT_SET_1, &CAnimationFactoryDlg::OnBnClickedButtonFormatSet1)
	ON_BN_CLICKED(IDC_BUTTON_FORMAT_DESTROY_0, &CAnimationFactoryDlg::OnBnClickedButtonFormatDestroy0)	
	ON_BN_CLICKED(IDC_BUTTON_FORMAT_DESTROY_1, &CAnimationFactoryDlg::OnBnClickedButtonFormatDestroy1)
	ON_BN_CLICKED(IDC_BUTTON_CREATE_CLONE_0, &CAnimationFactoryDlg::OnBnClickedButtonCreateClone0)
	ON_BN_CLICKED(IDC_BUTTON_CREATE_CLONE_1, &CAnimationFactoryDlg::OnBnClickedButtonCreateClone1)
	ON_BN_CLICKED(IDC_BUTTON_CREATE_DESTROY_0, &CAnimationFactoryDlg::OnBnClickedButtonCreateDestroy0)
	ON_BN_CLICKED(IDC_BUTTON_CREATE_DESTROY_1, &CAnimationFactoryDlg::OnBnClickedButtonCreateDestroy1)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT_BMP_0, &CAnimationFactoryDlg::OnBnClickedButtonSnapshotBmp0)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT_BMP_1, &CAnimationFactoryDlg::OnBnClickedButtonSnapshotBmp1)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT_JPG_0, &CAnimationFactoryDlg::OnBnClickedButtonSnapshotJpg0)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT_JPG_1, &CAnimationFactoryDlg::OnBnClickedButtonSnapshotJpg1)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT_BMP_EX_0, &CAnimationFactoryDlg::OnBnClickedButtonSnapshotBmpEx0)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT_BMP_EX_1, &CAnimationFactoryDlg::OnBnClickedButtonSnapshotBmpEx1)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT_JPG_EX_0, &CAnimationFactoryDlg::OnBnClickedButtonSnapshotJpgEx0)
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT_JPG_EX_1, &CAnimationFactoryDlg::OnBnClickedButtonSnapshotJpgEx1)
	ON_BN_CLICKED(IDC_BUTTON_OSD_TEXT_0, &CAnimationFactoryDlg::OnBnClickedButtonOsdText0)
	ON_BN_CLICKED(IDC_BUTTON_OSD_TEXT_1, &CAnimationFactoryDlg::OnBnClickedButtonOsdText1)
	ON_BN_CLICKED(IDC_BUTTON_OSD_PICTURE_0, &CAnimationFactoryDlg::OnBnClickedButtonOsdPicture0)
	ON_BN_CLICKED(IDC_BUTTON_OSD_PICTURE_1, &CAnimationFactoryDlg::OnBnClickedButtonOsdPicture1)	
	ON_CBN_SELCHANGE(IDC_COMBO_VIDEO_INPUT_0, &CAnimationFactoryDlg::OnCbnSelchangeComboVideoInput0)
	ON_CBN_SELCHANGE(IDC_COMBO_AUDIO_INPUT_0, &CAnimationFactoryDlg::OnCbnSelchangeComboAudioInput0)
	ON_CBN_SELCHANGE(IDC_COMBO_VIDEO_INPUT_2, &CAnimationFactoryDlg::OnCbnSelchangeComboVideoInput2)
	ON_CBN_SELCHANGE(IDC_COMBO_AUDIO_INPUT_2, &CAnimationFactoryDlg::OnCbnSelchangeComboAudioInput2)
	ON_CBN_SELCHANGE(IDC_COMBO_VIDEO_DEINTERLACE_TYPE_0, &CAnimationFactoryDlg::OnCbnSelchangeComboVideoDeinterlaceType0)
	ON_CBN_SELCHANGE(IDC_COMBO_VIDEO_DEINTERLACE_TYPE_1, &CAnimationFactoryDlg::OnCbnSelchangeComboVideoDeinterlaceType1)
	ON_BN_CLICKED(IDC_CHECK_DISPLAY_AUDIO_0, &CAnimationFactoryDlg::OnBnClickedCheckDisplayAudio0)
	ON_BN_CLICKED(IDC_CHECK_DISPLAY_AUDIO_1, &CAnimationFactoryDlg::OnBnClickedCheckDisplayAudio1)
	
	//Channel Record
	ON_BN_CLICKED(IDC_BUTTON_START_RECORD_0, &CAnimationFactoryDlg::OnBnClickedButtonStartRecord0)
	ON_BN_CLICKED(IDC_BUTTON_START_RECORD_1, &CAnimationFactoryDlg::OnBnClickedButtonStartRecord1)
	ON_BN_CLICKED(IDC_BUTTON_STOP_RECORD_0, &CAnimationFactoryDlg::OnBnClickedButtonStopRecord0)
	ON_BN_CLICKED(IDC_BUTTON_STOP_RECORD_1, &CAnimationFactoryDlg::OnBnClickedButtonStopRecord1)

	//Share Record
	ON_BN_CLICKED(IDC_BUTTON_START_SHARE_RECORD, &CAnimationFactoryDlg::OnBnClickedButtonStartRecord2)
	ON_BN_CLICKED(IDC_BUTTON_STOP_SHARE_RECORD, &CAnimationFactoryDlg::OnBnClickedButtonStopRecord2)
	ON_BN_CLICKED(IDC_BUTTON_OSD_PICTURE_2, &CAnimationFactoryDlg::OnBnClickedButtonOsdPicture2)

	//Broadcast
	ON_BN_CLICKED(IDC_BUTTON_START_SERVER_0, &CAnimationFactoryDlg::OnBnClickedButtonStartServer0)
	ON_BN_CLICKED(IDC_BUTTON_STOP_SERVER_0, &CAnimationFactoryDlg::OnBnClickedButtonStopServer0)
	ON_BN_CLICKED(IDC_BUTTON_START_SERVER_1, &CAnimationFactoryDlg::OnBnClickedButtonStartServer1)
	ON_BN_CLICKED(IDC_BUTTON_STOP_SERVER_1, &CAnimationFactoryDlg::OnBnClickedButtonStopServer1)

	//Virtual Camera
	ON_BN_CLICKED(IDC_BUTTON_VIRTUAL_CAMERA_OSD_TEXT, &CAnimationFactoryDlg::OnBnClickedButtonVirtualCameraOsdText)
	ON_BN_CLICKED(IDC_BUTTON_VIRTUAL_CAMERA_OSD_PICTURE, &CAnimationFactoryDlg::OnBnClickedButtonVirtualCameraOsdPicture)
	ON_BN_CLICKED(IDC_BUTTON_VIRTUAL_CAMERA_SNAPSHOT_BMP, &CAnimationFactoryDlg::OnBnClickedButtonVirtualCameraSnapshotBmp)
	ON_BN_CLICKED(IDC_BUTTON_VIRTUAL_CAMERA_SNAPSHOT_JPG, &CAnimationFactoryDlg::OnBnClickedButtonVirtualCameraSnapshotJpg)
	ON_BN_CLICKED(IDC_BUTTON_VIRTUAL_CAMERA_SNAPSHOT_BMP_EX, &CAnimationFactoryDlg::OnBnClickedButtonVirtualCameraSnapshotBmpEx)
	ON_BN_CLICKED(IDC_BUTTON_VIRTUAL_CAMERA_SNAPSHOT_JPG_EX, &CAnimationFactoryDlg::OnBnClickedButtonVirtualCameraSnapshotJpgEx)
	ON_BN_CLICKED(IDC_BUTTON_START_VIRTAUL_CAMERA, &CAnimationFactoryDlg::OnBnClickedButtonStartVirtaulCamera)
	ON_BN_CLICKED(IDC_BUTTON_STOP_VIRTUAL_CAMERA, &CAnimationFactoryDlg::OnBnClickedButtonStopVirtualCamera)
	ON_BN_CLICKED(IDC_BUTTON_START_VIRTAUL_CAMERA_DISPLAY, &CAnimationFactoryDlg::OnBnClickedButtonStartVirtaulCameraDisplay)
	ON_BN_CLICKED(IDC_BUTTON_STOP_VIRTUAL_CAMERA_DISPLAY, &CAnimationFactoryDlg::OnBnClickedButtonStopVirtualCameraDisplay)

	//File Player
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_OPEN, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerOpen)
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_PLAY, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerPlay)
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_PAUSE, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerPause)
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_STOP, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerStop)
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_SPEED_FAST, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerSpeedFast)
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_SPEED_SLOW, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerSpeedSlow)
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_SNAPSHOT_JPG, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerSnapshotJpg)
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_SNAPSHOT_BMP, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerSnapshotBmp)
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_SNAPSHOT_BMP_EX, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerSnapshotBmpEx)
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_SNAPSHOT_JPG_EX, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerSnapshotJpgEx)
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_OSD_TEXT, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerOsdText)
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_OSD_PICTURE, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerOsdPicture)
	ON_BN_CLICKED(IDC_BUTTON_FILE_PLAYER_ANALYSIS, &CAnimationFactoryDlg::OnBnClickedButtonFilePlayerAnalysis)
	//}}AFX_MSG_MAP

END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAnimationFactoryDlg message handlers

extern CAnimationFactoryApp theApp;

void CAnimationFactoryDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here	
	OnBnClickedButtonStopServer0();
	OnBnClickedButtonStopServer1();

	// UNINITIALIZE NETWORK BROADCAST
	//
	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	m_nNetworkServerStates[ 0 ] = 0x0000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	m_nNetworkServerStates[ 1 ] = 0x0000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	// UNINITIALIZE SHARE RECORDING
	//
	EnterCriticalSection( &m_hShareRecordAccessCriticalSection );

	m_nShareRecordState = 0x00000000;

	LeaveCriticalSection( &m_hShareRecordAccessCriticalSection );
	
	// UNINITIALIZE VIRTUAL CAMERA PLAYER
	//
	if ( m_hCameraDevice != 0 ) {

		QCAP_STOP( m_hCameraDevice );

		QCAP_DESTROY( m_hCameraDevice );

		m_hCameraDevice = NULL;
	}

	if ( m_pVirtualCamera != 0 )
	{
		QCAP_STOP_VIRTUAL_CAMERA( m_pVirtualCamera );

		QCAP_DESTROY_VIRTUAL_CAMERA( m_pVirtualCamera );

		m_pVirtualCamera = NULL;
	}

	// UNINITIALIZE Channel Record & Share Record
	//
	QCAP_STOP_SHARE_RECORD( 0 );

	for( ULONG i = 0 ; i < 2 ; i++ ) {

		if( m_pDevices[ i ] ) {

			QCAP_STOP_RECORD( m_pDevices[ i ], 0 );
		}
	}

	// UNINITIALIZE ANIMATION CLIP
	//
	if( m_pClip ) {

		QCAP_STOP_ANIMATION_CLIP( m_pClip );

		QCAP_DESTROY_ANIMATION_CLIP( m_pClip );

		m_pClip = NULL;
	}

	// UNINITIALIZE FILE PLAYER
	//
	if( m_pFile ) {

		QCAP_DESTROY( m_pFile );

		m_pFile = NULL;
	}

	// UNINITIALIZE DEVICE RESOURCE
	// 
	for( ULONG i = 0 ; i < 2 ; i++ ) {

		if ( m_hNetworkServer[ i ] != NULL ) {

			QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer[ i ] );

			QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer[ i ] );

			m_hNetworkServer[ i ] = NULL;
		}

		if( m_hCloneCapDev[ i ] != 0 ) {

			QCAP_STOP( m_hCloneCapDev[ i ] );

			QCAP_DESTROY( m_hCloneCapDev[ i ] );

			m_hCloneCapDev[ i ] = NULL;
		}

		if( m_pDevices[ i ] ) {

			QCAP_STOP( m_pDevices[ i ] );

			QCAP_DESTROY( m_pDevices[ i ] );

			m_pDevices[ i ] = NULL;
		}
	}
	DeleteCriticalSection( &m_hShareRecordAccessCriticalSection );

	DeleteCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	DeleteCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	// UNINITIALIZE COM LIBRARY
	// 
	CoUninitialize();
}

BOOL CAnimationFactoryDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here


	m_editDeviceFormatInformation_0.SetWindowText( "INFO : ..." );
	m_editDeviceFormatInformation_1.SetWindowText( "INFO : ..." );

	//CH1 Device Video & Audio Format List Menu 
	ULONG CH01_VideoInput_index =0;
	CH01_VideoInput_index=theApp.GetProfileInt("CH01_Setting","CH01_VideoInput", 0);
	m_combol_video_input_0.InsertString(0,_T("QCAP_INPUT_TYPE_COMPOSITE"));
	m_combol_video_input_0.InsertString(1,_T("QCAP_INPUT_TYPE_SVIDEO"));
	m_combol_video_input_0.InsertString(2,_T("QCAP_INPUT_TYPE_HDMI"));
	m_combol_video_input_0.InsertString(3,_T("QCAP_INPUT_TYPE_DVI_D"));
	m_combol_video_input_0.InsertString(4,_T("QCAP_INPUT_TYPE_COMPONENTS"));
	m_combol_video_input_0.InsertString(5,_T("QCAP_INPUT_TYPE_DVI_A"));
	m_combol_video_input_0.InsertString(6,_T("QCAP_INPUT_TYPE_SDI"));
	m_combol_video_input_0.InsertString(7,_T("QCAP_INPUT_TYPE_AUTO"));
	m_combol_video_input_0.SetCurSel( CH01_VideoInput_index );

	ULONG CH01_AudioInput_index =0;
	CH01_AudioInput_index=theApp.GetProfileInt("CH01_Setting","CH01_AudioInput", 0);
	m_combol_audio_input_0.InsertString(0,_T("QCAP_INPUT_TYPE_EMBEDDED_AUDIO"));
	m_combol_audio_input_0.InsertString(1,_T("QCAP_INPUT_TYPE_LINE_IN"));
	m_combol_audio_input_0.InsertString(2,_T("QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE"));
	m_combol_audio_input_0.InsertString(3,_T("QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN"));
	m_combol_audio_input_0.SetCurSel(CH01_AudioInput_index);


	//Deinterlace Type List Menu
	ULONG CH01_Deinterlace_index =0;
	CH01_Deinterlace_index=theApp.GetProfileInt("CH01_Setting","CH01_DeinterlaceType", 0);
	m_combol_video_Deinterlace_Type_0.InsertString(0,_T("QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING"));
	m_combol_video_Deinterlace_Type_0.InsertString(1,_T("QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE"));
	m_combol_video_Deinterlace_Type_0.InsertString(2,_T("QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE"));
	m_combol_video_Deinterlace_Type_0.InsertString(3,_T("QCAP_SOFTWARE_DEINTERLACE_TYPE_NULL"));
	m_combol_video_Deinterlace_Type_0.SetCurSel( CH01_Deinterlace_index );


	//CH2 Device Video & Audio Format List Menu 
	ULONG CH02_VideoInput_index =0;
	CH02_VideoInput_index=theApp.GetProfileInt("CH02_Setting","CH02_VideoInput", 0);
	m_combol_video_input_1.InsertString(0,_T("QCAP_INPUT_TYPE_COMPOSITE"));
	m_combol_video_input_1.InsertString(1,_T("QCAP_INPUT_TYPE_SVIDEO"));
	m_combol_video_input_1.InsertString(2,_T("QCAP_INPUT_TYPE_HDMI"));
	m_combol_video_input_1.InsertString(3,_T("QCAP_INPUT_TYPE_DVI_D"));
	m_combol_video_input_1.InsertString(4,_T("QCAP_INPUT_TYPE_COMPONENTS"));
	m_combol_video_input_1.InsertString(5,_T("QCAP_INPUT_TYPE_DVI_A"));
	m_combol_video_input_1.InsertString(6,_T("QCAP_INPUT_TYPE_SDI"));
	m_combol_video_input_1.InsertString(7,_T("QCAP_INPUT_TYPE_AUTO"));
	m_combol_video_input_1.SetCurSel(CH02_VideoInput_index);

	ULONG CH02_AudioInput_index =0;
	CH02_AudioInput_index=theApp.GetProfileInt("CH02_Setting","CH02_AudioInput", 0);
	m_combol_audio_input_1.InsertString(0,_T("QCAP_INPUT_TYPE_EMBEDDED_AUDIO"));
	m_combol_audio_input_1.InsertString(1,_T("QCAP_INPUT_TYPE_LINE_IN"));
	m_combol_audio_input_1.InsertString(2,_T("QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE"));
	m_combol_audio_input_1.InsertString(3,_T("QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN"));	
	m_combol_audio_input_1.SetCurSel(CH02_AudioInput_index);


	//Deinterlace Type List Menu
	ULONG CH02_Deinterlace_index =0;
	CH02_Deinterlace_index=theApp.GetProfileInt("CH02_Setting","CH02_DeinterlaceType", 0);
	m_combol_video_Deinterlace_Type_1.InsertString(0,_T("QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING"));
	m_combol_video_Deinterlace_Type_1.InsertString(1,_T("QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE"));
	m_combol_video_Deinterlace_Type_1.InsertString(2,_T("QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE"));
	m_combol_video_Deinterlace_Type_1.InsertString(3,_T("QCAP_SOFTWARE_DEINTERLACE_TYPE_NULL"));
	m_combol_video_Deinterlace_Type_1.SetCurSel( CH02_Deinterlace_index );


	//CH01 Video Record Proerty
	ULONG CH01_VideoRecord_EncoderType_index =0;
	CH01_VideoRecord_EncoderType_index=theApp.GetProfileInt("CH01_Video_Record_Setting","CH01_video_Record_EncoderType", 0);
	m_combol_video_Record_Property_EncoderType_0.InsertString(0,_T("QCAP_ENCODER_TYPE_SOFTWARE"));
	m_combol_video_Record_Property_EncoderType_0.InsertString(1,_T("QCAP_ENCODER_TYPE_HARDWARE"));
	m_combol_video_Record_Property_EncoderType_0.InsertString(2,_T("QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK"));
	m_combol_video_Record_Property_EncoderType_0.InsertString(3,_T("QCAP_ENCODER_TYPE_NVIDIA_CUDA"));
	m_combol_video_Record_Property_EncoderType_0.SetCurSel(CH01_VideoRecord_EncoderType_index);


	ULONG CH01_VideoRecord_EncoderFormat_index =0;
	CH01_VideoRecord_EncoderFormat_index=theApp.GetProfileInt("CH01_Video_Record_Setting","CH01_video_Record_EncoderFormat", 0);
	m_combol_video_Record_Property_EncoderFormat_0.InsertString(0,_T("QCAP_ENCODER_FORMAT_H264"));
	m_combol_video_Record_Property_EncoderFormat_0.SetCurSel(CH01_VideoRecord_EncoderFormat_index);

	
	ULONG CH01_VideoRecord_Profile_index =0;
	CH01_VideoRecord_Profile_index=theApp.GetProfileInt("CH01_Video_Record_Setting","CH01_video_Record_Profile", 0);
	m_combol_video_Record_Property_RecordProfile_0.InsertString(0,_T("QCAP_RECORD_PROFILE_BASELINE"));
	m_combol_video_Record_Property_RecordProfile_0.InsertString(1,_T("QCAP_RECORD_PROFILE_MAIN"));
	m_combol_video_Record_Property_RecordProfile_0.InsertString(2,_T("QCAP_RECORD_PROFILE_HIGH"));
	m_combol_video_Record_Property_RecordProfile_0.SetCurSel(CH01_VideoRecord_Profile_index);


	ULONG CH01_VideoRecord_Level_index =0;
	CH01_VideoRecord_Level_index=theApp.GetProfileInt("CH01_Video_Record_Setting","CH01_video_Record_Level", 0);
	m_combol_video_Record_Property_RecordLevel_0.InsertString(0,_T("QCAP_RECORD_LEVEL_1"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(1,_T("QCAP_RECORD_LEVEL_1B"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(2,_T("QCAP_RECORD_LEVEL_11"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(3,_T("QCAP_RECORD_LEVEL_12"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(4,_T("QCAP_RECORD_LEVEL_13"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(5,_T("QCAP_RECORD_LEVEL_2"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(6,_T("QCAP_RECORD_LEVEL_21"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(7,_T("QCAP_RECORD_LEVEL_22"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(8,_T("QCAP_RECORD_LEVEL_3"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(9,_T("QCAP_RECORD_LEVEL_31"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(10,_T("QCAP_RECORD_LEVEL_32"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(11,_T("QCAP_RECORD_LEVEL_4"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(12,_T("QCAP_RECORD_LEVEL_41"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(13,_T("QCAP_RECORD_LEVEL_42"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(14,_T("QCAP_RECORD_LEVEL_50"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(15,_T("QCAP_RECORD_LEVEL_51"));
	m_combol_video_Record_Property_RecordLevel_0.InsertString(16,_T("QCAP_RECORD_LEVEL_52"));
	m_combol_video_Record_Property_RecordLevel_0.SetCurSel(CH01_VideoRecord_Level_index);


	ULONG CH01_VideoRecord_Entropy_index =0;
	CH01_VideoRecord_Entropy_index=theApp.GetProfileInt("CH01_Video_Record_Setting","CH01_video_Record_Entropy", 0);
	m_combol_video_Record_Property_RecordEntropy_0.InsertString(0,_T("QCAP_RECORD_ENTROPY_CAVLC"));
	m_combol_video_Record_Property_RecordEntropy_0.InsertString(1,_T("QCAP_RECORD_ENTROPY_CABAC"));
	m_combol_video_Record_Property_RecordEntropy_0.SetCurSel(CH01_VideoRecord_Entropy_index);


	ULONG CH01_VideoRecord_Complexity_index =0;
	CH01_VideoRecord_Complexity_index=theApp.GetProfileInt("CH01_Video_Record_Setting","CH01_video_Record_Complexity", 0);
	m_combol_video_Record_Property_RecordComplexity_0.InsertString(0,_T("QCAP_RECORD_COMPLEXITY_0"));
	m_combol_video_Record_Property_RecordComplexity_0.InsertString(1,_T("QCAP_RECORD_COMPLEXITY_1"));
	m_combol_video_Record_Property_RecordComplexity_0.InsertString(2,_T("QCAP_RECORD_COMPLEXITY_2"));
	m_combol_video_Record_Property_RecordComplexity_0.InsertString(3,_T("QCAP_RECORD_COMPLEXITY_3"));
	m_combol_video_Record_Property_RecordComplexity_0.InsertString(4,_T("QCAP_RECORD_COMPLEXITY_4"));
	m_combol_video_Record_Property_RecordComplexity_0.InsertString(5,_T("QCAP_RECORD_COMPLEXITY_5"));
	m_combol_video_Record_Property_RecordComplexity_0.InsertString(6,_T("QCAP_RECORD_COMPLEXITY_6"));
	m_combol_video_Record_Property_RecordComplexity_0.SetCurSel(CH01_VideoRecord_Complexity_index);


	ULONG CH01_VideoRecord_MODE_index =0;
	CH01_VideoRecord_MODE_index=theApp.GetProfileInt("CH01_Video_Record_Setting","CH01_video_Record_MODE", 0);
	m_combol_video_Record_Property_RecordMode_0.InsertString(0,_T("QCAP_RECORD_MODE_VBR"));
	m_combol_video_Record_Property_RecordMode_0.InsertString(1,_T("QCAP_RECORD_MODE_CBR"));
	m_combol_video_Record_Property_RecordMode_0.InsertString(2,_T("QCAP_RECORD_MODE_ABR"));
	m_combol_video_Record_Property_RecordMode_0.SetCurSel(CH01_VideoRecord_MODE_index);


	ULONG CH01_VideoRecord_Quality_index =0;
	CH01_VideoRecord_Quality_index=theApp.GetProfileInt("CH01_Video_Record_Setting","CH01_video_Record_Quality", 0);
	m_combol_video_Record_Property_Quality_0.InsertString(0,_T("QCAP_RECORD_QUALITY  1000"));
	m_combol_video_Record_Property_Quality_0.InsertString(1,_T("QCAP_RECORD_QUALITY  2000"));
	m_combol_video_Record_Property_Quality_0.InsertString(2,_T("QCAP_RECORD_QUALITY  3000"));
	m_combol_video_Record_Property_Quality_0.InsertString(3,_T("QCAP_RECORD_QUALITY  4000"));
	m_combol_video_Record_Property_Quality_0.InsertString(4,_T("QCAP_RECORD_QUALITY  5000"));
	m_combol_video_Record_Property_Quality_0.InsertString(5,_T("QCAP_RECORD_QUALITY  6000"));
	m_combol_video_Record_Property_Quality_0.InsertString(6,_T("QCAP_RECORD_QUALITY  7000"));
	m_combol_video_Record_Property_Quality_0.InsertString(7,_T("QCAP_RECORD_QUALITY  8000"));
	m_combol_video_Record_Property_Quality_0.InsertString(8,_T("QCAP_RECORD_QUALITY  9000"));
	m_combol_video_Record_Property_Quality_0.InsertString(9,_T("QCAP_RECORD_QUALITY  10000"));
	m_combol_video_Record_Property_Quality_0.SetCurSel(CH01_VideoRecord_Quality_index);


	ULONG CH01_VideoRecord_BitRate_index =0;
	CH01_VideoRecord_BitRate_index=theApp.GetProfileInt("CH01_Video_Record_Setting","CH01_video_Record_BitRate", 0);
	m_combol_video_Record_Property_BitRate_0.InsertString(0,_T("QCAP_RECORD_BITRATE 16MBPS"));
	m_combol_video_Record_Property_BitRate_0.InsertString(1,_T("QCAP_RECORD_BITRATE 12MBPS"));
	m_combol_video_Record_Property_BitRate_0.InsertString(2,_T("QCAP_RECORD_BITRATE 8MBPS"));
	m_combol_video_Record_Property_BitRate_0.InsertString(3,_T("QCAP_RECORD_BITRATE 6MBPS"));
	m_combol_video_Record_Property_BitRate_0.InsertString(4,_T("QCAP_RECORD_BITRATE 4MBPS"));
	m_combol_video_Record_Property_BitRate_0.InsertString(5,_T("QCAP_RECORD_BITRATE 2MBPS"));
	m_combol_video_Record_Property_BitRate_0.InsertString(6,_T("QCAP_RECORD_BITRATE 1MBPS"));
	m_combol_video_Record_Property_BitRate_0.InsertString(7,_T("QCAP_RECORD_BITRATE 512KBPS"));
	m_combol_video_Record_Property_BitRate_0.SetCurSel(CH01_VideoRecord_BitRate_index);


	//CH01 Auido Record Proerty
	ULONG CH01_AudioRecord_EncoderFormat_index =0;
	CH01_AudioRecord_EncoderFormat_index=theApp.GetProfileInt("CH01_Audio_Record_Setting","CH01_audio_Record_EncoderFormat", 0);
	m_combol_Audio_Record_Property_EncoderFormat_0.InsertString(0,_T("QCAP_ENCODER_FORMAT_PCM"));
	m_combol_Audio_Record_Property_EncoderFormat_0.InsertString(1,_T("QCAP_ENCODER_FORMAT_AAC"));
	m_combol_Audio_Record_Property_EncoderFormat_0.InsertString(2,_T("QCAP_ENCODER_FORMAT_AAC_ADTS"));
	m_combol_Audio_Record_Property_EncoderFormat_0.SetCurSel(CH01_AudioRecord_EncoderFormat_index);


	ULONG CH01_AudioRecord_EncoderType_index =0;
	CH01_AudioRecord_EncoderType_index=theApp.GetProfileInt("CH01_Audio_Record_Setting","CH01_audio_Record_EncoderType", 0);
	m_combol_Audio_Record_Property_EncoderType_0.InsertString(0,_T("QCAP_ENCODER_TYPE_SOFTWARE"));
	m_combol_Audio_Record_Property_EncoderType_0.SetCurSel(CH01_AudioRecord_EncoderType_index);


	//CH01 Start Record FilePathName
	ULONG CH01_Record_FilePathName_index =0;
	CH01_Record_FilePathName_index=theApp.GetProfileInt("CH01_Record_Setting","CH01_Record_FilePathName", 0);
	m_combol_Start_Record_FilePathName_0.InsertString(0,_T("AVI"));
	m_combol_Start_Record_FilePathName_0.InsertString(1,_T("MP4"));
	m_combol_Start_Record_FilePathName_0.InsertString(2,_T("ASF"));
	m_combol_Start_Record_FilePathName_0.InsertString(3,_T("FLV"));
	m_combol_Start_Record_FilePathName_0.InsertString(4,_T("TS"));
	m_combol_Start_Record_FilePathName_0.SetCurSel(CH01_Record_FilePathName_index);


	//CH01 Edit Record Property
	m_edit_Video_Record_Proerty_GOP_0.SetWindowText( "30" );
	m_edit_Video_Record_Proerty_BFrame_0.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_AspectRatio_X_0.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_AspectRatio_Y_0.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_CropX_0.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_CropY_0.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_CropW_0.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_CropH_0.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_DstW_0.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_DstH_0.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_Interleaved_0.SetWindowText( "0" );
	m_edit_Video_Record_Delay_Time_0.SetWindowText( "0" );
	m_edit_Audio_Record_Delay_Time_0.SetWindowText( "0" );


	//CH02 Video Record Proerty
	ULONG CH02_VideoRecord_EncoderType_index =0;
	CH02_VideoRecord_EncoderType_index=theApp.GetProfileInt("CH02_Video_Record_Setting","CH02_video_Record_EncoderType", 0);
	m_combol_video_Record_Property_EncoderType_1.InsertString(0,_T("QCAP_ENCODER_TYPE_SOFTWARE"));
	m_combol_video_Record_Property_EncoderType_1.InsertString(1,_T("QCAP_ENCODER_TYPE_HARDWARE"));
	m_combol_video_Record_Property_EncoderType_1.InsertString(2,_T("QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK"));
	m_combol_video_Record_Property_EncoderType_1.InsertString(3,_T("QCAP_ENCODER_TYPE_NVIDIA_CUDA"));
	m_combol_video_Record_Property_EncoderType_1.SetCurSel(CH02_VideoRecord_EncoderType_index);


	ULONG CH02_VideoRecord_EncoderFormat_index =0;
	CH02_VideoRecord_EncoderFormat_index=theApp.GetProfileInt("CH02_Video_Record_Setting","CH02_video_Record_EncoderFormat", 0);
	m_combol_video_Record_Property_EncoderFormat_1.InsertString(0,_T("QCAP_ENCODER_FORMAT_H264"));
	m_combol_video_Record_Property_EncoderFormat_1.SetCurSel(CH02_VideoRecord_EncoderFormat_index);


	ULONG CH02_VideoRecord_Profile_index =0;
	CH02_VideoRecord_Profile_index=theApp.GetProfileInt("CH02_Video_Record_Setting","CH02_video_Record_Profile", 0);
	m_combol_video_Record_Property_RecordProfile_1.InsertString(0,_T("QCAP_RECORD_PROFILE_BASELINE"));
	m_combol_video_Record_Property_RecordProfile_1.InsertString(1,_T("QCAP_RECORD_PROFILE_MAIN"));
	m_combol_video_Record_Property_RecordProfile_1.InsertString(2,_T("QCAP_RECORD_PROFILE_HIGH"));
	m_combol_video_Record_Property_RecordProfile_1.SetCurSel(CH02_VideoRecord_Profile_index);


	ULONG CH02_VideoRecord_Level_index =0;
	CH02_VideoRecord_Level_index=theApp.GetProfileInt("CH02_Video_Record_Setting","CH02_video_Record_Level", 0);
	m_combol_video_Record_Property_RecordLevel_1.InsertString(0,_T("QCAP_RECORD_LEVEL_1"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(1,_T("QCAP_RECORD_LEVEL_1B"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(2,_T("QCAP_RECORD_LEVEL_11"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(3,_T("QCAP_RECORD_LEVEL_12"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(4,_T("QCAP_RECORD_LEVEL_13"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(5,_T("QCAP_RECORD_LEVEL_2"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(6,_T("QCAP_RECORD_LEVEL_21"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(7,_T("QCAP_RECORD_LEVEL_22"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(8,_T("QCAP_RECORD_LEVEL_3"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(9,_T("QCAP_RECORD_LEVEL_31"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(10,_T("QCAP_RECORD_LEVEL_32"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(11,_T("QCAP_RECORD_LEVEL_4"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(12,_T("QCAP_RECORD_LEVEL_41"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(13,_T("QCAP_RECORD_LEVEL_42"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(14,_T("QCAP_RECORD_LEVEL_50"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(15,_T("QCAP_RECORD_LEVEL_51"));
	m_combol_video_Record_Property_RecordLevel_1.InsertString(16,_T("QCAP_RECORD_LEVEL_52"));
	m_combol_video_Record_Property_RecordLevel_1.SetCurSel(CH02_VideoRecord_Level_index);


	ULONG CH02_VideoRecord_Entropy_index =0;
	CH02_VideoRecord_Entropy_index=theApp.GetProfileInt("CH02_Video_Record_Setting","CH02_video_Record_Entropy", 0);
	m_combol_video_Record_Property_RecordEntropy_1.InsertString(0,_T("QCAP_RECORD_ENTROPY_CAVLC"));
	m_combol_video_Record_Property_RecordEntropy_1.InsertString(1,_T("QCAP_RECORD_ENTROPY_CABAC"));
	m_combol_video_Record_Property_RecordEntropy_1.SetCurSel(CH02_VideoRecord_Entropy_index);


	ULONG CH02_VideoRecord_Complexity_index =0;
	CH02_VideoRecord_Complexity_index=theApp.GetProfileInt("CH02_Video_Record_Setting","CH02_video_Record_Complexity", 0);
	m_combol_video_Record_Property_RecordComplexity_1.InsertString(0,_T("QCAP_RECORD_COMPLEXITY_0"));
	m_combol_video_Record_Property_RecordComplexity_1.InsertString(1,_T("QCAP_RECORD_COMPLEXITY_1"));
	m_combol_video_Record_Property_RecordComplexity_1.InsertString(2,_T("QCAP_RECORD_COMPLEXITY_2"));
	m_combol_video_Record_Property_RecordComplexity_1.InsertString(3,_T("QCAP_RECORD_COMPLEXITY_3"));
	m_combol_video_Record_Property_RecordComplexity_1.InsertString(4,_T("QCAP_RECORD_COMPLEXITY_4"));
	m_combol_video_Record_Property_RecordComplexity_1.InsertString(5,_T("QCAP_RECORD_COMPLEXITY_5"));
	m_combol_video_Record_Property_RecordComplexity_1.InsertString(6,_T("QCAP_RECORD_COMPLEXITY_6"));
	m_combol_video_Record_Property_RecordComplexity_1.SetCurSel(CH02_VideoRecord_Complexity_index);


	ULONG CH02_VideoRecord_MODE_index =0;
	CH02_VideoRecord_MODE_index=theApp.GetProfileInt("CH02_Video_Record_Setting","CH02_video_Record_MODE", 0);
	m_combol_video_Record_Property_RecordMode_1.InsertString(0,_T("QCAP_RECORD_MODE_VBR"));
	m_combol_video_Record_Property_RecordMode_1.InsertString(1,_T("QCAP_RECORD_MODE_CBR"));
	m_combol_video_Record_Property_RecordMode_1.InsertString(2,_T("QCAP_RECORD_MODE_ABR"));
	m_combol_video_Record_Property_RecordMode_1.SetCurSel(CH02_VideoRecord_MODE_index);


	ULONG CH02_VideoRecord_Quality_index =0;
	CH02_VideoRecord_Quality_index=theApp.GetProfileInt("CH02_Video_Record_Setting","CH02_video_Record_Quality", 0);
	m_combol_video_Record_Property_Quality_1.InsertString(0,_T("QCAP_RECORD_QUALITY  1000"));
	m_combol_video_Record_Property_Quality_1.InsertString(1,_T("QCAP_RECORD_QUALITY  2000"));
	m_combol_video_Record_Property_Quality_1.InsertString(2,_T("QCAP_RECORD_QUALITY  3000"));
	m_combol_video_Record_Property_Quality_1.InsertString(3,_T("QCAP_RECORD_QUALITY  4000"));
	m_combol_video_Record_Property_Quality_1.InsertString(4,_T("QCAP_RECORD_QUALITY  5000"));
	m_combol_video_Record_Property_Quality_1.InsertString(5,_T("QCAP_RECORD_QUALITY  6000"));
	m_combol_video_Record_Property_Quality_1.InsertString(6,_T("QCAP_RECORD_QUALITY  7000"));
	m_combol_video_Record_Property_Quality_1.InsertString(7,_T("QCAP_RECORD_QUALITY  8000"));
	m_combol_video_Record_Property_Quality_1.InsertString(8,_T("QCAP_RECORD_QUALITY  9000"));
	m_combol_video_Record_Property_Quality_1.InsertString(9,_T("QCAP_RECORD_QUALITY  10000"));
	m_combol_video_Record_Property_Quality_1.SetCurSel(CH02_VideoRecord_Quality_index);


	ULONG CH02_VideoRecord_BitRate_index =0;
	CH02_VideoRecord_BitRate_index=theApp.GetProfileInt("CH02_Video_Record_Setting","CH02_video_Record_BitRate", 0);
	m_combol_video_Record_Property_BitRate_1.InsertString(0,_T("QCAP_RECORD_BITRATE 16MBPS"));
	m_combol_video_Record_Property_BitRate_1.InsertString(1,_T("QCAP_RECORD_BITRATE 12MBPS"));
	m_combol_video_Record_Property_BitRate_1.InsertString(2,_T("QCAP_RECORD_BITRATE 8MBPS"));
	m_combol_video_Record_Property_BitRate_1.InsertString(3,_T("QCAP_RECORD_BITRATE 6MBPS"));
	m_combol_video_Record_Property_BitRate_1.InsertString(4,_T("QCAP_RECORD_BITRATE 4MBPS"));
	m_combol_video_Record_Property_BitRate_1.InsertString(5,_T("QCAP_RECORD_BITRATE 2MBPS"));
	m_combol_video_Record_Property_BitRate_1.InsertString(6,_T("QCAP_RECORD_BITRATE 1MBPS"));
	m_combol_video_Record_Property_BitRate_1.InsertString(7,_T("QCAP_RECORD_BITRATE 512KBPS"));
	m_combol_video_Record_Property_BitRate_1.SetCurSel(CH02_VideoRecord_BitRate_index);


	//CH02 Auido Record Proerty
	ULONG CH02_AudioRecord_EncoderFormat_index =0;
	CH02_AudioRecord_EncoderFormat_index=theApp.GetProfileInt("CH02_Audio_Record_Setting","CH02_audio_Record_EncoderFormat", 0);
	m_combol_Audio_Record_Property_EncoderFormat_1.InsertString(0,_T("QCAP_ENCODER_FORMAT_PCM"));
	m_combol_Audio_Record_Property_EncoderFormat_1.InsertString(1,_T("QCAP_ENCODER_FORMAT_AAC"));
	m_combol_Audio_Record_Property_EncoderFormat_1.InsertString(2,_T("QCAP_ENCODER_FORMAT_AAC_ADTS"));
	m_combol_Audio_Record_Property_EncoderFormat_1.SetCurSel(CH02_AudioRecord_EncoderFormat_index);


	ULONG CH02_AudioRecord_EncoderType_index =0;
	CH02_AudioRecord_EncoderType_index=theApp.GetProfileInt("CH02_Audio_Record_Setting","CH02_audio_Record_EncoderType", 0);
	m_combol_Audio_Record_Property_EncoderType_1.InsertString(0,_T("QCAP_ENCODER_TYPE_SOFTWARE"));
	m_combol_Audio_Record_Property_EncoderType_1.SetCurSel(CH02_AudioRecord_EncoderType_index);


	//CH02 Start Record FilePathName
	ULONG CH02_Record_FilePathName_index =0;
	CH02_Record_FilePathName_index=theApp.GetProfileInt("CH02_Record_Setting","CH02_Record_FilePathName", 0);
	m_combol_Start_Record_FilePathName_1.InsertString(0,_T("AVI"));
	m_combol_Start_Record_FilePathName_1.InsertString(1,_T("MP4"));
	m_combol_Start_Record_FilePathName_1.InsertString(2,_T("ASF"));
	m_combol_Start_Record_FilePathName_1.InsertString(3,_T("FLV"));
	m_combol_Start_Record_FilePathName_1.InsertString(4,_T("TS"));
	m_combol_Start_Record_FilePathName_1.SetCurSel(CH02_Record_FilePathName_index);


	//CH02 Edit Record Property
	m_edit_Video_Record_Proerty_GOP_1.SetWindowText( "30" );
	m_edit_Video_Record_Proerty_BFrame_1.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_AspectRatio_X_1.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_AspectRatio_Y_1.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_CropX_1.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_CropY_1.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_CropW_1.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_CropH_1.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_DstW_1.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_DstH_1.SetWindowText( "0" );
	m_edit_Video_Record_Proerty_Interleaved_1.SetWindowText( "0" );
	m_edit_Video_Record_Delay_Time_1.SetWindowText( "0" );
	m_edit_Audio_Record_Delay_Time_1.SetWindowText( "0" );

	//Share Record Vdieo PROPERTY
	ULONG Video_Share_Record_EncoderType_index =0;
	Video_Share_Record_EncoderType_index=theApp.GetProfileInt("Video_Share_Record_Setting","Video_Share_Record_EncoderType", 0);
	m_combol_video_Share_Record_Property_EncoderType.InsertString(0,_T("QCAP_ENCODER_TYPE_SOFTWARE"));
	m_combol_video_Share_Record_Property_EncoderType.InsertString(1,_T("QCAP_ENCODER_TYPE_HARDWARE"));
	m_combol_video_Share_Record_Property_EncoderType.InsertString(2,_T("QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK"));
	m_combol_video_Share_Record_Property_EncoderType.InsertString(3,_T("QCAP_ENCODER_TYPE_NVIDIA_CUDA"));
	m_combol_video_Share_Record_Property_EncoderType.SetCurSel(Video_Share_Record_EncoderType_index);


	ULONG Video_Share_Record_EncoderFormat_index =0;
	Video_Share_Record_EncoderFormat_index=theApp.GetProfileInt("Video_Share_Record_Setting","Video_Share_Record_EncoderFormat", 0);
	m_combol_video_Share_Record_Property_EncoderFormat.InsertString(0,_T("QCAP_ENCODER_FORMAT_H264"));
	m_combol_video_Share_Record_Property_EncoderFormat.SetCurSel(Video_Share_Record_EncoderFormat_index);


	ULONG Video_Share_Record_Profile_index =0;
	Video_Share_Record_Profile_index=theApp.GetProfileInt("Video_Share_Record_Setting","Video_Share_Record_Profile", 0);
	m_combol_video_Share_Record_Property_RecordProfile.InsertString(0,_T("QCAP_RECORD_PROFILE_BASELINE"));
	m_combol_video_Share_Record_Property_RecordProfile.InsertString(1,_T("QCAP_RECORD_PROFILE_MAIN"));
	m_combol_video_Share_Record_Property_RecordProfile.InsertString(2,_T("QCAP_RECORD_PROFILE_HIGH"));
	m_combol_video_Share_Record_Property_RecordProfile.SetCurSel(Video_Share_Record_Profile_index);


	ULONG Video_Share_Record_Level_index =0;
	Video_Share_Record_Level_index=theApp.GetProfileInt("Video_Share_Record_Setting","Video_Share_Record_Level", 0);
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(0,_T("QCAP_RECORD_LEVEL_1"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(1,_T("QCAP_RECORD_LEVEL_1B"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(2,_T("QCAP_RECORD_LEVEL_11"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(3,_T("QCAP_RECORD_LEVEL_12"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(4,_T("QCAP_RECORD_LEVEL_13"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(5,_T("QCAP_RECORD_LEVEL_2"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(6,_T("QCAP_RECORD_LEVEL_21"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(7,_T("QCAP_RECORD_LEVEL_22"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(8,_T("QCAP_RECORD_LEVEL_3"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(9,_T("QCAP_RECORD_LEVEL_31"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(10,_T("QCAP_RECORD_LEVEL_32"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(11,_T("QCAP_RECORD_LEVEL_4"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(12,_T("QCAP_RECORD_LEVEL_41"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(13,_T("QCAP_RECORD_LEVEL_42"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(14,_T("QCAP_RECORD_LEVEL_50"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(15,_T("QCAP_RECORD_LEVEL_51"));
	m_combol_video_Share_Record_Property_RecordLevel.InsertString(16,_T("QCAP_RECORD_LEVEL_52"));
	m_combol_video_Share_Record_Property_RecordLevel.SetCurSel(Video_Share_Record_Level_index);


	ULONG Video_Share_Record_Entropy_index =0;
	Video_Share_Record_Entropy_index=theApp.GetProfileInt("Video_Share_Record_Setting","Video_Share_Record_Entropy", 0);
	m_combol_video_Share_Record_Property_RecordEntropy.InsertString(0,_T("QCAP_RECORD_ENTROPY_CAVLC"));
	m_combol_video_Share_Record_Property_RecordEntropy.InsertString(1,_T("QCAP_RECORD_ENTROPY_CABAC"));
	m_combol_video_Share_Record_Property_RecordEntropy.SetCurSel(Video_Share_Record_Entropy_index);


	ULONG Video_Share_Record_Complexity_index =0;
	Video_Share_Record_Complexity_index=theApp.GetProfileInt("Video_Share_Record_Setting","Video_Share_Record_Complexity", 0);
	m_combol_video_Share_Record_Property_RecordComplexity.InsertString(0,_T("QCAP_RECORD_COMPLEXITY_0"));
	m_combol_video_Share_Record_Property_RecordComplexity.InsertString(1,_T("QCAP_RECORD_COMPLEXITY_1"));
	m_combol_video_Share_Record_Property_RecordComplexity.InsertString(2,_T("QCAP_RECORD_COMPLEXITY_2"));
	m_combol_video_Share_Record_Property_RecordComplexity.InsertString(3,_T("QCAP_RECORD_COMPLEXITY_3"));
	m_combol_video_Share_Record_Property_RecordComplexity.InsertString(4,_T("QCAP_RECORD_COMPLEXITY_4"));
	m_combol_video_Share_Record_Property_RecordComplexity.InsertString(5,_T("QCAP_RECORD_COMPLEXITY_5"));
	m_combol_video_Share_Record_Property_RecordComplexity.InsertString(6,_T("QCAP_RECORD_COMPLEXITY_6"));
	m_combol_video_Share_Record_Property_RecordComplexity.SetCurSel(Video_Share_Record_Complexity_index);


	ULONG Video_Share_Record_Mode_index =0;
	Video_Share_Record_Mode_index=theApp.GetProfileInt("Video_Share_Record_Setting","Video_Share_Record_Mode", 0);
	m_combol_video_Share_Record_Property_RecordMode.InsertString(0,_T("QCAP_RECORD_MODE_VBR"));
	m_combol_video_Share_Record_Property_RecordMode.InsertString(1,_T("QCAP_RECORD_MODE_CBR"));
	m_combol_video_Share_Record_Property_RecordMode.InsertString(2,_T("QCAP_RECORD_MODE_ABR"));
	m_combol_video_Share_Record_Property_RecordMode.SetCurSel(Video_Share_Record_Mode_index);


	ULONG Video_Share_Record_Quality_index =0;
	Video_Share_Record_Quality_index=theApp.GetProfileInt("Video_Share_Record_Setting","Video_Share_Record_Quality", 0);
	m_combol_video_Share_Record_Property_Quality.InsertString(0,_T("QCAP_RECORD_QUALITY  1000"));
	m_combol_video_Share_Record_Property_Quality.InsertString(1,_T("QCAP_RECORD_QUALITY  2000"));
	m_combol_video_Share_Record_Property_Quality.InsertString(2,_T("QCAP_RECORD_QUALITY  3000"));
	m_combol_video_Share_Record_Property_Quality.InsertString(3,_T("QCAP_RECORD_QUALITY  4000"));
	m_combol_video_Share_Record_Property_Quality.InsertString(4,_T("QCAP_RECORD_QUALITY  5000"));
	m_combol_video_Share_Record_Property_Quality.InsertString(5,_T("QCAP_RECORD_QUALITY  6000"));
	m_combol_video_Share_Record_Property_Quality.InsertString(6,_T("QCAP_RECORD_QUALITY  7000"));
	m_combol_video_Share_Record_Property_Quality.InsertString(7,_T("QCAP_RECORD_QUALITY  8000"));
	m_combol_video_Share_Record_Property_Quality.InsertString(8,_T("QCAP_RECORD_QUALITY  9000"));
	m_combol_video_Share_Record_Property_Quality.InsertString(9,_T("QCAP_RECORD_QUALITY  10000"));
	m_combol_video_Share_Record_Property_Quality.SetCurSel(Video_Share_Record_Quality_index);


	ULONG Video_Share_Record_BitRate_index =0;
	Video_Share_Record_BitRate_index=theApp.GetProfileInt("Video_Share_Record_Setting","Video_Share_Record_BitRate", 0);
	m_combol_video_Share_Record_Property_BitRate.InsertString(0,_T("QCAP_RECORD_BITRATE 16MBPS"));
	m_combol_video_Share_Record_Property_BitRate.InsertString(1,_T("QCAP_RECORD_BITRATE 12MBPS"));
	m_combol_video_Share_Record_Property_BitRate.InsertString(2,_T("QCAP_RECORD_BITRATE 8MBPS"));
	m_combol_video_Share_Record_Property_BitRate.InsertString(3,_T("QCAP_RECORD_BITRATE 6MBPS"));
	m_combol_video_Share_Record_Property_BitRate.InsertString(4,_T("QCAP_RECORD_BITRATE 4MBPS"));
	m_combol_video_Share_Record_Property_BitRate.InsertString(5,_T("QCAP_RECORD_BITRATE 2MBPS"));
	m_combol_video_Share_Record_Property_BitRate.InsertString(6,_T("QCAP_RECORD_BITRATE 1MBPS"));
	m_combol_video_Share_Record_Property_BitRate.InsertString(7,_T("QCAP_RECORD_BITRATE 512KBPS"));
	m_combol_video_Share_Record_Property_BitRate.SetCurSel(Video_Share_Record_BitRate_index);


	//Edit Share Record PROPERTY
	m_edit_Video_Share_Record_Proerty_AspectRatio_X.SetWindowText( "0" );
	m_edit_Video_Share_Record_Proerty_AspectRatio_Y.SetWindowText( "0" );
	m_edit_Video_Share_Record_Proerty_GOP.SetWindowText( "30" );
	m_edit_Video_Share_Record_Proerty_BFrame.SetWindowText( "0" );
	m_edit_Video_Share_Record_Proerty_Interleaved.SetWindowText( "0" );
	m_edit_Share_Record_Video_Delay_Time.SetWindowText( "0" );
	m_edit_Share_Record_Audio_Delay_Time.SetWindowText( "0" );

	//Share Record AUDIO PROPERTY
	ULONG Audio_Share_Record_EncoderType_index =0;
	Audio_Share_Record_EncoderType_index=theApp.GetProfileInt("Audio_Share_Record_Setting","Audio_Share_Record_BitRate", 0);
	m_combol_Audio_Share_Record_Property_EncoderType.InsertString(0,_T("QCAP_ENCODER_TYPE_SOFTWARE"));
	m_combol_Audio_Share_Record_Property_EncoderType.SetCurSel(Audio_Share_Record_EncoderType_index);


	ULONG Audio_Share_Record_EncoderFormat_index =0;
	Audio_Share_Record_EncoderFormat_index=theApp.GetProfileInt("Audio_Share_Record_Setting","Audio_Share_Record_EncoderFormat", 0);
	m_combol_Audio_Share_Record_Property_EncoderFormat.InsertString(0,_T("QCAP_ENCODER_FORMAT_PCM"));
	m_combol_Audio_Share_Record_Property_EncoderFormat.InsertString(1,_T("QCAP_ENCODER_FORMAT_AAC"));
	m_combol_Audio_Share_Record_Property_EncoderFormat.InsertString(2,_T("QCAP_ENCODER_FORMAT_AAC_ADTS"));
	m_combol_Audio_Share_Record_Property_EncoderFormat.SetCurSel(Audio_Share_Record_EncoderFormat_index);


	ULONG Share_Record_FilePathName_index =0;
	Share_Record_FilePathName_index=theApp.GetProfileInt("Share_Record_Setting","Share_Record_FilePathName", 0);
	m_combol_Share_Record_FilePathName.InsertString(0,_T("AVI"));
	m_combol_Share_Record_FilePathName.InsertString(1,_T("MP4"));
	m_combol_Share_Record_FilePathName.InsertString(2,_T("ASF"));
	m_combol_Share_Record_FilePathName.InsertString(3,_T("FLV"));
	m_combol_Share_Record_FilePathName.InsertString(4,_T("TS"));
	m_combol_Share_Record_FilePathName.SetCurSel(Share_Record_FilePathName_index);


	//CH01 Broadcast Server
	ULONG CH01_Video_Broadcast_Server_EncoderType_index =0;
	CH01_Video_Broadcast_Server_EncoderType_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_EncoderType", 0);
	m_combol_video_Broadcast_Server_Property_EncoderType_0.InsertString(0,_T("QCAP_ENCODER_TYPE_SOFTWARE"));
	m_combol_video_Broadcast_Server_Property_EncoderType_0.InsertString(1,_T("QCAP_ENCODER_TYPE_HARDWARE"));
	m_combol_video_Broadcast_Server_Property_EncoderType_0.InsertString(2,_T("QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK"));
	m_combol_video_Broadcast_Server_Property_EncoderType_0.InsertString(3,_T("QCAP_ENCODER_TYPE_NVIDIA_CUDA"));
	m_combol_video_Broadcast_Server_Property_EncoderType_0.SetCurSel(CH01_Video_Broadcast_Server_EncoderType_index);


	ULONG CH01_Video_Broadcast_Server_EncoderFormat_index =0;
	CH01_Video_Broadcast_Server_EncoderFormat_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_EncoderFormat", 0);
	m_combol_video_Broadcast_Server_Property_EncoderFormat_0.InsertString(0,_T("QCAP_ENCODER_FORMAT_H264"));
	m_combol_video_Broadcast_Server_Property_EncoderFormat_0.SetCurSel(CH01_Video_Broadcast_Server_EncoderFormat_index);


	ULONG CH01_Video_Broadcast_Server_Profile_index =0;
	CH01_Video_Broadcast_Server_Profile_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_Profile", 0);
	m_combol_video_Broadcast_Server_Property_RecordProfile_0.InsertString(0,_T("QCAP_RECORD_PROFILE_BASELINE"));
	m_combol_video_Broadcast_Server_Property_RecordProfile_0.InsertString(1,_T("QCAP_RECORD_PROFILE_MAIN"));
	m_combol_video_Broadcast_Server_Property_RecordProfile_0.InsertString(2,_T("QCAP_RECORD_PROFILE_HIGH"));
	m_combol_video_Broadcast_Server_Property_RecordProfile_0.SetCurSel(CH01_Video_Broadcast_Server_Profile_index);


	ULONG CH01_Video_Broadcast_Server_Level_index =0;
	CH01_Video_Broadcast_Server_Level_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_Level", 0);
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(0,_T("QCAP_RECORD_LEVEL_1"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(1,_T("QCAP_RECORD_LEVEL_1B"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(2,_T("QCAP_RECORD_LEVEL_11"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(3,_T("QCAP_RECORD_LEVEL_12"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(4,_T("QCAP_RECORD_LEVEL_13"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(5,_T("QCAP_RECORD_LEVEL_2"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(6,_T("QCAP_RECORD_LEVEL_21"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(7,_T("QCAP_RECORD_LEVEL_22"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(8,_T("QCAP_RECORD_LEVEL_3"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(9,_T("QCAP_RECORD_LEVEL_31"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(10,_T("QCAP_RECORD_LEVEL_32"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(11,_T("QCAP_RECORD_LEVEL_4"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(12,_T("QCAP_RECORD_LEVEL_41"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(13,_T("QCAP_RECORD_LEVEL_42"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(14,_T("QCAP_RECORD_LEVEL_50"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(15,_T("QCAP_RECORD_LEVEL_51"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.InsertString(16,_T("QCAP_RECORD_LEVEL_52"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.SetCurSel(CH01_Video_Broadcast_Server_Level_index);


	ULONG CH01_Video_Broadcast_Server_Entropy_index =0;
	CH01_Video_Broadcast_Server_Entropy_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_Entropy", 0);
	m_combol_video_Broadcast_Server_Property_RecordEntropy_0.InsertString(0,_T("QCAP_RECORD_ENTROPY_CAVLC"));
	m_combol_video_Broadcast_Server_Property_RecordEntropy_0.InsertString(1,_T("QCAP_RECORD_ENTROPY_CABAC"));
	m_combol_video_Broadcast_Server_Property_RecordEntropy_0.SetCurSel(CH01_Video_Broadcast_Server_Entropy_index);


	ULONG CH01_Video_Broadcast_Server_Complexity_index =0;
	CH01_Video_Broadcast_Server_Complexity_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_Complexity", 0);
	m_combol_video_Broadcast_Server_Property_RecordComplexity_0.InsertString(0,_T("QCAP_RECORD_COMPLEXITY_0"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_0.InsertString(1,_T("QCAP_RECORD_COMPLEXITY_1"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_0.InsertString(2,_T("QCAP_RECORD_COMPLEXITY_2"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_0.InsertString(3,_T("QCAP_RECORD_COMPLEXITY_3"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_0.InsertString(4,_T("QCAP_RECORD_COMPLEXITY_4"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_0.InsertString(5,_T("QCAP_RECORD_COMPLEXITY_5"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_0.InsertString(6,_T("QCAP_RECORD_COMPLEXITY_6"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_0.SetCurSel(CH01_Video_Broadcast_Server_Complexity_index);


	ULONG CH01_Video_Broadcast_Server_RecordMode_index =0;
	CH01_Video_Broadcast_Server_RecordMode_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_RecordMode", 0);
	m_combol_video_Broadcast_Server_Property_RecordMode_0.InsertString(0,_T("QCAP_RECORD_MODE_VBR"));
	m_combol_video_Broadcast_Server_Property_RecordMode_0.InsertString(1,_T("QCAP_RECORD_MODE_CBR"));
	m_combol_video_Broadcast_Server_Property_RecordMode_0.InsertString(2,_T("QCAP_RECORD_MODE_ABR"));
	m_combol_video_Broadcast_Server_Property_RecordMode_0.SetCurSel(CH01_Video_Broadcast_Server_RecordMode_index);


	ULONG CH01_Video_Broadcast_Server_Mode_index =0;
	CH01_Video_Broadcast_Server_Mode_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_Mode", 0);
	m_combol_video_Broadcast_Server_Property_Quality_0.InsertString(0,_T("QCAP_RECORD_QUALITY  1000"));
	m_combol_video_Broadcast_Server_Property_Quality_0.InsertString(1,_T("QCAP_RECORD_QUALITY  2000"));
	m_combol_video_Broadcast_Server_Property_Quality_0.InsertString(2,_T("QCAP_RECORD_QUALITY  3000"));
	m_combol_video_Broadcast_Server_Property_Quality_0.InsertString(3,_T("QCAP_RECORD_QUALITY  4000"));
	m_combol_video_Broadcast_Server_Property_Quality_0.InsertString(4,_T("QCAP_RECORD_QUALITY  5000"));
	m_combol_video_Broadcast_Server_Property_Quality_0.InsertString(5,_T("QCAP_RECORD_QUALITY  6000"));
	m_combol_video_Broadcast_Server_Property_Quality_0.InsertString(6,_T("QCAP_RECORD_QUALITY  7000"));
	m_combol_video_Broadcast_Server_Property_Quality_0.InsertString(7,_T("QCAP_RECORD_QUALITY  8000"));
	m_combol_video_Broadcast_Server_Property_Quality_0.InsertString(8,_T("QCAP_RECORD_QUALITY  9000"));
	m_combol_video_Broadcast_Server_Property_Quality_0.InsertString(9,_T("QCAP_RECORD_QUALITY  10000"));
	m_combol_video_Broadcast_Server_Property_Quality_0.SetCurSel(CH01_Video_Broadcast_Server_Mode_index);


	ULONG CH01_Video_Broadcast_Server_BitRate_index =0;
	CH01_Video_Broadcast_Server_BitRate_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_BitRate", 0);
	m_combol_video_Broadcast_Server_Property_BitRate_0.InsertString(0,_T("QCAP_RECORD_BITRATE 16MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_0.InsertString(1,_T("QCAP_RECORD_BITRATE 12MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_0.InsertString(2,_T("QCAP_RECORD_BITRATE 8MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_0.InsertString(3,_T("QCAP_RECORD_BITRATE 6MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_0.InsertString(4,_T("QCAP_RECORD_BITRATE 4MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_0.InsertString(5,_T("QCAP_RECORD_BITRATE 2MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_0.InsertString(6,_T("QCAP_RECORD_BITRATE 1MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_0.InsertString(7,_T("QCAP_RECORD_BITRATE 512KBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_0.SetCurSel(CH01_Video_Broadcast_Server_BitRate_index);


	//CH01 Edit Broadcast Server PROPERTY
	m_edit_Video_Broadcast_Server_Proerty_GOP_0.SetWindowText( "30" );
	m_edit_Video_Broadcast_Server_Proerty_BFrame_0.SetWindowText( "0" );
	m_edit_Video_Broadcast_Server_Proerty_AspectRatio_X_0.SetWindowText( "0" );
	m_edit_Video_Broadcast_Server_Proerty_AspectRatio_Y_0.SetWindowText( "0" );
	m_edit_Video_Broadcast_Server_Proerty_Interleaved_0.SetWindowText( "0" );


	//CH01 AUDIO BROADCAST SERVER PROPERTY
	ULONG CH01_Broadcast_Server_EncoderType_index =0;
	CH01_Broadcast_Server_EncoderType_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH01_Broadcast_Server_EncoderType", 0);
	m_combol_Audio_Broadcast_Server_Property_EncoderType_0.InsertString(0,_T("QCAP_ENCODER_TYPE_SOFTWARE"));
	m_combol_Audio_Broadcast_Server_Property_EncoderType_0.SetCurSel(CH01_Broadcast_Server_EncoderType_index);


	ULONG CH01_Audio_Broadcast_Server_EncoderFormat_index =0;
	CH01_Audio_Broadcast_Server_EncoderFormat_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH01_Audio_Broadcast_Server_EncoderFormat", 0);
	m_combol_Audio_Broadcast_Server_Property_EncoderFormat_0.InsertString(0,_T("QCAP_ENCODER_FORMAT_PCM"));
	m_combol_Audio_Broadcast_Server_Property_EncoderFormat_0.InsertString(1,_T("QCAP_ENCODER_FORMAT_AAC"));
	m_combol_Audio_Broadcast_Server_Property_EncoderFormat_0.InsertString(2,_T("QCAP_ENCODER_FORMAT_AAC_ADTS"));
	m_combol_Audio_Broadcast_Server_Property_EncoderFormat_0.SetCurSel(CH01_Audio_Broadcast_Server_EncoderFormat_index);


	//CH01 Broadcast Server Type Select
	ULONG CH01_Broadcast_Server_Select_index =0;
	CH01_Broadcast_Server_Select_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH01_Broadcast_Server_Select", 0);
	m_combol_Broadcast_Server_Type_Select_0.InsertString(0,_T("RTSP SERVER"));
	m_combol_Broadcast_Server_Type_Select_0.InsertString(1,_T("RTMP SERVER"));
	m_combol_Broadcast_Server_Type_Select_0.InsertString(2,_T("RTMP WEB PORTAL SERVER"));
	m_combol_Broadcast_Server_Type_Select_0.InsertString(3,_T("HLS SERVER"));
	m_combol_Broadcast_Server_Type_Select_0.SetCurSel(CH01_Broadcast_Server_Select_index);


	m_edit_URL_ADDRESS_0.SetWindowText( "rtmp://127.0.0.1/live/session0.mpg" );


	//CH02 Broadcast Server
	ULONG CH02_Video_Broadcast_Server_EncoderType_index =0;
	CH02_Video_Broadcast_Server_EncoderType_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_EncoderType", 0);
	m_combol_video_Broadcast_Server_Property_EncoderType_1.InsertString(0,_T("QCAP_ENCODER_TYPE_SOFTWARE"));
	m_combol_video_Broadcast_Server_Property_EncoderType_1.InsertString(1,_T("QCAP_ENCODER_TYPE_HARDWARE"));
	m_combol_video_Broadcast_Server_Property_EncoderType_1.InsertString(2,_T("QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK"));
	m_combol_video_Broadcast_Server_Property_EncoderType_1.InsertString(3,_T("QCAP_ENCODER_TYPE_NVIDIA_CUDA"));
	m_combol_video_Broadcast_Server_Property_EncoderType_1.SetCurSel(CH02_Video_Broadcast_Server_EncoderType_index);


	ULONG CH02_Video_Broadcast_Server_EncoderFormat_index =0;
	CH02_Video_Broadcast_Server_EncoderFormat_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_EncoderFormat", 0);
	m_combol_video_Broadcast_Server_Property_EncoderFormat_1.InsertString(0,_T("QCAP_ENCODER_FORMAT_H264"));
	m_combol_video_Broadcast_Server_Property_EncoderFormat_1.SetCurSel(CH02_Video_Broadcast_Server_EncoderFormat_index);


	ULONG CH02_Video_Broadcast_Server_Profile_index =0;
	CH02_Video_Broadcast_Server_Profile_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_Profile", 0);
	m_combol_video_Broadcast_Server_Property_RecordProfile_1.InsertString(0,_T("QCAP_RECORD_PROFILE_BASELINE"));
	m_combol_video_Broadcast_Server_Property_RecordProfile_1.InsertString(1,_T("QCAP_RECORD_PROFILE_MAIN"));
	m_combol_video_Broadcast_Server_Property_RecordProfile_1.InsertString(2,_T("QCAP_RECORD_PROFILE_HIGH"));
	m_combol_video_Broadcast_Server_Property_RecordProfile_1.SetCurSel(CH02_Video_Broadcast_Server_Profile_index);


	ULONG CH02_Video_Broadcast_Server_Level_index =0;
	CH02_Video_Broadcast_Server_Level_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_Level", 0);
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(0,_T("QCAP_RECORD_LEVEL_1"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(1,_T("QCAP_RECORD_LEVEL_1B"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(2,_T("QCAP_RECORD_LEVEL_11"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(3,_T("QCAP_RECORD_LEVEL_12"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(4,_T("QCAP_RECORD_LEVEL_13"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(5,_T("QCAP_RECORD_LEVEL_2"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(6,_T("QCAP_RECORD_LEVEL_21"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(7,_T("QCAP_RECORD_LEVEL_22"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(8,_T("QCAP_RECORD_LEVEL_3"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(9,_T("QCAP_RECORD_LEVEL_31"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(10,_T("QCAP_RECORD_LEVEL_32"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(11,_T("QCAP_RECORD_LEVEL_4"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(12,_T("QCAP_RECORD_LEVEL_41"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(13,_T("QCAP_RECORD_LEVEL_42"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(14,_T("QCAP_RECORD_LEVEL_50"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(15,_T("QCAP_RECORD_LEVEL_51"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.InsertString(16,_T("QCAP_RECORD_LEVEL_52"));
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.SetCurSel(CH02_Video_Broadcast_Server_Level_index);


	ULONG CH02_Video_Broadcast_Server_Entropy_index =0;
	CH02_Video_Broadcast_Server_Entropy_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_Entropy", 0);
	m_combol_video_Broadcast_Server_Property_RecordEntropy_1.InsertString(0,_T("QCAP_RECORD_ENTROPY_CAVLC"));
	m_combol_video_Broadcast_Server_Property_RecordEntropy_1.InsertString(1,_T("QCAP_RECORD_ENTROPY_CABAC"));
	m_combol_video_Broadcast_Server_Property_RecordEntropy_1.SetCurSel(CH02_Video_Broadcast_Server_Entropy_index);


	ULONG CH02_Video_Broadcast_Server_Complexity_index =0;
	CH02_Video_Broadcast_Server_Complexity_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_Complexity", 0);
	m_combol_video_Broadcast_Server_Property_RecordComplexity_1.InsertString(0,_T("QCAP_RECORD_COMPLEXITY_0"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_1.InsertString(1,_T("QCAP_RECORD_COMPLEXITY_1"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_1.InsertString(2,_T("QCAP_RECORD_COMPLEXITY_2"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_1.InsertString(3,_T("QCAP_RECORD_COMPLEXITY_3"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_1.InsertString(4,_T("QCAP_RECORD_COMPLEXITY_4"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_1.InsertString(5,_T("QCAP_RECORD_COMPLEXITY_5"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_1.InsertString(6,_T("QCAP_RECORD_COMPLEXITY_6"));
	m_combol_video_Broadcast_Server_Property_RecordComplexity_1.SetCurSel(CH02_Video_Broadcast_Server_Complexity_index);


	ULONG CH02_Video_Broadcast_Server_Mode_index =0;
	CH02_Video_Broadcast_Server_Mode_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_Mode", 0);
	m_combol_video_Broadcast_Server_Property_RecordMode_1.InsertString(0,_T("QCAP_RECORD_MODE_VBR"));
	m_combol_video_Broadcast_Server_Property_RecordMode_1.InsertString(1,_T("QCAP_RECORD_MODE_CBR"));
	m_combol_video_Broadcast_Server_Property_RecordMode_1.InsertString(2,_T("QCAP_RECORD_MODE_ABR"));
	m_combol_video_Broadcast_Server_Property_RecordMode_1.SetCurSel(CH02_Video_Broadcast_Server_Mode_index);


	ULONG CH02_Video_Broadcast_Server_Quality_index =0;
	CH02_Video_Broadcast_Server_Quality_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_Quality", 0);
	m_combol_video_Broadcast_Server_Property_Quality_1.InsertString(0,_T("QCAP_RECORD_QUALITY  1000"));
	m_combol_video_Broadcast_Server_Property_Quality_1.InsertString(1,_T("QCAP_RECORD_QUALITY  2000"));
	m_combol_video_Broadcast_Server_Property_Quality_1.InsertString(2,_T("QCAP_RECORD_QUALITY  3000"));
	m_combol_video_Broadcast_Server_Property_Quality_1.InsertString(3,_T("QCAP_RECORD_QUALITY  4000"));
	m_combol_video_Broadcast_Server_Property_Quality_1.InsertString(4,_T("QCAP_RECORD_QUALITY  5000"));
	m_combol_video_Broadcast_Server_Property_Quality_1.InsertString(5,_T("QCAP_RECORD_QUALITY  6000"));
	m_combol_video_Broadcast_Server_Property_Quality_1.InsertString(6,_T("QCAP_RECORD_QUALITY  7000"));
	m_combol_video_Broadcast_Server_Property_Quality_1.InsertString(7,_T("QCAP_RECORD_QUALITY  8000"));
	m_combol_video_Broadcast_Server_Property_Quality_1.InsertString(8,_T("QCAP_RECORD_QUALITY  9000"));
	m_combol_video_Broadcast_Server_Property_Quality_1.InsertString(9,_T("QCAP_RECORD_QUALITY  10000"));
	m_combol_video_Broadcast_Server_Property_Quality_1.SetCurSel(CH02_Video_Broadcast_Server_Quality_index);


	ULONG CH02_Video_Broadcast_Server_BitRate_index =0;
	CH02_Video_Broadcast_Server_BitRate_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_BitRate", 0);
	m_combol_video_Broadcast_Server_Property_BitRate_1.InsertString(0,_T("QCAP_RECORD_BITRATE 16MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_1.InsertString(1,_T("QCAP_RECORD_BITRATE 12MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_1.InsertString(2,_T("QCAP_RECORD_BITRATE 8MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_1.InsertString(3,_T("QCAP_RECORD_BITRATE 6MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_1.InsertString(4,_T("QCAP_RECORD_BITRATE 4MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_1.InsertString(5,_T("QCAP_RECORD_BITRATE 2MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_1.InsertString(6,_T("QCAP_RECORD_BITRATE 1MBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_1.InsertString(7,_T("QCAP_RECORD_BITRATE 512KBPS"));
	m_combol_video_Broadcast_Server_Property_BitRate_1.SetCurSel(CH02_Video_Broadcast_Server_BitRate_index);


	//CH01 Edit Broadcast Server PROPERTY
	m_edit_Video_Broadcast_Server_Proerty_GOP_1.SetWindowText( "30" );
	m_edit_Video_Broadcast_Server_Proerty_BFrame_1.SetWindowText( "0" );
	m_edit_Video_Broadcast_Server_Proerty_AspectRatio_X_1.SetWindowText( "0" );
	m_edit_Video_Broadcast_Server_Proerty_AspectRatio_Y_1.SetWindowText( "0" );
	m_edit_Video_Broadcast_Server_Proerty_Interleaved_1.SetWindowText( "0" );


	//CH01 AUDIO BROADCAST SERVER PROPERTY
	ULONG CH02_Audio_Broadcast_Server_EncoderType_index =0;
	CH02_Audio_Broadcast_Server_EncoderType_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH02_Audio_Broadcast_Server_EncoderType", 0);
	m_combol_Audio_Broadcast_Server_Property_EncoderType_1.InsertString(0,_T("QCAP_ENCODER_TYPE_SOFTWARE"));
	m_combol_Audio_Broadcast_Server_Property_EncoderType_1.SetCurSel(CH02_Audio_Broadcast_Server_EncoderType_index);


	ULONG CH02_Audio_Broadcast_Server_EncoderFormat_index =0;
	CH02_Audio_Broadcast_Server_EncoderFormat_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH02_Audio_Broadcast_Server_EncoderFormat", 0);
	m_combol_Audio_Broadcast_Server_Property_EncoderFormat_1.InsertString(0,_T("QCAP_ENCODER_FORMAT_PCM"));
	m_combol_Audio_Broadcast_Server_Property_EncoderFormat_1.InsertString(1,_T("QCAP_ENCODER_FORMAT_AAC"));
	m_combol_Audio_Broadcast_Server_Property_EncoderFormat_1.InsertString(2,_T("QCAP_ENCODER_FORMAT_AAC_ADTS"));
	m_combol_Audio_Broadcast_Server_Property_EncoderFormat_1.SetCurSel(CH02_Audio_Broadcast_Server_EncoderFormat_index);


	//CH01 Broadcast Server Type Select
	ULONG CH02_Broadcast_Server_Select_index =0;
	CH02_Broadcast_Server_Select_index=theApp.GetProfileInt("Broadcast_Server_Setting","CH02_Broadcast_Server_Select", 0);
	m_combol_Broadcast_Server_Type_Select_1.InsertString(0,_T("RTSP SERVER"));
	m_combol_Broadcast_Server_Type_Select_1.InsertString(1,_T("RTMP SERVER"));
	m_combol_Broadcast_Server_Type_Select_1.InsertString(2,_T("RTMP WEB PORTAL SERVER"));
	m_combol_Broadcast_Server_Type_Select_1.InsertString(3,_T("HLS SERVER"));
	m_combol_Broadcast_Server_Type_Select_1.SetCurSel(CH02_Broadcast_Server_Select_index);


	m_edit_URL_ADDRESS_1.SetWindowText( "rtmp://127.0.0.1/live/session1.mpg" );


	// INITIALIZE COM LIBRARY
	// 
	HRESULT hr = CoInitialize( NULL );

	// INITIALIZE DEVICE RESOURCE
	// 
	g_pAnimationFactoryDlg = this;

	m_bThumbDRAW_0 = FALSE;
	m_bThumbDRAW_1 = FALSE;
	m_bMaintain_Aspect_Ratio_0 = FALSE;
	m_bMaintain_Aspect_Ratio_1 = FALSE;

	m_bAudio_Display_0 = FALSE;
	m_bAudio_Display_1 = FALSE;

	m_bVideoPreviewCB_0 = FALSE;
	m_bVideoPreviewCB_1 = FALSE;
	m_bAudioPreviewCB_0 = FALSE;
	m_bAudioPreviewCB_1 = FALSE;

	Video_CB_Count_0 = 0;
	Video_CB_Count_1 = 0;
	Audio_CB_Count_0 = 0;
	Audio_CB_Count_1 = 0;

	//VIRTUAL CAMERA DISPLAY
	m_hCameraDevice = NULL;

	//OSD
	m_bOSDTEXT_VIRTUALCAMERA = FALSE;

	m_bOSDTEXT_FILEPLAY = FALSE;

	m_bOSDPICTURE_VIRTUALCAMERA = FALSE;

	m_bOSDPICTURE_FILEPLAY = FALSE;

	//FILE
	m_pFile = NULL;

	m_nFileVideoFormat = 0;

	m_nFileVideoWidth = 0;

	m_nFileVideoHeight = 0;

	m_dFileVideoFrameRate = 0;

	m_nFileAudioFormat = 0;

	m_nFileAudioChannels = 0;

	m_nFileAudioBitsPerSample = 0;

	m_nFileAudioSampleFrequency = 0;

	m_dFileTotalDuationTimes = 0;

	m_nFileTotalVideoFrames = 0;

	m_nFileTotalAudioFrames = 0;

	m_pVirtualCamera = NULL;
	
	m_brtmp_web = FALSE;

	m_pClip = NULL;

	m_iClipCurrentFrame = 0;

	m_nClipFrames = 0;

	m_nClipSprites = 0;

	m_nClipColorSpaceType = 0x00000000;

	m_nClipWidth = 0;

	m_nClipHeight = 0;

	m_nShareRecordActiveChannel = 0;

	m_nShareRecordState = 0x00000000;

	InitializeCriticalSection( &m_hShareRecordAccessCriticalSection );

	InitializeCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	InitializeCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	m_nNetworkServerStates[ 0 ] = 0x00000000;

	m_nNetworkServerStates[ 1 ] = 0x00000000;

	for( ULONG i = 0 ; i < 2 ; i++ ) {

		m_pDevices[ i ] = NULL;

		m_hNetworkServer[ i ] = NULL;

		m_hCloneCapDev[ i ] = NULL;

		//OSD
		m_bOSDTEXT[ i ] = FALSE;

		m_bOSDPICTURE[ i ] = FALSE;

		//FORMAT
		m_bNoSignal[ i ] = TRUE;

		strVideoInput[ i ][ MAX_PATH ] =  0 ;

		strAudioInput[ i ][ MAX_PATH ] =  0 ;

		strFrameType[ i ][ MAX_PATH ] =  0 ; 

		m_nDeviceVideoWidths[ i ] = 0;

		m_nDeviceVideoHeights[ i ] = 0;

		m_bDeviceVideoIsInterleaved[ i ] = FALSE;

		m_dDeviceVideoFrameRates[ i ] = 0;

		m_nDeviceAudioChannels[ i ] = 0;

		m_nDeviceAudioBitsPerSamples[ i ] = 0;

		m_nDeviceAudioSampleFrequencys[ i ] = 0;

		//SNAPSHOT FPS OUTPUT FORMAT MESSAGE
		//
		g_n_video_frame_number[ i ] = 0;

		g_d_video_start_sample_time[ i ] = 0;

		g_d_video_stop_sample_time[ i ] = 0;
	}

	RECT rect;
	GetClientRect(&rect);
	SetScrollRange(SB_HORZ,   0,  rect.right-rect.left,   TRUE);
	SetScrollRange(SB_VERT,   0,  rect.bottom-rect.top,   TRUE);

	
	// SET DEFAULT RECORD&SNAPSHOT PATH
	// 
	{	BYTE pData[ MAX_PATH ]; DWORD dwType = REG_SZ; DWORD dwData = MAX_PATH;

		HKEY hKey = NULL; RegOpenKey( HKEY_CURRENT_USER, "Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", &hKey );

		RegQueryValueEx( hKey, "Personal", NULL, &dwType, pData, &dwData );

		RegCloseKey( hKey );

		CHAR psz[ MAX_PATH ] = "";

		/*
		if ( strlen( (CHAR*)(pData) ) ) {

			m_strDefaultPath.Format( "%s", (CHAR*)(pData) );
		}
		else {
			m_strDefaultPath.Format( "%s", "" );
		}
			m_strRecordPath.Format( "%s\\", m_strDefaultPath );

		*/	CreateDirectory( m_strRecordPath, NULL );
			
	}
	m_strRecordFileName = "";

	// SET PAHT
	::GetModuleFileName( 0, m_strRecordPath.GetBufferSetLength( MAX_PATH + 1 ), MAX_PATH );
	
	m_strRecordPath.ReleaseBuffer();

	INT nPos;

	nPos = m_strRecordPath.ReverseFind('\\');

	// GET PATH
	m_strRecordPath = m_strRecordPath.Left( nPos );
	

	//SET INITIALIZE BUTTON
	//
	CheckDlgButton( IDC_CHECK_THUMB_DRAW_0, BST_CHECKED );
	CheckDlgButton( IDC_CHECK_THUMB_DRAW_1, BST_CHECKED );

	CheckDlgButton( IDC_CHECK_DISPLAY_AUDIO_0, BST_CHECKED );
	CheckDlgButton( IDC_CHECK_DISPLAY_AUDIO_1, BST_CHECKED );

	CheckDlgButton( IDC_CHECK_SHARE_RECORD_THUMB_DRAW, BST_CHECKED );
	CheckDlgButton( IDC_CHECK_VIRTUAL_CAMERA_THUMB_DRAW, BST_CHECKED );
	
	m_btnStartClone_0.EnableWindow( FALSE ); 
	m_btnStopClone_0.EnableWindow( FALSE ); 
	m_btnStartClone_1.EnableWindow( FALSE ); 
	m_btnStopClone_1.EnableWindow( FALSE ); 
	
	m_btnRecordStart_0.EnableWindow( FALSE ); 
	m_btnRecordStop_0.EnableWindow( FALSE ); 
	m_btnRecordStart_1.EnableWindow( FALSE ); 
	m_btnRecordStop_1.EnableWindow( FALSE ); 

	m_btnBroadcastServerStart_0.EnableWindow( FALSE ); 
	m_btnBroadcastServerStop_0.EnableWindow( FALSE ); 
	m_btnBroadcastServerStart_1.EnableWindow( FALSE ); 
	m_btnBroadcastServerStop_1.EnableWindow( FALSE ); 

	m_btnVirtualCameraStart.EnableWindow( FALSE ); 
	m_btnVirtualCameraStop.EnableWindow( FALSE ); 

	m_btnVirtualCameraStartDisplay.EnableWindow( FALSE ); 
	m_btnVirtualCameraStopDisplay.EnableWindow( FALSE ); 

	m_bOSDTEXT_0.EnableWindow( FALSE );
	m_bOSDPICT_0.EnableWindow( FALSE ); 
	m_bSNAPBMP_0.EnableWindow( FALSE ); 
	m_bSNAPJPG_0.EnableWindow( FALSE ); 
	m_bSNAPBMP_EX_0.EnableWindow( FALSE ); 
	m_bSNAPJPG_EX_0.EnableWindow( FALSE ); 

	m_bOSDTEXT_1.EnableWindow( FALSE );
	m_bOSDPICT_1.EnableWindow( FALSE ); 
	m_bSNAPBMP_1.EnableWindow( FALSE ); 
	m_bSNAPJPG_1.EnableWindow( FALSE ); 
	m_bSNAPBMP_EX_1.EnableWindow( FALSE ); 
	m_bSNAPJPG_EX_1.EnableWindow( FALSE ); 

	m_bOSDTEXT_VIRTUAL_CAMERA.EnableWindow( FALSE );
	m_bOSDPICT_VIRTUAL_CAMERA.EnableWindow( FALSE );
	m_bSNAPBMP_VIRTUAL_CAMERA.EnableWindow( FALSE );
	m_bSNAPJPG_VIRTUAL_CAMERA.EnableWindow( FALSE );
	m_bSNAPBMP_EX_VIRTUAL_CAMERA.EnableWindow( FALSE );
	m_bSNAPJPG_EX_VIRTUAL_CAMERA.EnableWindow( FALSE );

	m_bANALYSIS_FILE_PLAY.EnableWindow( FALSE );
	m_bOSDTEXT_FILE_PLAY.EnableWindow( FALSE );
	m_bOSDPICT_FILE_PLAY.EnableWindow( FALSE );
	m_bSNAPSHOT_FILE_PLAY.EnableWindow( FALSE );
	m_bSNAPJPG_FILE_PLAY.EnableWindow( FALSE );
	m_bSNAPBMP_EX_FILE_PLAY.EnableWindow( FALSE );
	m_bSNAPJPG_EX_FILE_PLAY.EnableWindow( FALSE );
	m_bSPEED_ADD_FILE_PLAY.EnableWindow( FALSE );
	m_bSPEED_REDUCE_FILE_PLAY.EnableWindow( FALSE );
	m_bPAUSE_FILE_PLAY.EnableWindow( FALSE );
	m_bSTOP_FILE_PLAY.EnableWindow( FALSE );
	m_bPLAY_FILE_PLAY.EnableWindow( FALSE );

return TRUE;  // return TRUE  unless you set the focus to a control
}

void CAnimationFactoryDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAnimationFactoryDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAnimationFactoryDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CAnimationFactoryDlg::OnOK() 
{
	// TODO: Add extra validation here
	
//	CDialog::OnOK();
}

void CAnimationFactoryDlg::OnCancel() 
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CAnimationFactoryDlg::OnVScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)        
{
 SCROLLINFO scrollInfo;          
 GetScrollInfo(SB_VERT,   &scrollInfo,   SIF_ALL);          
 switch   (nSBCode)          
 {          
  case   SB_LINEUP:              
   scrollInfo.nPos -= 1;              
   if   (scrollInfo.nPos   <   scrollInfo.nMin)              
   {                  
    scrollInfo.nPos =   scrollInfo.nMin;                  
    break;              
   }              
   SetScrollInfo(SB_VERT,   &scrollInfo,   SIF_ALL);              
   ScrollWindow(0,   1);              
   break;          
  case   SB_LINEDOWN:             
   scrollInfo.nPos += 1;              
   if   (scrollInfo.nPos   >   scrollInfo.nMax)              
   {                  
    scrollInfo.nPos =   scrollInfo.nMax;                  
    break;              
   }              
   SetScrollInfo(SB_VERT,   &scrollInfo,   SIF_ALL);              
   ScrollWindow(0,   -1);              
   break;          
  case   SB_TOP:              
   ScrollWindow(0,   (scrollInfo.nPos   -   scrollInfo.nMin)   *   1);              
   scrollInfo.nPos =   scrollInfo.nMin;              
   SetScrollInfo(SB_VERT,   &scrollInfo,   SIF_ALL);              
   break;          
  case   SB_BOTTOM:              
   ScrollWindow(0,   -(scrollInfo.nMax   -   scrollInfo.nPos)   *   1);              
   scrollInfo.nPos =   scrollInfo.nMax;              
   SetScrollInfo(SB_VERT,   &scrollInfo,   SIF_ALL);             
   break;          
  case   SB_PAGEUP:              
   scrollInfo.nPos -= 1;              
   if   (scrollInfo.nPos   <   scrollInfo.nMin)              
   {                 
    scrollInfo.nPos =   scrollInfo.nMin;                  
    break;              
   }              
   SetScrollInfo(SB_VERT,&scrollInfo,SIF_ALL);              
   ScrollWindow(0,   1   *   1);              
   break;          
  case   SB_PAGEDOWN:              
   scrollInfo.nPos += 1;              
   if   (scrollInfo.nPos   >   scrollInfo.nMax)              
   {                  
    scrollInfo.nPos =   scrollInfo.nMax;                  
    break;              
   }              
   SetScrollInfo(SB_VERT,   &scrollInfo,   SIF_ALL);              
   ScrollWindow(0,   -1   *   1);              
   break;          
  case   SB_ENDSCROLL:              
   break;          
  case   SB_THUMBPOSITION:              
   break;          
  case   SB_THUMBTRACK:
   
   char mstr[64]={0};
   sprintf(mstr,"nPos1:%d nPos1:%d/n",scrollInfo.nPos,nPos);
   OutputDebugString(mstr);  


   ScrollWindow(0,   (scrollInfo.nPos   -   nPos) );              
   scrollInfo.nPos =  nPos;
   SetScrollInfo(SB_VERT,   &scrollInfo,   SIF_ALL);              
   break;          
 }         
}

void CAnimationFactoryDlg::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar)        
{
 SCROLLINFO scrollInfo;          
 GetScrollInfo(SB_HORZ,   &scrollInfo,   SIF_ALL);          
 switch   (nSBCode)          
 {          
  case   SB_LINEUP:              
   scrollInfo.nPos -= 1;              
   if   (scrollInfo.nPos   <   scrollInfo.nMin)              
   {                  
    scrollInfo.nPos =   scrollInfo.nMin;                  
    break;              
   }              
   SetScrollInfo(SB_HORZ,   &scrollInfo,   SIF_ALL);              
   ScrollWindow(10,   0);              
   break;          
  case   SB_LINEDOWN:             
   scrollInfo.nPos += 1;              
   if   (scrollInfo.nPos   >   scrollInfo.nMax)              
   {                  
    scrollInfo.nPos =   scrollInfo.nMax;                  
    break;              
   }              
   SetScrollInfo(SB_HORZ,   &scrollInfo,   SIF_ALL);              
   ScrollWindow(-10,   0);              
   break;          
  case   SB_TOP:              
   ScrollWindow(  (scrollInfo.nPos   -   scrollInfo.nMin)   *   10,0);              
   scrollInfo.nPos =   scrollInfo.nMin;              
   SetScrollInfo(SB_HORZ,   &scrollInfo,   SIF_ALL);              
   break;          
  case   SB_BOTTOM:              
   ScrollWindow(  -(scrollInfo.nMax   -   scrollInfo.nPos)   *   10,0);              
   scrollInfo.nPos =   scrollInfo.nMax;              
   SetScrollInfo(SB_HORZ,   &scrollInfo,   SIF_ALL);             
   break;          
  case   SB_PAGEUP:              
   scrollInfo.nPos -= 5;              
   if   (scrollInfo.nPos   <   scrollInfo.nMin)              
   {                 
    scrollInfo.nPos =   scrollInfo.nMin;                  
    break;              
   }              
   SetScrollInfo(SB_HORZ,&scrollInfo,SIF_ALL);              
   ScrollWindow(  10   *   5,0);              
   break;          
  case   SB_PAGEDOWN:              
   scrollInfo.nPos += 5;              
   if   (scrollInfo.nPos   >   scrollInfo.nMax)              
   {                  
    scrollInfo.nPos =   scrollInfo.nMax;                  
    break;              
   }              
   SetScrollInfo(SB_HORZ,   &scrollInfo,   SIF_ALL);              
   ScrollWindow(   -10   *   5,0);              
   break;          
  case   SB_ENDSCROLL:              
   break;          
  case   SB_THUMBPOSITION:              
   break;          
  case   SB_THUMBTRACK:              
   ScrollWindow((scrollInfo.nPos   -   nPos)   *   10, 0  );              
   scrollInfo.nPos =   nPos;              
   SetScrollInfo(SB_HORZ,   &scrollInfo,   SIF_ALL);              
   break;          
 }
}

void CAnimationFactoryDlg::OnClickedChannelWindow( ULONG nChannel ) 
{
	SC_DEBUG( "OnClickedChannelWindow( %d )", nChannel );

	if( m_nShareRecordActiveChannel == nChannel ) return ;

	if( m_nDeviceVideoWidths[ nChannel ] == 0 ) return ; 

	if( m_nDeviceVideoHeights[ nChannel ] == 0 ) return ; 

	if( (g_pAnimationFactoryDlg->m_iClipCurrentFrame + 1) < (g_pAnimationFactoryDlg->m_nClipFrames) ) { return ; }

	QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClip, 0, m_pDevices[ m_nShareRecordActiveChannel ] );

	QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClip, 1, m_pDevices[ nChannel ] );

	QCAP_STOP_ANIMATION_CLIP( m_pClip );

	QCAP_START_ANIMATION_CLIP( m_pClip );

	Sleep( 30 ); // NEED WAIT SPRITE SOURCE TO BE UPDATED

	EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );

	m_iClipCurrentFrame = 0;

	m_nShareRecordActiveChannel = nChannel;

	LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );
}

void CAnimationFactoryDlg::OnClickedChannelWindow0() 
{
	// TODO: Add your control notification handler code here
	
	OnClickedChannelWindow( 0 );
}

void CAnimationFactoryDlg::OnClickedChannelWindow1() 
{
	// TODO: Add your control notification handler code here
	
	OnClickedChannelWindow( 1 );
}

void CAnimationFactoryDlg::OnTimer(UINT_PTR nIDEvent)
{
	// TODO: Add your message handler code here and/or call default
	if( nIDEvent == 0x00000001 ) {

		CString VideoCount_Set_0, VideoCount_Set_1, AudioCount_Set_0, AudioCount_Set_1, test_Set_0;

		for ( ULONG i = 0; i < 2; i++ ) {

			if ( m_bNoSignal[ i ] ) {

				if ( i == 0 ) { m_editDeviceFormatInformation_0.SetWindowText( _T("INFO :...") ); }
				if ( i == 1 ) { m_editDeviceFormatInformation_1.SetWindowText( _T("INFO :...") ); }
			}
			else {

				if ( i == 0 ) { 

					if ( m_bVideoPreviewCB_0 == TRUE && m_bAudioPreviewCB_0 == TRUE ) {
						VideoCount_Set_0.Format( "%d", Video_CB_Count_0 );
						AudioCount_Set_0.Format( "/ %d", Audio_CB_Count_0 );
						VideoCount_Set_0 = m_strFormatChangedOutput[ 0 ] + VideoCount_Set_0 + AudioCount_Set_0 ;
						m_editDeviceFormatInformation_0.SetWindowText( (LPCTSTR)VideoCount_Set_0 );
					}
					else if ( m_bVideoPreviewCB_0 == FALSE && m_bAudioPreviewCB_0 == FALSE )
					{
						m_editDeviceFormatInformation_0.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 0 ] );
						Video_CB_Count_0 = 0;
						Audio_CB_Count_0 = 0;
					}

					if ( m_bVideoPreviewCB_0 == TRUE && m_bAudioPreviewCB_0 == FALSE ) {
						VideoCount_Set_0.Format( "%d", Video_CB_Count_0 );
						VideoCount_Set_0 = m_strFormatChangedOutput[ 0 ] + VideoCount_Set_0;
						m_editDeviceFormatInformation_0.SetWindowText( (LPCTSTR)VideoCount_Set_0 );
					}
					else if ( m_bVideoPreviewCB_0 == FALSE && m_bAudioPreviewCB_0 == FALSE ) 
					{ 
						Video_CB_Count_0 = 0; }

					if ( m_bAudioPreviewCB_0 == TRUE && m_bVideoPreviewCB_0 == FALSE ) {
						AudioCount_Set_0.Format( "/ %d", Audio_CB_Count_0 );
						AudioCount_Set_0 = m_strFormatChangedOutput[ 0 ] + AudioCount_Set_0;
						m_editDeviceFormatInformation_0.SetWindowText( (LPCTSTR)AudioCount_Set_0 );
					}
					else if ( m_bAudioPreviewCB_0 == FALSE && m_bVideoPreviewCB_0 == FALSE ) 
					{ 
						Audio_CB_Count_0 = 0; }

				}
				if ( i == 1 ) { 
					//m_editDeviceFormatInformation_1.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 1 ] );

					if ( m_bVideoPreviewCB_1 == TRUE && m_bAudioPreviewCB_1 == TRUE ) {
						VideoCount_Set_1.Format( "%d", Video_CB_Count_1 );
						AudioCount_Set_1.Format( "/ %d", Audio_CB_Count_1 );
						VideoCount_Set_1 = m_strFormatChangedOutput[ 1 ] + VideoCount_Set_1 + AudioCount_Set_1;
						m_editDeviceFormatInformation_1.SetWindowText( (LPCTSTR)VideoCount_Set_1 );
					}
					else if ( m_bVideoPreviewCB_1 == FALSE && m_bAudioPreviewCB_1 == FALSE )
					{
						m_editDeviceFormatInformation_1.SetWindowText( (LPCTSTR)m_strFormatChangedOutput[ 1 ] );
						Video_CB_Count_1 = 0;
						Audio_CB_Count_1 = 0;
					}

					if ( m_bVideoPreviewCB_1 == TRUE && m_bAudioPreviewCB_1 == FALSE ) {
						VideoCount_Set_1.Format( "%d", Video_CB_Count_1 );
						VideoCount_Set_1 = m_strFormatChangedOutput[ 1 ] + VideoCount_Set_1;
						m_editDeviceFormatInformation_1.SetWindowText( (LPCTSTR)VideoCount_Set_1 );
					}
					else if ( m_bVideoPreviewCB_1 == FALSE && m_bAudioPreviewCB_1 == FALSE ) { Video_CB_Count_1 = 0; }

					if ( m_bAudioPreviewCB_1 == TRUE && m_bVideoPreviewCB_1 == FALSE ) {
						AudioCount_Set_1.Format( "/ %d", Audio_CB_Count_1 );
						AudioCount_Set_1 = m_strFormatChangedOutput[ 1 ] + AudioCount_Set_1;
						m_editDeviceFormatInformation_1.SetWindowText( (LPCTSTR)AudioCount_Set_1 );
					}
					else if ( m_bAudioPreviewCB_1 == FALSE && m_bVideoPreviewCB_1 == FALSE ) { Audio_CB_Count_1 = 0; }

				}
			}
		}
	}

	if( nIDEvent == 0x00000005 ) {

		if( m_pFile ) {

			double dSampleTime = 0;

			QCAP_GET_FILE_POSITION( m_pFile, &dSampleTime );

			m_progTimeBar.SetPos( (int)(100.0 * (dSampleTime / m_dFileTotalDuationTimes)) );
		}
	}

 CDialog::OnTimer(nIDEvent);
}

void CAnimationFactoryDlg::OnBnClickedButtonFormatSet0()
{
	// TODO: Add your control notification handler code here
	m_btnCreate_0.EnableWindow( FALSE ); 
	m_btnDestroy_0.EnableWindow( TRUE ); 

	m_bThumbDRAW_0 = m_checkThumbDRAW_0.GetCheck();
	m_bMaintain_Aspect_Ratio_0 = m_checkMaintain_Aspect_Ratio_0.GetCheck();

	//if  ( m_bThumbDRAW_0 && m_bMaintain_Aspect_Ratio_0 ) { QCAP_CREATE( "FH8735 PCI", 0, m_statChannelWindow0.m_hWnd, &m_pDevices[ 0 ], TRUE, TRUE ); }
	//else if ( m_bThumbDRAW_0 )						   { QCAP_CREATE( "FH8735 PCI", 0, m_statChannelWindow0.m_hWnd, &m_pDevices[ 0 ], TRUE, FALSE ); }
	//else if ( m_bMaintain_Aspect_Ratio_0 )			   { QCAP_CREATE( "FH8735 PCI", 0, m_statChannelWindow0.m_hWnd, &m_pDevices[ 0 ], FALSE, TRUE ); }
	//else												   { QCAP_CREATE( "FH8735 PCI", 0, m_statChannelWindow0.m_hWnd, &m_pDevices[ 0 ], FALSE, FALSE ); }

	if  ( m_bThumbDRAW_0 && m_bMaintain_Aspect_Ratio_0 ) { QCAP_CREATE( "SA7160 PCI", 0, m_statChannelWindow0.m_hWnd, &m_pDevices[ 0 ], TRUE, TRUE ); }
	else if ( m_bThumbDRAW_0 )							 { QCAP_CREATE( "SA7160 PCI", 0, m_statChannelWindow0.m_hWnd, &m_pDevices[ 0 ], TRUE, FALSE ); }
	else if ( m_bMaintain_Aspect_Ratio_0 )				 { QCAP_CREATE( "SA7160 PCI", 0, m_statChannelWindow0.m_hWnd, &m_pDevices[ 0 ], FALSE, TRUE ); }
	else												 { QCAP_CREATE( "SA7160 PCI", 0, m_statChannelWindow0.m_hWnd, &m_pDevices[ 0 ], FALSE, FALSE ); }

	// REGISTER FORMAT CHANGED CALLBACK FUNCTION
	// 
	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevices[ 0 ], on_format_changed_callback, (PVOID)(0) );

	// REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
	// 
    QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevices[ 0 ], on_no_signal_detected_callback, (PVOID)(0) );

	// REGISTER NO SIGNAL REMOVED CALLBACK FUNCTION
	// 
    QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevices[ 0 ], on_no_signal_removed_callback, (PVOID)(0) );

	// REGISTER VIDEO PREVIEW CALLBACK FUNCTION
	// 
	QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevices[ 0 ], on_video_preview_callback, (PVOID)(0) );

	// REGISTER AUDIO PREVIEW CALLBACK FUNCTION
	// 
    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevices[ 0 ], on_audio_preview_callback, (PVOID)(0) );

	QCAP_RUN( m_pDevices[ 0 ] );
	
	SetTimer( 0x00000001, 1000, NULL );

	CString nVideoDeinterlace_ch0, nVideoFormat_ch0, nAudioFormat_ch0;
	m_combol_video_Deinterlace_Type_0.GetWindowTextA( nVideoDeinterlace_ch0 );
	m_combol_video_input_0.GetWindowTextA( nVideoFormat_ch0 );
	m_combol_audio_input_0.GetWindowTextA( nAudioFormat_ch0 );

	//VIDEO DEINTERLACE TYPE
	//
	ULONG CH01_Deinterlace_index, CH01_VideoInput_index, CH01_AudioInput_index;
	BOOL m_nDeinteralcaeType = FALSE;

	if		( nVideoDeinterlace_ch0 ==  "QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING" )			{ QCAP_SET_VIDEO_DEINTERLACE_TYPE( m_pDevices[ 0 ], QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING ); CH01_Deinterlace_index = 0; }

	else if ( nVideoDeinterlace_ch0 ==  "QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE" )	{ QCAP_SET_VIDEO_DEINTERLACE_TYPE( m_pDevices[ 0 ], QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE ); CH01_Deinterlace_index = 1; }

	else if ( nVideoDeinterlace_ch0 ==  "QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE" )	{ QCAP_SET_VIDEO_DEINTERLACE_TYPE( m_pDevices[ 0 ], QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE ); CH01_Deinterlace_index = 2; }

	else if ( nVideoDeinterlace_ch0 ==  "QCAP_SOFTWARE_DEINTERLACE_TYPE_NULL" )				{ m_nDeinteralcaeType = TRUE; CH01_Deinterlace_index = 3; }

	if ( m_nDeinteralcaeType == TRUE ) { QCAP_SET_VIDEO_DEINTERLACE( m_pDevices[ 0 ], FALSE ); }
	else { QCAP_SET_VIDEO_DEINTERLACE( m_pDevices[ 0 ], TRUE ); }

	theApp.WriteProfileInt("CH01_Setting","CH01_DeinterlaceType", CH01_Deinterlace_index);


	//VIDEO FORMAT
	if		( nVideoFormat_ch0 ==  "QCAP_INPUT_TYPE_COMPOSITE" )		{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_COMPOSITE ); CH01_VideoInput_index = 0; }

	else if ( nVideoFormat_ch0 ==  "QCAP_INPUT_TYPE_SVIDEO" )			{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_SVIDEO ); CH01_VideoInput_index = 1; }

	else if ( nVideoFormat_ch0 ==  "QCAP_INPUT_TYPE_HDMI" )				{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_HDMI ); CH01_VideoInput_index = 2; }

	else if ( nVideoFormat_ch0 ==  "QCAP_INPUT_TYPE_DVI_D" )			{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_DVI_D ); CH01_VideoInput_index = 3; }

	else if ( nVideoFormat_ch0 ==  "QCAP_INPUT_TYPE_COMPONENTS" )		{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_COMPONENTS ); CH01_VideoInput_index = 4; }

	else if ( nVideoFormat_ch0 ==  "QCAP_INPUT_TYPE_DVI_A" )			{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_DVI_A ); CH01_VideoInput_index = 5; }

	else if ( nVideoFormat_ch0 ==  "QCAP_INPUT_TYPE_SDI" )				{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_SDI ); CH01_VideoInput_index = 6; }

	else if ( nVideoFormat_ch0 ==  "QCAP_INPUT_TYPE_AUTO" )				{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_AUTO ); CH01_VideoInput_index = 7; }

	theApp.WriteProfileInt("CH01_Setting","CH01_VideoInput", CH01_VideoInput_index);


	//AUDIO FORMAT
	if		( nAudioFormat_ch0 == "QCAP_INPUT_TYPE_EMBEDDED_AUDIO" )		 { QCAP_SET_AUDIO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO ); CH01_AudioInput_index = 0; }

	else if ( nAudioFormat_ch0 == "QCAP_INPUT_TYPE_LINE_IN" )				 { QCAP_SET_AUDIO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_LINE_IN ); CH01_AudioInput_index = 1; }

	else if ( nAudioFormat_ch0 == "QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE" )	 { QCAP_SET_AUDIO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE ); CH01_AudioInput_index = 2; }

	else if ( nAudioFormat_ch0 == "QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN" )		 { QCAP_SET_AUDIO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN ); CH01_AudioInput_index = 3; }

	theApp.WriteProfileInt("CH01_Setting","CH01_AudioInput", CH01_AudioInput_index);


	//Set Volume
	m_bAudio_Display_0 = m_check_Audio_Display_0.GetCheck();

	if ( m_bAudio_Display_0 ) { QCAP_SET_AUDIO_VOLUME( m_pDevices[ 0 ], 100 ); }
	else { 	QCAP_SET_AUDIO_VOLUME( m_pDevices[ 0 ], 0 ); }

	m_bOSDTEXT_0.EnableWindow( TRUE ); 
	m_bOSDPICT_0.EnableWindow( TRUE ); 
	m_bSNAPBMP_0.EnableWindow( TRUE ); 
	m_bSNAPJPG_0.EnableWindow( TRUE ); 
	m_bSNAPBMP_EX_0.EnableWindow( TRUE ); 
	m_bSNAPJPG_EX_0.EnableWindow( TRUE ); 

	m_btnStartClone_0.EnableWindow( TRUE ); 
	m_btnStopClone_0.EnableWindow( TRUE ); 
	m_btnRecordStart_0.EnableWindow( TRUE ); 
	m_btnRecordStop_0.EnableWindow( TRUE ); 
	m_btnBroadcastServerStart_0.EnableWindow( TRUE ); 
	m_btnBroadcastServerStop_0.EnableWindow( TRUE ); 
}

void CAnimationFactoryDlg::OnBnClickedButtonFormatDestroy0()
{
	// TODO: Add your control notification handler code here
	m_btnCreate_0.EnableWindow( TRUE ); 
	m_btnDestroy_0.EnableWindow( FALSE ); 

	if ( m_hCloneCapDev[ 0 ] != 0 ) {

		QCAP_STOP( m_hCloneCapDev[ 0 ] );

		QCAP_DESTROY( m_hCloneCapDev[ 0 ] );

		m_hCloneCapDev[ 0 ] = 0;
	}

	if ( m_pDevices[ 0 ] != 0 ) {

			QCAP_STOP( m_pDevices[ 0 ] );

			QCAP_DESTROY( m_pDevices[ 0 ] );

			m_pDevices[ 0 ] = NULL;
	}

	m_bVideoPreviewCB_0 = FALSE;
	m_bAudioPreviewCB_0 = FALSE;

	m_bOSDTEXT_0.EnableWindow( FALSE ); 
	m_bOSDPICT_0.EnableWindow( FALSE ); 
	m_bSNAPBMP_0.EnableWindow( FALSE ); 
	m_bSNAPJPG_0.EnableWindow( FALSE ); 
	m_bSNAPBMP_EX_0.EnableWindow( FALSE ); 
	m_bSNAPJPG_EX_0.EnableWindow( FALSE ); 

	m_btnStartClone_0.EnableWindow( FALSE ); 
	m_btnStopClone_0.EnableWindow( FALSE ); 
	m_btnRecordStart_0.EnableWindow( FALSE ); 
	m_btnRecordStop_0.EnableWindow( FALSE ); 
	m_btnBroadcastServerStart_0.EnableWindow( FALSE );  
	m_btnBroadcastServerStop_0.EnableWindow( FALSE ); 
}

void CAnimationFactoryDlg::OnCbnSelchangeComboVideoDeinterlaceType0()
{
	// TODO: Add your control notification handler code here

	ULONG CH01_Deinterlace_index;

	 if		 ( m_combol_video_Deinterlace_Type_0.GetCurSel() == 0 )	{ 

			 QCAP_SET_VIDEO_DEINTERLACE_TYPE( m_pDevices[ 0 ], QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING ); 

			 QCAP_SET_VIDEO_DEINTERLACE( m_pDevices[ 0 ], TRUE );

			  CH01_Deinterlace_index = 0;
	 }
	 else if ( m_combol_video_Deinterlace_Type_0.GetCurSel() == 1 )	{ 

			 QCAP_SET_VIDEO_DEINTERLACE_TYPE( m_pDevices[ 0 ], QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE );

			 QCAP_SET_VIDEO_DEINTERLACE( m_pDevices[ 0 ], TRUE );

			 CH01_Deinterlace_index = 1;
	 }
	 else if ( m_combol_video_Deinterlace_Type_0.GetCurSel() == 2 )	{ 
		 
		     QCAP_SET_VIDEO_DEINTERLACE_TYPE( m_pDevices[ 0 ], QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE ); 

		     QCAP_SET_VIDEO_DEINTERLACE( m_pDevices[ 0 ], TRUE );

			 CH01_Deinterlace_index = 2;
	 }
	 else if ( m_combol_video_Deinterlace_Type_0.GetCurSel() == 3 )	{ 
		 
		     QCAP_SET_VIDEO_DEINTERLACE( m_pDevices[ 0 ], FALSE );

			 CH01_Deinterlace_index = 3;
	 }

	theApp.WriteProfileInt("CH01_Setting","CH01_DeinterlaceType", CH01_Deinterlace_index);

}

void CAnimationFactoryDlg::OnCbnSelchangeComboVideoInput0()
{
	// TODO: Add your control notification handler code here

	ULONG CH01_VideoInput_index;

	if		( m_combol_video_input_0.GetCurSel() == 0 )	{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_COMPOSITE ); CH01_VideoInput_index = 0; }
	
	else if ( m_combol_video_input_0.GetCurSel() == 1 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_SVIDEO ); CH01_VideoInput_index = 1; }

	else if ( m_combol_video_input_0.GetCurSel() == 2 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_HDMI ); CH01_VideoInput_index = 2; }

	else if ( m_combol_video_input_0.GetCurSel() == 3 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_DVI_D ); CH01_VideoInput_index = 3; }

	else if ( m_combol_video_input_0.GetCurSel() == 4 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_COMPONENTS ); CH01_VideoInput_index = 4; }

	else if ( m_combol_video_input_0.GetCurSel() == 5 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_DVI_A ); CH01_VideoInput_index = 5; }

	else if ( m_combol_video_input_0.GetCurSel() == 6 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_SDI ); CH01_VideoInput_index = 6; }

	else if ( m_combol_video_input_0.GetCurSel() == 7 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_AUTO ); CH01_VideoInput_index = 7; }

	theApp.WriteProfileInt("CH01_Setting","CH01_VideoInput", CH01_VideoInput_index);
}

void CAnimationFactoryDlg::OnCbnSelchangeComboAudioInput0()
{
	// TODO: Add your control notification handler code here

	ULONG CH01_AudioInput_index;

	if ( m_combol_audio_input_0.GetCurSel() == 0 )		{ QCAP_SET_AUDIO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO ); CH01_AudioInput_index = 0; }
	
	else if ( m_combol_audio_input_0.GetCurSel() == 1 ) { QCAP_SET_AUDIO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_LINE_IN ); CH01_AudioInput_index = 1; }

	else if ( m_combol_audio_input_0.GetCurSel() == 2 ) { QCAP_SET_AUDIO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE ); CH01_AudioInput_index = 2; }

	else if ( m_combol_audio_input_0.GetCurSel() == 3 ) { QCAP_SET_AUDIO_INPUT( m_pDevices[ 0 ], QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN ); CH01_AudioInput_index = 3; }

	theApp.WriteProfileInt("CH01_Setting","CH01_AudioInput", CH01_AudioInput_index);
}

void CAnimationFactoryDlg::OnBnClickedCheckDisplayAudio0()
{
	// TODO: Add your control notification handler code here

	m_bAudio_Display_0 = m_check_Audio_Display_0.GetCheck();

	if ( m_bAudio_Display_0 ) { QCAP_SET_AUDIO_VOLUME( m_pDevices[ 0 ], 100 ); }
	else { 	QCAP_SET_AUDIO_VOLUME( m_pDevices[ 0 ], 0 ); }
}

void CAnimationFactoryDlg::OnBnClickedButtonFormatSet1()
{
	// TODO: Add your control notification handler code here
	m_btnCreate_1.EnableWindow( FALSE ); 
	m_btnDestroy_1.EnableWindow( TRUE ); 

	m_bThumbDRAW_1 = m_checkThumbDRAW_1.GetCheck();
	m_bMaintain_Aspect_Ratio_1 = m_checkMaintain_Aspect_Ratio_1.GetCheck();

	//if  ( m_bThumbDRAW_1 && m_bMaintain_Aspect_Ratio_1 ) { QCAP_CREATE( "FH8735 PCI", 1, m_statChannelWindow1.m_hWnd, &m_pDevices[ 1 ], TRUE, TRUE ); }
	//else if ( m_bThumbDRAW_1 )							 { QCAP_CREATE( "FH8735 PCI", 1, m_statChannelWindow1.m_hWnd, &m_pDevices[ 1 ], TRUE, FALSE ); }
	//else if ( m_bMaintain_Aspect_Ratio_1 )				 { QCAP_CREATE( "FH8735 PCI", 1, m_statChannelWindow1.m_hWnd, &m_pDevices[ 1 ], FALSE, TRUE ); }
	//else												 { QCAP_CREATE( "FH8735 PCI", 1, m_statChannelWindow1.m_hWnd, &m_pDevices[ 1 ], FALSE, FALSE ); }

	if  ( m_bThumbDRAW_1 && m_bMaintain_Aspect_Ratio_1 ) { QCAP_CREATE( "SA7160 PCI", 1, m_statChannelWindow1.m_hWnd, &m_pDevices[ 1 ], TRUE, TRUE ); }
	else if ( m_bThumbDRAW_1 )							 { QCAP_CREATE( "SA7160 PCI", 1, m_statChannelWindow1.m_hWnd, &m_pDevices[ 1 ], TRUE, FALSE ); }
	else if ( m_bMaintain_Aspect_Ratio_1 )				 { QCAP_CREATE( "SA7160 PCI", 1, m_statChannelWindow1.m_hWnd, &m_pDevices[ 1 ], FALSE, TRUE ); }
	else												 { QCAP_CREATE( "SA7160 PCI", 1, m_statChannelWindow1.m_hWnd, &m_pDevices[ 1 ], FALSE, FALSE ); }

	// REGISTER FORMAT CHANGED CALLBACK FUNCTION
	// 
	QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevices[ 1 ], on_format_changed_callback, (PVOID)(1) );

	// REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
	// 
    QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevices[ 1 ], on_no_signal_detected_callback, (PVOID)(1) );

	// REGISTER NO SIGNAL REMOVED CALLBACK FUNCTION
	// 
    QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevices[ 1 ], on_no_signal_removed_callback, (PVOID)(1) );

	// REGISTER VIDEO PREVIEW CALLBACK FUNCTION
	// 
	QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevices[ 1 ], on_video_preview_callback, (PVOID)(1) );

	// REGISTER AUDIO PREVIEW CALLBACK FUNCTION
	// 
    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevices[ 1 ], on_audio_preview_callback, (PVOID)(1) );

	QCAP_RUN( m_pDevices[ 1 ] );
	
	SetTimer( 0x00000001, 1000, NULL );

	CString nVideoDeinterlace_ch1, nVideoFormat_ch1, nAudioFormat_ch1;
	m_combol_video_Deinterlace_Type_1.GetWindowTextA( nVideoDeinterlace_ch1 );
	m_combol_video_input_1.GetWindowTextA( nVideoFormat_ch1 );
	m_combol_audio_input_1.GetWindowTextA( nAudioFormat_ch1 );

	//VIDEO DEINTERLACE TYPE
	//
	ULONG CH02_Deinterlace_index, CH02_VideoInput_index, CH02_AudioInput_index;
	BOOL m_nDeinteralcaeType = FALSE;

	if		( nVideoDeinterlace_ch1 ==  "QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING" )			{ QCAP_SET_VIDEO_DEINTERLACE_TYPE( m_pDevices[ 1 ], QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING ); CH02_Deinterlace_index = 0; }

	else if ( nVideoDeinterlace_ch1 ==  "QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE" )	{ QCAP_SET_VIDEO_DEINTERLACE_TYPE( m_pDevices[ 1 ], QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE ); CH02_Deinterlace_index = 1; }

	else if ( nVideoDeinterlace_ch1 ==  "QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE" )	{ QCAP_SET_VIDEO_DEINTERLACE_TYPE( m_pDevices[ 1 ], QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE ); CH02_Deinterlace_index = 2; }

	else if ( nVideoDeinterlace_ch1 ==  "QCAP_SOFTWARE_DEINTERLACE_TYPE_NULL" )				{ m_nDeinteralcaeType = TRUE; CH02_Deinterlace_index = 3; }

	if ( m_nDeinteralcaeType == TRUE ) { QCAP_SET_VIDEO_DEINTERLACE( m_pDevices[ 1 ], FALSE ); }
	else { QCAP_SET_VIDEO_DEINTERLACE( m_pDevices[ 1 ], TRUE ); }

	theApp.WriteProfileInt("CH02_Setting","CH02_DeinterlaceType", CH02_Deinterlace_index);


	//VIDEO FORMAT
	if		( nVideoFormat_ch1 ==  "QCAP_INPUT_TYPE_COMPOSITE" )		{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_COMPOSITE ); CH02_VideoInput_index = 0; }

	else if ( nVideoFormat_ch1 ==  "QCAP_INPUT_TYPE_SVIDEO" )			{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_SVIDEO ); CH02_VideoInput_index = 1; }

	else if ( nVideoFormat_ch1 ==  "QCAP_INPUT_TYPE_HDMI" )				{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_HDMI ); CH02_VideoInput_index = 2; }

	else if ( nVideoFormat_ch1 ==  "QCAP_INPUT_TYPE_DVI_D" )			{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_DVI_D ); CH02_VideoInput_index = 3; }

	else if ( nVideoFormat_ch1 ==  "QCAP_INPUT_TYPE_COMPONENTS" )		{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_COMPONENTS ); CH02_VideoInput_index = 4; }

	else if ( nVideoFormat_ch1 ==  "QCAP_INPUT_TYPE_DVI_A" )			{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_DVI_A ); CH02_VideoInput_index = 5; }

	else if ( nVideoFormat_ch1 ==  "QCAP_INPUT_TYPE_SDI" )				{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_SDI ); CH02_VideoInput_index = 6; }

	else if ( nVideoFormat_ch1 ==  "QCAP_INPUT_TYPE_AUTO" )				{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_AUTO ); CH02_VideoInput_index = 7; }

	theApp.WriteProfileInt("CH02_Setting","CH02_VideoInput", CH02_VideoInput_index);


	//AUDIO FORMAT
	if		( nAudioFormat_ch1 == "QCAP_INPUT_TYPE_EMBEDDED_AUDIO" )		{ QCAP_SET_AUDIO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO ); CH02_AudioInput_index = 0; }

	else if ( nAudioFormat_ch1 == "QCAP_INPUT_TYPE_LINE_IN" )				 { QCAP_SET_AUDIO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_LINE_IN ); CH02_AudioInput_index = 1; }

	else if ( nAudioFormat_ch1 == "QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE" )	 { QCAP_SET_AUDIO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE ); CH02_AudioInput_index = 2; }

	else if ( nAudioFormat_ch1 == "QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN" )		 { QCAP_SET_AUDIO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN ); CH02_AudioInput_index = 3; }

	theApp.WriteProfileInt("CH02_Setting","CH02_AudioInput", CH02_AudioInput_index);


	//Set Volume
	m_bAudio_Display_1 = m_check_Audio_Display_1.GetCheck();

	if ( m_bAudio_Display_1 ) { QCAP_SET_AUDIO_VOLUME( m_pDevices[ 1 ], 100 ); }
	else { 	QCAP_SET_AUDIO_VOLUME( m_pDevices[ 1 ], 0 ); }

	m_bOSDTEXT_1.EnableWindow( TRUE );
	m_bOSDPICT_1.EnableWindow( TRUE); 
	m_bSNAPBMP_1.EnableWindow( TRUE ); 
	m_bSNAPJPG_1.EnableWindow( TRUE ); 
	m_bSNAPBMP_EX_1.EnableWindow( TRUE ); 
	m_bSNAPJPG_EX_1.EnableWindow( TRUE ); 

	m_btnStartClone_1.EnableWindow( TRUE ); 
	m_btnStopClone_1.EnableWindow( TRUE ); 
	m_btnRecordStart_1.EnableWindow( TRUE ); 
	m_btnRecordStop_1.EnableWindow( TRUE ); 
	m_btnBroadcastServerStart_1.EnableWindow( TRUE ); 
	m_btnBroadcastServerStop_1.EnableWindow( TRUE );
}

void CAnimationFactoryDlg::OnBnClickedButtonFormatDestroy1()
{
	// TODO: Add your control notification handler code here
	m_btnCreate_1.EnableWindow( TRUE ); 
	m_btnDestroy_1.EnableWindow( FALSE );

	if ( m_hCloneCapDev[ 1 ] != 0 ) {

		QCAP_STOP( m_hCloneCapDev[ 1 ] );

		QCAP_DESTROY( m_hCloneCapDev[ 1 ] );

		m_hCloneCapDev[ 1 ] = 0;
	}

	if ( m_pDevices[ 1 ] != 0 ) {

			QCAP_STOP( m_pDevices[ 1 ] );

			QCAP_DESTROY( m_pDevices[ 1 ] );

			m_pDevices[ 1 ] = NULL;
	}

	m_bVideoPreviewCB_1 = FALSE;
	m_bAudioPreviewCB_1 = FALSE;

	m_bOSDTEXT_1.EnableWindow( FALSE );
	m_bOSDPICT_1.EnableWindow( FALSE); 
	m_bSNAPBMP_1.EnableWindow( FALSE ); 
	m_bSNAPJPG_1.EnableWindow( FALSE ); 
	m_bSNAPBMP_EX_1.EnableWindow( FALSE ); 
	m_bSNAPJPG_EX_1.EnableWindow( FALSE ); 

	m_btnStartClone_1.EnableWindow( FALSE ); 
	m_btnStopClone_1.EnableWindow( FALSE );
	m_btnRecordStart_1.EnableWindow( FALSE ); 
	m_btnRecordStop_1.EnableWindow( FALSE ); 
	m_btnBroadcastServerStart_1.EnableWindow( FALSE );  
	m_btnBroadcastServerStop_1.EnableWindow( FALSE ); 
}

void CAnimationFactoryDlg::OnCbnSelchangeComboVideoDeinterlaceType1()
{
	// TODO: Add your control notification handler code here

	ULONG CH02_Deinterlace_index;

	if		 ( m_combol_video_Deinterlace_Type_1.GetCurSel() == 0 )	{ 

			 QCAP_SET_VIDEO_DEINTERLACE_TYPE( m_pDevices[ 1 ], QCAP_SOFTWARE_DEINTERLACE_TYPE_BLENDING ); 

			 QCAP_SET_VIDEO_DEINTERLACE( m_pDevices[ 1 ], TRUE );

			 CH02_Deinterlace_index = 0;
	 }
	 else if ( m_combol_video_Deinterlace_Type_1.GetCurSel() == 1 )	{ 

			 QCAP_SET_VIDEO_DEINTERLACE_TYPE( m_pDevices[ 1 ], QCAP_SOFTWARE_DEINTERLACE_TYPE_MOTIONAD_APTIVE );

			 QCAP_SET_VIDEO_DEINTERLACE( m_pDevices[ 1 ], TRUE );

			 CH02_Deinterlace_index = 1;
	 }
	 else if ( m_combol_video_Deinterlace_Type_1.GetCurSel() == 2 )	{ 
		 
		     QCAP_SET_VIDEO_DEINTERLACE_TYPE( m_pDevices[ 1 ], QCAP_SOFTWARE_DEINTERLACE_TYPE_FILTER_TRIANGLE ); 

		     QCAP_SET_VIDEO_DEINTERLACE( m_pDevices[ 1 ], TRUE );

			 CH02_Deinterlace_index = 2;
	 }
	 else if ( m_combol_video_Deinterlace_Type_1.GetCurSel() == 3 )	{ 
		 
		     QCAP_SET_VIDEO_DEINTERLACE( m_pDevices[ 1 ], FALSE );

			 CH02_Deinterlace_index = 3;
	 }

	 theApp.WriteProfileInt("CH02_Setting","CH02_DeinterlaceType", CH02_Deinterlace_index);

}

void CAnimationFactoryDlg::OnCbnSelchangeComboVideoInput2()
{
	// TODO: Add your control notification handler code here

	ULONG CH02_VideoInput_index;

	if ( m_combol_video_input_1.GetCurSel() == 0 )		{ QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_COMPOSITE ); CH02_VideoInput_index = 0; }
	
	else if ( m_combol_video_input_1.GetCurSel() == 1 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_SVIDEO ); CH02_VideoInput_index = 1; }

	else if ( m_combol_video_input_1.GetCurSel() == 2 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_HDMI ); CH02_VideoInput_index = 2; }

	else if ( m_combol_video_input_1.GetCurSel() == 3 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_DVI_D ); CH02_VideoInput_index = 3; }

	else if ( m_combol_video_input_1.GetCurSel() == 4 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_COMPONENTS ); CH02_VideoInput_index = 4; }

	else if ( m_combol_video_input_1.GetCurSel() == 5 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_DVI_A ); CH02_VideoInput_index = 5; }

	else if ( m_combol_video_input_1.GetCurSel() == 6 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_SDI ); CH02_VideoInput_index = 6; }

	else if ( m_combol_video_input_1.GetCurSel() == 7 ) { QCAP_SET_VIDEO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_AUTO ); CH02_VideoInput_index = 7; }

	theApp.WriteProfileInt("CH02_Setting","CH02_VideoInput", CH02_VideoInput_index);
}

void CAnimationFactoryDlg::OnCbnSelchangeComboAudioInput2()
{
	// TODO: Add your control notification handler code here

	ULONG CH02_AudioInput_index;

	if ( m_combol_audio_input_1.GetCurSel() == 0 )		{ QCAP_SET_AUDIO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO ); CH02_AudioInput_index = 0; }
	
	else if ( m_combol_audio_input_1.GetCurSel() == 1 ) { QCAP_SET_AUDIO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_LINE_IN ); CH02_AudioInput_index = 1; }

	else if ( m_combol_audio_input_1.GetCurSel() == 2 ) { QCAP_SET_AUDIO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_SOUNDCARD_MICROPHONE ); CH02_AudioInput_index = 2; }

	else if ( m_combol_audio_input_1.GetCurSel() == 3 ) { QCAP_SET_AUDIO_INPUT( m_pDevices[ 1 ], QCAP_INPUT_TYPE_SOUNDCARD_LINE_IN ); CH02_AudioInput_index = 3; }

	theApp.WriteProfileInt("CH02_Setting","CH02_AudioInput", CH02_AudioInput_index);
}

void CAnimationFactoryDlg::OnBnClickedCheckDisplayAudio1()
{
	// TODO: Add your control notification handler code here

	//Set Volume
	m_bAudio_Display_1 = m_check_Audio_Display_1.GetCheck();

	if ( m_bAudio_Display_1 ) { QCAP_SET_AUDIO_VOLUME( m_pDevices[ 1 ], 100 ); }
	else { 	QCAP_SET_AUDIO_VOLUME( m_pDevices[ 1 ], 0 ); }
}

void CAnimationFactoryDlg::OnBnClickedButtonCreateClone0()
{
	// TODO: Add your control notification handler code here
	m_btnStartClone_0.EnableWindow( FALSE ); 
	m_btnStopClone_0.EnableWindow( TRUE ); 

	if ( m_pDevices[ 0 ] != 0 ) {

		if (m_bThumbDRAW_0 && m_bMaintain_Aspect_Ratio_0 ) { QCAP_CREATE_CLONE( m_pDevices[ 0 ], m_statShowCloneVideo_0.GetSafeHwnd(), &m_hCloneCapDev[ 0 ], TRUE, TRUE ); }

		else if (m_bThumbDRAW_0 ) { QCAP_CREATE_CLONE( m_pDevices[ 0 ], m_statShowCloneVideo_0.GetSafeHwnd(), &m_hCloneCapDev[ 0 ], TRUE, FALSE ); }

		else if ( m_bMaintain_Aspect_Ratio_0 ) { QCAP_CREATE_CLONE( m_pDevices[ 0 ], m_statShowCloneVideo_0.GetSafeHwnd(), &m_hCloneCapDev[ 0 ], FALSE, TRUE ); }

		else { QCAP_CREATE_CLONE( m_pDevices[ 0 ], m_statShowCloneVideo_0.GetSafeHwnd(), &m_hCloneCapDev[ 0 ], FALSE, FALSE ); }

		QCAP_RUN( m_hCloneCapDev[ 0 ] );

		QCAP_SET_AUDIO_VOLUME( m_hCloneCapDev[ 0 ], 0 );
	}
}

void CAnimationFactoryDlg::OnBnClickedButtonCreateDestroy0()
{
	// TODO: Add your control notification handler code here
	m_btnStartClone_0.EnableWindow( TRUE ); 
	m_btnStopClone_0.EnableWindow( FALSE ); 

	if ( m_hCloneCapDev[ 0 ] != 0 ) {

		QCAP_STOP( m_hCloneCapDev[ 0 ] );

		QCAP_DESTROY( m_hCloneCapDev[ 0 ] );

		m_hCloneCapDev[ 0 ] = 0;
	}
}

void CAnimationFactoryDlg::OnBnClickedButtonCreateClone1()
{
	// TODO: Add your control notification handler code here
	m_btnStartClone_1.EnableWindow( FALSE ); 
	m_btnStopClone_1.EnableWindow( TRUE ); 

	if ( m_pDevices[ 1 ] != 0 ) {

		if (m_bThumbDRAW_1 && m_bMaintain_Aspect_Ratio_1 ) { QCAP_CREATE_CLONE( m_pDevices[ 1 ], m_statShowCloneVideo_1.GetSafeHwnd(), &m_hCloneCapDev[ 1 ], TRUE, TRUE ); }

		else if (m_bThumbDRAW_1 ) { QCAP_CREATE_CLONE( m_pDevices[ 1 ], m_statShowCloneVideo_1.GetSafeHwnd(), &m_hCloneCapDev[ 1 ], TRUE, FALSE ); }

		else if ( m_bMaintain_Aspect_Ratio_1 ) { QCAP_CREATE_CLONE( m_pDevices[ 1 ], m_statShowCloneVideo_1.GetSafeHwnd(), &m_hCloneCapDev[ 1 ], FALSE, TRUE ); }

		else { QCAP_CREATE_CLONE( m_pDevices[ 1 ], m_statShowCloneVideo_1.GetSafeHwnd(), &m_hCloneCapDev[ 1 ], FALSE, FALSE ); }

		QCAP_RUN( m_hCloneCapDev[ 1 ] );

		QCAP_SET_AUDIO_VOLUME( m_hCloneCapDev[ 1 ], 0 );
	}
}

void CAnimationFactoryDlg::OnBnClickedButtonCreateDestroy1()
{
	// TODO: Add your control notification handler code here
	m_btnStartClone_1.EnableWindow( TRUE ); 
	m_btnStopClone_1.EnableWindow( FALSE ); 

	if ( m_hCloneCapDev[ 1 ] != 0 ) {

		QCAP_STOP( m_hCloneCapDev[ 1 ] );

		QCAP_DESTROY( m_hCloneCapDev[ 1 ] );

		m_hCloneCapDev[ 1 ] = 0;
	}
}

void CAnimationFactoryDlg::OnBnClickedButtonSnapshotBmp0()
{
	// TODO: Add your control notification handler code here

	double fps = 0.0;

	if( (g_d_video_stop_sample_time[ 0 ] - g_d_video_start_sample_time[ 0 ]) > 0 ) { 
					
		 fps = (g_n_video_frame_number[ 0 ]) / (g_d_video_stop_sample_time[ 0 ] - g_d_video_start_sample_time[ 0 ]);
	}

	if ( m_pDevices[ 0 ] != 0 ) {
	
		CString strFullPathName;

		CString m_strFormatPath ;

		CTime time = CTime::GetCurrentTime(); 

		CString timeformat(time.Format(CString("_%Y.%m.%d.%H.%M.%S")));

		m_strFormatPath.Format("\\%s_%d x %d%s_@%2.3fQCAP_FPS_@%fCal_FPS ",
			                   strVideoInput[0],
							   m_nDeviceVideoWidths[ 0 ], 
							   m_nDeviceVideoHeights[ 0 ], 
							   strFrameType[0], 
							   m_dDeviceVideoFrameRates[ 0 ],
							   fps );

		strFullPathName = m_strRecordPath + m_strFormatPath + timeformat + _T(".bmp");
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

        QCAP_SNAPSHOT_BMP( m_pDevices[ 0 ], psz );

		strFullPathName.ReleaseBuffer();
	}
}

void CAnimationFactoryDlg::OnBnClickedButtonSnapshotJpg0()
{
	// TODO: Add your control notification handler code here

	double fps = 0.0;

	if( (g_d_video_stop_sample_time[ 0 ] - g_d_video_start_sample_time[ 0 ]) > 0 ) { 
					
		 fps = (g_n_video_frame_number[ 0 ]) / (g_d_video_stop_sample_time[ 0 ] - g_d_video_start_sample_time[ 0 ]);
	}

	if ( m_pDevices[ 0 ] != 0 ) {
	
		CString strFullPathName;

		CString m_strFormatPath ;

		CTime time = CTime::GetCurrentTime(); 

		CString timeformat(time.Format(CString("_%Y.%m.%d.%H.%M.%S")));

		m_strFormatPath.Format("\\%s_%d x %d%s_@%2.3fQCAP_FPS_@%fCal_FPS ",
			                   strVideoInput[0],
							   m_nDeviceVideoWidths[ 0 ], 
							   m_nDeviceVideoHeights[ 0 ], 
							   strFrameType[0], 
							   m_dDeviceVideoFrameRates[ 0 ],
							   fps );

		strFullPathName = m_strRecordPath + m_strFormatPath + timeformat + _T(".JPG");
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

        QCAP_SNAPSHOT_JPG( m_pDevices[ 0 ], psz, 100 );

		strFullPathName.ReleaseBuffer();
	}
}

void CAnimationFactoryDlg::OnBnClickedButtonSnapshotBmpEx0()
{
	// TODO: Add your control notification handler code here

	ULONG CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH;
	//Cal Sanpshot Format
	//
	CAL_CropX = m_nDeviceVideoWidths[ 0 ] - ( m_nDeviceVideoWidths[ 0 ]-(m_nDeviceVideoWidths[ 0 ]/4) );
	CAL_CropY = m_nDeviceVideoHeights[ 0 ] - (m_nDeviceVideoHeights[ 0 ]-(m_nDeviceVideoHeights[ 0 ]/4) );
	CAL_CropW = m_nDeviceVideoWidths[ 0 ]/2;
	CAL_CropH = m_nDeviceVideoHeights[ 0 ]/2;
	CAL_DstW = m_nDeviceVideoWidths[ 0 ];
	CAL_DstH = m_nDeviceVideoHeights[ 0 ];

	double fps = 0.0;

	if( (g_d_video_stop_sample_time[ 0 ] - g_d_video_start_sample_time[ 0 ]) > 0 ) { 
					
		 fps = (g_n_video_frame_number[ 0 ]) / (g_d_video_stop_sample_time[ 0 ] - g_d_video_start_sample_time[ 0 ]);
	}

	if ( m_pDevices[ 0 ] != 0 ) {
	
		CString strFullPathName;

		CString m_strFormatPath ;

		CTime time = CTime::GetCurrentTime(); 

		CString timeformat(time.Format(CString("_%Y.%m.%d.%H.%M.%S")));

		m_strFormatPath.Format("\\%s_%d x %d%s_@%2.3fQCAP_FPS_@%fCal_FPS ",
			                   strVideoInput[0],
							   m_nDeviceVideoWidths[ 0 ], 
							   m_nDeviceVideoHeights[ 0 ], 
							   strFrameType[0], 
							   m_dDeviceVideoFrameRates[ 0 ],
							   fps );

		strFullPathName = m_strRecordPath + m_strFormatPath + timeformat + _T("_EX.bmp");
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

        QCAP_SNAPSHOT_BMP_EX( m_pDevices[ 0 ], psz, CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH );

		strFullPathName.ReleaseBuffer();
	}
}

void CAnimationFactoryDlg::OnBnClickedButtonSnapshotJpgEx0()
{
	// TODO: Add your control notification handler code here

	ULONG CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH;
	//Cal Sanpshot Format
	//
	CAL_CropX = m_nDeviceVideoWidths[ 0 ] - ( m_nDeviceVideoWidths[ 0 ]-(m_nDeviceVideoWidths[ 0 ]/4) );
	CAL_CropY = m_nDeviceVideoHeights[ 0 ] - (m_nDeviceVideoHeights[ 0 ]-(m_nDeviceVideoHeights[ 0 ]/4) );
	CAL_CropW = m_nDeviceVideoWidths[ 0 ]/2;
	CAL_CropH = m_nDeviceVideoHeights[ 0 ]/2;
	CAL_DstW = m_nDeviceVideoWidths[ 0 ];
	CAL_DstH = m_nDeviceVideoHeights[ 0 ];

	double fps = 0.0;

	if( (g_d_video_stop_sample_time[ 0 ] - g_d_video_start_sample_time[ 0 ]) > 0 ) { 
					
		 fps = (g_n_video_frame_number[ 0 ]) / (g_d_video_stop_sample_time[ 0 ] - g_d_video_start_sample_time[ 0 ]);
	}

	if ( m_pDevices[ 0 ] != 0 ) {
	
		CString strFullPathName;

		CString m_strFormatPath ;

		CTime time = CTime::GetCurrentTime(); 

		CString timeformat(time.Format(CString("_%Y.%m.%d.%H.%M.%S")));

		m_strFormatPath.Format("\\%s_%d x %d%s_@%2.3fQCAP_FPS_@%fCal_FPS ",
			                   strVideoInput[0],
							   m_nDeviceVideoWidths[ 0 ], 
							   m_nDeviceVideoHeights[ 0 ], 
							   strFrameType[0], 
							   m_dDeviceVideoFrameRates[ 0 ],
							   fps );

		strFullPathName = m_strRecordPath + m_strFormatPath + timeformat + _T("_EX.JPG");
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

        QCAP_SNAPSHOT_JPG_EX( m_pDevices[ 0 ], psz, CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH, 100 );

		strFullPathName.ReleaseBuffer();
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonOsdText0()
{
	// TODO: Add your control notification handler code here

	if ( m_bOSDTEXT[ 0 ] == FALSE ) {

		QCAP_SET_OSD_TEXT( m_pDevices[ 0 ], 0, 0, 0, -1, -1, "QCAP OSD TEXT", "Arial", QCAP_FONT_STYLE_BOLD, 120, 0xFFFF0000, 0x00000000, 125, 0, 0, QCAP_SEQUENCE_STYLE_FOREMOST );
		m_bOSDTEXT[ 0 ] = TRUE;
	}
	else if (m_bOSDTEXT[ 0 ] == TRUE) {

		QCAP_SET_OSD_TEXT( m_pDevices[ 0 ], 0, 0, 0, -1, -1, "", "Arial", QCAP_FONT_STYLE_BOLD, 120, 0x00000000, 0x00000000, 125, 0, 0, QCAP_SEQUENCE_STYLE_FOREMOST );
		m_bOSDTEXT[ 0 ] = FALSE;
	}	
}


void CAnimationFactoryDlg::OnBnClickedButtonOsdPicture0()
{
	// TODO: Add your control notification handler code here

	if ( m_bOSDPICTURE[ 0 ] == FALSE ) {

	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "PNG\0*.PNG\0BMP\0*.BMP\0JPG\0*.JPG\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	ULONG X, Y;

	X = m_nDeviceVideoWidths[ 0 ]-(m_nDeviceVideoWidths[ 0 ]/6);
	Y = m_nDeviceVideoHeights[ 0 ]-(m_nDeviceVideoHeights[ 0 ]/6);

		QCAP_SET_OSD_PICTURE(m_pDevices[ 0 ], 1, X, Y, -1, -1, (CHAR *)(LPCSTR)psz, 255, QCAP_SEQUENCE_STYLE_FOREMOST ); 
		m_bOSDPICTURE[ 0 ] = TRUE;
	}
	else if ( m_bOSDPICTURE[ 0 ] == TRUE ) {

		QCAP_SET_OSD_PICTURE(m_pDevices[ 0 ], 1, 0, 0, -1, -1, "", 255, QCAP_SEQUENCE_STYLE_FOREMOST ); 
		m_bOSDPICTURE[ 0 ] = FALSE;
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonSnapshotBmp1()
{
	// TODO: Add your control notification handler code here

	double fps = 0.0;

	if( (g_d_video_stop_sample_time[ 1 ] - g_d_video_start_sample_time[ 1 ]) > 0 ) { 
					
		 fps = (g_n_video_frame_number[ 1 ]) / (g_d_video_stop_sample_time[ 1 ] - g_d_video_start_sample_time[ 1 ]);
	}

	if ( m_pDevices[ 1 ] != 0 ) {
	
		CString strFullPathName;

		CString m_strFormatPath ;

		CTime time = CTime::GetCurrentTime(); 

		CString timeformat(time.Format(CString("_%Y.%m.%d.%H.%M.%S")));

		m_strFormatPath.Format("\\%s_%d x %d%s_@%2.3fQCAP_FPS_@%fCal_FPS ",
			                   strVideoInput[ 1 ],
							   m_nDeviceVideoWidths[ 1 ], 
							   m_nDeviceVideoHeights[ 1 ], 
							   strFrameType[ 1 ], 
							   m_dDeviceVideoFrameRates[ 1 ],
							   fps );

		strFullPathName = m_strRecordPath + m_strFormatPath + timeformat + _T(".bmp");
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

        QCAP_SNAPSHOT_BMP( m_pDevices[ 1 ], psz );

		strFullPathName.ReleaseBuffer();
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonSnapshotJpg1()
{
	// TODO: Add your control notification handler code here

	double fps = 0.0;

	if( (g_d_video_stop_sample_time[ 1 ] - g_d_video_start_sample_time[ 1 ]) > 0 ) { 
					
		 fps = (g_n_video_frame_number[ 1 ]) / (g_d_video_stop_sample_time[ 1 ] - g_d_video_start_sample_time[ 1 ]);
	}

	if ( m_pDevices[ 1 ] != 0 ) {
	
		CString strFullPathName;

		CString m_strFormatPath ;

		CTime time = CTime::GetCurrentTime(); 

		CString timeformat(time.Format(CString("_%Y.%m.%d.%H.%M.%S")));

		m_strFormatPath.Format("\\%s_%d x %d%s_@%2.3fQCAP_FPS_@%fCal_FPS ",
			                   strVideoInput[ 1 ],
							   m_nDeviceVideoWidths[ 1 ], 
							   m_nDeviceVideoHeights[ 1 ], 
							   strFrameType[ 1 ], 
							   m_dDeviceVideoFrameRates[ 1 ],
							   fps );

		strFullPathName = m_strRecordPath + m_strFormatPath + timeformat + _T(".JPG");
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

        QCAP_SNAPSHOT_JPG( m_pDevices[ 1 ], psz, 100 );

		strFullPathName.ReleaseBuffer();
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonSnapshotBmpEx1()
{
	// TODO: Add your control notification handler code here

	ULONG CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH;
	//Cal Sanpshot Format
	//
	CAL_CropX = m_nDeviceVideoWidths[ 1 ] - ( m_nDeviceVideoWidths[ 1 ]-(m_nDeviceVideoWidths[ 1 ]/4) );
	CAL_CropY = m_nDeviceVideoHeights[ 1 ] - (m_nDeviceVideoHeights[ 1 ]-(m_nDeviceVideoHeights[ 1 ]/4) );
	CAL_CropW = m_nDeviceVideoWidths[ 1 ]/2;
	CAL_CropH = m_nDeviceVideoHeights[ 1 ]/2;
	CAL_DstW = m_nDeviceVideoWidths[ 1 ];
	CAL_DstH = m_nDeviceVideoHeights[ 1 ];

	double fps = 0.0;

	if( (g_d_video_stop_sample_time[ 1 ] - g_d_video_start_sample_time[ 1 ]) > 0 ) { 
					
		 fps = (g_n_video_frame_number[ 1 ]) / (g_d_video_stop_sample_time[ 1 ] - g_d_video_start_sample_time[ 1 ]);
	}

	if ( m_pDevices[ 1 ] != 0 ) {
	
		CString strFullPathName;

		CString m_strFormatPath ;

		CTime time = CTime::GetCurrentTime(); 

		CString timeformat(time.Format(CString("_%Y.%m.%d.%H.%M.%S")));

		m_strFormatPath.Format("\\%s_%d x %d%s_@%2.3fQCAP_FPS_@%fCal_FPS ",
			                   strVideoInput[ 1 ],
							   m_nDeviceVideoWidths[ 1 ], 
							   m_nDeviceVideoHeights[ 1 ], 
							   strFrameType[ 1 ], 
							   m_dDeviceVideoFrameRates[ 1 ],
							   fps );

		strFullPathName = m_strRecordPath + m_strFormatPath + timeformat + _T("_EX.bmp");
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

        QCAP_SNAPSHOT_BMP_EX( m_pDevices[ 1 ], psz, CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH );

		strFullPathName.ReleaseBuffer();
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonSnapshotJpgEx1()
{
	// TODO: Add your control notification handler code here

	ULONG CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH;
	//Cal Sanpshot Format
	//
	CAL_CropX = m_nDeviceVideoWidths[ 1 ] - ( m_nDeviceVideoWidths[ 1 ]-(m_nDeviceVideoWidths[ 1 ]/4) );
	CAL_CropY = m_nDeviceVideoHeights[ 1 ] - (m_nDeviceVideoHeights[ 1 ]-(m_nDeviceVideoHeights[ 1 ]/4) );
	CAL_CropW = m_nDeviceVideoWidths[ 1 ]/2;
	CAL_CropH = m_nDeviceVideoHeights[ 1 ]/2;
	CAL_DstW = m_nDeviceVideoWidths[ 1 ];
	CAL_DstH = m_nDeviceVideoHeights[ 1 ];

	double fps = 0.0;

	if( (g_d_video_stop_sample_time[ 1 ] - g_d_video_start_sample_time[ 1 ]) > 0 ) { 
					
		 fps = (g_n_video_frame_number[ 1 ]) / (g_d_video_stop_sample_time[ 1 ] - g_d_video_start_sample_time[ 1 ]);
	}

	if ( m_pDevices[ 1 ] != 0 ) {
	
		CString strFullPathName;

		CString m_strFormatPath ;

		CTime time = CTime::GetCurrentTime(); 

		CString timeformat(time.Format(CString("_%Y.%m.%d.%H.%M.%S")));

		m_strFormatPath.Format("\\%s_%d x %d%s_@%2.3fQCAP_FPS_@%fCal_FPS ",
			                   strVideoInput[ 1 ],
							   m_nDeviceVideoWidths[ 1 ], 
							   m_nDeviceVideoHeights[ 1 ], 
							   strFrameType[ 1 ], 
							   m_dDeviceVideoFrameRates[ 1 ],
							   fps );

		strFullPathName = m_strRecordPath + m_strFormatPath + timeformat + _T("_EX.JPG");
		
		ULONG nStrlen = strFullPathName.GetLength();

		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

        QCAP_SNAPSHOT_JPG_EX( m_pDevices[ 1 ], psz, CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH, 100 );

		strFullPathName.ReleaseBuffer();
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonOsdText1()
{
	// TODO: Add your control notification handler code here

	if ( m_bOSDTEXT[ 1 ] == FALSE ) {

		QCAP_SET_OSD_TEXT( m_pDevices[ 1 ], 0, 0, 0, -1, -1, "QCAP OSD TEXT", "Arial", QCAP_FONT_STYLE_BOLD, 120, 0xFFFF0000, 0x00000000, 125, 0, 0, QCAP_SEQUENCE_STYLE_FOREMOST );
		m_bOSDTEXT[ 1 ] = TRUE;
	}
	else if (m_bOSDTEXT[ 1 ] == TRUE) {

		QCAP_SET_OSD_TEXT( m_pDevices[ 1 ], 0, 0, 0, -1, -1, "", "Arial", QCAP_FONT_STYLE_BOLD, 120, 0x00000000, 0x00000000, 125, 0, 0, QCAP_SEQUENCE_STYLE_FOREMOST );
		m_bOSDTEXT[ 1 ] = FALSE;
	}	
}


void CAnimationFactoryDlg::OnBnClickedButtonOsdPicture1()
{
	// TODO: Add your control notification handler code here
	if ( m_bOSDPICTURE[ 1 ] == FALSE ) {

	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "PNG\0*.PNG\0BMP\0*.BMP\0JPG\0*.JPG\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	ULONG X, Y;

	X = m_nDeviceVideoWidths[ 1 ]-(m_nDeviceVideoWidths[ 1 ]/6);
	Y = m_nDeviceVideoHeights[ 1 ]-(m_nDeviceVideoHeights[ 1 ]/6);

		QCAP_SET_OSD_PICTURE(m_pDevices[ 1 ], 1, X, Y, -1, -1, (CHAR *)(LPCSTR)psz, 255, QCAP_SEQUENCE_STYLE_FOREMOST );
		m_bOSDPICTURE[ 1 ] = TRUE;
	}
	else if ( m_bOSDPICTURE[ 1 ] == TRUE ) {

		QCAP_SET_OSD_PICTURE(m_pDevices[ 1 ], 1, 0, 0, -1, -1, "", 255, QCAP_SEQUENCE_STYLE_FOREMOST );
		m_bOSDPICTURE[ 1 ] = FALSE;
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonStartRecord0()
{
	// TODO: Add your control notification handler code here
	m_btnRecordStart_0.EnableWindow( FALSE ); 
	m_btnRecordStop_0.EnableWindow( TRUE ); 

	CString nEncoderType_ch0, nEncoderFormat_ch0, nRecordProfile_ch0, nRecordLevel_ch0, nRecodRecordEntropy_ch0, nRecodComplexity_ch0, nRecordMode_ch0, nBitRate_ch0, nQuality_ch0, nAudioEncoderType_ch0, nAudioEncoderFormat_ch0, nFilePathName_ch0;

	CString nGOP_ch0, nBFrame_ch0, nAspectRatioX_ch0, nAspectRatioY_ch0, nCropX_ch0, nCropY_ch0, nCropW_ch0, nCropH_ch0, nDstW_ch0, nDstH_ch0,  nInterleaved_ch0, nVideoDelayTime_ch0, nAudioDelayTime_ch0 ;

	ULONG nEncoderType_Set_ch0 = 0, nEncoderFormat_Set_ch0 = 0, nRecordProfile_Set_ch0 = 0, nRecordLevel_Set_ch0 = 0, nRecodRecordEntropy_Set_ch0 = 0, nRecodComplexity_Set_ch0 = 0, nRecordMode_Set_ch0 = 0, nBitRate_Set_ch0 = 0, nQuality_Set_ch0 = 0, nAudioEncoderType_Set_ch0 = 0, nAudioEncoderFormat_Set_ch0 = 0, nFilePathName_Set_ch0 = 0 ;

	m_combol_video_Record_Property_EncoderType_0.GetWindowTextA( nEncoderType_ch0 );
	m_combol_video_Record_Property_EncoderFormat_0.GetWindowTextA( nEncoderFormat_ch0 );
	m_combol_video_Record_Property_RecordProfile_0.GetWindowTextA( nRecordProfile_ch0 );
	m_combol_video_Record_Property_RecordLevel_0.GetWindowTextA( nRecordLevel_ch0 );
	m_combol_video_Record_Property_RecordEntropy_0.GetWindowTextA( nRecodRecordEntropy_ch0 );
	m_combol_video_Record_Property_RecordMode_0.GetWindowTextA( nRecordMode_ch0 );
	m_combol_video_Record_Property_BitRate_0.GetWindowTextA( nBitRate_ch0 );
	m_combol_video_Record_Property_Quality_0.GetWindowTextA( nQuality_ch0 );
	m_combol_video_Record_Property_RecordComplexity_0.GetWindowTextA( nRecodComplexity_ch0 );

	m_combol_Audio_Record_Property_EncoderType_0.GetWindowTextA( nAudioEncoderType_ch0 );
	m_combol_Audio_Record_Property_EncoderFormat_0.GetWindowTextA( nAudioEncoderFormat_ch0 );

	m_combol_Start_Record_FilePathName_0.GetWindowTextA( nFilePathName_ch0 );
	

	ULONG CH01_VdieoRecord_EncoderType_index, CH01_VdieoRecord_EncoderFormat_index, CH01_VdieoRecord_Profile_index, CH01_VdieoRecord_Level_index, CH01_VdieoRecord_Entropy_index, CH01_VdieoRecord_Complexity_index, CH01_VdieoRecord_MODE_index, CH01_VdieoRecord_Quality_index, CH01_VdieoRecord_BitRate_index ;
	                                                                                     
	ULONG CH01_AudioRecord_EncoderType_index, CH01_AudioRecord_EncoderFormat_index, CH01_Record_FilePathName_index;

	//VIDEO RECORD ENCODER TYPE

	if		( nEncoderType_ch0 ==  "QCAP_ENCODER_TYPE_SOFTWARE" )			{ nEncoderType_Set_ch0 = 0; CH01_VdieoRecord_EncoderType_index = 0; }
	else if ( nEncoderType_ch0 ==  "QCAP_ENCODER_TYPE_HARDWARE" )			{ nEncoderType_Set_ch0 = 1; CH01_VdieoRecord_EncoderType_index = 1; }
	else if ( nEncoderType_ch0 ==  "QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK" )	{ nEncoderType_Set_ch0 = 2; CH01_VdieoRecord_EncoderType_index = 2; }
	else if ( nEncoderType_ch0 ==  "QCAP_ENCODER_TYPE_NVIDIA_CUDA" )		{ nEncoderType_Set_ch0 = 4; CH01_VdieoRecord_EncoderType_index = 3; }

	theApp.WriteProfileInt("CH01_Video_Record_Setting","CH01_video_Record_EncoderType", CH01_VdieoRecord_EncoderType_index);


	//VIDEO RECORD ENCODER FORMAT
	if ( nEncoderFormat_ch0 ==  "QCAP_ENCODER_FORMAT_H264" )			{ nEncoderFormat_Set_ch0 = 0; CH01_VdieoRecord_EncoderFormat_index = 0; }

	theApp.WriteProfileInt("CH01_Video_Record_Setting","CH01_video_Record_EncoderFormat", CH01_VdieoRecord_EncoderFormat_index);


	//VIDEO RECORD PROFILE
	if		( nRecordProfile_ch0 ==  "QCAP_RECORD_PROFILE_BASELINE" )	{ nRecordProfile_Set_ch0 = 0; CH01_VdieoRecord_Profile_index = 0; }
	else if ( nRecordProfile_ch0 ==  "QCAP_RECORD_PROFILE_MAIN" )		{ nRecordProfile_Set_ch0 = 1; CH01_VdieoRecord_Profile_index = 1; }
	else if ( nRecordProfile_ch0 ==  "QCAP_RECORD_PROFILE_HIGH" )		{ nRecordProfile_Set_ch0 = 2; CH01_VdieoRecord_Profile_index = 2; }

	theApp.WriteProfileInt("CH01_Video_Record_Setting","CH01_video_Record_Profile", CH01_VdieoRecord_Profile_index);


	//VIDEO RECORD LEVEL
	if		( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_1" )		{ nRecordLevel_Set_ch0 = 10; CH01_VdieoRecord_Level_index = 0; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_1B" )		{ nRecordLevel_Set_ch0 = 9;  CH01_VdieoRecord_Level_index = 1; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_11" )		{ nRecordLevel_Set_ch0 = 11; CH01_VdieoRecord_Level_index = 2; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_12" )		{ nRecordLevel_Set_ch0 = 12; CH01_VdieoRecord_Level_index = 3; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_13" )		{ nRecordLevel_Set_ch0 = 13; CH01_VdieoRecord_Level_index = 4; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_2" )		{ nRecordLevel_Set_ch0 = 20; CH01_VdieoRecord_Level_index = 5; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_21" )		{ nRecordLevel_Set_ch0 = 21; CH01_VdieoRecord_Level_index = 6; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_22" )		{ nRecordLevel_Set_ch0 = 22; CH01_VdieoRecord_Level_index = 7; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_3" )		{ nRecordLevel_Set_ch0 = 30; CH01_VdieoRecord_Level_index = 8; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_31" )		{ nRecordLevel_Set_ch0 = 31; CH01_VdieoRecord_Level_index = 9; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_32" )		{ nRecordLevel_Set_ch0 = 32; CH01_VdieoRecord_Level_index = 10;}
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_4" )		{ nRecordLevel_Set_ch0 = 40; CH01_VdieoRecord_Level_index = 11;}
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_41" )		{ nRecordLevel_Set_ch0 = 41; CH01_VdieoRecord_Level_index = 12;}
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_42" )		{ nRecordLevel_Set_ch0 = 42; CH01_VdieoRecord_Level_index = 13;}
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_50" )		{ nRecordLevel_Set_ch0 = 50; CH01_VdieoRecord_Level_index = 14;}
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_51" )		{ nRecordLevel_Set_ch0 = 51; CH01_VdieoRecord_Level_index = 15;}
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_52" )		{ nRecordLevel_Set_ch0 = 52; CH01_VdieoRecord_Level_index = 16;}

	theApp.WriteProfileInt("CH01_Video_Record_Setting","CH01_video_Record_Level", CH01_VdieoRecord_Level_index);


	//VIDEO RECORD ENTROPY
	if		( nRecodRecordEntropy_ch0 ==  "QCAP_RECORD_ENTROPY_CAVLC" )	{ nRecodRecordEntropy_Set_ch0 = 0; CH01_VdieoRecord_Entropy_index = 0; }
	else if ( nRecodRecordEntropy_ch0 ==  "QCAP_RECORD_ENTROPY_CABAC" )	{ nRecodRecordEntropy_Set_ch0 = 1; CH01_VdieoRecord_Entropy_index = 1; }

	theApp.WriteProfileInt("CH01_Video_Record_Setting","CH01_video_Record_Entropy", CH01_VdieoRecord_Entropy_index);


	//VIDEO RECORD COMPLEXITY
	if		( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_0" )	{ nRecodComplexity_Set_ch0 = 0; CH01_VdieoRecord_Complexity_index = 0; }
	else if ( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_1" )	{ nRecodComplexity_Set_ch0 = 1; CH01_VdieoRecord_Complexity_index = 1; }
	else if ( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_2" )	{ nRecodComplexity_Set_ch0 = 2; CH01_VdieoRecord_Complexity_index = 2; }
	else if ( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_3" )	{ nRecodComplexity_Set_ch0 = 3; CH01_VdieoRecord_Complexity_index = 3; }
	else if ( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_4" )	{ nRecodComplexity_Set_ch0 = 4; CH01_VdieoRecord_Complexity_index = 4; }
	else if ( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_5" )	{ nRecodComplexity_Set_ch0 = 5; CH01_VdieoRecord_Complexity_index = 5; }
	else if ( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_6" )	{ nRecodComplexity_Set_ch0 = 6; CH01_VdieoRecord_Complexity_index = 6; }

	theApp.WriteProfileInt("CH01_Video_Record_Setting","CH01_video_Record_Complexity", CH01_VdieoRecord_Complexity_index);


	//VIDEO RECORD MODE
	if		( nRecordMode_ch0 ==  "QCAP_RECORD_MODE_VBR" )	{ nRecordMode_Set_ch0 = 0; CH01_VdieoRecord_MODE_index = 0; }
	else if ( nRecordMode_ch0 ==  "QCAP_RECORD_MODE_CBR" )	{ nRecordMode_Set_ch0 = 1; CH01_VdieoRecord_MODE_index = 1; }
	else if ( nRecordMode_ch0 ==  "QCAP_RECORD_MODE_ABR" )	{ nRecordMode_Set_ch0 = 2; CH01_VdieoRecord_MODE_index = 2; }

	theApp.WriteProfileInt("CH01_Video_Record_Setting","CH01_video_Record_MODE", CH01_VdieoRecord_MODE_index);


	//VIDEO RECORD QUALITY
	if      ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  1000" )	{ nQuality_Set_ch0 = 1000; CH01_VdieoRecord_Quality_index = 0; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  2000" )	{ nQuality_Set_ch0 = 2000; CH01_VdieoRecord_Quality_index = 1; }	 
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  3000" )	{ nQuality_Set_ch0 = 3000; CH01_VdieoRecord_Quality_index = 2; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  4000" )	{ nQuality_Set_ch0 = 4000; CH01_VdieoRecord_Quality_index = 3; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  5000" )	{ nQuality_Set_ch0 = 5000; CH01_VdieoRecord_Quality_index = 4;}
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  6000" )	{ nQuality_Set_ch0 = 6000; CH01_VdieoRecord_Quality_index = 5; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  7000" )	{ nQuality_Set_ch0 = 7000; CH01_VdieoRecord_Quality_index = 6; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  8000" )	{ nQuality_Set_ch0 = 8000; CH01_VdieoRecord_Quality_index = 7; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  9000" )	{ nQuality_Set_ch0 = 9000; CH01_VdieoRecord_Quality_index = 8; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  10000" )	{ nQuality_Set_ch0 = 10000; CH01_VdieoRecord_Quality_index = 9; }

	theApp.WriteProfileInt("CH01_Video_Record_Setting","CH01_video_Record_Quality", CH01_VdieoRecord_Quality_index);


	//VIDEO RECORD BITRATE
	if      ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 16MBPS" )	{ nBitRate_Set_ch0 = 16*1024*1024; CH01_VdieoRecord_BitRate_index = 0; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 12MBPS" )	{ nBitRate_Set_ch0 = 12*1024*1024; CH01_VdieoRecord_BitRate_index = 1; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 8MBPS" )	{ nBitRate_Set_ch0 = 8*1024*1024;  CH01_VdieoRecord_BitRate_index = 2; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 6MBPS" )	{ nBitRate_Set_ch0 = 6*1024*1024;  CH01_VdieoRecord_BitRate_index = 3; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 4MBPS" )	{ nBitRate_Set_ch0 = 4*1024*1024;  CH01_VdieoRecord_BitRate_index = 4; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 2MBPS" )	{ nBitRate_Set_ch0 = 2*1024*1024;  CH01_VdieoRecord_BitRate_index = 5; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 1MBPS" )	{ nBitRate_Set_ch0 = 1*1024*1024;  CH01_VdieoRecord_BitRate_index = 6; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 512KBPS" )	{ nBitRate_Set_ch0 = 1*512*1024;   CH01_VdieoRecord_BitRate_index = 7; }

	theApp.WriteProfileInt("CH01_Video_Record_Setting","CH01_video_Record_BitRate", CH01_VdieoRecord_BitRate_index);


	//AUDIO RECORD ENCODERFORMAT
	if ( nAudioEncoderType_ch0 ==  "QCAP_ENCODER_TYPE_SOFTWARE" )			{ nAudioEncoderType_Set_ch0 = 0; CH01_AudioRecord_EncoderType_index = 0; }
	theApp.WriteProfileInt("CH01_Audio_Record_Setting","CH01_audio_Record_EncoderType", CH01_AudioRecord_EncoderType_index);


	if		( nAudioEncoderFormat_ch0 ==  "QCAP_ENCODER_FORMAT_PCM" )		{ nAudioEncoderFormat_Set_ch0 = 0; CH01_AudioRecord_EncoderFormat_index = 0; }
	else if ( nAudioEncoderFormat_ch0 ==  "QCAP_ENCODER_FORMAT_AAC" )		{ nAudioEncoderFormat_Set_ch0 = 1; CH01_AudioRecord_EncoderFormat_index = 1; }
	else if ( nAudioEncoderFormat_ch0 ==  "QCAP_ENCODER_FORMAT_AAC_ADTS" )	{ nAudioEncoderFormat_Set_ch0 = 2; CH01_AudioRecord_EncoderFormat_index = 2; }
	theApp.WriteProfileInt("CH01_Audio_Record_Setting","CH01_audio_Record_EncoderFormat", CH01_AudioRecord_EncoderFormat_index);


	//VIDEO RECORD SET PROPERTY	
	m_edit_Video_Record_Proerty_GOP_0.GetWindowTextA( nGOP_ch0 );
	ULONG nGOP_Set_ch0 = atoi(nGOP_ch0);

	m_edit_Video_Record_Proerty_BFrame_0.GetWindowTextA( nBFrame_ch0 );
	ULONG nBFrame_Set_ch0 = atoi(nBFrame_ch0);

	m_edit_Video_Record_Proerty_AspectRatio_X_0.GetWindowTextA( nAspectRatioX_ch0 );
                    	ULONG nAspectRatioX_Set_ch0 = atoi(nAspectRatioX_ch0);

	m_edit_Video_Record_Proerty_AspectRatio_Y_0.GetWindowTextA( nAspectRatioY_ch0 );
	ULONG nAspectRatioY_Set_ch0 =  atoi(nAspectRatioY_ch0);

	m_edit_Video_Record_Proerty_CropX_0.GetWindowTextA( nCropX_ch0 );
	ULONG nCropX_Set_ch0 =  atoi(nCropX_ch0);

	m_edit_Video_Record_Proerty_CropY_0.GetWindowTextA( nCropY_ch0 );
	ULONG nCropY_Set_ch0 =  atoi(nCropY_ch0);

	m_edit_Video_Record_Proerty_CropW_0.GetWindowTextA( nCropW_ch0 );
	ULONG nCropW_Set_ch0 = atoi(nCropW_ch0);

	m_edit_Video_Record_Proerty_CropH_0.GetWindowTextA( nCropH_ch0 );
	ULONG nCropH_Set_ch0 =  atoi(nCropH_ch0);

	m_edit_Video_Record_Proerty_DstW_0.GetWindowTextA( nDstW_ch0 );
	ULONG nDstW_Set_ch0 =  atoi(nDstW_ch0);

	m_edit_Video_Record_Proerty_DstH_0.GetWindowTextA( nDstH_ch0 );
	ULONG nDstH_Set_ch0 =  atoi(nDstH_ch0);

	m_edit_Video_Record_Proerty_Interleaved_0.GetWindowTextA( nInterleaved_ch0 );
	ULONG nInterleaved_Set_ch0 =  atoi(nInterleaved_ch0);
	
	m_edit_Video_Record_Delay_Time_0.GetWindowTextA( nVideoDelayTime_ch0 );
	double nVideoDelayTime_Set_ch0 =  atoi(nVideoDelayTime_ch0);

	m_edit_Audio_Record_Delay_Time_0.GetWindowTextA( nAudioDelayTime_ch0 );
	double nAudioDelayTime_Set_ch0 =  atoi(nAudioDelayTime_ch0);

	QCAP_SET_VIDEO_RECORD_PROPERTY_EX( m_pDevices[ 0 ],
									   0,
									   nEncoderType_Set_ch0,
									   nEncoderFormat_Set_ch0,
									   nRecordProfile_Set_ch0,
									   nRecordLevel_Set_ch0,
									   nRecodRecordEntropy_Set_ch0,
									   nRecodComplexity_Set_ch0,
									   nRecordMode_Set_ch0,
									   nQuality_Set_ch0,
									   nBitRate_Set_ch0,
									   nGOP_Set_ch0,
									   nBFrame_Set_ch0,
									   nInterleaved_Set_ch0,
									   0, /*nSlices*/
									   0, /*nLayers*/
									   0, /*nSceneCut*/
									   nAspectRatioX_Set_ch0,
									   nAspectRatioY_Set_ch0,
									   nCropX_Set_ch0,
									   nCropY_Set_ch0,
									   nCropW_Set_ch0,
									   nCropH_Set_ch0,
									   nDstW_Set_ch0,
									   nDstH_Set_ch0 );
	
	QCAP_SET_AUDIO_RECORD_PROPERTY( m_pDevices[ 0 ],
									0,
									nAudioEncoderType_Set_ch0,
									nAudioEncoderFormat_Set_ch0 );


	//
	CString strFullPathName;

	CString m_strFormatPath ;

	CTime time = CTime::GetCurrentTime(); 

	CString timeformat(time.Format(CString("\\CH01_%Y.%m.%d.%H.%M.%S")));

	//RECORD FILE PATH NAME
	if ( nFilePathName_ch0 ==  "AVI" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".AVI"); 
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_RECORD( m_pDevices[ 0 ], 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set_ch0, nAudioDelayTime_Set_ch0 );
		CH01_Record_FilePathName_index = 0;
	}
	else if ( nFilePathName_ch0 ==  "MP4" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".MP4"); 
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_RECORD( m_pDevices[ 0 ], 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set_ch0, nAudioDelayTime_Set_ch0 );
		CH01_Record_FilePathName_index = 1;
	}
	else if ( nFilePathName_ch0 ==  "ASF" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".ASF"); 
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_RECORD( m_pDevices[ 0 ], 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set_ch0, nAudioDelayTime_Set_ch0 );
		CH01_Record_FilePathName_index = 2;
	}
	else if ( nFilePathName_ch0 ==  "FLV" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".FLV");
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_RECORD( m_pDevices[ 0 ], 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set_ch0, nAudioDelayTime_Set_ch0 );
		CH01_Record_FilePathName_index = 3;
	}
	else if ( nFilePathName_ch0 ==  "TS" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".TS");
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_RECORD( m_pDevices[ 0 ], 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set_ch0, nAudioDelayTime_Set_ch0 );
		CH01_Record_FilePathName_index = 4;
	}
	strFullPathName.ReleaseBuffer();

	theApp.WriteProfileInt("CH01_Record_Setting","CH01_Record_FilePathName", CH01_Record_FilePathName_index);

}


void CAnimationFactoryDlg::OnBnClickedButtonStopRecord0()
{
	// TODO: Add your control notification handler code here
	m_btnRecordStart_0.EnableWindow( TRUE ); 
	m_btnRecordStop_0.EnableWindow( FALSE ); 

	if ( m_pDevices[ 0 ] != 0 )
	{
		QCAP_STOP_RECORD( m_pDevices[ 0 ], 0 );
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonStartRecord1()
{
	// TODO: Add your control notification handler code here
	m_btnRecordStart_1.EnableWindow( FALSE ); 
	m_btnRecordStop_1.EnableWindow( TRUE ); 

	CString nEncoderType_ch1, nEncoderFormat_ch1, nRecordProfile_ch1, nRecordLevel_ch1, nRecodRecordEntropy_ch1, nRecodComplexity_ch1, nRecordMode_ch1, nBitRate_ch1, nQuality_ch1, nAudioEncoderType_ch1, nAudioEncoderFormat_ch1, nFilePathName_ch1;

	CString nGOP_ch1, nBFrame_ch1, nAspectRatioX_ch1, nAspectRatioY_ch1, nCropX_ch1, nCropY_ch1, nCropW_ch1, nCropH_ch1, nDstW_ch1, nDstH_ch1,  nInterleaved_ch1, nVideoDelayTime_ch1, nAudioDelayTime_ch1 ;

	ULONG nEncoderType_Set_ch1 = 0, nEncoderFormat_Set_ch1 = 0, nRecordProfile_Set_ch1 = 0, nRecordLevel_Set_ch1 = 0, nRecodRecordEntropy_Set_ch1 = 0, nRecodComplexity_Set_ch1 = 0, nRecordMode_Set_ch1 = 0, nBitRate_Set_ch1 = 0, nQuality_Set_ch1 = 0, nAudioEncoderType_Set_ch1 = 0, nAudioEncoderFormat_Set_ch1 = 0, nFilePathName_Set_ch1 = 0 ;

	m_combol_video_Record_Property_EncoderType_1.GetWindowTextA( nEncoderType_ch1 );
	m_combol_video_Record_Property_EncoderFormat_1.GetWindowTextA( nEncoderFormat_ch1 );
	m_combol_video_Record_Property_RecordProfile_1.GetWindowTextA( nRecordProfile_ch1 );
	m_combol_video_Record_Property_RecordLevel_1.GetWindowTextA( nRecordLevel_ch1 );
	m_combol_video_Record_Property_RecordEntropy_1.GetWindowTextA( nRecodRecordEntropy_ch1 );
	m_combol_video_Record_Property_RecordMode_1.GetWindowTextA( nRecordMode_ch1 );
	m_combol_video_Record_Property_BitRate_1.GetWindowTextA( nBitRate_ch1 );
	m_combol_video_Record_Property_Quality_1.GetWindowTextA( nQuality_ch1 );
	m_combol_video_Record_Property_RecordComplexity_1.GetWindowTextA( nRecodComplexity_ch1 );

	m_combol_Audio_Record_Property_EncoderType_1.GetWindowTextA( nAudioEncoderType_ch1 );
	m_combol_Audio_Record_Property_EncoderFormat_1.GetWindowTextA( nAudioEncoderFormat_ch1 );

	m_combol_Start_Record_FilePathName_1.GetWindowTextA( nFilePathName_ch1 );


	ULONG CH02_VdieoRecord_EncoderType_index, CH02_VdieoRecord_EncoderFormat_index, CH02_VdieoRecord_Profile_index, CH02_VdieoRecord_Level_index, CH02_VdieoRecord_Entropy_index, CH02_VdieoRecord_Complexity_index, CH02_VdieoRecord_MODE_index, CH02_VdieoRecord_Quality_index, CH02_VdieoRecord_BitRate_index ;
	                                                                                     
	ULONG CH02_AudioRecord_EncoderType_index, CH02_AudioRecord_EncoderFormat_index, CH02_Record_FilePathName_index;

	//VIDEO RECORD ENCODER TYPE
	if		( nEncoderType_ch1 ==  "QCAP_ENCODER_TYPE_SOFTWARE" )			{ nEncoderType_Set_ch1 = 0; CH02_VdieoRecord_EncoderType_index = 0; }
	else if ( nEncoderType_ch1 ==  "QCAP_ENCODER_TYPE_HARDWARE" )			{ nEncoderType_Set_ch1 = 1; CH02_VdieoRecord_EncoderType_index = 1; }
	else if ( nEncoderType_ch1 ==  "QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK" )	{ nEncoderType_Set_ch1 = 2; CH02_VdieoRecord_EncoderType_index = 2; }
	else if ( nEncoderType_ch1 ==  "QCAP_ENCODER_TYPE_NVIDIA_CUDA" )		{ nEncoderType_Set_ch1 = 4; CH02_VdieoRecord_EncoderType_index = 3; }

	theApp.WriteProfileInt("CH02_Video_Record_Setting","CH02_video_Record_EncoderType", CH02_VdieoRecord_EncoderType_index);


	//VIDEO RECORD ENCODER FORMAT
	if ( nEncoderFormat_ch1 ==  "QCAP_ENCODER_FORMAT_H264" )			{ nEncoderFormat_Set_ch1 = 0; CH02_VdieoRecord_EncoderFormat_index = 0; }

	theApp.WriteProfileInt("CH02_Video_Record_Setting","CH02_video_Record_EncoderFormat", CH02_VdieoRecord_EncoderFormat_index);


	//VIDEO RECORD PROFILE
	if		( nRecordProfile_ch1 ==  "QCAP_RECORD_PROFILE_BASELINE" )	{ nRecordProfile_Set_ch1 = 0; CH02_VdieoRecord_Profile_index = 0; }
	else if ( nRecordProfile_ch1 ==  "QCAP_RECORD_PROFILE_MAIN" )		{ nRecordProfile_Set_ch1 = 1; CH02_VdieoRecord_Profile_index = 1; }
	else if ( nRecordProfile_ch1 ==  "QCAP_RECORD_PROFILE_HIGH" )		{ nRecordProfile_Set_ch1 = 2; CH02_VdieoRecord_Profile_index = 2; }

	theApp.WriteProfileInt("CH02_Video_Record_Setting","CH02_video_Record_Profile", CH02_VdieoRecord_Profile_index);


	//VIDEO RECORD LEVEL
	if		( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_1" )		{ nRecordLevel_Set_ch1 = 10; CH02_VdieoRecord_Level_index = 0; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_1B" )		{ nRecordLevel_Set_ch1 = 9;  CH02_VdieoRecord_Level_index = 1; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_11" )		{ nRecordLevel_Set_ch1 = 11; CH02_VdieoRecord_Level_index = 2; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_12" )		{ nRecordLevel_Set_ch1 = 12; CH02_VdieoRecord_Level_index = 3; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_13" )		{ nRecordLevel_Set_ch1 = 13; CH02_VdieoRecord_Level_index = 4; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_2" )		{ nRecordLevel_Set_ch1 = 20; CH02_VdieoRecord_Level_index = 5; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_21" )		{ nRecordLevel_Set_ch1 = 21; CH02_VdieoRecord_Level_index = 6; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_22" )		{ nRecordLevel_Set_ch1 = 22; CH02_VdieoRecord_Level_index = 7; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_3" )		{ nRecordLevel_Set_ch1 = 30; CH02_VdieoRecord_Level_index = 8; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_31" )		{ nRecordLevel_Set_ch1 = 31; CH02_VdieoRecord_Level_index = 9; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_32" )		{ nRecordLevel_Set_ch1 = 32; CH02_VdieoRecord_Level_index = 10; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_4" )		{ nRecordLevel_Set_ch1 = 40; CH02_VdieoRecord_Level_index = 11; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_41" )		{ nRecordLevel_Set_ch1 = 41; CH02_VdieoRecord_Level_index = 12; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_42" )		{ nRecordLevel_Set_ch1 = 42; CH02_VdieoRecord_Level_index = 13; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_50" )		{ nRecordLevel_Set_ch1 = 50; CH02_VdieoRecord_Level_index = 14; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_51" )		{ nRecordLevel_Set_ch1 = 51; CH02_VdieoRecord_Level_index = 15; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_52" )		{ nRecordLevel_Set_ch1 = 52; CH02_VdieoRecord_Level_index = 16; }

	theApp.WriteProfileInt("CH02_Video_Record_Setting","CH02_video_Record_Level", CH02_VdieoRecord_Level_index);


	//VIDEO RECORD ENTROPY
	if		( nRecodRecordEntropy_ch1 ==  "QCAP_RECORD_ENTROPY_CAVLC" )	{ nRecodRecordEntropy_Set_ch1 = 0; CH02_VdieoRecord_Entropy_index = 0; }
	else if ( nRecodRecordEntropy_ch1 ==  "QCAP_RECORD_ENTROPY_CABAC" )	{ nRecodRecordEntropy_Set_ch1 = 1; CH02_VdieoRecord_Entropy_index = 1; }

	theApp.WriteProfileInt("CH02_Video_Record_Setting","CH02_video_Record_Entropy", CH02_VdieoRecord_Entropy_index);


	//VIDEO RECORD COMPLEXITY
	if		( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_0" )	{ nRecodComplexity_Set_ch1 = 0; CH02_VdieoRecord_Complexity_index = 0; }
	else if ( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_1" )	{ nRecodComplexity_Set_ch1 = 1; CH02_VdieoRecord_Complexity_index = 1; }
	else if ( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_2" )	{ nRecodComplexity_Set_ch1 = 2; CH02_VdieoRecord_Complexity_index = 2; }
	else if ( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_3" )	{ nRecodComplexity_Set_ch1 = 3; CH02_VdieoRecord_Complexity_index = 3; }
	else if ( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_4" )	{ nRecodComplexity_Set_ch1 = 4; CH02_VdieoRecord_Complexity_index = 4; }
	else if ( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_5" )	{ nRecodComplexity_Set_ch1 = 5; CH02_VdieoRecord_Complexity_index = 5; }
	else if ( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_6" )	{ nRecodComplexity_Set_ch1 = 6; CH02_VdieoRecord_Complexity_index = 6; }

	theApp.WriteProfileInt("CH02_Video_Record_Setting","CH02_video_Record_Complexity", CH02_VdieoRecord_Complexity_index);


	//VIDEO RECORD MODE
	if		( nRecordMode_ch1 ==  "QCAP_RECORD_MODE_VBR" )	{ nRecordMode_Set_ch1 = 0; CH02_VdieoRecord_MODE_index = 0; }
	else if ( nRecordMode_ch1 ==  "QCAP_RECORD_MODE_CBR" )	{ nRecordMode_Set_ch1 = 1; CH02_VdieoRecord_MODE_index = 1; }
	else if ( nRecordMode_ch1 ==  "QCAP_RECORD_MODE_ABR" )	{ nRecordMode_Set_ch1 = 2; CH02_VdieoRecord_MODE_index = 2; }

	theApp.WriteProfileInt("CH02_Video_Record_Setting","CH02_video_Record_MODE", CH02_VdieoRecord_MODE_index);


	//VIDEO RECORD QUALITY
	if      ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  1000" )	{ nQuality_Set_ch1 = 1000; CH02_VdieoRecord_Quality_index = 0; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  2000" )	{ nQuality_Set_ch1 = 2000; CH02_VdieoRecord_Quality_index = 1; }	 
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  3000" )	{ nQuality_Set_ch1 = 3000; CH02_VdieoRecord_Quality_index = 2; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  4000" )	{ nQuality_Set_ch1 = 4000; CH02_VdieoRecord_Quality_index = 3; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  5000" )	{ nQuality_Set_ch1 = 5000; CH02_VdieoRecord_Quality_index = 4; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  6000" )	{ nQuality_Set_ch1 = 6000; CH02_VdieoRecord_Quality_index = 5; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  7000" )	{ nQuality_Set_ch1 = 7000; CH02_VdieoRecord_Quality_index = 6; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  8000" )	{ nQuality_Set_ch1 = 8000; CH02_VdieoRecord_Quality_index = 7; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  9000" )	{ nQuality_Set_ch1 = 9000; CH02_VdieoRecord_Quality_index = 8; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY	 10000" )	{ nQuality_Set_ch1 = 10000; CH02_VdieoRecord_Quality_index = 9; }

	theApp.WriteProfileInt("CH02_Video_Record_Setting","CH02_video_Record_Quality", CH02_VdieoRecord_Quality_index);


	//VIDEO RECORD BITRATE
	if      ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 16MBPS" )	{ nBitRate_Set_ch1 = 16*1024*1024; CH02_VdieoRecord_BitRate_index = 0; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 12MBPS" )	{ nBitRate_Set_ch1 = 12*1024*1024; CH02_VdieoRecord_BitRate_index = 1; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 8MBPS" )	{ nBitRate_Set_ch1 = 8*1024*1024;  CH02_VdieoRecord_BitRate_index = 2; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 6MBPS" )	{ nBitRate_Set_ch1 = 6*1024*1024;  CH02_VdieoRecord_BitRate_index = 3; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 4MBPS" )	{ nBitRate_Set_ch1 = 4*1024*1024;  CH02_VdieoRecord_BitRate_index = 4; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 2MBPS" )	{ nBitRate_Set_ch1 = 2*1024*1024;  CH02_VdieoRecord_BitRate_index = 5; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 1MBPS" )	{ nBitRate_Set_ch1 = 1*1024*1024;  CH02_VdieoRecord_BitRate_index = 6; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 512KBPS" )	{ nBitRate_Set_ch1 = 1*512*1024;   CH02_VdieoRecord_BitRate_index = 7; }


	theApp.WriteProfileInt("CH02_Video_Record_Setting","CH02_video_Record_BitRate", CH02_VdieoRecord_BitRate_index);


	
	//AUDIO RECORD ENCODERFORMAT
	if ( nAudioEncoderType_ch1 ==  "QCAP_ENCODER_TYPE_SOFTWARE" )			{ nAudioEncoderType_Set_ch1 = 0; CH02_AudioRecord_EncoderType_index = 0; }

	theApp.WriteProfileInt("CH02_Audio_Record_Setting","CH02_audio_Record_EncoderType", CH02_AudioRecord_EncoderType_index);


	if		( nAudioEncoderFormat_ch1 ==  "QCAP_ENCODER_FORMAT_PCM" )		{ nAudioEncoderFormat_Set_ch1 = 0; CH02_AudioRecord_EncoderFormat_index = 0; }
	else if ( nAudioEncoderFormat_ch1 ==  "QCAP_ENCODER_FORMAT_AAC" )		{ nAudioEncoderFormat_Set_ch1 = 1; CH02_AudioRecord_EncoderFormat_index = 1; }
	else if ( nAudioEncoderFormat_ch1 ==  "QCAP_ENCODER_FORMAT_AAC_ADTS" )	{ nAudioEncoderFormat_Set_ch1 = 2; CH02_AudioRecord_EncoderFormat_index = 2; }

	theApp.WriteProfileInt("CH02_Audio_Record_Setting","CH02_audio_Record_EncoderFormat", CH02_AudioRecord_EncoderFormat_index);


	//VIDEO RECORD SET PROPERTY	
	m_edit_Video_Record_Proerty_GOP_1.GetWindowTextA( nGOP_ch1 );
	ULONG nGOP_Set_ch1 = atoi(nGOP_ch1);

	m_edit_Video_Record_Proerty_BFrame_1.GetWindowTextA( nBFrame_ch1 );
	ULONG nBFrame_Set_ch1 = atoi(nBFrame_ch1);

	m_edit_Video_Record_Proerty_AspectRatio_X_1.GetWindowTextA( nAspectRatioX_ch1 );
	ULONG nAspectRatioX_Set_ch1 = atoi(nAspectRatioX_ch1);

	m_edit_Video_Record_Proerty_AspectRatio_Y_1.GetWindowTextA( nAspectRatioY_ch1 );
	ULONG nAspectRatioY_Set_ch1 =  atoi(nAspectRatioY_ch1);

	m_edit_Video_Record_Proerty_CropX_1.GetWindowTextA( nCropX_ch1 );
	ULONG nCropX_Set_ch1 =  atoi(nCropX_ch1);

	m_edit_Video_Record_Proerty_CropY_1.GetWindowTextA( nCropY_ch1 );
	ULONG nCropY_Set_ch1 =  atoi(nCropY_ch1);

	m_edit_Video_Record_Proerty_CropW_1.GetWindowTextA( nCropW_ch1 );
	ULONG nCropW_Set_ch1 = atoi(nCropW_ch1);

	m_edit_Video_Record_Proerty_CropH_1.GetWindowTextA( nCropH_ch1 );
	ULONG nCropH_Set_ch1 =  atoi(nCropH_ch1);

	m_edit_Video_Record_Proerty_DstW_1.GetWindowTextA( nDstW_ch1 );
	ULONG nDstW_Set_ch1 =  atoi(nDstW_ch1);

	m_edit_Video_Record_Proerty_DstH_1.GetWindowTextA( nDstH_ch1 );
	ULONG nDstH_Set_ch1 =  atoi(nDstH_ch1);

	m_edit_Video_Record_Proerty_Interleaved_1.GetWindowTextA( nInterleaved_ch1 );
	ULONG nInterleaved_Set_ch1 =  atoi(nInterleaved_ch1);

	m_edit_Video_Record_Delay_Time_1.GetWindowTextA( nVideoDelayTime_ch1 );
	double nVideoDelayTime_Set_ch1 =  atoi(nVideoDelayTime_ch1);

	m_edit_Audio_Record_Delay_Time_1.GetWindowTextA( nAudioDelayTime_ch1 );
	double nAudioDelayTime_Set_ch1 =  atoi(nAudioDelayTime_ch1);

	QCAP_SET_VIDEO_RECORD_PROPERTY_EX( m_pDevices[ 1 ],
									   0,
									   nEncoderType_Set_ch1,
									   nEncoderFormat_Set_ch1,
									   nRecordProfile_Set_ch1,
									   nRecordLevel_Set_ch1,
									   nRecodRecordEntropy_Set_ch1,
									   nRecodComplexity_Set_ch1,
									   nRecordMode_Set_ch1,
									   nQuality_Set_ch1,
									   nBitRate_Set_ch1,
									   nGOP_Set_ch1,
									   nBFrame_Set_ch1,
									   nInterleaved_Set_ch1,
									   0, /*nSlices*/
									   0, /*nLayers*/
									   0, /*nSceneCut*/
									   nAspectRatioX_Set_ch1,
									   nAspectRatioY_Set_ch1,
									   nCropX_Set_ch1,
									   nCropY_Set_ch1,
									   nCropW_Set_ch1,
									   nCropH_Set_ch1,
									   nDstW_Set_ch1,
									   nDstH_Set_ch1 );
	
	QCAP_SET_AUDIO_RECORD_PROPERTY( m_pDevices[ 1 ],
									0,
									nAudioEncoderType_Set_ch1,
									nAudioEncoderFormat_Set_ch1 );




	CString strFullPathName;

	CString m_strFormatPath ;

	CTime time = CTime::GetCurrentTime(); 

	CString timeformat(time.Format(CString("\\CH02_%Y.%m.%d.%H.%M.%S")));

	//RECORD FILE PATH NAME
	if ( nFilePathName_ch1 ==  "AVI" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".AVI"); 
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_RECORD( m_pDevices[ 1 ], 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set_ch1, nAudioDelayTime_Set_ch1 );
		CH02_Record_FilePathName_index = 0;
	}
	else if ( nFilePathName_ch1 ==  "MP4" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".MP4"); 
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_RECORD( m_pDevices[ 1 ], 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set_ch1, nAudioDelayTime_Set_ch1 );
		CH02_Record_FilePathName_index = 1;
	}
	else if ( nFilePathName_ch1 ==  "ASF" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".ASF"); 
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_RECORD( m_pDevices[ 1 ], 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set_ch1, nAudioDelayTime_Set_ch1 );
		CH02_Record_FilePathName_index = 2;
	}
	else if ( nFilePathName_ch1 ==  "FLV" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".FLV");
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_RECORD( m_pDevices[ 1 ], 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set_ch1, nAudioDelayTime_Set_ch1 );
		CH02_Record_FilePathName_index = 3;
	}
	else if ( nFilePathName_ch1 ==  "TS" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".TS");
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_RECORD( m_pDevices[ 1 ], 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set_ch1, nAudioDelayTime_Set_ch1 );
		CH02_Record_FilePathName_index = 4;
	}
	strFullPathName.ReleaseBuffer();

	theApp.WriteProfileInt("CH02_Record_Setting","CH02_Record_FilePathName", CH02_Record_FilePathName_index);
}


void CAnimationFactoryDlg::OnBnClickedButtonStopRecord1()
{
	// TODO: Add your control notification handler code here
	m_btnRecordStart_1.EnableWindow( TRUE ); 
	m_btnRecordStop_1.EnableWindow( FALSE ); 

	if ( m_pDevices[ 1 ] != 0 )
	{
		QCAP_STOP_RECORD( m_pDevices[ 1 ], 0 );
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonStartRecord2()
{
	// TODO: Add your control notification handler code here
	m_btnShareRecordStart.EnableWindow( FALSE ); 
	m_btnShareRecordStop.EnableWindow( TRUE ); 

	CString nEncoderType, nEncoderFormat, nColorSpaceType, nRecordProfile, nRecordLevel, nRecodRecordEntropy, nRecodComplexity, nRecordMode, nBitRate, nQuality, nAudioEncoderType, nAudioEncoderFormat, nShareRecordFileName ;

	ULONG nEncoderType_Set = 0, nEncoderFormat_Set = 0, nRecordProfile_Set = 0, nRecordLevel_Set = 0, nRecodRecordEntropy_Set = 0, nRecodComplexity_Set = 0, nRecordMode_Set = 0, nBitRate_Set= 0, nQuality_Set = 0, nAudioEncoderType_Set = 0, nAudioEncoderFormat_Set = 0 ;

	m_combol_video_Share_Record_Property_EncoderType.GetWindowTextA( nEncoderType );
	m_combol_video_Share_Record_Property_EncoderFormat.GetWindowTextA( nEncoderFormat );

	m_combol_video_Share_Record_Property_RecordProfile.GetWindowTextA( nRecordProfile );
	m_combol_video_Share_Record_Property_RecordLevel.GetWindowTextA( nRecordLevel );
	m_combol_video_Share_Record_Property_RecordEntropy.GetWindowTextA( nRecodRecordEntropy );
	m_combol_video_Share_Record_Property_RecordComplexity.GetWindowTextA( nRecodComplexity );
	m_combol_video_Share_Record_Property_RecordMode.GetWindowTextA( nRecordMode );
	m_combol_video_Share_Record_Property_Quality.GetWindowTextA( nQuality );
	m_combol_video_Share_Record_Property_BitRate.GetWindowTextA( nBitRate );

	m_combol_Audio_Share_Record_Property_EncoderType.GetWindowTextA( nAudioEncoderType );
	m_combol_Audio_Share_Record_Property_EncoderFormat.GetWindowTextA( nAudioEncoderFormat );

	m_combol_Share_Record_FilePathName.GetWindowTextA( nShareRecordFileName );


	ULONG Video_Share_Record_EncoderType_index, Video_Share_Record_EncoderFormat_index, Video_Share_Record_Profile_index, Video_Share_Record_Level_index, Video_Share_Record_Entropy_index, Video_Share_Record_Complexity_index, Video_Share_Record_Mode_index, Video_Share_Record_Quality_index, Video_Share_Record_BitRate_index ;
	                                                                                     
	ULONG Audio_Share_Record_EncoderType_index, Audio_Share_Record_EncoderFormat_index, Share_Record_FilePathName_index;


	//VIDEO SHARE RECORD ENCODER TYPE
	if		( nEncoderType ==  "QCAP_ENCODER_TYPE_SOFTWARE" )			{ nEncoderType_Set = 0; Video_Share_Record_EncoderType_index = 0; }
	else if ( nEncoderType ==  "QCAP_ENCODER_TYPE_HARDWARE" )			{ nEncoderType_Set = 1; Video_Share_Record_EncoderType_index = 1; }
	else if ( nEncoderType ==  "QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK" )	{ nEncoderType_Set = 2; Video_Share_Record_EncoderType_index = 2; }
	else if ( nEncoderType ==  "QCAP_ENCODER_TYPE_NVIDIA_CUDA" )		{ nEncoderType_Set = 4; Video_Share_Record_EncoderType_index = 3; }

	theApp.WriteProfileInt("Video_Share_Record_Setting","Video_Share_Record_EncoderType", Video_Share_Record_EncoderType_index);


	//VIDEO SHARE RECORD ENCODER FORMAT
	if ( nEncoderFormat ==  "QCAP_ENCODER_FORMAT_H264" )				{ nEncoderFormat_Set = 0; Video_Share_Record_EncoderFormat_index = 0; }

	theApp.WriteProfileInt("Video_Share_Record_Setting","Video_Share_Record_EncoderFormat", Video_Share_Record_EncoderFormat_index);


	//VIDEO SHARE RECORD PROFILE
	if		( nRecordProfile ==  "QCAP_RECORD_PROFILE_BASELINE" )	{ nRecordProfile_Set = 0; Video_Share_Record_Profile_index = 0; }
	else if ( nRecordProfile ==  "QCAP_RECORD_PROFILE_MAIN" )		{ nRecordProfile_Set = 1; Video_Share_Record_Profile_index = 1; }
	else if ( nRecordProfile ==  "QCAP_RECORD_PROFILE_HIGH" )		{ nRecordProfile_Set = 2; Video_Share_Record_Profile_index = 2; }

	theApp.WriteProfileInt("Video_Share_Record_Setting","Video_Share_Record_Profile", Video_Share_Record_Profile_index);


	//VIDEO SHARE RECORD LEVEL
	if		( nRecordLevel ==  "QCAP_RECORD_LEVEL_1" )		{ nRecordLevel_Set = 10; Video_Share_Record_Level_index = 0; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_1B" )		{ nRecordLevel_Set = 9;  Video_Share_Record_Level_index = 1; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_11" )		{ nRecordLevel_Set = 11; Video_Share_Record_Level_index = 2; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_12" )		{ nRecordLevel_Set = 12; Video_Share_Record_Level_index = 3; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_13" )		{ nRecordLevel_Set = 13; Video_Share_Record_Level_index = 4; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_2" )		{ nRecordLevel_Set = 20; Video_Share_Record_Level_index = 5; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_21" )		{ nRecordLevel_Set = 21; Video_Share_Record_Level_index = 6; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_22" )		{ nRecordLevel_Set = 22; Video_Share_Record_Level_index = 7; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_3" )		{ nRecordLevel_Set = 30; Video_Share_Record_Level_index = 8; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_31" )		{ nRecordLevel_Set = 31; Video_Share_Record_Level_index = 9; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_32" )		{ nRecordLevel_Set = 32; Video_Share_Record_Level_index = 10; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_4" )		{ nRecordLevel_Set = 40; Video_Share_Record_Level_index = 11; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_41" )		{ nRecordLevel_Set = 41; Video_Share_Record_Level_index = 12; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_42" )		{ nRecordLevel_Set = 42; Video_Share_Record_Level_index = 13; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_50" )		{ nRecordLevel_Set = 50; Video_Share_Record_Level_index = 14; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_51" )		{ nRecordLevel_Set = 51; Video_Share_Record_Level_index = 15; }
	else if ( nRecordLevel ==  "QCAP_RECORD_LEVEL_52" )		{ nRecordLevel_Set = 52; Video_Share_Record_Level_index = 16; }

	theApp.WriteProfileInt("Video_Share_Record_Setting","Video_Share_Record_Level", Video_Share_Record_Level_index);


	//VIDEO SHARE RECORD ENTROPY
	if		( nRecodRecordEntropy ==  "QCAP_RECORD_ENTROPY_CAVLC" )	{ nRecodRecordEntropy_Set = 0; Video_Share_Record_Entropy_index = 0; }
	else if ( nRecodRecordEntropy ==  "QCAP_RECORD_ENTROPY_CABAC" )	{ nRecodRecordEntropy_Set = 1; Video_Share_Record_Entropy_index = 1; }

	theApp.WriteProfileInt("Video_Share_Record_Setting","Video_Share_Record_Entropy", Video_Share_Record_Entropy_index);


	//VIDEO SHARE RECORD COMPLEXITY
	if		( nRecodComplexity ==  "QCAP_RECORD_COMPLEXITY_0" )	{ nRecodComplexity_Set = 0; Video_Share_Record_Complexity_index = 0; }
	else if ( nRecodComplexity ==  "QCAP_RECORD_COMPLEXITY_1" )	{ nRecodComplexity_Set = 1; Video_Share_Record_Complexity_index = 1; }
	else if ( nRecodComplexity ==  "QCAP_RECORD_COMPLEXITY_2" )	{ nRecodComplexity_Set = 2; Video_Share_Record_Complexity_index = 2; }
	else if ( nRecodComplexity ==  "QCAP_RECORD_COMPLEXITY_3" )	{ nRecodComplexity_Set = 3; Video_Share_Record_Complexity_index = 3; }
	else if ( nRecodComplexity ==  "QCAP_RECORD_COMPLEXITY_4" )	{ nRecodComplexity_Set = 4; Video_Share_Record_Complexity_index = 4; }
	else if ( nRecodComplexity ==  "QCAP_RECORD_COMPLEXITY_5" )	{ nRecodComplexity_Set = 5; Video_Share_Record_Complexity_index = 5; }
	else if ( nRecodComplexity ==  "QCAP_RECORD_COMPLEXITY_6" )	{ nRecodComplexity_Set = 6; Video_Share_Record_Complexity_index = 6; }

	theApp.WriteProfileInt("Video_Share_Record_Setting","Video_Share_Record_Complexity", Video_Share_Record_Complexity_index);


	//VIDEO SHARE RECORD MODE
	if		( nRecordMode ==  "QCAP_RECORD_MODE_VBR" )	{ nRecordMode_Set = 0; Video_Share_Record_Mode_index = 0; }
	else if ( nRecordMode ==  "QCAP_RECORD_MODE_CBR" )	{ nRecordMode_Set = 1; Video_Share_Record_Mode_index = 1; }
	else if ( nRecordMode ==  "QCAP_RECORD_MODE_ABR" )	{ nRecordMode_Set = 2; Video_Share_Record_Mode_index = 2; }

	theApp.WriteProfileInt("Video_Share_Record_Setting","Video_Share_Record_Mode", Video_Share_Record_Mode_index);


	//VIDEO SHARE RECORD QUALITY
	if      ( nQuality ==  "QCAP_RECORD_QUALITY  1000" )	{ nQuality_Set = 1000; Video_Share_Record_Quality_index = 0; }
	else if ( nQuality ==  "QCAP_RECORD_QUALITY  2000" )	{ nQuality_Set = 2000; Video_Share_Record_Quality_index = 1; }	 
	else if ( nQuality ==  "QCAP_RECORD_QUALITY  3000" )	{ nQuality_Set = 3000; Video_Share_Record_Quality_index = 2; }
	else if ( nQuality ==  "QCAP_RECORD_QUALITY  4000" )	{ nQuality_Set = 4000; Video_Share_Record_Quality_index = 3; }
	else if ( nQuality ==  "QCAP_RECORD_QUALITY  5000" )	{ nQuality_Set = 5000; Video_Share_Record_Quality_index = 4; }
	else if ( nQuality ==  "QCAP_RECORD_QUALITY  6000" )	{ nQuality_Set = 6000; Video_Share_Record_Quality_index = 5; }
	else if ( nQuality ==  "QCAP_RECORD_QUALITY  7000" )	{ nQuality_Set = 7000; Video_Share_Record_Quality_index = 6; }
	else if ( nQuality ==  "QCAP_RECORD_QUALITY  8000" )	{ nQuality_Set = 8000; Video_Share_Record_Quality_index = 7; }
	else if ( nQuality ==  "QCAP_RECORD_QUALITY  9000" )	{ nQuality_Set = 9000; Video_Share_Record_Quality_index = 8; }
	else if ( nQuality ==  "QCAP_RECORD_QUALITY  10000" )	{ nQuality_Set = 10000; Video_Share_Record_Quality_index = 9; }

	theApp.WriteProfileInt("Video_Share_Record_Setting","Video_Share_Record_Quality", Video_Share_Record_Quality_index);


	//VIDEO SHARE RECORD BITRATE
	if      ( nBitRate ==  "QCAP_RECORD_BITRATE 16MBPS" )	{ nBitRate_Set = 16*1024*1024; Video_Share_Record_BitRate_index = 0; }
	else if ( nBitRate ==  "QCAP_RECORD_BITRATE 12MBPS" )	{ nBitRate_Set = 12*1024*1024; Video_Share_Record_BitRate_index = 1; }
	else if ( nBitRate ==  "QCAP_RECORD_BITRATE 8MBPS" )	{ nBitRate_Set = 8*1024*1024;  Video_Share_Record_BitRate_index = 2; }
	else if ( nBitRate ==  "QCAP_RECORD_BITRATE 6MBPS" )	{ nBitRate_Set = 6*1024*1024;  Video_Share_Record_BitRate_index = 3; }
	else if ( nBitRate ==  "QCAP_RECORD_BITRATE 4MBPS" )	{ nBitRate_Set = 4*1024*1024;  Video_Share_Record_BitRate_index = 4; }
	else if ( nBitRate ==  "QCAP_RECORD_BITRATE 2MBPS" )	{ nBitRate_Set = 2*1024*1024;  Video_Share_Record_BitRate_index = 5; }
	else if ( nBitRate ==  "QCAP_RECORD_BITRATE 1MBPS" )	{ nBitRate_Set = 1*1024*1024;  Video_Share_Record_BitRate_index = 6; }
	else if ( nBitRate ==  "QCAP_RECORD_BITRATE 512KBPS" )	{ nBitRate_Set = 1*512*1024;   Video_Share_Record_BitRate_index = 7; }

	theApp.WriteProfileInt("Video_Share_Record_Setting","Video_Share_Record_BitRate", Video_Share_Record_BitRate_index);


	//AUDIO SHARE RECORD ENCODERFORMAT
	if ( nAudioEncoderType ==  "QCAP_ENCODER_TYPE_SOFTWARE" )			{ nAudioEncoderType_Set = 0; }

	if		( nAudioEncoderFormat ==  "QCAP_ENCODER_FORMAT_PCM" )		{ nAudioEncoderFormat_Set = 0; Audio_Share_Record_EncoderFormat_index = 0; }
	else if ( nAudioEncoderFormat ==  "QCAP_ENCODER_FORMAT_AAC" )		{ nAudioEncoderFormat_Set = 1; Audio_Share_Record_EncoderFormat_index = 1; }
	else if ( nAudioEncoderFormat ==  "QCAP_ENCODER_FORMAT_AAC_ADTS" )	{ nAudioEncoderFormat_Set = 2; Audio_Share_Record_EncoderFormat_index = 2; }

	theApp.WriteProfileInt("Audio_Share_Record_Setting","Audio_Share_Record_EncoderFormat", Audio_Share_Record_EncoderFormat_index);


	CString nAspectRatioX, nGOP, nAspectRatioY, nBFrame, nInterleaved, nVideoDelayTime, nAudioDelayTime ;

	BOOL ShareRecordThumbDRAW = FALSE, ShareRecordAspect_Ratio = FALSE ;

	//VIDEO SHARE RECORD EDIT PROPERTY
	m_edit_Video_Share_Record_Proerty_AspectRatio_X.GetWindowTextA( nAspectRatioX );
	ULONG nAspectRatioX_Set = atoi(nAspectRatioX);
		
	m_edit_Video_Share_Record_Proerty_AspectRatio_Y.GetWindowTextA( nAspectRatioY );
	ULONG nAspectRatioY_Set =  atoi(nAspectRatioY);

	m_edit_Video_Share_Record_Proerty_GOP.GetWindowTextA( nGOP );
	ULONG nGOP_Set = atoi(nGOP);

	m_edit_Video_Share_Record_Proerty_BFrame.GetWindowTextA( nBFrame );
	ULONG nBFrame_Set = atoi(nBFrame);

	m_edit_Video_Share_Record_Proerty_Interleaved.GetWindowTextA( nInterleaved );
	ULONG nInterleaved_Set = atoi(nInterleaved);

	ShareRecordThumbDRAW = m_checkShareRecordThumbDRAW.GetCheck();
	ShareRecordAspect_Ratio = m_checkShareRecordMaintain_Aspect_Ratio.GetCheck();

	m_edit_Share_Record_Video_Delay_Time.GetWindowTextA( nVideoDelayTime );
	double nVideoDelayTime_Set =  atof(nVideoDelayTime);

	m_edit_Share_Record_Audio_Delay_Time.GetWindowTextA( nAudioDelayTime );
	double nAudioDelayTime_Set =  atof(nAudioDelayTime);

	// INITIALIZE ANIMATION RESOURCE
	// 
	if ( m_pClip == NULL ) {QCAP_CREATE_ANIMATION_CLIP( "EXAMPLE.PIP.XML", &m_pClip, &m_nClipFrames, &m_nClipSprites, &m_nClipColorSpaceType, &m_nClipWidth, &m_nClipHeight ); }
	
	m_iClipCurrentFrame = m_nClipFrames - 1;

	if( m_pClip ) {

		QCAP_START_ANIMATION_CLIP( m_pClip );

		if( m_pDevices[ 0 ] != 0 ) { QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClip, 0, m_pDevices[ 0 ] ); }

		if( m_pDevices[ 1 ] != 0 ) { QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClip, 1, m_pDevices[ 1 ] ); }

	}
	else {

		return ;
	}

	// INITIALIZE SHARE RECORDING RESOURCE
	// 
	QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY_EX(0,
											nEncoderType_Set,
											nEncoderFormat_Set,
											QCAP_COLORSPACE_TYEP_YUY2, 
											m_nClipWidth,
											m_nClipHeight,
											nGOP_Set,
											nRecordProfile_Set,
											nRecordLevel_Set,
											nRecodRecordEntropy_Set,
											nRecodComplexity_Set,
											nRecordMode_Set,
											nQuality_Set,
											nBitRate_Set,
											nGOP_Set,
											nBFrame_Set,
											nInterleaved_Set,
											0, /*nSlices*/
											0, /*nLayers*/
											0, /*nSceneCut*/
											nAspectRatioX_Set,
											nAspectRatioY_Set,
											m_statShareWindow.m_hWnd,
											ShareRecordThumbDRAW,
											ShareRecordAspect_Ratio );

	
	QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY(0,
										 nAudioEncoderType_Set,
										 nAudioEncoderFormat_Set,
										 2,
										 16,
										 48000,
										 50);


	CString strFullPathName;

	CString m_strFormatPath ;

	CTime time = CTime::GetCurrentTime(); 

	CString timeformat(time.Format(CString("\\SHARERECORD_%Y.%m.%d.%H.%M.%S")));

	//RECORD FILE PATH NAME
	if ( nShareRecordFileName ==  "AVI" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".AVI"); 
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_SHARE_RECORD( 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set, nAudioDelayTime_Set );
		Share_Record_FilePathName_index = 0;
	}
	else if ( nShareRecordFileName ==  "MP4" )	{
		strFullPathName =  m_strRecordPath + timeformat + _T(".MP4"); 
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_SHARE_RECORD( 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set, nAudioDelayTime_Set );
		Share_Record_FilePathName_index = 1;
	}
	else if ( nShareRecordFileName ==  "ASF" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".ASF"); 
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_SHARE_RECORD( 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set, nAudioDelayTime_Set );
		Share_Record_FilePathName_index = 2;
	}
	else if ( nShareRecordFileName ==  "FLV" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".FLV");
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_SHARE_RECORD( 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set, nAudioDelayTime_Set );
		Share_Record_FilePathName_index = 3;
	}
	else if ( nShareRecordFileName==  "TS" )	{ 
		strFullPathName = m_strRecordPath + timeformat + _T(".TS");
		ULONG nStrlen = strFullPathName.GetLength();
		CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );
		QCAP_START_SHARE_RECORD( 0, psz, QCAP_RECORD_FLAG_FULL, nVideoDelayTime_Set, nAudioDelayTime_Set );
		Share_Record_FilePathName_index = 4;
	
	}

	EnterCriticalSection( &m_hShareRecordAccessCriticalSection );

	m_nShareRecordState = 0x00000001;

	LeaveCriticalSection( &m_hShareRecordAccessCriticalSection );
	
	strFullPathName.ReleaseBuffer();

	theApp.WriteProfileInt("Share_Record_Setting","Share_Record_FilePathName", Share_Record_FilePathName_index);

	m_btnVirtualCameraStart.EnableWindow( TRUE ); 
	m_btnVirtualCameraStop.EnableWindow( TRUE ); 

}


void CAnimationFactoryDlg::OnBnClickedButtonStopRecord2()
{
	// TODO: Add your control notification handler code here
	m_btnShareRecordStart.EnableWindow( TRUE ); 
	m_btnShareRecordStop.EnableWindow( FALSE ); 

	// UNINITIALIZE SHARE RECORDING
	//
	EnterCriticalSection( &m_hShareRecordAccessCriticalSection );

	m_nShareRecordState = 0x00000000;

	LeaveCriticalSection( &m_hShareRecordAccessCriticalSection );

	QCAP_STOP_SHARE_RECORD( 0 );

	// UNINITIALIZE ANIMATION CLIP
	//
	if( m_pClip ) {

		QCAP_STOP_ANIMATION_CLIP( m_pClip );

		QCAP_DESTROY_ANIMATION_CLIP( m_pClip );

		m_pClip = NULL;
	}

	m_btnVirtualCameraStart.EnableWindow( FALSE ); 
	m_btnVirtualCameraStop.EnableWindow( FALSE ); 
}


void CAnimationFactoryDlg::OnBnClickedButtonOsdPicture2()
{
	// TODO: Add your control notification handler code here

	// SELECT THE ACTION SCRIPT FILE
	//
	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "XML\0*.XML\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	QCAP_CREATE_ANIMATION_CLIP( (CHAR *)(LPCSTR)psz, &m_pClip, &m_nClipFrames, &m_nClipSprites, &m_nClipColorSpaceType, &m_nClipWidth, &m_nClipHeight );

}


void CAnimationFactoryDlg::OnBnClickedButtonStartServer0()
{
	// TODO: Add your control notification handler code here
	
	m_btnBroadcastServerStart_0.EnableWindow( FALSE ); 
	m_btnBroadcastServerStop_0.EnableWindow( TRUE ); 

	CString nEncoderType_ch0, nEncoderFormat_ch0, nColorSpaceType_ch0, nRecordProfile_ch0, nRecordLevel_ch0, nRecodRecordEntropy_ch0, nRecodComplexity_ch0, nRecordMode_ch0, nBitRate_ch0, nQuality_ch0, nAudioEncoderType_ch0, nAudioEncoderFormat_ch0, nServerTypeSelect_ch0 ;

	ULONG nEncoderType_Set_ch0 = 0, nEncoderFormat_Set_ch0 = 0, nRecordProfile_Set_ch0 = 0, nRecordLevel_Set_ch0 = 0, nRecodRecordEntropy_Set_ch0 = 0, nRecodComplexity_Set_ch0 = 0, nRecordMode_Set_ch0 = 0, nBitRate_Set_ch0= 0, nQuality_Set_ch0 = 0, nAudioEncoderType_Set_ch0 = 0, nAudioEncoderFormat_Set_ch0 = 0 ;

	m_combol_video_Broadcast_Server_Property_EncoderType_0.GetWindowTextA( nEncoderType_ch0 );
	m_combol_video_Broadcast_Server_Property_EncoderFormat_0.GetWindowTextA( nEncoderFormat_ch0 );

	m_combol_video_Broadcast_Server_Property_RecordProfile_0.GetWindowTextA( nRecordProfile_ch0 );
	m_combol_video_Broadcast_Server_Property_RecordLevel_0.GetWindowTextA( nRecordLevel_ch0 );
	m_combol_video_Broadcast_Server_Property_RecordEntropy_0.GetWindowTextA( nRecodRecordEntropy_ch0 );
	m_combol_video_Broadcast_Server_Property_RecordComplexity_0.GetWindowTextA( nRecodComplexity_ch0 );
	m_combol_video_Broadcast_Server_Property_RecordMode_0.GetWindowTextA( nRecordMode_ch0 );
	m_combol_video_Broadcast_Server_Property_Quality_0.GetWindowTextA( nQuality_ch0 );
	m_combol_video_Broadcast_Server_Property_BitRate_0.GetWindowTextA( nBitRate_ch0 );

	m_combol_Audio_Broadcast_Server_Property_EncoderType_0.GetWindowTextA( nAudioEncoderType_ch0 );
	m_combol_Audio_Broadcast_Server_Property_EncoderFormat_0.GetWindowTextA( nAudioEncoderFormat_ch0 );

	m_combol_Broadcast_Server_Type_Select_0.GetWindowTextA( nServerTypeSelect_ch0 );
	
	ULONG CH01_Vdieo_Broadcast_EncoderType_index, CH01_Vdieo_Broadcast_EncoderFormat_index, CH01_Vdieo_Broadcast_Profile_index, CH01_Vdieo_Broadcast_Level_index, CH01_Vdieo_Broadcast_Entropy_index, CH01_Vdieo_Broadcast_Complexity_index, CH01_Vdieo_Broadcast_Mode_index, CH01_Vdieo_Broadcast_Quality_index, CH01_Vdieo_Broadcast_BitRate_index ;
	                                                                                     
	ULONG CH01_Audio_Broadcast_EncoderType_index, CH01_Audio_Broadcast_EncoderFormat_index, CH01_Broadcast_Select_index;

	//VIDEO BROADCAST SERVER ENCODER TYPE
	if		( nEncoderType_ch0 ==  "QCAP_ENCODER_TYPE_SOFTWARE" )			{ nEncoderType_Set_ch0 = 0; CH01_Vdieo_Broadcast_EncoderType_index = 0; }
	else if ( nEncoderType_ch0 ==  "QCAP_ENCODER_TYPE_HARDWARE" )			{ nEncoderType_Set_ch0 = 1; CH01_Vdieo_Broadcast_EncoderType_index = 1; }                                                                                                                                                                                                                                                                                               
	else if ( nEncoderType_ch0 ==  "QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK" )	{ nEncoderType_Set_ch0 = 2; CH01_Vdieo_Broadcast_EncoderType_index = 2; }
	else if ( nEncoderType_ch0 ==  "QCAP_ENCODER_TYPE_NVIDIA_CUDA" )		{ nEncoderType_Set_ch0 = 4; CH01_Vdieo_Broadcast_EncoderType_index = 3; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_EncoderType", CH01_Vdieo_Broadcast_EncoderType_index);


	//VIDEO BROADCAST SERVER ENCODER FORMAT
	if ( nEncoderFormat_ch0 ==  "QCAP_ENCODER_FORMAT_H264" )			{ nEncoderFormat_Set_ch0 = 0; CH01_Vdieo_Broadcast_EncoderFormat_index = 0; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_EncoderFormat", CH01_Vdieo_Broadcast_EncoderFormat_index);


	//VIDEO BROADCAST SERVER PROFILE
	if		( nRecordProfile_ch0 ==  "QCAP_RECORD_PROFILE_BASELINE" )	{ nRecordProfile_Set_ch0 = 0; CH01_Vdieo_Broadcast_Profile_index = 0; }
	else if ( nRecordProfile_ch0 ==  "QCAP_RECORD_PROFILE_MAIN" )		{ nRecordProfile_Set_ch0 = 1; CH01_Vdieo_Broadcast_Profile_index = 1; }
	else if ( nRecordProfile_ch0 ==  "QCAP_RECORD_PROFILE_HIGH" )		{ nRecordProfile_Set_ch0 = 2; CH01_Vdieo_Broadcast_Profile_index = 2; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_Profile", CH01_Vdieo_Broadcast_Profile_index);


	//VIDEO BROADCAST SERVER LEVEL
	if		( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_1" )		{ nRecordLevel_Set_ch0 = 10; CH01_Vdieo_Broadcast_Level_index = 0; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_1B" )		{ nRecordLevel_Set_ch0 = 9;  CH01_Vdieo_Broadcast_Level_index = 1; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_11" )		{ nRecordLevel_Set_ch0 = 11; CH01_Vdieo_Broadcast_Level_index = 2; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_12" )		{ nRecordLevel_Set_ch0 = 12; CH01_Vdieo_Broadcast_Level_index = 3; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_13" )		{ nRecordLevel_Set_ch0 = 13; CH01_Vdieo_Broadcast_Level_index = 4; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_2" )		{ nRecordLevel_Set_ch0 = 20; CH01_Vdieo_Broadcast_Level_index = 5; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_21" )		{ nRecordLevel_Set_ch0 = 21; CH01_Vdieo_Broadcast_Level_index = 6; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_22" )		{ nRecordLevel_Set_ch0 = 22; CH01_Vdieo_Broadcast_Level_index = 7; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_3" )		{ nRecordLevel_Set_ch0 = 30; CH01_Vdieo_Broadcast_Level_index = 8; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_31" )		{ nRecordLevel_Set_ch0 = 31; CH01_Vdieo_Broadcast_Level_index = 9; }
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_32" )		{ nRecordLevel_Set_ch0 = 32; CH01_Vdieo_Broadcast_Level_index = 10;}
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_4" )		{ nRecordLevel_Set_ch0 = 40; CH01_Vdieo_Broadcast_Level_index = 11;}
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_41" )		{ nRecordLevel_Set_ch0 = 41; CH01_Vdieo_Broadcast_Level_index = 12;}
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_42" )		{ nRecordLevel_Set_ch0 = 42; CH01_Vdieo_Broadcast_Level_index = 13;}
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_50" )		{ nRecordLevel_Set_ch0 = 50; CH01_Vdieo_Broadcast_Level_index = 14;}
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_51" )		{ nRecordLevel_Set_ch0 = 51; CH01_Vdieo_Broadcast_Level_index = 15;}
	else if ( nRecordLevel_ch0 ==  "QCAP_RECORD_LEVEL_52" )		{ nRecordLevel_Set_ch0 = 52; CH01_Vdieo_Broadcast_Level_index = 16;}

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_Level", CH01_Vdieo_Broadcast_Level_index);


	//VIDEO BROADCAST SERVER ENTROPY
	if		( nRecodRecordEntropy_ch0 ==  "QCAP_RECORD_ENTROPY_CAVLC" )	{ nRecodRecordEntropy_Set_ch0 = 0; CH01_Vdieo_Broadcast_Entropy_index = 0; }
	else if ( nRecodRecordEntropy_ch0 ==  "QCAP_RECORD_ENTROPY_CABAC" )	{ nRecodRecordEntropy_Set_ch0 = 1; CH01_Vdieo_Broadcast_Entropy_index = 1; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_Entropy", CH01_Vdieo_Broadcast_Entropy_index);


	//VIDEO BROADCAST SERVER COMPLEXITY
	if		( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_0" )	{ nRecodComplexity_Set_ch0 = 0; CH01_Vdieo_Broadcast_Complexity_index = 0; }
	else if ( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_1" )	{ nRecodComplexity_Set_ch0 = 1; CH01_Vdieo_Broadcast_Complexity_index = 1; }
	else if ( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_2" )	{ nRecodComplexity_Set_ch0 = 2; CH01_Vdieo_Broadcast_Complexity_index = 2; }
	else if ( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_3" )	{ nRecodComplexity_Set_ch0 = 3; CH01_Vdieo_Broadcast_Complexity_index = 3; }
	else if ( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_4" )	{ nRecodComplexity_Set_ch0 = 4; CH01_Vdieo_Broadcast_Complexity_index = 4; }
	else if ( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_5" )	{ nRecodComplexity_Set_ch0 = 5; CH01_Vdieo_Broadcast_Complexity_index = 5; }
	else if ( nRecodComplexity_ch0 ==  "QCAP_RECORD_COMPLEXITY_6" )	{ nRecodComplexity_Set_ch0 = 6; CH01_Vdieo_Broadcast_Complexity_index = 6; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_Complexity", CH01_Vdieo_Broadcast_Complexity_index);


	//VIDEO BROADCAST SERVER MODE
	if		( nRecordMode_ch0 ==  "QCAP_RECORD_MODE_VBR" )	{ nRecordMode_Set_ch0 = 0; CH01_Vdieo_Broadcast_Mode_index = 0; }
	else if ( nRecordMode_ch0 ==  "QCAP_RECORD_MODE_CBR" )	{ nRecordMode_Set_ch0 = 1; CH01_Vdieo_Broadcast_Mode_index = 1; }
	else if ( nRecordMode_ch0 ==  "QCAP_RECORD_MODE_ABR" )	{ nRecordMode_Set_ch0 = 2; CH01_Vdieo_Broadcast_Mode_index = 2; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_Mode", CH01_Vdieo_Broadcast_Mode_index);


	//VIDEO BROADCAST SERVER QUALITY
	if      ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  1000" )	{ nQuality_Set_ch0 = 1000; CH01_Vdieo_Broadcast_Quality_index = 0; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  2000" )	{ nQuality_Set_ch0 = 2000; CH01_Vdieo_Broadcast_Quality_index = 1; }	 
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  3000" )	{ nQuality_Set_ch0 = 3000; CH01_Vdieo_Broadcast_Quality_index = 2; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  4000" )	{ nQuality_Set_ch0 = 4000; CH01_Vdieo_Broadcast_Quality_index = 3; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  5000" )	{ nQuality_Set_ch0 = 5000; CH01_Vdieo_Broadcast_Quality_index = 4; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  6000" )	{ nQuality_Set_ch0 = 6000; CH01_Vdieo_Broadcast_Quality_index = 5; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  7000" )	{ nQuality_Set_ch0 = 7000; CH01_Vdieo_Broadcast_Quality_index = 6; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  8000" )	{ nQuality_Set_ch0 = 8000; CH01_Vdieo_Broadcast_Quality_index = 7; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  9000" )	{ nQuality_Set_ch0 = 9000; CH01_Vdieo_Broadcast_Quality_index = 8; }
	else if ( nQuality_ch0 ==  "QCAP_RECORD_QUALITY  10000" )	{ nQuality_Set_ch0 = 10000; CH01_Vdieo_Broadcast_Quality_index = 9; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_Quality", CH01_Vdieo_Broadcast_Quality_index);


	//VIDEO BROADCAST SERVER BITRATE
	if      ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 16MBPS" )	{ nBitRate_Set_ch0 = 16*1024*1024; CH01_Vdieo_Broadcast_BitRate_index = 0; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 12MBPS" )	{ nBitRate_Set_ch0 = 12*1024*1024; CH01_Vdieo_Broadcast_BitRate_index = 1; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 8MBPS" )	{ nBitRate_Set_ch0 = 8*1024*1024;  CH01_Vdieo_Broadcast_BitRate_index = 2; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 6MBPS" )	{ nBitRate_Set_ch0 = 6*1024*1024;  CH01_Vdieo_Broadcast_BitRate_index = 3; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 4MBPS" )	{ nBitRate_Set_ch0 = 4*1024*1024;  CH01_Vdieo_Broadcast_BitRate_index = 4; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 2MBPS" )	{ nBitRate_Set_ch0 = 2*1024*1024;  CH01_Vdieo_Broadcast_BitRate_index = 5; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 1MBPS" )	{ nBitRate_Set_ch0 = 1*1024*1024;  CH01_Vdieo_Broadcast_BitRate_index = 6; }
	else if ( nBitRate_ch0 ==  "QCAP_RECORD_BITRATE 512KBPS" )	{ nBitRate_Set_ch0 = 1*512*1024;   CH01_Vdieo_Broadcast_BitRate_index = 7; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH01_Video_Broadcast_Server_BitRate", CH01_Vdieo_Broadcast_BitRate_index);


	//AUDIO BROADCAST SERVER ENCODERFORMAT
	if ( nAudioEncoderType_ch0 ==  "QCAP_ENCODER_TYPE_SOFTWARE" )			{ nAudioEncoderType_Set_ch0 = 0; CH01_Audio_Broadcast_EncoderType_index = 0; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH01_Audio_Broadcast_Server_EncoderType", CH01_Audio_Broadcast_EncoderType_index);


	if		( nAudioEncoderFormat_ch0 ==  "QCAP_ENCODER_FORMAT_PCM" )		{ nAudioEncoderFormat_Set_ch0 = 0; CH01_Audio_Broadcast_EncoderFormat_index = 0; }
	else if ( nAudioEncoderFormat_ch0 ==  "QCAP_ENCODER_FORMAT_AAC" )		{ nAudioEncoderFormat_Set_ch0 = 1; CH01_Audio_Broadcast_EncoderFormat_index = 1; }
	else if ( nAudioEncoderFormat_ch0 ==  "QCAP_ENCODER_FORMAT_AAC_ADTS" )	{ nAudioEncoderFormat_Set_ch0 = 2; CH01_Audio_Broadcast_EncoderFormat_index = 2; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH01_Audio_Broadcast_Server_EncoderFormat", CH01_Audio_Broadcast_EncoderFormat_index);


	CString nAspectRatioX_ch0, nGOP_ch0, nAspectRatioY_ch0, nBFrame_ch0, nInterleaved_ch0, nURL ;

	CString strWebServerRootFolder = "C:\\AppServ\\www\\", strSubFolder = "hls1\\";

	//VIDEO BROADCAST SERVER SET PROPERTY
	m_edit_Video_Broadcast_Server_Proerty_AspectRatio_X_0.GetWindowTextA( nAspectRatioX_ch0 );
	ULONG nAspectRatioX_Set_ch0 = atoi(nAspectRatioX_ch0);
	
	m_edit_Video_Broadcast_Server_Proerty_AspectRatio_Y_0.GetWindowTextA( nAspectRatioY_ch0 );
	ULONG nAspectRatioY_Set_ch0 =  atoi(nAspectRatioY_ch0);

	m_edit_Video_Broadcast_Server_Proerty_GOP_0.GetWindowTextA( nGOP_ch0 );
	ULONG nGOP_Set_ch0 = atoi(nGOP_ch0);
	
	m_edit_Video_Broadcast_Server_Proerty_BFrame_0.GetWindowTextA( nBFrame_ch0 );
	ULONG nBFrame_Set_ch0 = atoi(nBFrame_ch0);
	
	m_edit_Video_Record_Proerty_Interleaved_0.GetWindowTextA( nInterleaved_ch0 );
	ULONG nInterleaved_Set_ch0 =  atoi(nInterleaved_ch0);
	
	//[2013.11.28 BUG]
	//m_edit_URL_ADDRESS_0.GetWindowTextA( (CHAR*)(LPCSTR)nURL, 1024 );

	m_edit_URL_ADDRESS_0.GetWindowTextA( nURL );

	m_bThumbDRAW_0 = m_checkThumbDRAW_0.GetCheck();
	m_bMaintain_Aspect_Ratio_0 = m_checkMaintain_Aspect_Ratio_0.GetCheck();
	
	//SERVER TYPE SELECT
	if ( nServerTypeSelect_ch0 ==  "RTSP SERVER" )	{  
		QCAP_CREATE_BROADCAST_RTSP_SERVER( 0, 1, &m_hNetworkServer[ 0 ], "root", "root", 554, 8080 );
		//QCAP_CREATE_BROADCAST_RTSP_SERVER( 0, 2, &m_hNetworkServer[ 0 ], "root", "root", 3000, 8080 );
		CH01_Broadcast_Select_index = 0;
	}
	else if ( nServerTypeSelect_ch0 ==  "RTMP SERVER" )	{ 
		QCAP_CREATE_BROADCAST_RTMP_SERVER( 0, 1, &m_hNetworkServer[ 0 ], NULL, NULL, 1935, 8080);
		CH01_Broadcast_Select_index = 1;
	}
	else if ( nServerTypeSelect_ch0 ==  "RTMP WEB PORTAL SERVER" )	{ 
		QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER( 0, (CHAR*)(LPCSTR)nURL, &m_hNetworkServer[ 0 ] );
		CH01_Broadcast_Select_index = 2;
	}
	else if ( nServerTypeSelect_ch0 ==  "HLS SERVER" )	{ 
		QCAP_CREATE_BROADCAST_HLS_SERVER( 0, 1, &m_hNetworkServer[ 0 ], (CHAR *)(LPCSTR)(strWebServerRootFolder), (CHAR *)(LPCSTR)(strSubFolder) );
		CH01_Broadcast_Select_index = 3;
	}

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH01_Broadcast_Server_Select", CH01_Broadcast_Select_index);


	//FPS
	//
	double fps_CH0 = m_dDeviceVideoFrameRates[ 0 ];

	if( m_bDeviceVideoIsInterleaved[ 0 ] == TRUE ) {

		fps_CH0 /= 2;
	}

	//QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[ 0 ], 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, 30, QCAP_RECORD_MODE_CBR, 8000, 12*1024*1024, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY_EX( m_hNetworkServer[ 0 ], 
												 0, 
												 nEncoderType_Set_ch0,
												 nEncoderFormat_Set_ch0,
												 QCAP_COLORSPACE_TYEP_YUY2,
												 m_nDeviceVideoWidths[ 0 ],
												 m_nDeviceVideoHeights[ 0 ],
												 fps_CH0, 
												 nRecordProfile_Set_ch0,
												 nRecordLevel_Set_ch0,
												 nRecodRecordEntropy_Set_ch0,
												 nRecodComplexity_Set_ch0,
												 nRecordMode_Set_ch0,
												 nQuality_Set_ch0,
												 nBitRate_Set_ch0,
												 nGOP_Set_ch0,
												 nBFrame_Set_ch0,
												 nInterleaved_Set_ch0,
												 0, /*nSlices*/
												 0, /*nLayers*/
												 0, /*nSceneCut*/
												 nAspectRatioX_Set_ch0,
												 nAspectRatioY_Set_ch0,
												 NULL,
												 m_bThumbDRAW_0,
												 m_bMaintain_Aspect_Ratio_0,
												 QCAP_BROADCAST_FLAG_FULL);
	

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[ 0 ], 
											  0, 
											  nAudioEncoderType_Set_ch0, 
											  nAudioEncoderFormat_Set_ch0, 
											  2, 
											  16, 
											  48000, 
											  100 );
	
	QCAP_START_BROADCAST_SERVER( m_hNetworkServer[ 0 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	m_nNetworkServerStates[ 0 ] = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

}


void CAnimationFactoryDlg::OnBnClickedButtonStopServer0()
{
	// TODO: Add your control notification handler code here
	m_btnBroadcastServerStart_0.EnableWindow( TRUE ); 
	m_btnBroadcastServerStop_0.EnableWindow( FALSE ); 
		
	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	m_nNetworkServerStates[ 0 ] = 0x00000000;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections[ 0 ] );

	if ( m_hNetworkServer[ 0 ] != NULL )
	{
		QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer[ 0 ] );

		QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer[ 0 ] );

		m_hNetworkServer[ 0 ] = NULL;
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonStartServer1()
{
	// TODO: Add your control notification handler code here
	m_btnBroadcastServerStart_1.EnableWindow( FALSE ); 
	m_btnBroadcastServerStop_1.EnableWindow( TRUE ); 

	CString nEncoderType_ch1, nEncoderFormat_ch1, nColorSpaceType_ch1, nRecordProfile_ch1, nRecordLevel_ch1, nRecodRecordEntropy_ch1, nRecodComplexity_ch1, nRecordMode_ch1, nBitRate_ch1, nQuality_ch1, nAudioEncoderType_ch1, nAudioEncoderFormat_ch1, nServerTypeSelect_ch1 ;

	ULONG nEncoderType_Set_ch1 = 0, nEncoderFormat_Set_ch1 = 0, nRecordProfile_Set_ch1 = 0, nRecordLevel_Set_ch1 = 0, nRecodRecordEntropy_Set_ch1 = 0, nRecodComplexity_Set_ch1 = 0, nRecordMode_Set_ch1 = 0, nBitRate_Set_ch1 = 0, nQuality_Set_ch1 = 0, nAudioEncoderType_Set_ch1 = 0, nAudioEncoderFormat_Set_ch1 = 0 ;

	m_combol_video_Broadcast_Server_Property_EncoderType_1.GetWindowTextA( nEncoderType_ch1 );
	m_combol_video_Broadcast_Server_Property_EncoderFormat_1.GetWindowTextA( nEncoderFormat_ch1 );

	m_combol_video_Broadcast_Server_Property_RecordProfile_1.GetWindowTextA( nRecordProfile_ch1 );
	m_combol_video_Broadcast_Server_Property_RecordLevel_1.GetWindowTextA( nRecordLevel_ch1 );
	m_combol_video_Broadcast_Server_Property_RecordEntropy_1.GetWindowTextA( nRecodRecordEntropy_ch1 );
	m_combol_video_Broadcast_Server_Property_RecordComplexity_1.GetWindowTextA( nRecodComplexity_ch1 );
	m_combol_video_Broadcast_Server_Property_RecordMode_1.GetWindowTextA( nRecordMode_ch1 );
	m_combol_video_Broadcast_Server_Property_Quality_1.GetWindowTextA( nQuality_ch1 );
	m_combol_video_Broadcast_Server_Property_BitRate_1.GetWindowTextA( nBitRate_ch1 );

	m_combol_Audio_Broadcast_Server_Property_EncoderType_1.GetWindowTextA( nAudioEncoderType_ch1 );
	m_combol_Audio_Broadcast_Server_Property_EncoderFormat_1.GetWindowTextA( nAudioEncoderFormat_ch1 );

	m_combol_Broadcast_Server_Type_Select_1.GetWindowTextA( nServerTypeSelect_ch1 );

	ULONG CH02_Vdieo_Broadcast_EncoderType_index, CH02_Vdieo_Broadcast_EncoderFormat_index, CH02_Vdieo_Broadcast_Profile_index, CH02_Vdieo_Broadcast_Level_index, CH02_Vdieo_Broadcast_Entropy_index, CH02_Vdieo_Broadcast_Complexity_index, CH02_Vdieo_Broadcast_Mode_index, CH02_Vdieo_Broadcast_Quality_index, CH02_Vdieo_Broadcast_BitRate_index ;
	                                                                                     
	ULONG CH02_Audio_Broadcast_EncoderType_index, CH02_Audio_Broadcast_EncoderFormat_index, CH02_Broadcast_Select_index;

	//VIDEO BROADCAST SERVER ENCODER TYPE
	if		( nEncoderType_ch1 ==  "QCAP_ENCODER_TYPE_SOFTWARE" )			{ nEncoderType_Set_ch1 = 0; CH02_Vdieo_Broadcast_EncoderType_index = 0; }
	else if ( nEncoderType_ch1 ==  "QCAP_ENCODER_TYPE_HARDWARE" )			{ nEncoderType_Set_ch1 = 1; CH02_Vdieo_Broadcast_EncoderType_index = 1; }
	else if ( nEncoderType_ch1 ==  "QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK" )	{ nEncoderType_Set_ch1 = 2; CH02_Vdieo_Broadcast_EncoderType_index = 2; }
	else if ( nEncoderType_ch1 ==  "QCAP_ENCODER_TYPE_NVIDIA_CUDA" )		{ nEncoderType_Set_ch1 = 4; CH02_Vdieo_Broadcast_EncoderType_index = 3; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_EncoderType", CH02_Vdieo_Broadcast_EncoderType_index);


	//VIDEO BROADCAST SERVER ENCODER FORMAT
	if ( nEncoderFormat_ch1 ==  "QCAP_ENCODER_FORMAT_H264" )			{ nEncoderFormat_Set_ch1 = 0; CH02_Vdieo_Broadcast_EncoderFormat_index = 0; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_EncoderFormat", CH02_Vdieo_Broadcast_EncoderFormat_index);


	//VIDEO BROADCAST SERVER PROFILE
	if		( nRecordProfile_ch1 ==  "QCAP_RECORD_PROFILE_BASELINE" )	{ nRecordProfile_Set_ch1 = 0; CH02_Vdieo_Broadcast_Profile_index = 0; }
	else if ( nRecordProfile_ch1 ==  "QCAP_RECORD_PROFILE_MAIN" )		{ nRecordProfile_Set_ch1 = 1; CH02_Vdieo_Broadcast_Profile_index = 1; }
	else if ( nRecordProfile_ch1 ==  "QCAP_RECORD_PROFILE_HIGH" )		{ nRecordProfile_Set_ch1 = 2; CH02_Vdieo_Broadcast_Profile_index = 2; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_Profile", CH02_Vdieo_Broadcast_Profile_index);


	//VIDEO BROADCAST SERVER LEVEL
	if		( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_1" )		{ nRecordLevel_Set_ch1 = 10; CH02_Vdieo_Broadcast_Level_index = 0; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_1B" )		{ nRecordLevel_Set_ch1 = 9;  CH02_Vdieo_Broadcast_Level_index = 1; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_11" )		{ nRecordLevel_Set_ch1 = 11; CH02_Vdieo_Broadcast_Level_index = 2; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_12" )		{ nRecordLevel_Set_ch1 = 12; CH02_Vdieo_Broadcast_Level_index = 3; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_13" )		{ nRecordLevel_Set_ch1 = 13; CH02_Vdieo_Broadcast_Level_index = 4; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_2" )		{ nRecordLevel_Set_ch1 = 20; CH02_Vdieo_Broadcast_Level_index = 5; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_21" )		{ nRecordLevel_Set_ch1 = 21; CH02_Vdieo_Broadcast_Level_index = 6; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_22" )		{ nRecordLevel_Set_ch1 = 22; CH02_Vdieo_Broadcast_Level_index = 7; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_3" )		{ nRecordLevel_Set_ch1 = 30; CH02_Vdieo_Broadcast_Level_index = 8; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_31" )		{ nRecordLevel_Set_ch1 = 31; CH02_Vdieo_Broadcast_Level_index = 9; }
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_32" )		{ nRecordLevel_Set_ch1 = 32; CH02_Vdieo_Broadcast_Level_index = 10;}
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_4" )		{ nRecordLevel_Set_ch1 = 40; CH02_Vdieo_Broadcast_Level_index = 11;}
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_41" )		{ nRecordLevel_Set_ch1 = 41; CH02_Vdieo_Broadcast_Level_index = 12;}
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_42" )		{ nRecordLevel_Set_ch1 = 42; CH02_Vdieo_Broadcast_Level_index = 13;}
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_50" )		{ nRecordLevel_Set_ch1 = 50; CH02_Vdieo_Broadcast_Level_index = 14;}
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_51" )		{ nRecordLevel_Set_ch1 = 51; CH02_Vdieo_Broadcast_Level_index = 15;}
	else if ( nRecordLevel_ch1 ==  "QCAP_RECORD_LEVEL_52" )		{ nRecordLevel_Set_ch1 = 52; CH02_Vdieo_Broadcast_Level_index = 16;}

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_Level", CH02_Vdieo_Broadcast_Level_index);



	//VIDEO BROADCAST SERVER ENTROPY
	if		( nRecodRecordEntropy_ch1 ==  "QCAP_RECORD_ENTROPY_CAVLC" )	{ nRecodRecordEntropy_Set_ch1 = 0; CH02_Vdieo_Broadcast_Entropy_index = 0; }
	else if ( nRecodRecordEntropy_ch1 ==  "QCAP_RECORD_ENTROPY_CABAC" )	{ nRecodRecordEntropy_Set_ch1 = 1; CH02_Vdieo_Broadcast_Entropy_index = 1; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_Entropy", CH02_Vdieo_Broadcast_Entropy_index);


	//VIDEO BROADCAST SERVER COMPLEXITY
	if		( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_0" )	{ nRecodComplexity_Set_ch1 = 0; CH02_Vdieo_Broadcast_Complexity_index = 0; }
	else if ( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_1" )	{ nRecodComplexity_Set_ch1 = 1; CH02_Vdieo_Broadcast_Complexity_index = 1; }
	else if ( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_2" )	{ nRecodComplexity_Set_ch1 = 2; CH02_Vdieo_Broadcast_Complexity_index = 2; }
	else if ( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_3" )	{ nRecodComplexity_Set_ch1 = 3; CH02_Vdieo_Broadcast_Complexity_index = 3; }
	else if ( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_4" )	{ nRecodComplexity_Set_ch1 = 4; CH02_Vdieo_Broadcast_Complexity_index = 4; }
	else if ( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_5" )	{ nRecodComplexity_Set_ch1 = 5; CH02_Vdieo_Broadcast_Complexity_index = 5; }
	else if ( nRecodComplexity_ch1 ==  "QCAP_RECORD_COMPLEXITY_6" )	{ nRecodComplexity_Set_ch1 = 6; CH02_Vdieo_Broadcast_Complexity_index = 6; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_Complexity", CH02_Vdieo_Broadcast_Complexity_index);


	//VIDEO BROADCAST SERVER MODE
	if		( nRecordMode_ch1 ==  "QCAP_RECORD_MODE_VBR" )	{ nRecordMode_Set_ch1 = 0; CH02_Vdieo_Broadcast_Mode_index = 0; }
	else if ( nRecordMode_ch1 ==  "QCAP_RECORD_MODE_CBR" )	{ nRecordMode_Set_ch1 = 1; CH02_Vdieo_Broadcast_Mode_index = 1; }
	else if ( nRecordMode_ch1 ==  "QCAP_RECORD_MODE_ABR" )	{ nRecordMode_Set_ch1 = 2; CH02_Vdieo_Broadcast_Mode_index = 2; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_Complexity", CH02_Vdieo_Broadcast_Mode_index);


	//VIDEO BROADCAST SERVER QUALITY
	if      ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  1000" )	{ nQuality_Set_ch1 = 1000; CH02_Vdieo_Broadcast_Quality_index = 0; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  2000" )	{ nQuality_Set_ch1 = 2000; CH02_Vdieo_Broadcast_Quality_index = 1; }	 
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  3000" )	{ nQuality_Set_ch1 = 3000; CH02_Vdieo_Broadcast_Quality_index = 2; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  4000" )	{ nQuality_Set_ch1 = 4000; CH02_Vdieo_Broadcast_Quality_index = 3; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  5000" )	{ nQuality_Set_ch1 = 5000; CH02_Vdieo_Broadcast_Quality_index = 4; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  6000" )	{ nQuality_Set_ch1 = 6000; CH02_Vdieo_Broadcast_Quality_index = 5; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  7000" )	{ nQuality_Set_ch1 = 7000; CH02_Vdieo_Broadcast_Quality_index = 6; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  8000" )	{ nQuality_Set_ch1 = 8000; CH02_Vdieo_Broadcast_Quality_index = 7; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  9000" )	{ nQuality_Set_ch1 = 9000; CH02_Vdieo_Broadcast_Quality_index = 8; }
	else if ( nQuality_ch1 ==  "QCAP_RECORD_QUALITY  10000" )	{ nQuality_Set_ch1 = 10000; CH02_Vdieo_Broadcast_Quality_index = 9; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_Quality", CH02_Vdieo_Broadcast_Quality_index);


	//VIDEO BROADCAST SERVER BITRATE
	if      ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 16MBPS" )	{ nBitRate_Set_ch1 = 16*1024*1024; CH02_Vdieo_Broadcast_BitRate_index = 0; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 12MBPS" )	{ nBitRate_Set_ch1 = 12*1024*1024; CH02_Vdieo_Broadcast_BitRate_index = 1; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 8MBPS" )	{ nBitRate_Set_ch1 = 8*1024*1024;  CH02_Vdieo_Broadcast_BitRate_index = 2; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 6MBPS" )	{ nBitRate_Set_ch1 = 6*1024*1024;  CH02_Vdieo_Broadcast_BitRate_index = 3; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 4MBPS" )	{ nBitRate_Set_ch1 = 4*1024*1024;  CH02_Vdieo_Broadcast_BitRate_index = 4; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 2MBPS" )	{ nBitRate_Set_ch1 = 2*1024*1024;  CH02_Vdieo_Broadcast_BitRate_index = 5; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 1MBPS" )	{ nBitRate_Set_ch1 = 1*1024*1024;  CH02_Vdieo_Broadcast_BitRate_index = 6; }
	else if ( nBitRate_ch1 ==  "QCAP_RECORD_BITRATE 512KBPS" )	{ nBitRate_Set_ch1 = 1*512*1024;   CH02_Vdieo_Broadcast_BitRate_index = 7; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH02_Video_Broadcast_Server_BitRate", CH02_Vdieo_Broadcast_BitRate_index);


	//AUDIO BROADCAST SERVER ENCODERFORMAT
	if ( nAudioEncoderType_ch1 ==  "QCAP_ENCODER_TYPE_SOFTWARE" )			{ nAudioEncoderType_Set_ch1 = 0; CH02_Audio_Broadcast_EncoderType_index = 0; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH02_Audio_Broadcast_Server_EncoderType", CH02_Audio_Broadcast_EncoderType_index);


	if		( nAudioEncoderFormat_ch1 ==  "QCAP_ENCODER_FORMAT_PCM" )		{ nAudioEncoderFormat_Set_ch1 = 0; CH02_Audio_Broadcast_EncoderFormat_index = 0; }
	else if ( nAudioEncoderFormat_ch1 ==  "QCAP_ENCODER_FORMAT_AAC" )		{ nAudioEncoderFormat_Set_ch1 = 1; CH02_Audio_Broadcast_EncoderFormat_index = 1; }
	else if ( nAudioEncoderFormat_ch1 ==  "QCAP_ENCODER_FORMAT_AAC_ADTS" )	{ nAudioEncoderFormat_Set_ch1 = 2; CH02_Audio_Broadcast_EncoderFormat_index = 2; }

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH02_Audio_Broadcast_Server_EncoderFormat", CH02_Audio_Broadcast_EncoderFormat_index);


	CString nAspectRatioX_ch1, nGOP_ch1, nAspectRatioY_ch1, nBFrame_ch1, nInterleaved_ch1, nURL ;

	CString strWebServerRootFolder = "C:\\AppServ\\www\\", strSubFolder = "hls2\\";

	//VIDEO BROADCAST SERVER SET PROPERTY
	m_edit_Video_Broadcast_Server_Proerty_AspectRatio_X_1.GetWindowTextA( nAspectRatioX_ch1 );
	ULONG nAspectRatioX_Set_ch1 = atoi(nAspectRatioX_ch1);
		
	m_edit_Video_Broadcast_Server_Proerty_AspectRatio_Y_1.GetWindowTextA( nAspectRatioY_ch1 );
	ULONG nAspectRatioY_Set_ch1 =  atoi(nAspectRatioY_ch1);

	m_edit_Video_Broadcast_Server_Proerty_GOP_1.GetWindowTextA( nGOP_ch1 );
	ULONG nGOP_Set_ch1 = atoi(nGOP_ch1);

	m_edit_Video_Broadcast_Server_Proerty_BFrame_1.GetWindowTextA( nBFrame_ch1 );
	ULONG nBFrame_Set_ch1 = atoi(nBFrame_ch1);

	m_edit_Video_Record_Proerty_Interleaved_1.GetWindowTextA( nInterleaved_ch1 );
	ULONG nInterleaved_Set_ch1 =  atoi(nInterleaved_ch1);

	//m_edit_URL_ADDRESS_1.GetWindowTextA( (CHAR*)(LPCSTR)nURL, 1024 );

	m_edit_URL_ADDRESS_1.GetWindowTextA( nURL );

	m_bThumbDRAW_1 = m_checkThumbDRAW_1.GetCheck();
	m_bMaintain_Aspect_Ratio_1 = m_checkMaintain_Aspect_Ratio_1.GetCheck();

	//SERVER TYPE SELECT
	if ( nServerTypeSelect_ch1 ==  "RTSP SERVER" )	{  
		QCAP_CREATE_BROADCAST_RTSP_SERVER( 1, 1, &m_hNetworkServer[ 1 ], "root", "root", 1000, 8080 );
		CH02_Broadcast_Select_index = 0;
	}
	else if ( nServerTypeSelect_ch1 ==  "RTMP SERVER" )	{ 
		QCAP_CREATE_BROADCAST_RTMP_SERVER( 1, 1, &m_hNetworkServer[ 1 ], NULL, NULL, 1930, 8070);
		//QCAP_CREATE_BROADCAST_RTMP_SERVER( 1, 2, &m_hNetworkServer[ 1 ], NULL, NULL, 1930, 8082);
		CH02_Broadcast_Select_index = 1;
	}
	else if ( nServerTypeSelect_ch1 ==  "RTMP WEB PORTAL SERVER" )	{ 
		QCAP_CREATE_BROADCAST_RTMP_WEB_PORTAL_SERVER( 1, (CHAR*)(LPCSTR)nURL, &m_hNetworkServer[ 1 ] );
		m_brtmp_web = TRUE ;
		CH02_Broadcast_Select_index = 2;
	}
	else if ( nServerTypeSelect_ch1 ==  "HLS SERVER" )	{ 
		QCAP_CREATE_BROADCAST_HLS_SERVER( 1, 1, &m_hNetworkServer[ 1 ], (CHAR *)(LPCSTR)(strWebServerRootFolder), (CHAR *)(LPCSTR)(strSubFolder) );
		CH02_Broadcast_Select_index = 3;
	}

	theApp.WriteProfileInt("Broadcast_Server_Setting","CH02_Broadcast_Server_Select", CH02_Broadcast_Select_index);


	//FPS
	//
	double fps_CH1 = m_dDeviceVideoFrameRates[ 1 ];

	if( m_bDeviceVideoIsInterleaved[ 1 ] == TRUE ) {

		fps_CH1 /= 2;
	}
	
	QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY_EX( m_hNetworkServer[ 1 ], 
												 0, 
												 nEncoderType_Set_ch1,
												 nEncoderFormat_Set_ch1,
												 QCAP_COLORSPACE_TYEP_YUY2,
												 m_nDeviceVideoWidths[ 1 ],
												 m_nDeviceVideoHeights[ 1 ],
												 fps_CH1, 
												 nRecordProfile_Set_ch1,
												 nRecordLevel_Set_ch1,
												 nRecodRecordEntropy_Set_ch1,
												 nRecodComplexity_Set_ch1,
												 nRecordMode_Set_ch1,
												 nQuality_Set_ch1,
												 nBitRate_Set_ch1,
												 nGOP_Set_ch1,
												 nBFrame_Set_ch1,
												 nInterleaved_Set_ch1,
												 0, /*nSlices*/
												 0, /*nLayers*/
												 0, /*nSceneCut*/
												 nAspectRatioX_Set_ch1,
												 nAspectRatioY_Set_ch1,
												 NULL,
												 m_bThumbDRAW_1,
												 m_bMaintain_Aspect_Ratio_1,
												 QCAP_BROADCAST_FLAG_FULL);

	QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer[ 1 ], 
											  0, 
											  nAudioEncoderType_Set_ch1, 
											  nAudioEncoderFormat_Set_ch1, 
											  2, 
											  16, 
											  48000, 
											  100 );
	
	QCAP_START_BROADCAST_SERVER( m_hNetworkServer[ 1 ] );

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	m_nNetworkServerStates[ 1 ] = 0x00000001;

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );
}


void CAnimationFactoryDlg::OnBnClickedButtonStopServer1()
{
	// TODO: Add your control notification handler code here
	m_btnBroadcastServerStart_1.EnableWindow( TRUE ); 
	m_btnBroadcastServerStop_1.EnableWindow( FALSE ); 

	EnterCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	m_nNetworkServerStates[ 1 ] = 0x00000000;	

	LeaveCriticalSection( &m_hNetworkServerAccessCriticalSections[ 1 ] );

	if ( m_hNetworkServer[ 1 ] != NULL )
	{
		QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer[ 1 ] );

		QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer[ 1 ] );

		m_hNetworkServer[ 1 ] = NULL;
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonStartVirtaulCamera()
{
	// TODO: Add your control notification handler code here
	m_btnVirtualCameraStart.EnableWindow( FALSE ); 
	m_btnVirtualCameraStop.EnableWindow( TRUE ); 

	QCAP_CREATE_VIRTUAL_CAMERA( 0, &m_pVirtualCamera );

	QCAP_SET_VIDEO_VIRTUAL_CAMERA_PROPERTY( m_pVirtualCamera, QCAP_COLORSPACE_TYEP_YV12, m_nClipWidth, m_nClipHeight, 30 );

	QCAP_SET_AUDIO_VIRTUAL_CAMERA_PROPERTY( m_pVirtualCamera, 2, 16, 48000 );

	QCAP_START_VIRTUAL_CAMERA( m_pVirtualCamera );

	m_bOSDTEXT_VIRTUAL_CAMERA.EnableWindow( TRUE );
	m_bOSDPICT_VIRTUAL_CAMERA.EnableWindow( TRUE );
	m_bSNAPBMP_VIRTUAL_CAMERA.EnableWindow( TRUE );
	m_bSNAPJPG_VIRTUAL_CAMERA.EnableWindow( TRUE );
	m_bSNAPBMP_EX_VIRTUAL_CAMERA.EnableWindow( TRUE );
	m_bSNAPJPG_EX_VIRTUAL_CAMERA.EnableWindow( TRUE );

	m_btnVirtualCameraStartDisplay.EnableWindow( TRUE ); 
	m_btnVirtualCameraStopDisplay.EnableWindow( TRUE ); 
}


void CAnimationFactoryDlg::OnBnClickedButtonStopVirtualCamera()
{
	// TODO: Add your control notification handler code here
	m_btnVirtualCameraStart.EnableWindow( TRUE ); 
	m_btnVirtualCameraStop.EnableWindow( FALSE ); 

	if ( m_hCameraDevice != 0 ) {

		QCAP_STOP( m_hCameraDevice );

		QCAP_DESTROY( m_hCameraDevice );

		m_hCameraDevice = NULL;
	}

	if ( m_pVirtualCamera != 0 )
	{
		QCAP_STOP_VIRTUAL_CAMERA( m_pVirtualCamera );

		QCAP_DESTROY_VIRTUAL_CAMERA( m_pVirtualCamera );

		m_pVirtualCamera = NULL;
	}

	m_bOSDTEXT_VIRTUAL_CAMERA.EnableWindow( FALSE);
	m_bOSDPICT_VIRTUAL_CAMERA.EnableWindow( FALSE );
	m_bSNAPBMP_VIRTUAL_CAMERA.EnableWindow( FALSE );
	m_bSNAPJPG_VIRTUAL_CAMERA.EnableWindow( FALSE );
	m_bSNAPBMP_EX_VIRTUAL_CAMERA.EnableWindow( FALSE );
	m_bSNAPJPG_EX_VIRTUAL_CAMERA.EnableWindow( FALSE );

	m_btnVirtualCameraStartDisplay.EnableWindow( FALSE ); 
	m_btnVirtualCameraStopDisplay.EnableWindow( FALSE ); 
}


void CAnimationFactoryDlg::OnBnClickedButtonVirtualCameraOsdText()
{
	// TODO: Add your control notification handler code here

	if ( m_bOSDTEXT_VIRTUALCAMERA == FALSE ) {

		QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT( m_pVirtualCamera, 0, 0, 0, 0, 0, "Yuan's Virtual Camera", "Arial", QCAP_FONT_STYLE_BOLD, 24, 0xFFFFFFFF, 0xFFFF0000, 0xFF );
		m_bOSDTEXT_VIRTUALCAMERA = TRUE;
	}
	else if ( m_bOSDTEXT_VIRTUALCAMERA == TRUE ) {
		QCAP_SET_OSD_VIRTUAL_CAMERA_TEXT( m_pVirtualCamera, 0, 0, 0, -1, -1, "", "Arial", QCAP_FONT_STYLE_BOLD, 24, 0xFFFFFFFF, 0xFFFF0000, 0xFF );
		m_bOSDTEXT_VIRTUALCAMERA = FALSE;
	}	
}


void CAnimationFactoryDlg::OnBnClickedButtonVirtualCameraOsdPicture()
{
	// TODO: Add your control notification handler code here
	if ( m_bOSDPICTURE_VIRTUALCAMERA == FALSE ) {

	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "PNG\0*.PNG\0BMP\0*.BMP\0JPG\0*.JPG\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	ULONG X, Y;

	X = m_nDeviceVideoWidths[ 1 ]-(m_nDeviceVideoWidths[ 1 ]/6);
	Y = m_nDeviceVideoHeights[ 1 ]-(m_nDeviceVideoHeights[ 1 ]/6);

		QCAP_SET_OSD_VIRTUAL_CAMERA_PICTURE( m_pVirtualCamera, 1, X, Y, -1, -1, (CHAR *)(LPCSTR)psz, 255, QCAP_SEQUENCE_STYLE_FOREMOST );
		m_bOSDPICTURE_VIRTUALCAMERA = TRUE;

	}
	else if ( m_bOSDPICTURE_VIRTUALCAMERA == TRUE ) {

		QCAP_SET_OSD_VIRTUAL_CAMERA_PICTURE( m_pVirtualCamera, 1, 0, 0, -1, -1, "", 255, QCAP_SEQUENCE_STYLE_FOREMOST );
		m_bOSDPICTURE_VIRTUALCAMERA = FALSE;
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonVirtualCameraSnapshotBmp()
{
	// TODO: Add your control notification handler code here	
	
	CString strFullPathName;

	CString m_strFormatPath ;

	CTime time = CTime::GetCurrentTime(); 

	CString timeformat(time.Format(CString("\\VirtualCamera_%Y.%m.%d.%H.%M.%S")));
 
	strFullPathName = m_strRecordPath + timeformat + _T(".BMP");
		
	ULONG nStrlen = strFullPathName.GetLength();

	CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

    QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP( m_pVirtualCamera, psz );

	strFullPathName.ReleaseBuffer();
}


void CAnimationFactoryDlg::OnBnClickedButtonVirtualCameraSnapshotJpg()
{
	// TODO: Add your control notification handler code here

	CString strFullPathName;

	CString m_strFormatPath ;

	CTime time = CTime::GetCurrentTime(); 

	CString timeformat(time.Format(CString("\\VirtualCamera_%Y.%m.%d.%H.%M.%S")));
 
	strFullPathName = m_strRecordPath + timeformat + _T(".JPG");
		
	ULONG nStrlen = strFullPathName.GetLength();

	CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

     QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG( m_pVirtualCamera, psz, 100 );

	strFullPathName.ReleaseBuffer();
}


void CAnimationFactoryDlg::OnBnClickedButtonVirtualCameraSnapshotBmpEx()
{
	// TODO: Add your control notification handler code here

	ULONG CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH;

	CAL_CropX = m_nClipWidth - ( m_nClipWidth-(m_nClipWidth/4) );
	CAL_CropY = m_nClipHeight - (m_nClipHeight-(m_nClipHeight/4) );
	CAL_CropW = m_nClipWidth/2;
	CAL_CropH = m_nClipHeight/2;
	CAL_DstW  = m_nClipWidth;
	CAL_DstH  = m_nClipHeight;

	CString strFullPathName;

	CString m_strFormatPath ;

	CTime time = CTime::GetCurrentTime(); 

	CString timeformat(time.Format(CString("\\VirtualCameraEX_%Y.%m.%d.%H.%M.%S")));

	strFullPathName = m_strRecordPath + timeformat + _T(".BMP");
		
	ULONG nStrlen = strFullPathName.GetLength();

	CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

    QCAP_SNAPSHOT_VIRTUAL_CAMERA_BMP_EX( m_pVirtualCamera, psz, CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH );

	strFullPathName.ReleaseBuffer();
}


void CAnimationFactoryDlg::OnBnClickedButtonVirtualCameraSnapshotJpgEx()
{
	// TODO: Add your control notification handler code here


	ULONG CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH;

	CAL_CropX = m_nClipWidth - ( m_nClipWidth-(m_nClipWidth/4) );
	CAL_CropY = m_nClipHeight - (m_nClipHeight-(m_nClipHeight/4) );
	CAL_CropW = m_nClipWidth/2;
	CAL_CropH = m_nClipHeight/2;
	CAL_DstW  = m_nClipWidth;
	CAL_DstH  = m_nClipHeight;

	CString strFullPathName;

	CString m_strFormatPath ;

	CTime time = CTime::GetCurrentTime(); 

	CString timeformat(time.Format(CString("\\VirtualCameraEX_%Y.%m.%d.%H.%M.%S")));

	strFullPathName = m_strRecordPath + timeformat + _T(".JPG");
		
	ULONG nStrlen = strFullPathName.GetLength();

	CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

    QCAP_SNAPSHOT_VIRTUAL_CAMERA_JPG_EX( m_pVirtualCamera, psz, CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH, 100 );

	strFullPathName.ReleaseBuffer();
}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerOpen()
{
	// TODO: Add your control notification handler code here

	// SELECT THE ACTION SCRIPT FILE
	//
	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "MP4, ASF, AVI\0*.MP4;*.ASF;*.AVI\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	if( strlen( psz ) > 0 ) {

		m_strFilePath = psz;

		if( m_pFile ) {

			QCAP_DESTROY_FILE( m_pFile );

			m_pFile = NULL;
		}
		QCAP_OPEN_FILE( psz, &m_pFile, QCAP_DECODER_TYPE_SOFTWARE, &m_nFileVideoFormat, &m_nFileVideoWidth, &m_nFileVideoHeight, &m_dFileVideoFrameRate, &m_nFileAudioFormat, &m_nFileAudioChannels, &m_nFileAudioBitsPerSample, &m_nFileAudioSampleFrequency, &m_dFileTotalDuationTimes, &m_nFileTotalVideoFrames, &m_nFileTotalAudioFrames, m_statfileplayerWindow.m_hWnd, 1 );

		QCAP_REGISTER_VIDEO_DECODER_FILE_CALLBACK( m_pFile, on_video_decoder_file_callback, this );

		QCAP_REGISTER_AUDIO_DECODER_FILE_CALLBACK( m_pFile, on_audio_decoder_file_callback, this );

		QCAP_REGISTER_FILE_SNAPSHOT_DONE_CALLBACK( m_pFile, on_snapshot_done_callback, this );

		QCAP_PAUSE_FILE( m_pFile );

		double speed = 0;

		QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );

		SetTimer( 0x00000005,  10, NULL );
	}
	else {

		return ;
	}

	m_bANALYSIS_FILE_PLAY.EnableWindow( TRUE );
	m_bOSDTEXT_FILE_PLAY.EnableWindow( TRUE );
	m_bOSDPICT_FILE_PLAY.EnableWindow( TRUE );
	m_bSNAPSHOT_FILE_PLAY.EnableWindow( TRUE );
	m_bSNAPJPG_FILE_PLAY.EnableWindow( TRUE );
	m_bSNAPBMP_EX_FILE_PLAY.EnableWindow( TRUE);
	m_bSNAPJPG_EX_FILE_PLAY.EnableWindow( TRUE );
	m_bSPEED_ADD_FILE_PLAY.EnableWindow( TRUE );
	m_bSPEED_REDUCE_FILE_PLAY.EnableWindow( TRUE );
	m_bPAUSE_FILE_PLAY.EnableWindow( TRUE );
	m_bSTOP_FILE_PLAY.EnableWindow( TRUE );
	m_bPLAY_FILE_PLAY.EnableWindow( TRUE );
}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerPlay()
{
	// TODO: Add your control notification handler code here
	double dSampleTime = 0;

	QCAP_GET_FILE_POSITION( m_pFile, &dSampleTime );

	if( dSampleTime >= m_dFileTotalDuationTimes ) {

		QCAP_STOP_FILE( m_pFile );
	}
	QCAP_PLAY_FILE( m_pFile );
}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerPause()
{
	// TODO: Add your control notification handler code here
	QCAP_PAUSE_FILE( m_pFile );
}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerStop()
{
	// TODO: Add your control notification handler code here
	QCAP_STOP_FILE( m_pFile );
}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerSpeedFast()
{
	// TODO: Add your control notification handler code here
	double speed = 0;

	QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );
	
	speed += 0.25;

	QCAP_SET_FILE_PLAYBACK_SPEED( m_pFile,  speed );

	QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );
}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerSpeedSlow()
{
	// TODO: Add your control notification handler code here
	double speed = 0;

	QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );
	
	speed -= 0.25;

	QCAP_SET_FILE_PLAYBACK_SPEED( m_pFile,  speed );

	QCAP_GET_FILE_PLAYBACK_SPEED( m_pFile, &speed );
}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerSnapshotBmp()
{
	// TODO: Add your control notification handler code here

	CString strFullPathName;

	CString m_strFormatPath ;

	CTime time = CTime::GetCurrentTime(); 

	CString timeformat(time.Format(CString("\\FilePlayer_%Y.%m.%d.%H.%M.%S")));
 
	strFullPathName = m_strRecordPath + timeformat + _T(".BMP");
	
	ULONG nStrlen = strFullPathName.GetLength();

	CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

    QCAP_SNAPSHOT_FILE_BMP( m_pFile, psz );

	strFullPathName.ReleaseBuffer();
}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerSnapshotJpg()
{
	// TODO: Add your control notification handler code here

	CString strFullPathName;

	CString m_strFormatPath ;

	CTime time = CTime::GetCurrentTime(); 

	CString timeformat(time.Format(CString("\\FilePlayer_%Y.%m.%d.%H.%M.%S")));
 
	strFullPathName = m_strRecordPath + timeformat + _T(".JPG");
		
	ULONG nStrlen = strFullPathName.GetLength();

	CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

    QCAP_SNAPSHOT_FILE_JPG( m_pFile, psz, 100 );

	strFullPathName.ReleaseBuffer();
}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerSnapshotBmpEx()
{
	// TODO: Add your control notification handler code here

	ULONG CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH;

	//Cal Sanpshot Format
	//
	CAL_CropX = m_nFileVideoWidth - ( m_nFileVideoWidth-(m_nFileVideoWidth/4) );
	CAL_CropY = m_nFileVideoHeight - (m_nFileVideoHeight-(m_nFileVideoHeight/4) );
	CAL_CropW = m_nFileVideoWidth/2;
	CAL_CropH = m_nFileVideoHeight/2;
	CAL_DstW = m_nFileVideoWidth;
	CAL_DstH = m_nFileVideoHeight;

	CString strFullPathName;

	CString m_strFormatPath ;

	CTime time = CTime::GetCurrentTime(); 

	CString timeformat(time.Format(CString("\\FilePlayerEX_%Y.%m.%d.%H.%M.%S")));
 
	strFullPathName = m_strRecordPath + timeformat + _T(".BMP");
		
	ULONG nStrlen = strFullPathName.GetLength();

	CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

    QCAP_SNAPSHOT_FILE_BMP_EX( m_pFile, psz, CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH );

	strFullPathName.ReleaseBuffer();
}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerSnapshotJpgEx()
{
	// TODO: Add your control notification handler code here

	ULONG CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH;

	//Cal Sanpshot Format
	//
	CAL_CropX = m_nFileVideoWidth - ( m_nFileVideoWidth-(m_nFileVideoWidth/4) );
	CAL_CropY = m_nFileVideoHeight - (m_nFileVideoHeight-(m_nFileVideoHeight/4) );
	CAL_CropW = m_nFileVideoWidth/2;
	CAL_CropH = m_nFileVideoHeight/2;
	CAL_DstW = m_nFileVideoWidth;
	CAL_DstH = m_nFileVideoHeight;


	CString strFullPathName;

	CString m_strFormatPath ;

	CTime time = CTime::GetCurrentTime(); 

	CString timeformat(time.Format(CString("\\FilePlayerEX_%Y.%m.%d.%H.%M.%S")));
 
	strFullPathName = m_strRecordPath + timeformat + _T("_FilePlayerEX.JPG");
		
	ULONG nStrlen = strFullPathName.GetLength();

	CHAR* psz = strFullPathName.GetBuffer( nStrlen+1 );

    QCAP_SNAPSHOT_FILE_JPG_EX( m_pFile, psz, CAL_CropX, CAL_CropY, CAL_CropW, CAL_CropH, CAL_DstW, CAL_DstH, 100 );

	strFullPathName.ReleaseBuffer();
}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerOsdText()
{
	// TODO: Add your control notification handler code here

	if ( m_bOSDTEXT_FILEPLAY == FALSE ) 
	{
		QCAP_SET_OSD_FILE_TEXT( m_pFile, 0, 0, 0, -1, -1, "Yuan's File Player", "Arial", QCAP_FONT_STYLE_BOLD, 35, 0xFFFFFFFF, 0xFFFF0000, 0xFF );
		m_bOSDTEXT_FILEPLAY = TRUE;
	}
	else if ( m_bOSDTEXT_FILEPLAY == TRUE ) 
	{
		QCAP_SET_OSD_FILE_TEXT( m_pFile, 0, 0, 0, -1, -1, "", "Arial", QCAP_FONT_STYLE_BOLD, 35, 0x00000000, 0x00000000, 0xFF );
		m_bOSDTEXT_FILEPLAY = FALSE;
	}	

}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerOsdPicture()
{
	// TODO: Add your control notification handler code here
	if ( m_bOSDPICTURE_FILEPLAY == FALSE ) {

	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = m_hWnd;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	ofn.lpstrFilter = "PNG\0*.PNG\0BMP\0*.BMP\0JPG\0*.JPG\0";

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	ULONG X, Y;

	X = m_nFileVideoWidth-(m_nFileVideoWidth/6);
	Y = m_nFileVideoHeight-(m_nFileVideoHeight/6);

		QCAP_SET_OSD_FILE_PICTURE( m_pFile, 1, X, Y, -1, -1, (CHAR *)(LPCSTR)psz, 255, QCAP_SEQUENCE_STYLE_FOREMOST );
		m_bOSDPICTURE_FILEPLAY = TRUE;
	}
	else if ( m_bOSDPICTURE_FILEPLAY == TRUE ) {

		QCAP_SET_OSD_FILE_PICTURE( m_pFile, 1, 0, 0, -1, -1, "", 255, QCAP_SEQUENCE_STYLE_FOREMOST );
		m_bOSDPICTURE_FILEPLAY = FALSE;
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonStartVirtaulCameraDisplay()
{
	// TODO: Add your control notification handler code here
	m_btnVirtualCameraStartDisplay.EnableWindow( FALSE ); 
	m_btnVirtualCameraStopDisplay.EnableWindow( TRUE ); 

	BOOL VirtualCameraThumbDRAW = FALSE, VirtualCameraAspect_Ratio = FALSE ;

	VirtualCameraThumbDRAW = m_checkVirtualCameraThumbDRAW.GetCheck();
	VirtualCameraAspect_Ratio = m_checkVirtualCameraMaintain_Aspect_Ratio.GetCheck();

	CHAR* pszCameraDevName = 0;

	BOOL bNext = TRUE;

		for( ULONG i = 0 ; i < 10 ; i++ ) {

			QCAP_CAMERA_ENUMERATION( &pszCameraDevName, bNext );

			CHAR szCameraDevName[ MAX_PATH ] = { 0 };

			sprintf( szCameraDevName, "%s", pszCameraDevName );

			CString SelectDevName(pszCameraDevName);

			if ( SelectDevName == "Custom Virtual Camera 01 Filter" ) {

					QCAP_SET_DEFAULT_CAMERA( szCameraDevName ); 
			}
		}

	// CREATE CAPTURE DEVICE
	//	
	QCAP_CREATE( "CAMERA", 2, m_statVirtualCameraWindow.m_hWnd, &m_hCameraDevice, VirtualCameraThumbDRAW, VirtualCameraAspect_Ratio );

	QCAP_RUN( m_hCameraDevice );	
}


void CAnimationFactoryDlg::OnBnClickedButtonStopVirtualCameraDisplay()
{
	// TODO: Add your control notification handler code here
	m_btnVirtualCameraStartDisplay.EnableWindow( TRUE); 
	m_btnVirtualCameraStopDisplay.EnableWindow( FALSE ); 

	if ( m_hCameraDevice != 0 ) {

		QCAP_STOP( m_hCameraDevice );

		QCAP_DESTROY( m_hCameraDevice );

		m_hCameraDevice = NULL;
	}
}


void CAnimationFactoryDlg::OnBnClickedButtonFilePlayerAnalysis()
{
	// TODO: Add your control notification handler code here

	CString str_path;

	CHAR psz_info[ 512 ];

	CString vfmt;

	CString afmt;

	if( m_nFileVideoFormat == QCAP_ENCODER_FORMAT_H264 ) { vfmt = "H264"; }

	if( m_nFileAudioFormat == QCAP_ENCODER_FORMAT_PCM ) { afmt = "PCM"; }

	if( m_nFileAudioFormat == QCAP_ENCODER_FORMAT_AAC_RAW ) { afmt = "AAC RAW"; }

	if( m_nFileAudioFormat == QCAP_ENCODER_FORMAT_AAC_ADTS ) { afmt = "AAC ADTS"; }

	sprintf( psz_info, "File Path = %s\r\nFile Total Duration Times = %f sec\r\nFile Total Video Frames = %d\r\nFile Total Audio Frames = %d\r\nVideo Encoder Format = %s\r\nVideo Width = %d\r\nVideo Height = %d\r\nVideo Frame Rate = %f fps\r\nAudio Encoder Format = %s\r\nAudio Channels = %d\r\nAudio Bits Per Sample = %d bits\r\nAudio Sample Frequency = %d Hz\r\n", m_strFilePath, m_dFileTotalDuationTimes, m_nFileTotalVideoFrames, m_nFileTotalAudioFrames, vfmt, m_nFileVideoWidth, m_nFileVideoHeight, m_dFileVideoFrameRate, afmt, m_nFileAudioChannels, m_nFileAudioBitsPerSample, m_nFileAudioSampleFrequency );

	{	CHAR psz[ MAX_PATH ];

		GetModuleFileName( NULL, psz, MAX_PATH );

		str_path = psz;

		str_path = str_path.Left( str_path.ReverseFind('\\') + 1 );

		str_path += "ANALYSIS.LOG";
	}
	ofstream file;

	file.open( str_path );

	file << psz_info;
	
	ULONG  nStreamBufferSize = m_nFileVideoWidth * m_nFileVideoHeight * 3 / 2;

	BYTE * pStreamBuffer = (BYTE *)(malloc( nStreamBufferSize ));

	double dLastSampleTime = 0;

	file << "\r\n[VIDEO STREAM]\r\n\r\n";

	for( ULONG i = 0 ; i < m_nFileTotalVideoFrames ; i++ ) {

		ULONG  nStreamBufferLen = nStreamBufferSize;

		BOOL   bIsKeyFrame = FALSE;

		double dSampleTime = 0;

		QCAP_GET_VIDEO_FILE_STREAM_BUFFER( m_pFile, i, pStreamBuffer, &nStreamBufferLen, &bIsKeyFrame, &dSampleTime );

		sprintf( psz_info, "%08d %f (%f) - %d BYTES\t[%02X%02X%02X%02X%02X%02X%02X%02X %02X%02X%02X%02X%02X%02X%02X%02X] %s\r\n", i, dSampleTime, dSampleTime - dLastSampleTime, nStreamBufferLen, pStreamBuffer[ 0 ], pStreamBuffer[ 1 ], pStreamBuffer[ 2 ], pStreamBuffer[ 3 ], pStreamBuffer[ 4 ], pStreamBuffer[ 5 ], pStreamBuffer[ 6 ], pStreamBuffer[ 7 ], pStreamBuffer[ 8 ], pStreamBuffer[ 9 ], pStreamBuffer[ 10 ], pStreamBuffer[ 11 ], pStreamBuffer[ 12 ], pStreamBuffer[ 13 ], pStreamBuffer[ 14 ], pStreamBuffer[ 15 ], bIsKeyFrame ? "[I]" : "" );

		file << psz_info;

		dLastSampleTime = dSampleTime;
	}

	file << "\r\n[AUDIO STREAM]\r\n\r\n";

	dLastSampleTime = 0;

	for(ULONG i = 0 ; i < m_nFileTotalAudioFrames ; i++ ) {

		ULONG  nStreamBufferLen = nStreamBufferSize;

		double dSampleTime = 0;

		QCAP_GET_AUDIO_FILE_STREAM_BUFFER( m_pFile, i, pStreamBuffer, &nStreamBufferLen, &dSampleTime );

		sprintf( psz_info, "%08d %f (%f) - %d BYTES\t[%02X%02X%02X%02X%02X%02X%02X%02X %02X%02X%02X%02X%02X%02X%02X%02X]\r\n", i, dSampleTime, dSampleTime - dLastSampleTime, nStreamBufferLen, pStreamBuffer[ 0 ], pStreamBuffer[ 1 ], pStreamBuffer[ 2 ], pStreamBuffer[ 3 ], pStreamBuffer[ 4 ], pStreamBuffer[ 5 ], pStreamBuffer[ 6 ], pStreamBuffer[ 7 ], pStreamBuffer[ 8 ], pStreamBuffer[ 9 ], pStreamBuffer[ 10 ], pStreamBuffer[ 11 ], pStreamBuffer[ 12 ], pStreamBuffer[ 13 ], pStreamBuffer[ 14 ], pStreamBuffer[ 15 ] );

		file << psz_info;

		dLastSampleTime = dSampleTime;
	}
	file.close();

	if( pStreamBuffer ) {

		free( pStreamBuffer );

		pStreamBuffer = NULL;
	}
}


