// dllmain.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include <afxwin.h>
#include <afxdllx.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

HMODULE g_hModule;

static AFX_EXTENSION_MODULE CBaseCapDLL = { NULL, NULL };

// ENCODER PROPERTY
//
SETUP_RECORD_PROPERTY_EX gScm;

extern "C" int APIENTRY
DllMain(HINSTANCE hInstance, DWORD dwReason, LPVOID lpReserved)
{

#ifdef SA7160_CAP_X64
	const TCHAR *pszKey = _T("SA7160_CAP_UI"); 
#endif

	switch ( dwReason ) 
	{
		case DLL_PROCESS_ATTACH:

			g_hModule = (HMODULE)hInstance; 

			TRACE0("CBaseCap.DLL Initializing!\n");
		
			// Extension DLL one-time initialization
			if (!AfxInitExtensionModule(CBaseCapDLL, hInstance)) { return 0; }

			new CDynLinkLibrary(CBaseCapDLL);

			::GetProfileString( pszKey, _T("RECORDPATH"), "C:\\DEMO.MP4", gScm.pszRecordFilePathName , 512 );
			gScm.nEncoderType = ::GetProfileInt( pszKey, _T("ENCODERTYPE"), gScm.nEncoderType );
			gScm.nEncoderFormat = ::GetProfileInt( pszKey, _T("ENCODERFORMAT"), gScm.nEncoderFormat );
			gScm.nRecordProfile = ::GetProfileInt( pszKey, _T("ENCODERPROFILE"), gScm.nRecordProfile );
			gScm.nRecordLevel = ::GetProfileInt( pszKey, _T("ENCODERLEVEL"), gScm.nRecordLevel );
			gScm.nRecordComplexity = ::GetProfileInt( pszKey, _T("ENCODERCOMPLEXITY"), gScm.nRecordComplexity );
			gScm.nRecordEntropy = ::GetProfileInt( pszKey, _T("ENCODERENTROPY"), gScm.nRecordEntropy );
			gScm.nRecordMode = ::GetProfileInt( pszKey, _T("ENCODERMODE"), gScm.nRecordMode );
			gScm.nQuality = ::GetProfileInt( pszKey, _T("ENCODERQUALITY"), gScm.nQuality );
			gScm.nBitRate = ::GetProfileInt( pszKey, _T("ENCODERBITRATE"), gScm.nBitRate );
			gScm.nGOP = ::GetProfileInt( pszKey, _T("ENCODERGOP"), gScm.nGOP );
			gScm.nBFrames = ::GetProfileInt( pszKey, _T("ENCODERBFRAME"), gScm.nBFrames );
			gScm.bIsInterleaved = ::GetProfileInt( pszKey, _T("ENCODERINTERLACE"), gScm.bIsInterleaved );
			gScm.nCropX = ::GetProfileInt( pszKey, _T("ENCODERCROPX"), gScm.nCropX );
			gScm.nCropY = ::GetProfileInt( pszKey, _T("ENCODERCROPY"), gScm.nCropY );
			gScm.nCropW = ::GetProfileInt( pszKey, _T("ENCODERCROPW"), gScm.nCropW );
			gScm.nCropH = ::GetProfileInt( pszKey, _T("ENCODERCROPH"), gScm.nCropH );
			gScm.nDstH = ::GetProfileInt( pszKey, _T("ENCODERDESH"), gScm.nDstH );
			gScm.nDstW = ::GetProfileInt( pszKey, _T("ENCODERDESW"), gScm.nDstW );
			gScm.nAspectRatioX = ::GetProfileInt( pszKey, _T("ENCODERASPECTX"), gScm.nAspectRatioX );
			gScm.nAspectRatioY = ::GetProfileInt( pszKey, _T("ENCODERASPECTY"), gScm.nAspectRatioY );

			break;

		case DLL_THREAD_ATTACH:

			break;
 
		case DLL_THREAD_DETACH:

			break;
 
		case DLL_PROCESS_DETACH:
			
			TRACE0("CBaseCap.DLL Terminating!\n");

			// Terminate the library before destructors are called
			AfxTermExtensionModule(CBaseCapDLL);

			break;
	}

	return 1;   // ok
}
