#define _QCAP_LABVIEW_IMPORT
typedef int                 BOOL;
#define FALSE 0
#define TRUE 1
typedef int INT;
#include <QDebug>

#include "netbroadcasterdlg.h"
#include "ui_netbroadcasterdlg.h"

#include "QCAP.H"

QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    NetBroadcasterDlg * pNetBroadcasterDlg = (NetBroadcasterDlg *)(pUserData);

    qDebug("signal removed \n");

    pNetBroadcasterDlg->ui->m_info->setText(QString("info...(signal removed)"));

    return QCAP_RT_OK;
}

QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    NetBroadcasterDlg * pNetBroadcasterDlg = (NetBroadcasterDlg *)(pUserData);

    qDebug("no signal Detected  \n");

    pNetBroadcasterDlg->ui->m_info->setText(QString("info...(no signal detected)"));

    return QCAP_RT_OK;
}

QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
    NetBroadcasterDlg * pNetBroadcasterDlg = (NetBroadcasterDlg *)(pUserData);

    qDebug("format changed Detected  \n");

    CHAR strVideoInput[ MAX_PATH ] = { 0 };

    CHAR strAudioInput[ MAX_PATH ] = { 0 };

    CHAR strFrameType[ MAX_PATH ] = { 0 };

    pNetBroadcasterDlg->m_nVideoWidth = nVideoWidth;

    pNetBroadcasterDlg->m_nVideoHeight = nVideoHeight;

    pNetBroadcasterDlg->m_bVideoIsInterleaved = bVideoIsInterleaved;

    pNetBroadcasterDlg->m_dVideoFrameRate = dVideoFrameRate;

    pNetBroadcasterDlg->m_nAudioChannels = nAudioChannels;

    pNetBroadcasterDlg->m_nAudioBitsPerSample = nAudioBitsPerSample;

    pNetBroadcasterDlg->m_nAudioSampleFrequency = nAudioSampleFrequency;

    UINT nVH = 0;

    if ( nVideoInput == 0 ) { sprintf( strVideoInput, "COMPOSITE" ); }

    if ( nVideoInput == 1 ) { sprintf( strVideoInput, "SVIDEO" ); }

    if ( nVideoInput == 2 ) { sprintf( strVideoInput, "HDMI" );}

    if ( nVideoInput == 3 ) { sprintf( strVideoInput, "DVI_D" );}

    if ( nVideoInput == 4 ) { sprintf( strVideoInput, "COMPONENTS (YCBCR)" );}

    if ( nVideoInput == 5 ) { sprintf( strVideoInput, "DVI_A (RGB / VGA)" );}

    if ( nVideoInput == 6 ) { sprintf( strVideoInput, "SDI" );}

    if ( nVideoInput == 7 ) { sprintf( strVideoInput, "AUTO" );}

    if ( nAudioInput == 0 ) { sprintf( strAudioInput, "EMBEDDED_AUDIO" );}

    if ( nAudioInput == 1 ) { sprintf( strAudioInput, "LINE_IN" );}

    if ( nAudioInput == 2 ) { sprintf( strAudioInput, "SOUNDCARD_MICROPHONE" );}

    if ( nAudioInput == 3 ) { sprintf( strAudioInput, "SOUNDCARD_LINE_IN" );}

    if ( bVideoIsInterleaved == TRUE ) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

    if ( bVideoIsInterleaved == TRUE ) { sprintf( strFrameType, " I " ); } else { sprintf( strFrameType, " P " ); }

    QString str_info;

    str_info.sprintf("INFO : %d x %d%s @%2.3f FPS , %d CH x %d BITS x %d HZ,  VIDEO INPUT : %s ,  AUDIO INPUT : %s"

                                                            , nVideoWidth, nVH, strFrameType, dVideoFrameRate, nAudioChannels, nAudioBitsPerSample

                                                            , nAudioSampleFrequency, strVideoInput, strAudioInput);

    pNetBroadcasterDlg->ui->m_info->setText(str_info);

    return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    NetBroadcasterDlg * pNetBroadcasterDlg = (NetBroadcasterDlg *)(pUserData);

    if( pFrameBuffer )
    {
        EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection_video );

        if( pNetBroadcasterDlg->m_nNetworkServerState_video > 0x00000000 )
        {
            QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, QCAP_COLORSPACE_TYEP_YUY2, pNetBroadcasterDlg->m_nVideoWidth, pNetBroadcasterDlg->m_nVideoHeight, pFrameBuffer, nFrameBufferLen );

            QCAP_SET_VIDEO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 1, QCAP_COLORSPACE_TYEP_YUY2, pNetBroadcasterDlg->m_nVideoWidth, pNetBroadcasterDlg->m_nVideoHeight, pFrameBuffer, nFrameBufferLen );
        }

        LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection_video );
    }

    return QCAP_RT_OK;
}

QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    NetBroadcasterDlg * pNetBroadcasterDlg = (NetBroadcasterDlg *)(pUserData);

    if( pFrameBuffer )
    {
        EnterCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection_audio );

        if( pNetBroadcasterDlg->m_nNetworkServerState_audio > 0x00000000 )
        {
            QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 0, pFrameBuffer, nFrameBufferLen );

            QCAP_SET_AUDIO_BROADCAST_SERVER_UNCOMPRESSION_BUFFER( pNetBroadcasterDlg->m_hNetworkServer, 1, pFrameBuffer, nFrameBufferLen );
        }

        LeaveCriticalSection( &pNetBroadcasterDlg->m_hNetworkServerAccessCriticalSection_audio );
    }

    return QCAP_RT_OK;
}

NetBroadcasterDlg::NetBroadcasterDlg(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::NetBroadcasterDlg)
{
    ui->setupUi(this);

    this->setWindowTitle("NetBroadcaster");

    this->setMinimumSize(625,486);

    this->setMaximumSize(625,486);

    ui->lineEdit_UDPTCP->setText(QString("554"));

    ui->lineEdit_HTTP->setText(QString("8080"));

    CoInitialize( NULL );

    //INITIALIZE MEMBER VARIABLES

    InitializeCriticalSection( &m_hNetworkServerAccessCriticalSection_audio );

    InitializeCriticalSection( &m_hNetworkServerAccessCriticalSection_video );

    m_pDevice = NULL;

    m_hNetworkServer = NULL;

    m_nNetworkServerState_audio = 0x00000000;

    m_nNetworkServerState_video = 0x00000000;

    m_nVideoWidth = 0;

    m_nVideoHeight = 0;

    m_bVideoIsInterleaved = FALSE;

    m_dVideoFrameRate = 0.0;

    m_nAudioChannels = 0;

    m_nAudioBitsPerSample = 0;

    m_nAudioSampleFrequency = 0;

    ui->pushBTN_StartRTSP->setEnabled(false);

    ui->pushBTN_StopRTSP->setEnabled(false);

    HwInitialize();

    if( m_pDevice )
    {
        ui->pushBTN_StartRTSP->setEnabled(true);
    }
}

NetBroadcasterDlg::~NetBroadcasterDlg()
{
    HwUninitialize();

    delete ui;
}

void NetBroadcasterDlg::HwInitialize()
{
    //CREATE CAPTURE DEVICE

    QCAP_CREATE( "SA7160 PCI", 0, (HWND)ui->PreviewWindow->winId(), &m_pDevice, TRUE);

    QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_pDevice, on_process_no_signal_detected, this );

    QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_pDevice, on_process_signal_removed, this );

    QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_pDevice, on_process_format_changed, this );

    QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_pDevice, on_video_preview_callback, this );

    QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_pDevice, on_process_preview_audio_buffer, this );

    QCAP_SET_VIDEO_INPUT( m_pDevice, QCAP_INPUT_TYPE_AUTO );

    QCAP_SET_AUDIO_INPUT( m_pDevice, QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

    QCAP_SET_AUDIO_VOLUME( m_pDevice, 100 );

    QCAP_SET_VIDEO_DEINTERLACE( m_pDevice, 1 );

    QCAP_RUN( m_pDevice );

}

void NetBroadcasterDlg::HwUninitialize()
{
    //DESTROY CAPTURE DEVICE

    on_pushBTN_StopRTSP_clicked();

    if( m_pDevice ) {

        QCAP_STOP( m_pDevice );

        QCAP_DESTROY( m_pDevice );

        m_pDevice = NULL;
    }

    DeleteCriticalSection( &m_hNetworkServerAccessCriticalSection_audio );

    DeleteCriticalSection( &m_hNetworkServerAccessCriticalSection_video );

    CoUninitialize();
}

void NetBroadcasterDlg::on_pushBTN_StartRTSP_clicked()
{
    if( (m_nVideoWidth == 0) || (m_nVideoHeight == 0) ) { return; }

    QCAP_CREATE_BROADCAST_RTSP_SERVER( 0, 2 /*2 CHANNELS*/, &m_hNetworkServer, "root", "root", (ULONG)ui->lineEdit_UDPTCP->text().toInt(), (ULONG)ui->lineEdit_HTTP->text().toInt() );

    QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2, 1280, 720, 30, QCAP_RECORD_MODE_CBR, 8000, 8000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

    QCAP_SET_VIDEO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 1, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, QCAP_COLORSPACE_TYEP_YUY2,  640, 360, 30, QCAP_RECORD_MODE_CBR, 8000, 2000000, 30, 0, 0, NULL, FALSE, FALSE, QCAP_BROADCAST_FLAG_FULL );

    QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, 0 );

    QCAP_SET_AUDIO_BROADCAST_SERVER_PROPERTY( m_hNetworkServer, 1, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nAudioChannels, m_nAudioBitsPerSample, m_nAudioSampleFrequency, 0 );

    QCAP_START_BROADCAST_SERVER( m_hNetworkServer );

    EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_audio );

    m_nNetworkServerState_audio = 0x00000001;

    LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_audio );

    EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_video );

    m_nNetworkServerState_video = 0x00000001;

    LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_video );

    ui->pushBTN_StartRTSP->setEnabled(false);

    ui->pushBTN_StopRTSP->setEnabled(true);
}

void NetBroadcasterDlg::on_pushBTN_StopRTSP_clicked()
{
    if( m_hNetworkServer!= NULL )
    {
        EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_audio );

        m_nNetworkServerState_audio = 0x00000000;

        LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_audio );

        EnterCriticalSection( &m_hNetworkServerAccessCriticalSection_video );

        m_nNetworkServerState_video = 0x00000000;

        LeaveCriticalSection( &m_hNetworkServerAccessCriticalSection_video );

        QCAP_STOP_BROADCAST_SERVER( m_hNetworkServer );

        QCAP_DESTROY_BROADCAST_SERVER( m_hNetworkServer );

        m_hNetworkServer = NULL;

        ui->pushBTN_StartRTSP->setEnabled(true);

        ui->pushBTN_StopRTSP->setEnabled(false);
    }
}
