#include "setupdlg.h"
#include "ui_setupdlg.h"
#include "channelwindow.h"

SetUpDlg::SetUpDlg(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SetUpDlg)
{
    ui->setupUi(this);

    this->setWindowTitle("SET UP DIALOG");

    this->setMinimumSize(700,280);

    this->setMaximumSize(700,280);

    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    ui->BmpPath->setText( SC510dlg->path + QString("/Snapshot_BMP.bmp"));

    ui->JpgPath->setText( SC510dlg->path + QString("/Snapshot_JPG.jpg"));

    ui->checkBox_DEINTERLACE->setChecked(true);

    ui->radioButton_SPLIT->setChecked(true);

    ui->pushBTN_AudioInput->setEnabled(false);

    ui->pushBTN_SnapshotBMP->setEnabled(false);

    ui->pushBTN_SnapshotJPG->setEnabled(false);

    ui->pushBTN_VideoInpur->setEnabled(false);

    ui->pushBTN_VideoQuality->setEnabled(false);
}

SetUpDlg::~SetUpDlg()
{
    delete ui;
}

void SetUpDlg::on_pushBTN_VideoInpur_clicked()
{
    emit SetUpDialogSignal_VideoInput();
}

void SetUpDlg::on_pushBTN_AudioInput_clicked()
{
    emit SetUpDialogSignal_AudioInput();
}

void SetUpDlg::on_pushBTN_SnapshotBMP_clicked()
{
    emit SetUpDialogSignal_Snapshot_BMP();
}

void SetUpDlg::on_pushBTN_SnapshotJPG_clicked()
{
    emit SetUpDialogSignal_Snapshot_JPG();
}

void SetUpDlg::on_pushBTN_VideoQuality_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    if( SC510dlg->m_hVideoDevice[0] )
    {
        emit SetUpDialogSignal_VideoQuality();
    }
}

void SetUpDlg::on_checkBox_DEINTERLACE_stateChanged(int arg1)
{
    emit SetUpDialogSignal_DEINTERLACE( arg1 );
}

void SetUpDlg::on_checkBox_Clone_stateChanged(int arg1)
{
    emit SetUpDialogSignal_CLONE( arg1 );
}

void SetUpDlg::closeEvent ( QCloseEvent * e )
{
    emit SetUpDialogSignal_DestroyAP();
}

void SetUpDlg::on_pushBTN_FileRecord_clicked()
{
    emit SetUpDialogSignal_FileRecord();
}

void SetUpDlg::on_pushBTN_ShareRecord_clicked()
{
    emit SetUpDialogSignal_ShareRecord();
}

void SetUpDlg::on_radioButton_CH1_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    SC510dlg->m_nChannelWindow = 0;

    emit SetUpDialogSignal_DisplayWindow();
}

void SetUpDlg::on_radioButton_CH2_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    SC510dlg->m_nChannelWindow = 1;

    emit SetUpDialogSignal_DisplayWindow();
}

void SetUpDlg::on_radioButton_CH3_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    SC510dlg->m_nChannelWindow = 2;

    emit SetUpDialogSignal_DisplayWindow();
}

void SetUpDlg::on_radioButton_CH4_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    SC510dlg->m_nChannelWindow = 3;

    emit SetUpDialogSignal_DisplayWindow();
}

void SetUpDlg::on_radioButton_SPLIT_clicked()
{
    ChannelWindow* SC510dlg = (ChannelWindow*)parentWidget();

    SC510dlg->m_nChannelWindow = 4;

    emit SetUpDialogSignal_DisplayWindow();
}
