﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Runtime.InteropServices;

using QCAP.NET;

[StructLayout(LayoutKind.Sequential)]
public struct SYSTEMTIME
{
    public ushort wYear;
    public ushort wMonth;
    public ushort wDayOfWeek;
    public ushort wDay;
    public ushort wHour;
    public ushort wMinute;
    public ushort wSecond;
    public ushort wMilliseconds;
}

namespace StreamCatcherDemo
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);

        [DllImport("Kernel32.dll ")]
        public static extern void GetLocalTime(ref SYSTEMTIME sysTime);

        public uint i = 0;

        // FOURCC MARCO
        //
        uint MAKEFOURCC(uint ch0, uint ch1, uint ch2, uint ch3)
        {
            return ((uint)(byte)(ch0) | ((uint)(byte)(ch1) << 8) | ((uint)(byte)(ch2) << 16) | ((uint)(byte)(ch3) << 24));
        }

        // RECORD PROPERTY
        //
        public string[] m_strRecordFilePath = new string[6];        

        public string[] m_strSnapshotFilePath = new string[6];

        public bool[] m_bSupportGPU = new bool[6];        

        public bool[] m_bCheckedAVI = new bool[6], m_bCheckedMP4 = new bool[6];        

        public uint[] m_nVideoStandard = new uint[6];        

        public double[] m_dFrameRate = new double[6];        

        public uint[] m_nEncoderType = new uint[6], m_nEncoderFormat = new uint[6];        

        public uint[] m_nEncoderWidth = new uint[6], m_nEncoderHeight = new uint[6];        

        public uint[] m_nAudioEncoderFormat = new uint[6];        

        public uint[] m_nRecordMode = new uint[6], m_nQuality = new uint[6], m_nBitRate = new uint[6], m_nGOP = new uint[6], m_DownloadScaleMode = new uint[6];        

        public uint[] m_nContinuousSnapshots = new uint[6], m_nContinuousSnapshotsDuration = new uint[6];                

        // DEVICE PROPERTY
        //
        public uint[] m_hCapDev = new uint[6];                         // STREAM CAPTURE DEVICE

        public uint[] m_hCloneCapDev = new uint[6];                // CLONE STREAM CAPTURE DEVICE        

        public MyAdvancedSettingsDlg m_cMyAdvancedSettingsDlg;

        public MyShareRecordAdvancedSettingsDlg m_cMyShareRecordAdvancedSettingsDlg;

        public string m_strCurrentDir = "";

        public bool[] m_bNoSignal = new bool[6];

        public string[] m_strFormatChangedOutput = new string[6];

        public bool m_bIsStreaming = false;

        public uint m_nVideoWidth = 1920;

        public uint m_nVideoHeight = 1080;

        public double m_dVideoFrameRate = 60.0;

        // SHARE RECORD
        //
        public bool m_bCreateShareRecord1 = false, m_bCreateShareRecord2 = false;

        public string m_strShareRecordFilePath;

        public bool m_bIsShareRecord = false;

        public bool[] m_bShareRecordCH = new bool[6];        

        public double m_dShareVideoFrameRate = 60.0;        

        public bool m_bShareSupportGPU = false;

        public bool m_bShareCheckedAVI = true, m_bShareCheckedMP4 = false;

        public uint m_nShareVideoStandard = 0;

        public double m_dShareFrameRate;

        public uint m_nShareEncoderType, m_nShareEncoderFormat;

        public uint m_nShareEncoderWidth, m_nShareEncoderHeight;

        public uint m_nShareAudioEncoderFormat;

        public uint m_nShareRecordMode, m_nShareQuality, m_nShareBitRate, m_nShareGOP, m_ShareDownloadScaleMode;

        string m_strChipName = "FH8735 PCI";

        ToolTip toolTip = new ToolTip();

        // CALLBACK FUNCTION
        //        
        EXPORTS.PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB;

        EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB;

        EXPORTS.PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB;

        EXPORTS.PF_VIDEO_HARDWARE_ENCODER_CALLBACK m_pVideoHardwareEncoderCallback;

        EXPORTS.PF_VIDEO_PREVIEW_CALLBACK m_pPreviewVideoCB;

        EXPORTS.PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB;

        //  FORMAT CHANGED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_format_changed(uint pDevice, uint nVideoInput, uint nAudioInput, uint nVideoWidth, uint nVideoHeight, uint bVideoIsInterleaved, double dVideoFrameRate, uint nAudioChannels, uint nAudioBitsPerSample, uint nAudioSampleFrequency, uint pUserData)
        {
            uint nCH = pUserData;

            // OUTPUT FORMAT CHANGED MESSAGE
            //
            string strOutput = "CH" + (nCH + 1).ToString() + " -> FORMAT CHANGED : pDevice : " + pDevice.ToString() + " , " + "nVideoInput : " + nVideoInput.ToString() + " , " +

                                        "nAudioInput : " + nAudioInput.ToString() + " , " + "nVideoWidth : " + nVideoWidth.ToString() + " , " +

                                        "nVideoHeight : " + nVideoHeight.ToString() + " , " + "bVideoIsInterleaved : " + bVideoIsInterleaved.ToString() + " , " +

                                        "dVideoFrameRate : " + dVideoFrameRate.ToString() + " , " + "nAudioChannels : " + nAudioChannels.ToString() + " , " +

                                        "nAudioBitsPerSample : " + nAudioBitsPerSample.ToString() + " , " + "nAudioSampleFrequency : " + nAudioSampleFrequency.ToString() + " , " +

                                        "pUserData : " + pUserData.ToString() + " \n";

            OutputDebugString(strOutput);

            m_nVideoWidth = nVideoWidth;

            m_nVideoHeight = nVideoHeight;

            m_dVideoFrameRate = dVideoFrameRate;

            uint nVH = 0;

            string strFrameType = " P ";

            string strVideoInput = "";

            string strAudioInput = "";

            if (nVideoInput == 0) { strVideoInput = "COMPOSITE"; } if (nVideoInput == 1) { strVideoInput = "SVIDEO"; } if (nVideoInput == 2) { strVideoInput = "HDMI"; }

            if (nVideoInput == 3) { strVideoInput = "DVI_D"; } if (nVideoInput == 4) { strVideoInput = "COMPONENTS (YCBCR)"; } if (nVideoInput == 5) { strVideoInput = "DVI_A (RGB / VGA)"; }

            if (nVideoInput == 6) { strVideoInput = "SDI"; } if (nVideoInput == 7) { strVideoInput = "AUTO"; }

            if (nAudioInput == 0) { strAudioInput = "EMBEDDED_AUDIO"; } if (nAudioInput == 1) { strAudioInput = "LINE_IN"; }

            if (bVideoIsInterleaved == 1) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

            if (bVideoIsInterleaved == 1) { strFrameType = " I "; } else { strFrameType = " P "; }

            m_strFormatChangedOutput[nCH] = nVideoWidth.ToString() + " x " + nVH.ToString() + strFrameType + " @" + dVideoFrameRate.ToString() +

                " FPS , " + nAudioChannels.ToString() + " CH x " + nAudioBitsPerSample.ToString() + " BITS x " + nAudioSampleFrequency.ToString() + " HZ , " +

                " VIDEO INPUT : " + strVideoInput + " , " + " AUDIO INPUT : " + strAudioInput + " \n";

            m_strFormatChangedOutput[nCH] = @"INPUT : " + strVideoInput + " , " + nVideoWidth.ToString() + " x " + nVH.ToString() + strFrameType + " @" + dVideoFrameRate.ToString() + " FPS ";

            // NO SIGNAL
            //       
            if (nVideoWidth == 0 && nVideoHeight == 0 && dVideoFrameRate == 0.0 && nAudioChannels == 0 && nAudioBitsPerSample == 0 && nAudioSampleFrequency == 0)
            {
                m_bNoSignal[nCH] = true;
            }
            else
            {
                m_bNoSignal[nCH] = false;
            }

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // PREVIEW VIDEO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_video_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            uint nCH = pUserData;

            //string strOutput = "CH" + (nCH + 1).ToString() +  " : on_process_preview_video_buffer => pDevice : " + pDevice.ToString() + " , dSampleTime : " + dSampleTime.ToString() + " , pFrameBuffer : " + pFrameBuffer.ToString() + " , nFrameBufferLen : " + nFrameBufferLen.ToString() + " , pUserData : " + pUserData.ToString() + " \n";

            //OutputDebugString(strOutput);

            if (m_bIsShareRecord && m_bShareRecordCH[nCH])
            {
                if (m_bCreateShareRecord1)
                {
                    EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, MAKEFOURCC('Y', 'V', '1', '2'), 1920, 1080, pFrameBuffer, nFrameBufferLen);
                }

                if (m_bCreateShareRecord2)
                {
                    EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER(1, MAKEFOURCC('Y', 'V', '1', '2'), 1920, 1080, pFrameBuffer, 1920 * 1080 * 2);
                }
            }

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // PREVIEW AUDIO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_audio_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            uint nCH = pUserData;

            //string strOutput = "CH" + (nCH + 1).ToString() + " : on_process_preview_audio_buffer => pDevice : " + pDevice.ToString() + " , dSampleTime : " + dSampleTime.ToString() + " , pFrameBuffer : " + pFrameBuffer.ToString() + " , nFrameBufferLen : " + nFrameBufferLen.ToString() + " , pUserData : " + pUserData.ToString() + " \n";

            //OutputDebugString(strOutput);

            if (m_bIsShareRecord && m_bShareRecordCH[nCH])
            {
                if (m_bCreateShareRecord1)
                {
                    EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, pFrameBuffer, nFrameBufferLen);
                }

                if (m_bCreateShareRecord2)
                {
                    EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER(1, pFrameBuffer, nFrameBufferLen);
                }
            }

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // VIDEO HARDWARE ENCODER CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_hardware_encoder_video_buffer(uint pDevice, uint iRecNum, double dSampleTime, uint pStreamBuffer, uint nStreamBufferLen, uint bIsKeyFrame, uint pUserData)
        {
            uint nCH = pUserData;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // NO SIGNAL DETEACTED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_no_signal_detected(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            uint nCH = pUserData;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // SIGNAL REMOVED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_signal_removed(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            uint nCH = pUserData;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        public bool HwInitialize()
        {
            for (i = 0; i < 6; i++) { m_hCapDev[i] = 0x00000000; }

            for (i = 0; i < 6; i++) { m_hCloneCapDev[i] = 0x00000000; }

            for (i = 0; i < 6; i++) { m_bNoSignal[i] = true; }

            for (i = 0; i < 6; i++) { m_strFormatChangedOutput[i] = ""; }

            // CREATE CAPTURE DEVICE
            //
            EXPORTS.QCAP_CREATE(ref m_strChipName, 0, (uint)PreviewWindowCH01.Handle.ToInt32(), ref m_hCapDev[0], 1);
              
            EXPORTS.QCAP_CREATE(ref m_strChipName, 1, (uint)PreviewWindowCH02.Handle.ToInt32(), ref m_hCapDev[1], 1);

            EXPORTS.QCAP_CREATE(ref m_strChipName, 2, (uint)PreviewWindowCH03.Handle.ToInt32(), ref m_hCapDev[2], 1);

            EXPORTS.QCAP_CREATE(ref m_strChipName, 3, (uint)PreviewWindowCH04.Handle.ToInt32(), ref m_hCapDev[3], 1);

            EXPORTS.QCAP_CREATE(ref m_strChipName, 4, (uint)PreviewWindowCH05.Handle.ToInt32(), ref m_hCapDev[4], 1);

            EXPORTS.QCAP_CREATE(ref m_strChipName, 5, (uint)PreviewWindowCH06.Handle.ToInt32(), ref m_hCapDev[5], 1);
         
            // REGISTER FORMAT CHANGED CALLBACK FUNCTION
            // 
            m_pFormatChangedCB = new EXPORTS.PF_FORMAT_CHANGED_CALLBACK(on_process_format_changed);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[0], m_pFormatChangedCB, 0);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[1], m_pFormatChangedCB, 1);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[2], m_pFormatChangedCB, 2);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[3], m_pFormatChangedCB, 3);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[4], m_pFormatChangedCB, 4);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hCapDev[5], m_pFormatChangedCB, 5);

            // REGISTER PREVIEW VIDEO CALLBACK FUNCTION
            // 
            m_pPreviewVideoCB = new EXPORTS.PF_VIDEO_PREVIEW_CALLBACK(on_process_preview_video_buffer);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[0], m_pPreviewVideoCB, 0);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[1], m_pPreviewVideoCB, 1);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[2], m_pPreviewVideoCB, 2);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[3], m_pPreviewVideoCB, 3);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[4], m_pPreviewVideoCB, 4);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hCapDev[5], m_pPreviewVideoCB, 5);

            // REGISTER VIDEO HARDWARE ENCODER CALLBACK FUNCTION
            //
            m_pVideoHardwareEncoderCallback = new EXPORTS.PF_VIDEO_HARDWARE_ENCODER_CALLBACK(on_process_hardware_encoder_video_buffer);

            EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(m_hCapDev[0], 0, m_pVideoHardwareEncoderCallback, 0);

            EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(m_hCapDev[1], 0, m_pVideoHardwareEncoderCallback, 1);

            EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(m_hCapDev[2], 0, m_pVideoHardwareEncoderCallback, 2);

            EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(m_hCapDev[3], 0, m_pVideoHardwareEncoderCallback, 3);

            EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(m_hCapDev[4], 0, m_pVideoHardwareEncoderCallback, 4);

            EXPORTS.QCAP_REGISTER_VIDEO_HARDWARE_ENCODER_CALLBACK(m_hCapDev[5], 0, m_pVideoHardwareEncoderCallback, 5);

            // REGISTER PREVIEW AUDIO CALLBACK FUNCTION
            //
            m_pPreviewAudioCB = new EXPORTS.PF_AUDIO_PREVIEW_CALLBACK(on_process_preview_audio_buffer);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[0], m_pPreviewAudioCB, 0);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[1], m_pPreviewAudioCB, 1);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[2], m_pPreviewAudioCB, 2);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[3], m_pPreviewAudioCB, 3);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[4], m_pPreviewAudioCB, 4);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hCapDev[5], m_pPreviewAudioCB, 5);

            // REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
            //
            m_pNoSignalDetectedCB = new EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK(on_process_no_signal_detected);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[0], m_pNoSignalDetectedCB, 0);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[1], m_pNoSignalDetectedCB, 1);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[2], m_pNoSignalDetectedCB, 2);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[3], m_pNoSignalDetectedCB, 3);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[4], m_pNoSignalDetectedCB, 4);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hCapDev[5], m_pNoSignalDetectedCB, 5);

            // REGISTER SIGNAL REMOVED CALLBACK FUNCTION
            //
            m_pSignalRemovedCB = new EXPORTS.PF_SIGNAL_REMOVED_CALLBACK(on_process_signal_removed);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[0], m_pSignalRemovedCB, 0);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[1], m_pSignalRemovedCB, 1);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[2], m_pSignalRemovedCB, 2);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[3], m_pSignalRemovedCB, 3);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[4], m_pSignalRemovedCB, 4);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hCapDev[5], m_pSignalRemovedCB, 5);        

            // SET INPUT
            //
            uint nInput = (uint)EXPORTS.InputVideoSourceEnum.QCAP_INPUT_TYPE_SDI;

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[0], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[1], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[2], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[3], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[4], nInput);

            EXPORTS.QCAP_SET_VIDEO_INPUT(m_hCapDev[5], nInput);

            // SET DEINTERLACE
            //
            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[0], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[1], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[2], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[3], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[4], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hCapDev[5], 0);

            EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev[0], 0, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev[0], 1, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev[1], 0, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev[1], 1, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev[2], 0, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev[2], 1, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev[3], 0, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev[3], 1, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev[4], 0, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev[4], 1, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev[5], 0, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 12 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

            EXPORTS.QCAP_SET_VIDEO_HARDWARE_ENCODER_PROPERTY_EX(m_hCapDev[5], 1, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_MAIN, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_41, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CABAC, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 6 * 1024 * 1024, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0);

            // RUN DEVICE
            //         
            EXPORTS.QCAP_RUN(m_hCapDev[0]);
       
            EXPORTS.QCAP_RUN(m_hCapDev[1]);

            EXPORTS.QCAP_RUN(m_hCapDev[2]);

            EXPORTS.QCAP_RUN(m_hCapDev[3]);

            EXPORTS.QCAP_RUN(m_hCapDev[4]);

            EXPORTS.QCAP_RUN(m_hCapDev[5]);    
        
            timerCheckSignal.Enabled = true;

            return true;
        }

        public bool HwUnInitialize()
        {
            if (m_bCreateShareRecord1){ EXPORTS.QCAP_STOP_SHARE_RECORD(0);}

            if (m_bCreateShareRecord2) { EXPORTS.QCAP_STOP_SHARE_RECORD(1); }

            if (m_hCloneCapDev[0] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[0]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[0]); m_hCloneCapDev[0] = 0x00000000; }

            if (m_hCloneCapDev[1] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[1]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[1]); m_hCloneCapDev[1] = 0x00000000; }

            if (m_hCloneCapDev[2] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[2]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[2]); m_hCloneCapDev[2] = 0x00000000; }

            if (m_hCloneCapDev[3] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[3]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[3]); m_hCloneCapDev[3] = 0x00000000; }

            if (m_hCloneCapDev[4] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[4]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[4]); m_hCloneCapDev[4] = 0x00000000; }

            if (m_hCloneCapDev[5] != 0) { EXPORTS.QCAP_STOP(m_hCloneCapDev[5]); EXPORTS.QCAP_DESTROY(m_hCloneCapDev[5]); m_hCloneCapDev[5] = 0x00000000; }

            if (m_hCapDev[0] != 0) { EXPORTS.QCAP_STOP_RECORD(m_hCapDev[0], 0); EXPORTS.QCAP_STOP_RECORD(m_hCapDev[0], 1);  EXPORTS.QCAP_STOP(m_hCapDev[0]); EXPORTS.QCAP_DESTROY(m_hCapDev[0]); m_hCapDev[0] = 0x00000000; }

            if (m_hCapDev[1] != 0) { EXPORTS.QCAP_STOP_RECORD(m_hCapDev[1], 0); EXPORTS.QCAP_STOP_RECORD(m_hCapDev[1], 1); EXPORTS.QCAP_STOP(m_hCapDev[1]); EXPORTS.QCAP_DESTROY(m_hCapDev[1]); m_hCapDev[1] = 0x00000000; }

            if (m_hCapDev[2] != 0) { EXPORTS.QCAP_STOP_RECORD(m_hCapDev[2], 0); EXPORTS.QCAP_STOP_RECORD(m_hCapDev[2], 1); EXPORTS.QCAP_STOP(m_hCapDev[2]); EXPORTS.QCAP_DESTROY(m_hCapDev[2]); m_hCapDev[2] = 0x00000000; }

            if (m_hCapDev[3] != 0) { EXPORTS.QCAP_STOP_RECORD(m_hCapDev[3], 0); EXPORTS.QCAP_STOP_RECORD(m_hCapDev[3], 1); EXPORTS.QCAP_STOP(m_hCapDev[3]); EXPORTS.QCAP_DESTROY(m_hCapDev[3]); m_hCapDev[3] = 0x00000000; }

            if (m_hCapDev[4] != 0) { EXPORTS.QCAP_STOP_RECORD(m_hCapDev[4], 0); EXPORTS.QCAP_STOP_RECORD(m_hCapDev[4], 1); EXPORTS.QCAP_STOP(m_hCapDev[4]); EXPORTS.QCAP_DESTROY(m_hCapDev[4]); m_hCapDev[4] = 0x00000000; }

            if (m_hCapDev[5] != 0) { EXPORTS.QCAP_STOP_RECORD(m_hCapDev[5], 0); EXPORTS.QCAP_STOP_RECORD(m_hCapDev[5], 1); EXPORTS.QCAP_STOP(m_hCapDev[5]); EXPORTS.QCAP_DESTROY(m_hCapDev[5]); m_hCapDev[5] = 0x00000000; }

            return true;
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // GET CURRENT DIRECTORY
            //
            m_strCurrentDir = Directory.GetCurrentDirectory();

            m_cMyAdvancedSettingsDlg = new MyAdvancedSettingsDlg();

            m_cMyAdvancedSettingsDlg.m_pMainForm = this;

            m_cMyAdvancedSettingsDlg.Visible = false;

            m_cMyShareRecordAdvancedSettingsDlg = new MyShareRecordAdvancedSettingsDlg();

            m_cMyShareRecordAdvancedSettingsDlg.m_pMainForm = this;

            m_cMyShareRecordAdvancedSettingsDlg.Visible = false;

            m_strShareRecordFilePath = m_strCurrentDir;

            for (i = 0; i < 6; i++)
            {
                m_strRecordFilePath[i] = m_strCurrentDir;                

                m_strSnapshotFilePath[i] = m_strCurrentDir;

                m_bSupportGPU[i] = false;

                m_bCheckedAVI[i] = true; m_bCheckedMP4[i] = false;

                m_nContinuousSnapshots[i] = 3;

                m_nContinuousSnapshotsDuration[i] = 10;

                m_nVideoStandard[i] = 0;

                m_dFrameRate[i] = 30.0;

                m_nEncoderWidth[i] = 1920; m_nEncoderHeight[i] = 1080;

                m_nEncoderType[i] = (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE;

                m_nShareEncoderType = (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE;

                m_nEncoderFormat[i] = (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264;

                m_nShareEncoderFormat = (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264;

                m_nAudioEncoderFormat[i] = (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM;

                m_nShareAudioEncoderFormat = (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_PCM;

                m_nRecordMode[i] = (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR;

                m_nShareRecordMode = (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR;

                m_DownloadScaleMode[i] = (uint)EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_OFF;

                m_ShareDownloadScaleMode = (uint)EXPORTS.DownScaleModeEnum.QCAP_DOWNSCALE_MODE_OFF;

                m_nQuality[i] = 8000;

                m_nShareQuality = 8000;

                m_nBitRate[i] = 12582912;

                m_nShareBitRate = 12582912;

                m_nGOP[i] = 30;

                m_nShareGOP = 30;
            }

            m_bShareCheckedAVI = true;

            m_bShareCheckedMP4 = false;

            m_bShareRecordCH[0] = true; m_bShareRecordCH[1] = false; m_bShareRecordCH[2] = false;

            m_bShareRecordCH[3] = false; m_bShareRecordCH[4] = false; m_bShareRecordCH[5] = false;



            //
            //
            Panel dynamicPanel_1 = new Panel();

            Panel dynamicPanel_2 = new Panel();

            dynamicPanel_1.Location = new System.Drawing.Point(239, 599);

            dynamicPanel_2.Location = new System.Drawing.Point(423, 599);

            dynamicPanel_1.Name = "Panel1";

            dynamicPanel_2.Name = "Panel2";

            dynamicPanel_1.Size = new System.Drawing.Size(178, 20);

            dynamicPanel_2.Size = new System.Drawing.Size(162, 20);

            //dynamicPanel.BackColor = Color.LightBlue;            

            //RadioButton m_btnShareRecordGPU_1920x1080 = new RadioButton();

            m_btnShareRecordGPU_1920x1080.Name = "m_btnShareRecordGPU_1920x1080";

            m_btnShareRecordGPU_1920x1080.Text = "GPU ( 1920 x 1080 )";


            //RadioButton m_btnShareRecordGPU_720x576 = new RadioButton();

            m_btnShareRecordGPU_720x576.Name = "m_btnShareRecordGPU_720x576";

            m_btnShareRecordGPU_720x576.Text = "GPU ( 720 x 576 )";


            m_btnShareRecordGPU_1920x1080.Location = new Point(0, 0);

            m_btnShareRecordGPU_1920x1080.Size = new Size(178, 20);

            m_btnShareRecordGPU_720x576.Location = new Point(0, 0);

            m_btnShareRecordGPU_720x576.Size = new Size(162, 20);

            dynamicPanel_1.Controls.Add(m_btnShareRecordGPU_1920x1080);

            dynamicPanel_2.Controls.Add(m_btnShareRecordGPU_720x576);

            Controls.Add(dynamicPanel_1);

            Controls.Add(dynamicPanel_2);

            m_btnShareRecordGPU_1920x1080.Checked = true;

            m_btnShareRecordGPU_720x576.Checked = true;

            m_btnShareRecordGPU_1920x1080.Enabled = false;

            m_btnShareRecordGPU_720x576.Enabled = false;
            //
            //


            HwInitialize();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            m_bIsShareRecord = false;

            timerCheckSignal.Enabled = false;

            HwUnInitialize();
        }

        private void timerCheckSignal_Tick(object sender, EventArgs e)
        {
            // DISPLAY FORMAT MESSAGE
            //
            if (m_bNoSignal[0]) { textBoxInfoCH01.Text = "..."; toolTip.SetToolTip(textBoxInfoCH01, "..."); } else { textBoxInfoCH01.Text = m_strFormatChangedOutput[0]; toolTip.SetToolTip(textBoxInfoCH01, m_strFormatChangedOutput[0]); }

            if (m_bNoSignal[1]) { textBoxInfoCH02.Text = "..."; toolTip.SetToolTip(textBoxInfoCH02, "..."); } else { textBoxInfoCH02.Text = m_strFormatChangedOutput[1]; toolTip.SetToolTip(textBoxInfoCH02, m_strFormatChangedOutput[1]); }

            if (m_bNoSignal[2]) { textBoxInfoCH03.Text = "..."; toolTip.SetToolTip(textBoxInfoCH03, "..."); } else { textBoxInfoCH03.Text = m_strFormatChangedOutput[2]; toolTip.SetToolTip(textBoxInfoCH03, m_strFormatChangedOutput[2]); }

            if (m_bNoSignal[3]) { textBoxInfoCH04.Text = "..."; toolTip.SetToolTip(textBoxInfoCH04, "..."); } else { textBoxInfoCH04.Text = m_strFormatChangedOutput[3]; toolTip.SetToolTip(textBoxInfoCH04, m_strFormatChangedOutput[3]); }

            if (m_bNoSignal[4]) { textBoxInfoCH05.Text = "..."; toolTip.SetToolTip(textBoxInfoCH05, "..."); } else { textBoxInfoCH05.Text = m_strFormatChangedOutput[2]; toolTip.SetToolTip(textBoxInfoCH05, m_strFormatChangedOutput[4]); }

            if (m_bNoSignal[5]) { textBoxInfoCH06.Text = "..."; toolTip.SetToolTip(textBoxInfoCH06, "..."); } else { textBoxInfoCH06.Text = m_strFormatChangedOutput[3]; toolTip.SetToolTip(textBoxInfoCH06, m_strFormatChangedOutput[5]); }

            if (m_bIsShareRecord)
            {
                if (m_bShareRecordCH[0] && !m_bNoSignal[0])
                {
                    textBoxShareInfo.Text = @"CH01 : " + m_strFormatChangedOutput[0]; toolTip.SetToolTip(textBoxShareInfo, m_strFormatChangedOutput[0]);
                }

                if (m_bShareRecordCH[1] && !m_bNoSignal[1])
                {
                    textBoxShareInfo.Text = @"CH02 : " + m_strFormatChangedOutput[1]; toolTip.SetToolTip(textBoxShareInfo, m_strFormatChangedOutput[1]);
                }

                if (m_bShareRecordCH[2] && !m_bNoSignal[2])
                {
                    textBoxShareInfo.Text = @"CH03 : " + m_strFormatChangedOutput[2]; toolTip.SetToolTip(textBoxShareInfo, m_strFormatChangedOutput[2]);
                }

                if (m_bShareRecordCH[3] && !m_bNoSignal[3])
                {
                    textBoxShareInfo.Text = @"CH04 : " + m_strFormatChangedOutput[3]; toolTip.SetToolTip(textBoxShareInfo, m_strFormatChangedOutput[3]);
                }

                if (m_bShareRecordCH[4] && !m_bNoSignal[4])
                {
                    textBoxShareInfo.Text = @"CH05 : " + m_strFormatChangedOutput[4]; toolTip.SetToolTip(textBoxShareInfo, m_strFormatChangedOutput[4]);
                }

                if (m_bShareRecordCH[5] && !m_bNoSignal[5])
                {
                    textBoxShareInfo.Text = @"CH06 : " + m_strFormatChangedOutput[5]; toolTip.SetToolTip(textBoxShareInfo, m_strFormatChangedOutput[5]);
                }
            }
            else
            {
                textBoxShareInfo.Text = "";

                toolTip.SetToolTip(textBoxShareInfo, "...");
            }        
        }

        private void m_btnPropertyCh01_Click(object sender, EventArgs e)
        {
            m_cMyAdvancedSettingsDlg.m_nChannelNumber = 0;

            m_cMyAdvancedSettingsDlg.m_hCapDev[0] = m_hCapDev[0]; m_cMyAdvancedSettingsDlg.m_hCapDev[1] = m_hCapDev[1]; m_cMyAdvancedSettingsDlg.m_hCapDev[2] = m_hCapDev[2]; m_cMyAdvancedSettingsDlg.m_hCapDev[3] = m_hCapDev[3]; m_cMyAdvancedSettingsDlg.m_hCapDev[4] = m_hCapDev[4]; m_cMyAdvancedSettingsDlg.m_hCapDev[5] = m_hCapDev[5];

            m_cMyAdvancedSettingsDlg.m_hCloneCapDev[0] = m_hCloneCapDev[0]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[1] = m_hCloneCapDev[1]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[2] = m_hCloneCapDev[2]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[3] = m_hCloneCapDev[3]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[4] = m_hCloneCapDev[4]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[5] = m_hCloneCapDev[5];

            m_cMyAdvancedSettingsDlg.Text = "Advanced Settings - CH01";

            m_cMyAdvancedSettingsDlg.Show();
        }

        private void m_btnPropertyCh02_Click(object sender, EventArgs e)
        {
            m_cMyAdvancedSettingsDlg.m_nChannelNumber = 1;

            m_cMyAdvancedSettingsDlg.m_hCapDev[0] = m_hCapDev[0]; m_cMyAdvancedSettingsDlg.m_hCapDev[1] = m_hCapDev[1]; m_cMyAdvancedSettingsDlg.m_hCapDev[2] = m_hCapDev[2]; m_cMyAdvancedSettingsDlg.m_hCapDev[3] = m_hCapDev[3]; m_cMyAdvancedSettingsDlg.m_hCapDev[4] = m_hCapDev[4]; m_cMyAdvancedSettingsDlg.m_hCapDev[5] = m_hCapDev[5];

            m_cMyAdvancedSettingsDlg.m_hCloneCapDev[0] = m_hCloneCapDev[0]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[1] = m_hCloneCapDev[1]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[2] = m_hCloneCapDev[2]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[3] = m_hCloneCapDev[3]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[4] = m_hCloneCapDev[4]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[5] = m_hCloneCapDev[5];

            m_cMyAdvancedSettingsDlg.Text = "Advanced Settings - CH02";

            m_cMyAdvancedSettingsDlg.Show();
        }

        private void m_btnPropertyCh03_Click(object sender, EventArgs e)
        {
            m_cMyAdvancedSettingsDlg.m_nChannelNumber = 2;

            m_cMyAdvancedSettingsDlg.m_hCapDev[0] = m_hCapDev[0]; m_cMyAdvancedSettingsDlg.m_hCapDev[1] = m_hCapDev[1]; m_cMyAdvancedSettingsDlg.m_hCapDev[2] = m_hCapDev[2]; m_cMyAdvancedSettingsDlg.m_hCapDev[3] = m_hCapDev[3]; m_cMyAdvancedSettingsDlg.m_hCapDev[4] = m_hCapDev[4]; m_cMyAdvancedSettingsDlg.m_hCapDev[5] = m_hCapDev[5];

            m_cMyAdvancedSettingsDlg.m_hCloneCapDev[0] = m_hCloneCapDev[0]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[1] = m_hCloneCapDev[1]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[2] = m_hCloneCapDev[2]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[3] = m_hCloneCapDev[3]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[4] = m_hCloneCapDev[4]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[5] = m_hCloneCapDev[5];

            m_cMyAdvancedSettingsDlg.Text = "Advanced Settings - CH03";

            m_cMyAdvancedSettingsDlg.Show();
        }

        private void m_btnPropertyCh04_Click(object sender, EventArgs e)
        {
            m_cMyAdvancedSettingsDlg.m_nChannelNumber = 3;

            m_cMyAdvancedSettingsDlg.m_hCapDev[0] = m_hCapDev[0]; m_cMyAdvancedSettingsDlg.m_hCapDev[1] = m_hCapDev[1]; m_cMyAdvancedSettingsDlg.m_hCapDev[2] = m_hCapDev[2]; m_cMyAdvancedSettingsDlg.m_hCapDev[3] = m_hCapDev[3]; m_cMyAdvancedSettingsDlg.m_hCapDev[4] = m_hCapDev[4]; m_cMyAdvancedSettingsDlg.m_hCapDev[5] = m_hCapDev[5];

            m_cMyAdvancedSettingsDlg.m_hCloneCapDev[0] = m_hCloneCapDev[0]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[1] = m_hCloneCapDev[1]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[2] = m_hCloneCapDev[2]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[3] = m_hCloneCapDev[3]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[4] = m_hCloneCapDev[4]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[5] = m_hCloneCapDev[5];

            m_cMyAdvancedSettingsDlg.Text = "Advanced Settings - CH04";

            m_cMyAdvancedSettingsDlg.Show();
        }

        private void m_btnPropertyCh05_Click(object sender, EventArgs e)
        {
            m_cMyAdvancedSettingsDlg.m_nChannelNumber = 4;

            m_cMyAdvancedSettingsDlg.m_hCapDev[0] = m_hCapDev[0]; m_cMyAdvancedSettingsDlg.m_hCapDev[1] = m_hCapDev[1]; m_cMyAdvancedSettingsDlg.m_hCapDev[2] = m_hCapDev[2]; m_cMyAdvancedSettingsDlg.m_hCapDev[3] = m_hCapDev[3]; m_cMyAdvancedSettingsDlg.m_hCapDev[4] = m_hCapDev[4]; m_cMyAdvancedSettingsDlg.m_hCapDev[5] = m_hCapDev[5];

            m_cMyAdvancedSettingsDlg.m_hCloneCapDev[0] = m_hCloneCapDev[0]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[1] = m_hCloneCapDev[1]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[2] = m_hCloneCapDev[2]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[3] = m_hCloneCapDev[3]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[4] = m_hCloneCapDev[4]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[5] = m_hCloneCapDev[5];

            m_cMyAdvancedSettingsDlg.Text = "Advanced Settings - CH05";

            m_cMyAdvancedSettingsDlg.Show();
        }

        private void m_btnPropertyCh06_Click(object sender, EventArgs e)
        {
            m_cMyAdvancedSettingsDlg.m_nChannelNumber = 5;

            m_cMyAdvancedSettingsDlg.m_hCapDev[0] = m_hCapDev[0]; m_cMyAdvancedSettingsDlg.m_hCapDev[1] = m_hCapDev[1]; m_cMyAdvancedSettingsDlg.m_hCapDev[2] = m_hCapDev[2]; m_cMyAdvancedSettingsDlg.m_hCapDev[3] = m_hCapDev[3]; m_cMyAdvancedSettingsDlg.m_hCapDev[4] = m_hCapDev[4]; m_cMyAdvancedSettingsDlg.m_hCapDev[5] = m_hCapDev[5];

            m_cMyAdvancedSettingsDlg.m_hCloneCapDev[0] = m_hCloneCapDev[0]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[1] = m_hCloneCapDev[1]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[2] = m_hCloneCapDev[2]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[3] = m_hCloneCapDev[3]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[4] = m_hCloneCapDev[4]; m_cMyAdvancedSettingsDlg.m_hCloneCapDev[5] = m_hCloneCapDev[5];

            m_cMyAdvancedSettingsDlg.Text = "Advanced Settings - CH06";

            m_cMyAdvancedSettingsDlg.Show();
        }

        private void m_btnRecordStartCh01_Click(object sender, EventArgs e)
        {
            if (m_btnRecordStartCh01.Text == "START REC")
            {
                if (m_hCapDev[0] != 0)
                {
                    // HARDWARE ENCODER
                    //
                    EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev[0], 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nAudioEncoderFormat[0]);

                    EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev[0], 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, m_nEncoderFormat[0], m_nRecordMode[0], m_nQuality[0], m_nBitRate[0], m_nGOP[0], 0, 0, m_DownloadScaleMode[0]);
                    
                    // SOFTWARE GPU
                    //
                    EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev[0], 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nAudioEncoderFormat[0]);

                    EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY_EX(m_hCapDev[0], 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, m_nEncoderFormat[0], (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_BASELINE, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_31, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CAVLC, (uint)EXPORTS.RecordComplexityEnum.QCAP_RECORD_COMPLEXITY_0, m_nRecordMode[0], m_nQuality[0], m_nBitRate[0], m_nGOP[0], 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 720, 576);

                    SYSTEMTIME system_times = new SYSTEMTIME(); GetLocalTime(ref system_times);

                    string strRecordName1 = "";

                    if (m_bCheckedAVI[0]) { strRecordName1 = m_strRecordFilePath[0] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH01_HW_ENCODER.AVI"; }

                    if (m_bCheckedMP4[0]) { strRecordName1 = m_strRecordFilePath[0] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH01_HW_ENCODER.MP4"; }

                    if (strRecordName1 != "")
                    {
                        EXPORTS.QCAP_START_RECORD(m_hCapDev[0], 0, ref strRecordName1);
                    }

                    string strRecordName2 = "";

                    if (m_bCheckedAVI[0]) { strRecordName2 = m_strRecordFilePath[0] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH01_SW_GPU.AVI"; }

                    if (m_bCheckedMP4[0]) { strRecordName2 = m_strRecordFilePath[0] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH01_SW_GPU.MP4"; }

                    if (strRecordName2 != "")
                    {
                        EXPORTS.QCAP_START_RECORD(m_hCapDev[0], 2, ref strRecordName2);
                    }
                }

                m_btnRecordStartCh01.Text = "STOP REC";
            }
            else if (m_btnRecordStartCh01.Text == "STOP REC")
            {
                EXPORTS.QCAP_STOP_RECORD(m_hCapDev[0], 0);

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev[0], 2);

                m_btnRecordStartCh01.Text = "START REC";
            } 
        }

        private void m_btnRecordStartCh02_Click(object sender, EventArgs e)
        {
            if (m_btnRecordStartCh02.Text == "START REC")
            {
                if (m_hCapDev[1] != 0)
                {
                    // HARDWARE ENCODER
                    //
                    EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev[1], 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nAudioEncoderFormat[1]);

                    EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev[1], 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, m_nEncoderFormat[1], m_nRecordMode[1], m_nQuality[1], m_nBitRate[1], m_nGOP[1], 0, 0, m_DownloadScaleMode[1]);

                    // SOFTWARE GPU
                    //
                    EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev[1], 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nAudioEncoderFormat[1]);

                    EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY_EX(m_hCapDev[1], 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, m_nEncoderFormat[1], (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_BASELINE, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_31, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CAVLC, (uint)EXPORTS.RecordComplexityEnum.QCAP_RECORD_COMPLEXITY_0, m_nRecordMode[1], m_nQuality[1], m_nBitRate[1], m_nGOP[1], 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 720, 576);

                    SYSTEMTIME system_times = new SYSTEMTIME(); GetLocalTime(ref system_times);

                    string strRecordName1 = "";

                    if (m_bCheckedAVI[1]) { strRecordName1 = m_strRecordFilePath[1] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH02_HW_ENCODER.AVI"; }

                    if (m_bCheckedMP4[1]) { strRecordName1 = m_strRecordFilePath[1] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH02_HW_ENCODER.MP4"; }

                    if (strRecordName1 != "")
                    {
                        EXPORTS.QCAP_START_RECORD(m_hCapDev[1], 0, ref strRecordName1);
                    }

                    string strRecordName2 = "";

                    if (m_bCheckedAVI[1]) { strRecordName2 = m_strRecordFilePath[1] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH02_SW_GPU.AVI"; }

                    if (m_bCheckedMP4[1]) { strRecordName2 = m_strRecordFilePath[1] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH02_SW_GPU.MP4"; }

                    if (strRecordName2 != "")
                    {
                        EXPORTS.QCAP_START_RECORD(m_hCapDev[1], 2, ref strRecordName2);
                    }
                }

                m_btnRecordStartCh02.Text = "STOP REC";
            }
            else if (m_btnRecordStartCh02.Text == "STOP REC")
            {
                EXPORTS.QCAP_STOP_RECORD(m_hCapDev[1], 0);

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev[1], 2);

                m_btnRecordStartCh02.Text = "START REC";
            }
        }

        private void m_btnRecordStartCh03_Click(object sender, EventArgs e)
        {            
            if (m_btnRecordStartCh03.Text == "START REC")
            {
                if (m_hCapDev[2] != 0)
                {
                    // HARDWARE ENCODER
                    //
                    EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev[2], 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nAudioEncoderFormat[2]);

                    EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev[2], 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, m_nEncoderFormat[2], m_nRecordMode[2], m_nQuality[2], m_nBitRate[2], m_nGOP[2], 0, 0, m_DownloadScaleMode[2]);

                    // SOFTWARE GPU
                    //
                    EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev[2], 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nAudioEncoderFormat[2]);

                    EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY_EX(m_hCapDev[2], 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, m_nEncoderFormat[2], (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_BASELINE, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_31, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CAVLC, (uint)EXPORTS.RecordComplexityEnum.QCAP_RECORD_COMPLEXITY_0, m_nRecordMode[2], m_nQuality[2], m_nBitRate[2], m_nGOP[2], 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 720, 576);

                    SYSTEMTIME system_times = new SYSTEMTIME(); GetLocalTime(ref system_times);

                    string strRecordName1 = "";

                    if (m_bCheckedAVI[2]) { strRecordName1 = m_strRecordFilePath[2] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH03_HW_ENCODER.AVI"; }

                    if (m_bCheckedMP4[2]) { strRecordName1 = m_strRecordFilePath[2] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH03_HW_ENCODER.MP4"; }

                    if (strRecordName1 != "")
                    {
                        EXPORTS.QCAP_START_RECORD(m_hCapDev[2], 0, ref strRecordName1);
                    }

                    string strRecordName2 = "";

                    if (m_bCheckedAVI[2]) { strRecordName2 = m_strRecordFilePath[2] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH03_SW_GPU.AVI"; }

                    if (m_bCheckedMP4[2]) { strRecordName2 = m_strRecordFilePath[2] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH03_SW_GPU.MP4"; }

                    if (strRecordName2 != "")
                    {
                        EXPORTS.QCAP_START_RECORD(m_hCapDev[2], 2, ref strRecordName2);
                    }
                }

                m_btnRecordStartCh03.Text = "STOP REC";
            }
            else if (m_btnRecordStartCh03.Text == "STOP REC")
            {
                EXPORTS.QCAP_STOP_RECORD(m_hCapDev[2], 0);

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev[2], 2);

                m_btnRecordStartCh03.Text = "START REC";
            }
        }

        private void m_btnRecordStartCh04_Click(object sender, EventArgs e)
        {
            if (m_btnRecordStartCh04.Text == "START REC")
            {
                if (m_hCapDev[3] != 0)
                {
                    // HARDWARE ENCODER
                    //
                    EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev[3], 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nAudioEncoderFormat[3]);

                    EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev[3], 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, m_nEncoderFormat[3], m_nRecordMode[3], m_nQuality[3], m_nBitRate[3], m_nGOP[3], 0, 0, m_DownloadScaleMode[3]);

                    // SOFTWARE GPU
                    //
                    EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev[3], 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nAudioEncoderFormat[3]);

                    EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY_EX(m_hCapDev[3], 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, m_nEncoderFormat[3], (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_BASELINE, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_31, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CAVLC, (uint)EXPORTS.RecordComplexityEnum.QCAP_RECORD_COMPLEXITY_0, m_nRecordMode[3], m_nQuality[3], m_nBitRate[3], m_nGOP[3], 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 720, 576);

                    SYSTEMTIME system_times = new SYSTEMTIME(); GetLocalTime(ref system_times);

                    string strRecordName1 = "";

                    if (m_bCheckedAVI[3]) { strRecordName1 = m_strRecordFilePath[3] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH04_HW_ENCODER.AVI"; }

                    if (m_bCheckedMP4[3]) { strRecordName1 = m_strRecordFilePath[3] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH04_HW_ENCODER.MP4"; }

                    if (strRecordName1 != "")
                    {
                        EXPORTS.QCAP_START_RECORD(m_hCapDev[3], 0, ref strRecordName1);
                    }

                    string strRecordName2 = "";

                    if (m_bCheckedAVI[3]) { strRecordName2 = m_strRecordFilePath[3] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH04_SW_GPU.AVI"; }

                    if (m_bCheckedMP4[3]) { strRecordName2 = m_strRecordFilePath[3] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH04_SW_GPU.MP4"; }

                    if (strRecordName2 != "")
                    {
                        EXPORTS.QCAP_START_RECORD(m_hCapDev[3], 2, ref strRecordName2);
                    }
                }

                m_btnRecordStartCh04.Text = "STOP REC";
            }
            else if (m_btnRecordStartCh04.Text == "STOP REC")
            {
                EXPORTS.QCAP_STOP_RECORD(m_hCapDev[3], 0);

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev[3], 2);

                m_btnRecordStartCh04.Text = "START REC";
            }
        }

        private void m_btnRecordStartCh05_Click(object sender, EventArgs e)
        {
            if (m_btnRecordStartCh05.Text == "START REC")
            {
                if (m_hCapDev[4] != 0)
                {
                    // HARDWARE ENCODER
                    //
                    EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev[4], 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nAudioEncoderFormat[4]);

                    EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev[4], 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, m_nEncoderFormat[4], m_nRecordMode[4], m_nQuality[4], m_nBitRate[4], m_nGOP[4], 0, 0, m_DownloadScaleMode[4]);

                    // SOFTWARE GPU
                    //
                    EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev[4], 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nAudioEncoderFormat[4]);

                    EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY_EX(m_hCapDev[4], 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, m_nEncoderFormat[4], (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_BASELINE, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_31, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CAVLC, (uint)EXPORTS.RecordComplexityEnum.QCAP_RECORD_COMPLEXITY_0, m_nRecordMode[4], m_nQuality[4], m_nBitRate[4], m_nGOP[4], 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 720, 576);

                    SYSTEMTIME system_times = new SYSTEMTIME(); GetLocalTime(ref system_times);

                    string strRecordName1 = "";

                    if (m_bCheckedAVI[4]) { strRecordName1 = m_strRecordFilePath[4] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH05_HW_ENCODER.AVI"; }

                    if (m_bCheckedMP4[4]) { strRecordName1 = m_strRecordFilePath[4] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH05_HW_ENCODER.MP4"; }

                    if (strRecordName1 != "")
                    {
                        EXPORTS.QCAP_START_RECORD(m_hCapDev[4], 0, ref strRecordName1);
                    }

                    string strRecordName2 = "";

                    if (m_bCheckedAVI[4]) { strRecordName2 = m_strRecordFilePath[4] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH05_SW_GPU.AVI"; }

                    if (m_bCheckedMP4[4]) { strRecordName2 = m_strRecordFilePath[4] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH05_SW_GPU.MP4"; }

                    if (strRecordName2 != "")
                    {
                        EXPORTS.QCAP_START_RECORD(m_hCapDev[4], 2, ref strRecordName2);
                    }
                }

                m_btnRecordStartCh05.Text = "STOP REC";
            }
            else if (m_btnRecordStartCh05.Text == "STOP REC")
            {
                EXPORTS.QCAP_STOP_RECORD(m_hCapDev[4], 0);

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev[4], 2);

                m_btnRecordStartCh05.Text = "START REC";
            }
        }

        private void m_btnRecordStartCh06_Click(object sender, EventArgs e)
        {
            if (m_btnRecordStartCh06.Text == "START REC")
            {
                if (m_hCapDev[5] != 0)
                {
                    // HARDWARE ENCODER
                    //
                    EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev[5], 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nAudioEncoderFormat[5]);

                    EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY(m_hCapDev[5], 0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_HARDWARE, m_nEncoderFormat[5], m_nRecordMode[5], m_nQuality[5], m_nBitRate[5], m_nGOP[5], 0, 0, m_DownloadScaleMode[5]);

                    // SOFTWARE GPU
                    //
                    EXPORTS.QCAP_SET_AUDIO_RECORD_PROPERTY(m_hCapDev[5], 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nAudioEncoderFormat[5]);

                    EXPORTS.QCAP_SET_VIDEO_RECORD_PROPERTY_EX(m_hCapDev[5], 2, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, m_nEncoderFormat[5], (uint)EXPORTS.RecordProfileEnum.QCAP_RECORD_PROFILE_BASELINE, (uint)EXPORTS.RecordLevelEnum.QCAP_RECORD_LEVEL_31, (uint)EXPORTS.RecordEntropyEnum.QCAP_RECORD_ENTROPY_CAVLC, (uint)EXPORTS.RecordComplexityEnum.QCAP_RECORD_COMPLEXITY_0, m_nRecordMode[5], m_nQuality[5], m_nBitRate[5], m_nGOP[5], 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 720, 576);

                    SYSTEMTIME system_times = new SYSTEMTIME(); GetLocalTime(ref system_times);

                    string strRecordName1 = "";

                    if (m_bCheckedAVI[5]) { strRecordName1 = m_strRecordFilePath[5] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH06_HW_ENCODER.AVI"; }

                    if (m_bCheckedMP4[5]) { strRecordName1 = m_strRecordFilePath[5] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH06_HW_ENCODER.MP4"; }

                    if (strRecordName1 != "")
                    {
                        EXPORTS.QCAP_START_RECORD(m_hCapDev[5], 0, ref strRecordName1);
                    }

                    string strRecordName2 = "";

                    if (m_bCheckedAVI[5]) { strRecordName2 = m_strRecordFilePath[5] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH06_SW_GPU.AVI"; }

                    if (m_bCheckedMP4[5]) { strRecordName2 = m_strRecordFilePath[5] + "\\" + system_times.wYear.ToString() + system_times.wMonth.ToString() + system_times.wDay.ToString() + system_times.wHour.ToString() + system_times.wMinute.ToString() + system_times.wSecond.ToString() + "_CH06_SW_GPU.MP4"; }

                    if (strRecordName2 != "")
                    {
                        EXPORTS.QCAP_START_RECORD(m_hCapDev[5], 2, ref strRecordName2);
                    }
                }

                m_btnRecordStartCh06.Text = "STOP REC";
            }
            else if (m_btnRecordStartCh06.Text == "STOP REC")
            {
                EXPORTS.QCAP_STOP_RECORD(m_hCapDev[5], 0);

                EXPORTS.QCAP_STOP_RECORD(m_hCapDev[5], 2);

                m_btnRecordStartCh06.Text = "START REC";
            }
        }

        private void m_btnShareProperty_Click(object sender, EventArgs e)
        {
            m_cMyShareRecordAdvancedSettingsDlg.Show();
        }

        private void m_btnShareRecordStart_Click(object sender, EventArgs e)
        {
            if (m_btnShareRecordStart.Text == "START REC")
            {
                if (m_bShareCheckedAVI)
                {
                    EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY(0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nShareAudioEncoderFormat, 2, 16, 48000, 100);

                    EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY(1, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nShareAudioEncoderFormat, 2, 16, 48000, 100);
                }

                if (m_bShareCheckedMP4)
                {
                    EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY(0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nShareAudioEncoderFormat, 2, 16, 48000, 100);

                    EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY(1, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, m_nShareAudioEncoderFormat, 2, 16, 48000, 100);
                }

                //if (m_btnShareRecordGPU_1920x1080.Checked == true)
                {
                    EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY(0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK,

                        (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'V', '1', '2'),

                        1920, 1080, m_dShareVideoFrameRate, m_nShareRecordMode, m_nShareQuality, m_nShareBitRate, m_nShareGOP, 0, 0,

                        (uint)ShareWindow.Handle.ToInt32(), 1);
                }

                //if (m_btnShareRecordGPU_720x576.Checked == true)
                {
                    EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY(1, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK,

                        (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264, MAKEFOURCC('Y', 'V', '1', '2'),

                        720, 576, m_dShareVideoFrameRate, m_nShareRecordMode, m_nShareQuality, m_nShareBitRate, m_nShareGOP, 0, 0,

                        0, 1);
                }

                if (m_bShareCheckedAVI)
                {
                    //if (m_btnShareRecordGPU_1920x1080.Checked == true)
                    {
                        string strRecordName1;

                        strRecordName1 = m_strShareRecordFilePath + "\\_GPU_1920X1080_SHARE_RECORD.AVI";

                        EXPORTS.QCAP_START_SHARE_RECORD(0, ref strRecordName1);

                        m_bCreateShareRecord1 = true;

                        m_bCreateShareRecord2 = true;
                    }

                    //if (m_btnShareRecordGPU_720x576.Checked == true)
                    {
                        string strRecordName1;

                        strRecordName1 = m_strShareRecordFilePath + "\\_GPU_720X576_SHARE_RECORD.AVI";

                        EXPORTS.QCAP_START_SHARE_RECORD(1, ref strRecordName1);

                        m_bCreateShareRecord1 = true;

                        m_bCreateShareRecord2 = true;
                    }
                }

                if (m_bShareCheckedMP4)
                {
                    //if (m_btnShareRecordGPU_1920x1080.Checked == true)
                    {
                        string strRecordName1;

                        strRecordName1 = m_strShareRecordFilePath + "\\_GPU_1920X1080_SHARE_RECORD.MP4";

                        EXPORTS.QCAP_START_SHARE_RECORD(0, ref strRecordName1);

                        m_bCreateShareRecord1 = true;                       

                        m_bCreateShareRecord2 = true;
                    }

                    //if (m_btnShareRecordGPU_720x576.Checked == true)
                    {
                        string strRecordName1;

                        strRecordName1 = m_strShareRecordFilePath + "\\_GPU_720X576_SHARE_RECORD.MP4";

                        EXPORTS.QCAP_START_SHARE_RECORD(1, ref strRecordName1);

                        m_bCreateShareRecord1 = true;

                        m_bCreateShareRecord2 = true;
                    }                    
                }                

                m_bIsShareRecord = true;

                m_btnShareRecordStart.Text = "STOP REC";
            }
            else if (m_btnShareRecordStart.Text == "STOP REC")
            {
                m_bIsShareRecord = false;

                System.Threading.Thread.Sleep(512);

                //if (m_bCreateShareRecord1) { EXPORTS.QCAP_STOP_SHARE_RECORD(0); m_bCreateShareRecord1 = false; }
                { EXPORTS.QCAP_STOP_SHARE_RECORD(0); m_bCreateShareRecord1 = false; }

                //if (m_bCreateShareRecord2) { EXPORTS.QCAP_STOP_SHARE_RECORD(1); m_bCreateShareRecord2 = false; }
                { EXPORTS.QCAP_STOP_SHARE_RECORD(1); m_bCreateShareRecord2 = false; }

                m_btnShareRecordStart.Text = "START REC";
            }
        }

        private void m_btnShareSwitchCH01_Click(object sender, EventArgs e)
        {
            m_btnShareSwitchCH01.Checked = true; m_btnShareSwitchCH02.Checked = false;

            m_btnShareSwitchCH03.Checked = false; m_btnShareSwitchCH04.Checked = false;

            m_btnShareSwitchCH05.Checked = false; m_btnShareSwitchCH06.Checked = false;

            m_bShareRecordCH[0] = true; m_bShareRecordCH[1] = false; m_bShareRecordCH[2] = false;

            m_bShareRecordCH[3] = false; m_bShareRecordCH[4] = false; m_bShareRecordCH[5] = false;
        }

        private void m_btnShareSwitchCH02_Click(object sender, EventArgs e)
        {
            m_btnShareSwitchCH01.Checked = false; m_btnShareSwitchCH02.Checked = true;

            m_btnShareSwitchCH03.Checked = false; m_btnShareSwitchCH04.Checked = false;

            m_btnShareSwitchCH05.Checked = false; m_btnShareSwitchCH06.Checked = false;

            m_bShareRecordCH[0] = false; m_bShareRecordCH[1] = true; m_bShareRecordCH[2] = false;

            m_bShareRecordCH[3] = false; m_bShareRecordCH[4] = false; m_bShareRecordCH[5] = false;
        }

        private void m_btnShareSwitchCH03_Click(object sender, EventArgs e)
        {
            m_btnShareSwitchCH01.Checked = false; m_btnShareSwitchCH02.Checked = false;

            m_btnShareSwitchCH03.Checked = true; m_btnShareSwitchCH04.Checked = false;

            m_btnShareSwitchCH05.Checked = false; m_btnShareSwitchCH06.Checked = false;

            m_bShareRecordCH[0] = false; m_bShareRecordCH[1] = false; m_bShareRecordCH[2] = true;

            m_bShareRecordCH[3] = false; m_bShareRecordCH[4] = false; m_bShareRecordCH[5] = false;
        }

        private void m_btnShareSwitchCH04_Click(object sender, EventArgs e)
        {
            m_btnShareSwitchCH01.Checked = false; m_btnShareSwitchCH02.Checked = false;

            m_btnShareSwitchCH03.Checked = false; m_btnShareSwitchCH04.Checked = true;

            m_btnShareSwitchCH05.Checked = false; m_btnShareSwitchCH06.Checked = false;

            m_bShareRecordCH[0] = false; m_bShareRecordCH[1] = false; m_bShareRecordCH[2] = false;

            m_bShareRecordCH[3] = true; m_bShareRecordCH[4] = false; m_bShareRecordCH[5] = false;
        }

        private void m_btnShareSwitchCH05_Click(object sender, EventArgs e)
        {
            m_btnShareSwitchCH01.Checked = false; m_btnShareSwitchCH02.Checked = false;

            m_btnShareSwitchCH03.Checked = false; m_btnShareSwitchCH04.Checked = false;

            m_btnShareSwitchCH05.Checked = true; m_btnShareSwitchCH06.Checked = false;

            m_bShareRecordCH[0] = false; m_bShareRecordCH[1] = false; m_bShareRecordCH[2] = false;

            m_bShareRecordCH[3] = false; m_bShareRecordCH[4] = true; m_bShareRecordCH[5] = false;
        }

        private void m_btnShareSwitchCH06_Click(object sender, EventArgs e)
        {
            m_btnShareSwitchCH01.Checked = false; m_btnShareSwitchCH02.Checked = false;

            m_btnShareSwitchCH03.Checked = false; m_btnShareSwitchCH04.Checked = false;

            m_btnShareSwitchCH05.Checked = false; m_btnShareSwitchCH06.Checked = true;

            m_bShareRecordCH[0] = false; m_bShareRecordCH[1] = false; m_bShareRecordCH[2] = false;

            m_bShareRecordCH[3] = false; m_bShareRecordCH[4] = false; m_bShareRecordCH[5] = true;
        }
    
        private void m_btnShareRecordGPU_1920x1080_Click(object sender, EventArgs e)
        {
            m_btnShareRecordGPU_1920x1080.Checked = true;

            m_btnShareRecordGPU_720x576.Checked = false;
        }

        private void m_btnShareRecordGPU_720x576_Click(object sender, EventArgs e)
        {
            m_btnShareRecordGPU_1920x1080.Checked = false;

            m_btnShareRecordGPU_720x576.Checked = true;
        }

        private void m_btnShareRecordGPU_720x576_CheckedChanged(object sender, EventArgs e)
        {

        }      
    }
}
