// MyLayout.cpp: implementation of the MyLayout class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"

#include "MyLayout.h"
#include "MyVideoWnd.h"
#include "MyViewManager.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

#define HIDE_AREA_4(a1, a2, a3, a4) \
if (a1 >= 0) {m_listWnd[ a1 ]->ShowWindow(SW_HIDE); m_listPosState[ a1 ] |= WND_MAX_HIDE;} \
if (a2 >= 0) {m_listWnd[ a2 ]->ShowWindow(SW_HIDE); m_listPosState[ a2 ] |= WND_MAX_HIDE;} \
if (a3 >= 0) {m_listWnd[ a3 ]->ShowWindow(SW_HIDE); m_listPosState[ a3 ] |= WND_MAX_HIDE;} \
if (a4 >= 0) {m_listWnd[ a4 ]->ShowWindow(SW_HIDE); m_listPosState[ a4 ] |= WND_MAX_HIDE;}

#define HIDE_AREA_9(a1, a2, a3, a4, a5, a6, a7, a8, a9) \
if (a1 >= 0) {m_listWnd[ a1 ]->ShowWindow(SW_HIDE); m_listPosState[ a1 ] |= WND_MAX_HIDE;} \
if (a2 >= 0) {m_listWnd[ a2 ]->ShowWindow(SW_HIDE); m_listPosState[ a2 ] |= WND_MAX_HIDE;} \
if (a3 >= 0) {m_listWnd[ a3 ]->ShowWindow(SW_HIDE); m_listPosState[ a3 ] |= WND_MAX_HIDE;} \
if (a4 >= 0) {m_listWnd[ a4 ]->ShowWindow(SW_HIDE); m_listPosState[ a4 ] |= WND_MAX_HIDE;} \
if (a5 >= 0) {m_listWnd[ a5 ]->ShowWindow(SW_HIDE); m_listPosState[ a5 ] |= WND_MAX_HIDE;} \
if (a6 >= 0) {m_listWnd[ a6 ]->ShowWindow(SW_HIDE); m_listPosState[ a6 ] |= WND_MAX_HIDE;} \
if (a7 >= 0) {m_listWnd[ a7 ]->ShowWindow(SW_HIDE); m_listPosState[ a7 ] |= WND_MAX_HIDE;} \
if (a8 >= 0) {m_listWnd[ a8 ]->ShowWindow(SW_HIDE); m_listPosState[ a8 ] |= WND_MAX_HIDE;} \
if (a9 >= 0) {m_listWnd[ a9 ]->ShowWindow(SW_HIDE); m_listPosState[ a9 ] |= WND_MAX_HIDE;}

#define HIDE_AREA_16(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16) \
if (a1  >= 0) {m_listWnd[ a1 ]->ShowWindow(SW_HIDE);  m_listPosState[ a1 ] |= WND_MAX_HIDE;} \
if (a2  >= 0) {m_listWnd[ a2 ]->ShowWindow(SW_HIDE);  m_listPosState[ a2 ] |= WND_MAX_HIDE;} \
if (a3  >= 0) {m_listWnd[ a3 ]->ShowWindow(SW_HIDE);  m_listPosState[ a3 ] |= WND_MAX_HIDE;} \
if (a4  >= 0) {m_listWnd[ a4 ]->ShowWindow(SW_HIDE);  m_listPosState[ a4 ] |= WND_MAX_HIDE;} \
if (a5  >= 0) {m_listWnd[ a5 ]->ShowWindow(SW_HIDE);  m_listPosState[ a5 ] |= WND_MAX_HIDE;} \
if (a6  >= 0) {m_listWnd[ a6 ]->ShowWindow(SW_HIDE);  m_listPosState[ a6 ] |= WND_MAX_HIDE;} \
if (a7  >= 0) {m_listWnd[ a7 ]->ShowWindow(SW_HIDE);  m_listPosState[ a7 ] |= WND_MAX_HIDE;} \
if (a8  >= 0) {m_listWnd[ a8 ]->ShowWindow(SW_HIDE);  m_listPosState[ a8 ] |= WND_MAX_HIDE;} \
if (a9  >= 0) {m_listWnd[ a9 ]->ShowWindow(SW_HIDE);  m_listPosState[ a9 ] |= WND_MAX_HIDE;} \
if (a10 >= 0) {m_listWnd[ a10 ]->ShowWindow(SW_HIDE); m_listPosState[ a10 ] |= WND_MAX_HIDE;} \
if (a11 >= 0) {m_listWnd[ a11 ]->ShowWindow(SW_HIDE); m_listPosState[ a11 ] |= WND_MAX_HIDE;} \
if (a12 >= 0) {m_listWnd[ a12 ]->ShowWindow(SW_HIDE); m_listPosState[ a12 ] |= WND_MAX_HIDE;} \
if (a13 >= 0) {m_listWnd[ a13 ]->ShowWindow(SW_HIDE); m_listPosState[ a13 ] |= WND_MAX_HIDE;} \
if (a14 >= 0) {m_listWnd[ a14 ]->ShowWindow(SW_HIDE); m_listPosState[ a14 ] |= WND_MAX_HIDE;} \
if (a15 >= 0) {m_listWnd[ a15 ]->ShowWindow(SW_HIDE); m_listPosState[ a15 ] |= WND_MAX_HIDE;} \
if (a16 >= 0) {m_listWnd[ a16 ]->ShowWindow(SW_HIDE); m_listPosState[ a16 ] |= WND_MAX_HIDE;} 

#define HIDE_AREA_36(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30, a31, a32, a33, a34, a35, a36) \
if (a1  >= 0) {m_listWnd[ a1 ]->ShowWindow(SW_HIDE);  m_listPosState[ a1 ] |= WND_MAX_HIDE;} \
if (a2  >= 0) {m_listWnd[ a2 ]->ShowWindow(SW_HIDE);  m_listPosState[ a2 ] |= WND_MAX_HIDE;} \
if (a3  >= 0) {m_listWnd[ a3 ]->ShowWindow(SW_HIDE);  m_listPosState[ a3 ] |= WND_MAX_HIDE;} \
if (a4  >= 0) {m_listWnd[ a4 ]->ShowWindow(SW_HIDE);  m_listPosState[ a4 ] |= WND_MAX_HIDE;} \
if (a5  >= 0) {m_listWnd[ a5 ]->ShowWindow(SW_HIDE);  m_listPosState[ a5 ] |= WND_MAX_HIDE;} \
if (a6  >= 0) {m_listWnd[ a6 ]->ShowWindow(SW_HIDE);  m_listPosState[ a6 ] |= WND_MAX_HIDE;} \
if (a7  >= 0) {m_listWnd[ a7 ]->ShowWindow(SW_HIDE);  m_listPosState[ a7 ] |= WND_MAX_HIDE;} \
if (a8  >= 0) {m_listWnd[ a8 ]->ShowWindow(SW_HIDE);  m_listPosState[ a8 ] |= WND_MAX_HIDE;} \
if (a9  >= 0) {m_listWnd[ a9 ]->ShowWindow(SW_HIDE);  m_listPosState[ a9 ] |= WND_MAX_HIDE;} \
if (a10 >= 0) {m_listWnd[ a10 ]->ShowWindow(SW_HIDE); m_listPosState[ a10 ] |= WND_MAX_HIDE;} \
if (a11 >= 0) {m_listWnd[ a11 ]->ShowWindow(SW_HIDE); m_listPosState[ a11 ] |= WND_MAX_HIDE;} \
if (a12 >= 0) {m_listWnd[ a12 ]->ShowWindow(SW_HIDE); m_listPosState[ a12 ] |= WND_MAX_HIDE;} \
if (a13 >= 0) {m_listWnd[ a13 ]->ShowWindow(SW_HIDE); m_listPosState[ a13 ] |= WND_MAX_HIDE;} \
if (a14 >= 0) {m_listWnd[ a14 ]->ShowWindow(SW_HIDE); m_listPosState[ a14 ] |= WND_MAX_HIDE;} \
if (a15 >= 0) {m_listWnd[ a15 ]->ShowWindow(SW_HIDE); m_listPosState[ a15 ] |= WND_MAX_HIDE;} \
if (a16 >= 0) {m_listWnd[ a16 ]->ShowWindow(SW_HIDE); m_listPosState[ a16 ] |= WND_MAX_HIDE;} \
if (a17 >= 0) {m_listWnd[ a17 ]->ShowWindow(SW_HIDE); m_listPosState[ a17 ] |= WND_MAX_HIDE;} \
if (a18 >= 0) {m_listWnd[ a18 ]->ShowWindow(SW_HIDE); m_listPosState[ a18 ] |= WND_MAX_HIDE;} \
if (a19 >= 0) {m_listWnd[ a19 ]->ShowWindow(SW_HIDE); m_listPosState[ a19 ] |= WND_MAX_HIDE;} \
if (a20 >= 0) {m_listWnd[ a20 ]->ShowWindow(SW_HIDE); m_listPosState[ a20 ] |= WND_MAX_HIDE;} \
if (a21 >= 0) {m_listWnd[ a21 ]->ShowWindow(SW_HIDE); m_listPosState[ a21 ] |= WND_MAX_HIDE;} \
if (a22 >= 0) {m_listWnd[ a22 ]->ShowWindow(SW_HIDE); m_listPosState[ a22 ] |= WND_MAX_HIDE;} \
if (a23 >= 0) {m_listWnd[ a23 ]->ShowWindow(SW_HIDE); m_listPosState[ a23 ] |= WND_MAX_HIDE;} \
if (a24 >= 0) {m_listWnd[ a24 ]->ShowWindow(SW_HIDE); m_listPosState[ a24 ] |= WND_MAX_HIDE;} \
if (a25 >= 0) {m_listWnd[ a25 ]->ShowWindow(SW_HIDE); m_listPosState[ a25 ] |= WND_MAX_HIDE;} \
if (a26 >= 0) {m_listWnd[ a26 ]->ShowWindow(SW_HIDE); m_listPosState[ a26 ] |= WND_MAX_HIDE;} \
if (a27 >= 0) {m_listWnd[ a27 ]->ShowWindow(SW_HIDE); m_listPosState[ a27 ] |= WND_MAX_HIDE;} \
if (a28 >= 0) {m_listWnd[ a28 ]->ShowWindow(SW_HIDE); m_listPosState[ a28 ] |= WND_MAX_HIDE;} \
if (a29 >= 0) {m_listWnd[ a29 ]->ShowWindow(SW_HIDE); m_listPosState[ a29 ] |= WND_MAX_HIDE;} \
if (a30 >= 0) {m_listWnd[ a30 ]->ShowWindow(SW_HIDE); m_listPosState[ a30 ] |= WND_MAX_HIDE;} \
if (a31 >= 0) {m_listWnd[ a31 ]->ShowWindow(SW_HIDE); m_listPosState[ a31 ] |= WND_MAX_HIDE;} \
if (a32 >= 0) {m_listWnd[ a32 ]->ShowWindow(SW_HIDE); m_listPosState[ a32 ] |= WND_MAX_HIDE;} \
if (a33 >= 0) {m_listWnd[ a33 ]->ShowWindow(SW_HIDE); m_listPosState[ a33 ] |= WND_MAX_HIDE;} \
if (a34 >= 0) {m_listWnd[ a34 ]->ShowWindow(SW_HIDE); m_listPosState[ a34 ] |= WND_MAX_HIDE;} \
if (a35 >= 0) {m_listWnd[ a35 ]->ShowWindow(SW_HIDE); m_listPosState[ a35 ] |= WND_MAX_HIDE;} \
if (a36 >= 0) {m_listWnd[ a36 ]->ShowWindow(SW_HIDE); m_listPosState[ a36 ] |= WND_MAX_HIDE;}

#define SHOW_AREA_4(a1, a2, a3, a4) \
if (a1 >= 0) {m_listWnd[ a1 ]->ShowWindow(SW_SHOW); m_listPosState[ a1 ] &= ~WND_MAX_HIDE;} \
if (a2 >= 0) {m_listWnd[ a2 ]->ShowWindow(SW_SHOW); m_listPosState[ a2 ] &= ~WND_MAX_HIDE;} \
if (a3 >= 0) {m_listWnd[ a3 ]->ShowWindow(SW_SHOW); m_listPosState[ a3 ] &= ~WND_MAX_HIDE;} \
if (a4 >= 0) {m_listWnd[ a4 ]->ShowWindow(SW_SHOW); m_listPosState[ a4 ] &= ~WND_MAX_HIDE;}

#define SHOW_AREA_9(a1, a2, a3, a4, a5, a6, a7, a8, a9) \
if (a1 >= 0) {m_listWnd[ a1 ]->ShowWindow(SW_SHOW); m_listPosState[ a1 ] &= ~WND_MAX_HIDE;} \
if (a2 >= 0) {m_listWnd[ a2 ]->ShowWindow(SW_SHOW); m_listPosState[ a2 ] &= ~WND_MAX_HIDE;} \
if (a3 >= 0) {m_listWnd[ a3 ]->ShowWindow(SW_SHOW); m_listPosState[ a3 ] &= ~WND_MAX_HIDE;} \
if (a4 >= 0) {m_listWnd[ a4 ]->ShowWindow(SW_SHOW); m_listPosState[ a4 ] &= ~WND_MAX_HIDE;} \
if (a5 >= 0) {m_listWnd[ a5 ]->ShowWindow(SW_SHOW); m_listPosState[ a5 ] &= ~WND_MAX_HIDE;} \
if (a6 >= 0) {m_listWnd[ a6 ]->ShowWindow(SW_SHOW); m_listPosState[ a6 ] &= ~WND_MAX_HIDE;} \
if (a7 >= 0) {m_listWnd[ a7 ]->ShowWindow(SW_SHOW); m_listPosState[ a7 ] &= ~WND_MAX_HIDE;} \
if (a8 >= 0) {m_listWnd[ a8 ]->ShowWindow(SW_SHOW); m_listPosState[ a8 ] &= ~WND_MAX_HIDE;} \
if (a9 >= 0) {m_listWnd[ a9 ]->ShowWindow(SW_SHOW); m_listPosState[ a9 ] &= ~WND_MAX_HIDE;}

#define SHOW_AREA_16(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16) \
if (a1  >= 0) {m_listWnd[ a1 ]->ShowWindow(SW_SHOW);  m_listPosState[ a1 ] &= ~WND_MAX_HIDE;} \
if (a2  >= 0) {m_listWnd[ a2 ]->ShowWindow(SW_SHOW);  m_listPosState[ a2 ] &= ~WND_MAX_HIDE;} \
if (a3  >= 0) {m_listWnd[ a3 ]->ShowWindow(SW_SHOW);  m_listPosState[ a3 ] &= ~WND_MAX_HIDE;} \
if (a4  >= 0) {m_listWnd[ a4 ]->ShowWindow(SW_SHOW);  m_listPosState[ a4 ] &= ~WND_MAX_HIDE;} \
if (a5  >= 0) {m_listWnd[ a5 ]->ShowWindow(SW_SHOW);  m_listPosState[ a5 ] &= ~WND_MAX_HIDE;} \
if (a6  >= 0) {m_listWnd[ a6 ]->ShowWindow(SW_SHOW);  m_listPosState[ a6 ] &= ~WND_MAX_HIDE;} \
if (a7  >= 0) {m_listWnd[ a7 ]->ShowWindow(SW_SHOW);  m_listPosState[ a7 ] &= ~WND_MAX_HIDE;} \
if (a8  >= 0) {m_listWnd[ a8 ]->ShowWindow(SW_SHOW);  m_listPosState[ a8 ] &= ~WND_MAX_HIDE;} \
if (a9  >= 0) {m_listWnd[ a9 ]->ShowWindow(SW_SHOW);  m_listPosState[ a9 ] &= ~WND_MAX_HIDE;} \
if (a10 >= 0) {m_listWnd[ a10 ]->ShowWindow(SW_SHOW); m_listPosState[ a10 ] &= ~WND_MAX_HIDE;} \
if (a11 >= 0) {m_listWnd[ a11 ]->ShowWindow(SW_SHOW); m_listPosState[ a11 ] &= ~WND_MAX_HIDE;} \
if (a12 >= 0) {m_listWnd[ a12 ]->ShowWindow(SW_SHOW); m_listPosState[ a12 ] &= ~WND_MAX_HIDE;} \
if (a13 >= 0) {m_listWnd[ a13 ]->ShowWindow(SW_SHOW); m_listPosState[ a13 ] &= ~WND_MAX_HIDE;} \
if (a14 >= 0) {m_listWnd[ a14 ]->ShowWindow(SW_SHOW); m_listPosState[ a14 ] &= ~WND_MAX_HIDE;} \
if (a15 >= 0) {m_listWnd[ a15 ]->ShowWindow(SW_SHOW); m_listPosState[ a15 ] &= ~WND_MAX_HIDE;} \
if (a16 >= 0) {m_listWnd[ a16 ]->ShowWindow(SW_SHOW); m_listPosState[ a16 ] &= ~WND_MAX_HIDE;}

#define SHOW_AREA_36(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, a17, a18, a19, a20, a21, a22, a23, a24, a25, a26, a27, a28, a29, a30, a31, a32, a33, a34, a35, a36) \
if (a1  >= 0) {m_listWnd[ a1 ]->ShowWindow(SW_SHOW);  m_listPosState[ a1 ] &= ~WND_MAX_HIDE;} \
if (a2  >= 0) {m_listWnd[ a2 ]->ShowWindow(SW_SHOW);  m_listPosState[ a2 ] &= ~WND_MAX_HIDE;} \
if (a3  >= 0) {m_listWnd[ a3 ]->ShowWindow(SW_SHOW);  m_listPosState[ a3 ] &= ~WND_MAX_HIDE;} \
if (a4  >= 0) {m_listWnd[ a4 ]->ShowWindow(SW_SHOW);  m_listPosState[ a4 ] &= ~WND_MAX_HIDE;} \
if (a5  >= 0) {m_listWnd[ a5 ]->ShowWindow(SW_SHOW);  m_listPosState[ a5 ] &= ~WND_MAX_HIDE;} \
if (a6  >= 0) {m_listWnd[ a6 ]->ShowWindow(SW_SHOW);  m_listPosState[ a6 ] &= ~WND_MAX_HIDE;} \
if (a7  >= 0) {m_listWnd[ a7 ]->ShowWindow(SW_SHOW);  m_listPosState[ a7 ] &= ~WND_MAX_HIDE;} \
if (a8  >= 0) {m_listWnd[ a8 ]->ShowWindow(SW_SHOW);  m_listPosState[ a8 ] &= ~WND_MAX_HIDE;} \
if (a9  >= 0) {m_listWnd[ a9 ]->ShowWindow(SW_SHOW);  m_listPosState[ a9 ] &= ~WND_MAX_HIDE;} \
if (a10 >= 0) {m_listWnd[ a10 ]->ShowWindow(SW_SHOW); m_listPosState[ a10 ] &= ~WND_MAX_HIDE;} \
if (a11 >= 0) {m_listWnd[ a11 ]->ShowWindow(SW_SHOW); m_listPosState[ a11 ] &= ~WND_MAX_HIDE;} \
if (a12 >= 0) {m_listWnd[ a12 ]->ShowWindow(SW_SHOW); m_listPosState[ a12 ] &= ~WND_MAX_HIDE;} \
if (a13 >= 0) {m_listWnd[ a13 ]->ShowWindow(SW_SHOW); m_listPosState[ a13 ] &= ~WND_MAX_HIDE;} \
if (a14 >= 0) {m_listWnd[ a14 ]->ShowWindow(SW_SHOW); m_listPosState[ a14 ] &= ~WND_MAX_HIDE;} \
if (a15 >= 0) {m_listWnd[ a15 ]->ShowWindow(SW_SHOW); m_listPosState[ a15 ] &= ~WND_MAX_HIDE;} \
if (a16 >= 0) {m_listWnd[ a16 ]->ShowWindow(SW_SHOW); m_listPosState[ a16 ] &= ~WND_MAX_HIDE;} \
if (a17 >= 0) {m_listWnd[ a17 ]->ShowWindow(SW_SHOW); m_listPosState[ a17 ] &= ~WND_MAX_HIDE;} \
if (a18 >= 0) {m_listWnd[ a18 ]->ShowWindow(SW_SHOW); m_listPosState[ a18 ] &= ~WND_MAX_HIDE;} \
if (a19 >= 0) {m_listWnd[ a19 ]->ShowWindow(SW_SHOW); m_listPosState[ a19 ] &= ~WND_MAX_HIDE;} \
if (a20 >= 0) {m_listWnd[ a20 ]->ShowWindow(SW_SHOW); m_listPosState[ a20 ] &= ~WND_MAX_HIDE;} \
if (a21 >= 0) {m_listWnd[ a21 ]->ShowWindow(SW_SHOW); m_listPosState[ a21 ] &= ~WND_MAX_HIDE;} \
if (a22 >= 0) {m_listWnd[ a22 ]->ShowWindow(SW_SHOW); m_listPosState[ a22 ] &= ~WND_MAX_HIDE;} \
if (a23 >= 0) {m_listWnd[ a23 ]->ShowWindow(SW_SHOW); m_listPosState[ a23 ] &= ~WND_MAX_HIDE;} \
if (a24 >= 0) {m_listWnd[ a24 ]->ShowWindow(SW_SHOW); m_listPosState[ a24 ] &= ~WND_MAX_HIDE;} \
if (a25 >= 0) {m_listWnd[ a25 ]->ShowWindow(SW_SHOW); m_listPosState[ a25 ] &= ~WND_MAX_HIDE;} \
if (a26 >= 0) {m_listWnd[ a26 ]->ShowWindow(SW_SHOW); m_listPosState[ a26 ] &= ~WND_MAX_HIDE;} \
if (a27 >= 0) {m_listWnd[ a27 ]->ShowWindow(SW_SHOW); m_listPosState[ a27 ] &= ~WND_MAX_HIDE;} \
if (a28 >= 0) {m_listWnd[ a28 ]->ShowWindow(SW_SHOW); m_listPosState[ a28 ] &= ~WND_MAX_HIDE;} \
if (a29 >= 0) {m_listWnd[ a29 ]->ShowWindow(SW_SHOW); m_listPosState[ a29 ] &= ~WND_MAX_HIDE;} \
if (a30 >= 0) {m_listWnd[ a30 ]->ShowWindow(SW_SHOW); m_listPosState[ a30 ] &= ~WND_MAX_HIDE;} \
if (a31 >= 0) {m_listWnd[ a31 ]->ShowWindow(SW_SHOW); m_listPosState[ a31 ] &= ~WND_MAX_HIDE;} \
if (a32 >= 0) {m_listWnd[ a32 ]->ShowWindow(SW_SHOW); m_listPosState[ a32 ] &= ~WND_MAX_HIDE;} \
if (a33 >= 0) {m_listWnd[ a33 ]->ShowWindow(SW_SHOW); m_listPosState[ a33 ] &= ~WND_MAX_HIDE;} \
if (a34 >= 0) {m_listWnd[ a34 ]->ShowWindow(SW_SHOW); m_listPosState[ a34 ] &= ~WND_MAX_HIDE;} \
if (a35 >= 0) {m_listWnd[ a35 ]->ShowWindow(SW_SHOW); m_listPosState[ a35 ] &= ~WND_MAX_HIDE;} \
if (a36 >= 0) {m_listWnd[ a36 ]->ShowWindow(SW_SHOW); m_listPosState[ a36 ] &= ~WND_MAX_HIDE;}

#define COMBINE_RECT(dest, src1, src2) \
		(dest).left   = (src1).left; \
		(dest).top    = (src1).top; \
		(dest).right  = (src2).right; \
		(dest).bottom = (src2).bottom;

#define SCALE_RECT(r, x1, x2) \
			(r).left   = (r).left   * (x1) / (x2); \
			(r).right  = (r).right  * (x1) / (x2); \
			(r).top    = (r).top    * (x1) / (x2); \
			(r).bottom = (r).bottom * (x1) / (x2); 

#define SCALE_RECT_2(r, x1, x2, y1, y2) \
			r.left   = r.left   * (x1) / (x2); \
			r.right  = r.right  * (x1) / (x2); \
			r.top    = r.top    * (y1) / (y2); \
			r.bottom = r.bottom * (y1) / (y2); 
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

MyLayout::MyLayout()
{
	m_bIsCompare = FALSE;
}
 
MyLayout::~MyLayout()
{

}

void MyLayout::Active()
{
	int i = 0, j = 0;

	for (i = 0 ; i < m_listWnd.GetSize() ; ++i)
	{
        m_listWnd[ i ]->SetViewManager(m_pViewManager);

		m_listWnd[ i ]->MoveWindow( &(m_listVideoWndPos[ i ]) );

		if (m_listPosState[ i ] & WND_MAX_HIDE)
		{
			m_listWnd[ i ]->ShowWindow(SW_HIDE);
		}
		else
		{
			m_listWnd[ i ]->ShowWindow(SW_SHOW);
		}
	}	
}

void MyLayout::Inactive()
{
	int i;

	for (i = 0 ; i < m_listWnd.GetSize() ; ++i)
	{
        m_listWnd[ i ]->SetViewManager(NULL);

		m_listWnd[ i ]->ShowWindow(SW_HIDE);
	}
}

MyVideoWnd* MyLayout::GetAt(int nPos)
{
    return m_listWnd[ nPos ];
}

void MyLayout::SetLayoutRect(RECT &rect)
{
	if (m_listOrginalWnd.GetSize() == 0) { return; }

	m_listVideoWndPos.RemoveAll();

	RECT r;

	m_Rect = rect;

	for (int i = 0 ; i < (m_nXCount * m_nYCount) ; ++i)
	{
		r = CalcWndPos( i );

		m_listVideoWndPos.Add( CalcWndPos( i ) );
	}

	for (i = 0 ; i < (m_nXCount * m_nYCount) ; ++i)
	{
		if (m_listPosState[ i ] & WND_MAX)
		{
			Maximize( i );
		}
	}
}

void MyLayout::Notify(MyVideoWnd* pVideoWnd)
{
	if ( m_bIsCompare ) return;

	for (int i = 0 ; i< m_listWnd.GetSize() ; ++i)
	{
		if (pVideoWnd == m_listWnd[ i ])
		{
			(m_listPosState[ i ] & WND_MAX) ? Restore( i ) : Maximize( i );
			break;
		}
	}
}

BOOL MyLayout::IsWinMaximize()
{
	BOOL bIsWinMaximize = FALSE;

	for (int i = 0 ; i < m_listWnd.GetSize() ; ++i)
	{
		if (m_listPosState[ i ] & WND_MAX)
		{
			bIsWinMaximize = TRUE;
			break;
		}	
	}

	return bIsWinMaximize;
}

void MyLayout::SwapView(MyVideoWnd *pVideoWnd1, MyVideoWnd *pVideoWnd2)
{
	int nPos1 = -1, nPos2 = -1;

	int i;

	for (i = 0 ; i < m_listWnd.GetSize() ; ++i)
	{
		if (m_listWnd[ i ] == pVideoWnd1) { nPos1 = i; }
		if (m_listWnd[ i ] == pVideoWnd2) { nPos2 = i; }
	}

	SWAP(m_listWnd[ nPos1 ], m_listWnd[ nPos2 ]);

	m_listWnd[ nPos1 ]->MoveWindow( &(m_listVideoWndPos[ nPos1 ]) );

	m_listWnd[ nPos2 ]->MoveWindow( &(m_listVideoWndPos[ nPos2 ]));
}

void MyLayout::AddChannelToView(int nView, int nChannelNum)
{
	m_listViewChannel[ nView ].Add( nChannelNum );
}

void MyLayout::SetVideoWnds(MyVideoWnd *listWnd, int nCount)
{
	m_listWnd.RemoveAll();

	m_listOrginalWnd.RemoveAll();

	m_listPosState.RemoveAll();

	m_listVideoWndPos.RemoveAll();

	for (int i = 0 ; i < nCount ; ++i)
	{
		m_listViewChannel[ i ].RemoveAll();

		m_listWnd.Add( listWnd + i );

		m_listOrginalWnd.Add( listWnd + i );

		m_listPosState.Add( WND_NORMAL );
	}
}

void MyLayout::Maximize(int nIndex)
{

}

void MyLayout::ResetWndPos(int nIndex)
{
	m_listVideoWndPos[ nIndex ] = CalcWndPos( nIndex );
}

RECT MyLayout::CalcWndPos(int nIndex)
{
	int xCount = m_nXCount;
	int yCount = m_nYCount;

	int height = m_Rect.bottom - m_Rect.top;
	int width  = m_Rect.right  - m_Rect.left;

    int x, y;

	x = nIndex % m_nXCount;
	y = nIndex / m_nXCount;

	RECT r;

	r.left   = (width  * x / xCount);
	r.top    = (height * y / yCount);

	r.right  = (width  * (x + 1) / xCount);
	r.bottom = (height * (y + 1) / yCount );

	return r;
}

void MyLayout::Restore(int nIndex)
{

}

///////////////////////////////////////////////////////////////////////////////
My01Layout::My01Layout()
{
	m_nXCount = m_nYCount = 1;
}

My01Layout::~My01Layout()
{

}

void My01Layout::Maximize(int nIndex)
{

}

void My01Layout::Restore(int nIndex)
{

}
///////////////////////////////////////////////////////////////////////////////
My04Layout::My04Layout()
{
	m_nXCount = m_nYCount = 2;
}

My04Layout::~My04Layout()
{

}

void My04Layout::Maximize(int nIndex)
{	
	RECT r;

	if (nIndex == 0 || nIndex == 1 || nIndex == 2 || nIndex == 3)
	{
		COMBINE_RECT(r, m_listVideoWndPos[ 0 ], m_listVideoWndPos[ 3 ]);

		HIDE_AREA_4(0, 1, 2, 3);
	}

	m_listPosState[ nIndex ] = ((m_listPosState[ nIndex ]) & ~WND_MAX_HIDE) | WND_MAX;

	m_listVideoWndPos[ nIndex ] = r;

	m_listWnd[ nIndex ]->MoveWindow( &r );

	m_listWnd[ nIndex ]->ShowWindow(SW_SHOW);
}

void My04Layout::Restore(int nIndex)
{
	m_listVideoWndPos[ nIndex ] = CalcWndPos( nIndex );

	m_listWnd[ nIndex ]->MoveWindow(&(m_listVideoWndPos[ nIndex ]));

	if (nIndex == 0 || nIndex == 1 || nIndex == 2 || nIndex == 3)
	{
		SHOW_AREA_4(0, 1, 2, 3);
	}

	m_listPosState[ nIndex ] = ((m_listPosState[ nIndex ]) & ~WND_MAX);
}
///////////////////////////////////////////////////////////////////////////////
My09Layout::My09Layout()
{
	m_nXCount = m_nYCount = 3;
	m_nMaxWndIdx = -1;
}

My09Layout::~My09Layout()
{
}

void My09Layout::Maximize(int nIndex)
{
	RECT r;

	Restore(m_nMaxWndIdx);

	COMBINE_RECT(r, m_listVideoWndPos[ 0 ], m_listVideoWndPos[ 8 ]);

	HIDE_AREA_9( 0, 1, 2, 3, 4, 5, 6, 7, 8 );

	m_listPosState[ nIndex ] = ((m_listPosState[ nIndex ]) & ~WND_MAX_HIDE) | WND_MAX;

	m_listVideoWndPos[ nIndex ] = r;

	m_listWnd[ nIndex ]->MoveWindow( &r );

	m_listWnd[ nIndex ]->ShowWindow(SW_SHOW);

	m_nMaxWndIdx = nIndex;
}

void My09Layout::Restore(int nIndex)
{
	if (nIndex < 0) 
	{
		return;
	}

	m_listVideoWndPos[ nIndex ] = CalcWndPos( nIndex );

	m_listWnd[ nIndex ]->MoveWindow(&(m_listVideoWndPos[ nIndex ]));

	SHOW_AREA_9( 0, 1, 2, 3, 4, 5, 6, 7, 8 );
	
	m_listPosState[ nIndex ] = ((m_listPosState[ nIndex ]) & ~WND_MAX);

	m_nMaxWndIdx = -1;
}
///////////////////////////////////////////////////////////////////////////////
My16Layout::My16Layout()
{
	m_nXCount = m_nYCount = 4;
}

My16Layout::~My16Layout()
{

}

void My16Layout::Maximize(int nIndex)
{
	RECT r;

	COMBINE_RECT(r, m_listVideoWndPos[ 0 ], m_listVideoWndPos[ 15 ]);

	HIDE_AREA_16( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 );

	m_listPosState[ nIndex ] = ((m_listPosState[ nIndex ]) & ~WND_MAX_HIDE) | WND_MAX;

	m_listVideoWndPos[ nIndex ] = r;

	m_listWnd[ nIndex ]->MoveWindow( &r );

	m_listWnd[ nIndex ]->ShowWindow(SW_SHOW);
}

void My16Layout::Restore(int nIndex)
{
	m_listVideoWndPos[ nIndex ] = CalcWndPos( nIndex );

	m_listWnd[ nIndex ]->MoveWindow(&(m_listVideoWndPos[ nIndex ]));

	SHOW_AREA_16( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 );

	m_listPosState[ nIndex ] = ((m_listPosState[ nIndex ]) & ~WND_MAX);
}

///////////////////////////////////////////////////////////////////////////////
My36Layout::My36Layout()
{
	m_nXCount = m_nYCount = 6;
}

My36Layout::~My36Layout()
{

}

void My36Layout::Maximize(int nIndex)
{
	RECT r;

	if ( nIndex >= 0 && nIndex < 36 )
	{
		COMBINE_RECT(r, m_listVideoWndPos[ 0 ], m_listVideoWndPos[ 35 ]);

		HIDE_AREA_36( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35 );

		m_listPosState[ nIndex ] = ((m_listPosState[ nIndex ]) & ~WND_MAX_HIDE) | WND_MAX;

		m_listVideoWndPos[ nIndex ] = r;

		m_listWnd[ nIndex ]->MoveWindow( &r );

		m_listWnd[ nIndex ]->ShowWindow(SW_SHOW);
	}
}

void My36Layout::Restore(int nIndex)
{
	if ( nIndex >= 0 && nIndex < 36 )
	{
		m_listVideoWndPos[ nIndex ] = CalcWndPos( nIndex );

		m_listWnd[ nIndex ]->MoveWindow(&(m_listVideoWndPos[ nIndex ]));

		SHOW_AREA_36( 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35 );

		m_listPosState[ nIndex ] = ((m_listPosState[ nIndex ]) & ~WND_MAX);
	}	
}
///////////////////////////////////////////////////////////////////////////////
My64Layout::My64Layout()
{
	m_nXCount = m_nYCount = 8;
}

My64Layout::~My64Layout()
{

}

void My64Layout::Maximize(int nIndex)
{
	RECT r;

	if ( nIndex >= 0 && nIndex < 64 )
	{
		COMBINE_RECT(r, m_listVideoWndPos[ 0 ], m_listVideoWndPos[ 63 ]);

		HIDE_AREA_16(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);

		HIDE_AREA_16(16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31);

		HIDE_AREA_16(32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47);

		HIDE_AREA_16(48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63);

		m_listPosState[ nIndex ] = ((m_listPosState[ nIndex ]) & ~WND_MAX_HIDE) | WND_MAX;

		m_listVideoWndPos[ nIndex ] = r;

		m_listWnd[ nIndex ]->MoveWindow( &r );

		m_listWnd[ nIndex ]->ShowWindow(SW_SHOW);
	}
}

void My64Layout::Restore(int nIndex)
{
	if ( nIndex >= 0 && nIndex < 64 )
	{
		m_listVideoWndPos[ nIndex ] = CalcWndPos( nIndex );

		m_listWnd[ nIndex ]->MoveWindow(&(m_listVideoWndPos[ nIndex ]));

		SHOW_AREA_16(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15);

		SHOW_AREA_16(16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31);

		SHOW_AREA_16(32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47);

		SHOW_AREA_16(48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63);		
	}
}
///////////////////////////////////////////////////////////////////////////////
My144Layout::My144Layout()
{
	m_nXCount = m_nYCount = 12;
}

My144Layout::~My144Layout()
{

}

void My144Layout::Maximize(int nIndex)
{
	RECT r;

	if ( nIndex >= 0 && nIndex < 144 )
	{
		COMBINE_RECT(r, m_listVideoWndPos[ 0 ], m_listVideoWndPos[ 143 ]);

		HIDE_AREA_36(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35);

		HIDE_AREA_36(36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71);

		HIDE_AREA_36(72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107);

		HIDE_AREA_36(108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143);

		m_listPosState[ nIndex ] = ((m_listPosState[ nIndex ]) & ~WND_MAX_HIDE) | WND_MAX;

		m_listVideoWndPos[ nIndex ] = r;

		m_listWnd[ nIndex ]->MoveWindow( &r );

		m_listWnd[ nIndex ]->ShowWindow(SW_SHOW);
	}
}

void My144Layout::Restore(int nIndex)
{
	if ( nIndex >= 0 && nIndex < 144 )
	{
		m_listVideoWndPos[ nIndex ] = CalcWndPos( nIndex );

		m_listWnd[ nIndex ]->MoveWindow(&(m_listVideoWndPos[ nIndex ]));

		SHOW_AREA_36(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35);

		SHOW_AREA_36(36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71);

		SHOW_AREA_36(72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107);

		SHOW_AREA_36(108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143);
	}
}
///////////////////////////////////////////////////////////////////////////////
void MyLayout::SetViewManager(MyViewManager* pMgr)
{
    m_pViewManager = pMgr;
}

void MyLayout::DelAllChannelFromView(int nView)
{
	m_listViewChannel[ nView ].RemoveAll();
}

void MyLayout::MoveVideoWnds()
{
	int i = 0;
	
	for (i = 0 ; i < m_listWnd.GetSize() ; ++i)
	{
		m_listWnd[ i ]->MoveWindow( &(m_listVideoWndPos[ i ] ));
	}
}
///////////////////////////////////////////////////////////////////////////////