/*
 * Driver for Techwell TW6864/68 based DVR cards
 *
 * (c) 2009-10 liran <jlee@techwellinc.com.cn> [Techwell China]
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef TW686XREG_H_INCLUDED
#define TW686XREG_H_INCLUDED

//#define BIT(x)  (1<<(x))

//////////////////////////////////////////////////
//NO NOT CHANGE
// Register definitions
// IMPORTANT: These defines are DWORD-based.
#define TW6864_R_DMA_INT_STATUS				0x000	//0x00  //RO
#define		TW6864_R_DMA_INT_STATUS_ERR(ch)	(BIT(ch)<<24)
#define		TW6864_R_DMA_INT_STATUS_ERRALL	0xFF000000
#define		TW6864_R_DMA_INT_STATUS_TOUT	BIT(17)
#define		TW6864_R_DMA_INT_STATUS_DMA(ch)	BIT(ch)
#define		TW6864_R_DMA_INT_STATUS_DMAALL	0x1FFFF
#define TW6864_R_DMA_PB_STATUS				0x004	//0x01  //RO
#define TW6864_R_DMA_CMD					0x008	//0x02
#define		TW6864_R_DMA_CMD_TRIG			BIT(31)
#define		TW6864_R_DMA_CMD_RESET(ch)		BIT(ch)
#define		TW6864_R_DMA_CMD_RESETALL		0x01FFFF
#define TW6864_R_DMA_INT_ERROR				0x00C	//0x03
#define		TW6864_R_DMA_VINT_FLOW(ch)		(BIT(ch)<<24)
#define		TW6864_R_DMA_VINT_FIFO(ch)		(BIT(ch)<<16)
#define		TW6864_R_DMA_XINT_ERROR(ch)		BIT(ch)
#define TW6864_R_VIDEO_CHID					0x010	//0x04
#define TW6864_R_VIDEO_PARSER_STATUS		0x014	//0x05
#define TW6864_R_SYS_SOFT_RST				0x018	//0x06

#define TW6864_R_DMA_PAGE_TABLE0			0x020	//0x08  //RW
#define TW6864_R_DMA_PAGE_TABLE1			0x024	//0x09
#define TW6864_R_DMA_CHANNEL_ENABLE			0x028	//0x0a
#define TW6864_R_DMA_CONFIG					0x02C	//0x0b
#define TW6864_R_DMA_INT_REF				0x030	//0x0c
#define TW6864_R_DMA_CHANNEL_TIMEOUT		0x034	//0x0d

#define TW6864_R_DMA_CH0_CONFIG				0x040	//0x10  //DMA_CH0_CONFIG ~ DMA_CH7_CONFIG are continusly
#define TW6864_R_DMA_CH1_CONFIG				0x044	//0x11
#define TW6864_R_DMA_CH2_CONFIG				0x048	//0x12
#define TW6864_R_DMA_CH3_CONFIG				0x04C	//0x13
#define TW6864_R_DMA_CH4_CONFIG				0x050	//0x14
#define TW6864_R_DMA_CH5_CONFIG				0x054	//0x15
#define TW6864_R_DMA_CH6_CONFIG				0x058	//0x16
#define TW6864_R_DMA_CH7_CONFIG				0x05C	//0x17
#define TW6864_R_DMA_CH8_CONFIG_P			0x060	//0x18   // DMA_CH8_CONFIG_P ~ DMA_CH10_CONFIG_B are continusly
#define TW6864_R_DMA_CH8_CONFIG_B			0x064	//0x19
#define TW6864_R_DMA_CH9_CONFIG_P			0x068	//0x1A
#define TW6864_R_DMA_CH9_CONFIG_B			0x06C	//0x1B
#define TW6864_R_DMA_CHA_CONFIG_P			0x070	//0x1C
#define TW6864_R_DMA_CHA_CONFIG_B			0x074	//0x1D
#define TW6864_R_DMA_CHB_CONFIG_P			0x078	//0x1E
#define TW6864_R_DMA_CHB_CONFIG_B			0x07C	//0x1F
#define TW6864_R_DMA_CHC_CONFIG_P			0x080	//0x20
#define TW6864_R_DMA_CHC_CONFIG_B			0x084	//0x21
#define TW6864_R_DMA_CHD_CONFIG_P			0x088	//0x22
#define TW6864_R_DMA_CHD_CONFIG_B			0x08C	//0x23
#define TW6864_R_DMA_CHE_CONFIG_P			0x090	//0x24
#define TW6864_R_DMA_CHE_CONFIG_B			0x094	//0x25
#define TW6864_R_DMA_CHF_CONFIG_P			0x098	//0x26
#define TW6864_R_DMA_CHF_CONFIG_B			0x09C	//0x27
#define TW6864_R_DMA_CH10_CONFIG_P			0x0A0	//0x28
#define TW6864_R_DMA_CH10_CONFIG_B			0x0A4	//0x29
#define TW6864_R_CH0to7_CONFIG_REG(idx)		(TW6864_R_DMA_CH0_CONFIG+((idx)*4))
#define TW6864_R_CH8to15_CONFIG_REG_P(idx)	(TW6864_R_DMA_CH8_CONFIG_P+((idx)*8))
#define TW6864_R_CH8to15_CONFIG_REG_B(idx)	(TW6864_R_DMA_CH8_CONFIG_B+((idx)*8))

#define TW6864_R_VIDEO_CTRL1				0x0A8	//0x2A
#define		TW6864_R_VIDEO_CTRL1_STANDARD(ch)	(BIT(ch)<<13)
#define		TW6864_R_VIDEO_CTRL1_STANDARDALL	(0xFF<<13)
#define TW6864_R_VIDEO_CTRL2				0x0AC	//0x2B
#define		TW6864_R_VIDEO_CTRL2_GENRST(ch)		(BIT(ch)<<16)
#define		TW6864_R_VIDEO_CTRL2_GENRSTALL		0xFF0000
#define		TW6864_R_VIDEO_CTRL2_PATTERNS(ch)	(BIT(ch)<<8)
#define		TW6864_R_VIDEO_CTRL2_PATTERNSALL	0xFF00
#define		TW6864_R_VIDEO_CTRL2_GEN(ch)		BIT(ch)
#define		TW6864_R_VIDEO_CTRL2_GENALL			0xFF
#define TW6864_R_AUDIO_CTRL1				0x0B0	//0x2C
#define TW6864_R_AUDIO_CTRL2				0x0B4	//0x2D
#define TW6864_R_PHASE_REF_CONFIG			0x0B8	//0x2E
#define TW6864_R_GPIO_REG					0x0BC	//0x2F

#define TW6864_R_INTL_HBAR0_CTRL			0x0C0	//0x30
#define TW6864_R_INTL_HBAR1_CTRL			0x0C4	//0x31
#define TW6864_R_INTL_HBAR2_CTRL			0x0C8	//0x32
#define TW6864_R_INTL_HBAR3_CTRL			0x0CC	//0x33
#define TW6864_R_INTL_HBAR4_CTRL			0x0D0	//0x34
#define TW6864_R_INTL_HBAR5_CTRL			0x0D4	//0x35
#define TW6864_R_INTL_HBAR6_CTRL			0x0D8	//0x36
#define TW6864_R_INTL_HBAR7_CTRL			0x0DC	//0x37

#define TW6864_R_AUDIO_CTRL3				0x0E0	//0x38
#define TW6864_R_DROP_FIELD_REG0			0x0E4	//0x39
#define TW6864_R_DROP_FIELD_REG1			0x0E8	//0x3A
#define TW6864_R_DROP_FIELD_REG2			0x0EC	//0x3B
#define TW6864_R_DROP_FIELD_REG3			0x0F0	//0x3C
#define TW6864_R_DROP_FIELD_REG4			0x0F4	//0x3D
#define TW6864_R_DROP_FIELD_REG5			0x0F8	//0x3E
#define TW6864_R_DROP_FIELD_REG6			0x0FC	//0x3F
#define TW6864_R_DROP_FIELD_REG7			0x100	//0x40
#define TW6864_R_VIDEO_SIZE_REGA			0x104	//0x41		//Rev.A only
#define TW6864_R_SHSCALER_REG0				0x108	//0x42
#define TW6864_R_SHSCALER_REG1				0x10C	//0x43
#define TW6864_R_SHSCALER_REG2				0x110	//0x44
#define TW6864_R_SHSCALER_REG3				0x114	//0x45
#define TW6864_R_SHSCALER_REG4				0x118	//0x46
#define TW6864_R_SHSCALER_REG5				0x11C	//0x47
#define TW6864_R_SHSCALER_REG6				0x120	//0x48
#define TW6864_R_SHSCALER_REG7				0x124	//0x49
#define TW6864_R_VIDEO_SIZE_REG0			0x128	//0x4A		//Rev.B or later
#define TW6864_R_VIDEO_SIZE_REG1			0x12C	//0x4B
#define TW6864_R_VIDEO_SIZE_REG2			0x130	//0x4C
#define TW6864_R_VIDEO_SIZE_REG3			0x134	//0x4D
#define TW6864_R_VIDEO_SIZE_REG4			0x138	//0x4E
#define TW6864_R_VIDEO_SIZE_REG5			0x13C	//0x4F
#define TW6864_R_VIDEO_SIZE_REG6			0x140	//0x50
#define TW6864_R_VIDEO_SIZE_REG7			0x144	//0x51
#define TW6864_R_VIDEO_SIZE_REG0_F2			0x148	//0x52  //Rev.B or later
#define TW6864_R_VIDEO_SIZE_REG1_F2			0x14C	//0x53
#define TW6864_R_VIDEO_SIZE_REG2_F2			0x150	//0x54
#define TW6864_R_VIDEO_SIZE_REG3_F2			0x154	//0x55
#define TW6864_R_VIDEO_SIZE_REG4_F2			0x158	//0x56
#define TW6864_R_VIDEO_SIZE_REG5_F2			0x15C	//0x57
#define TW6864_R_VIDEO_SIZE_REG6_F2			0x160	//0x58
#define TW6864_R_VIDEO_SIZE_REG7_F2			0x164	//0x59
#define TW6864_R_VC_CTRL_REG0				0x1C0	//0x70
#define TW6864_R_VC_CTRL_REG1				0x1C4	//0x71
#define TW6864_R_VC_CTRL_REG2				0x1C8	//0x72
#define TW6864_R_VC_CTRL_REG3				0x1D0	//0x73
#define TW6864_R_VC_CTRL_REG4				0x1D4	//0x74
#define TW6864_R_VC_CTRL_REG5				0x1D8	//0x75
#define TW6864_R_VC_CTRL_REG6				0x1DC	//0x76
#define TW6864_R_VC_CTRL_REG7				0x1E0	//0x77
#define TW6864_R_BDMA_ADDR_P_0				0x200	//0x80   //0x80 ~ 0xBF,Rev.B or later
#define TW6864_R_BDMA_WHP_0					0x204	//0x81
#define TW6864_R_BDMA_ADDR_B_0				0x208	//0x82
#define TW6864_R_BDMA_ADDR_P_F2_0			0x210	//0x84
#define TW6864_R_BDMA_WHP_F2_0				0x214	//0x85
#define TW6864_R_BDMA_ADDR_B_F2_0			0x218	//0x86
#define TW6864_R_CSR_REG					0x3F4	//0xFD
#define TW6864_R_EP_REG_ADDR				0x3F8	//0xFE
#define TW6864_R_EP_REG_DATA				0x3FC	//0xFF
#define TW6864_R_DROP_FIELD_REG(idx)		(TW6864_R_DROP_FIELD_REG0+((idx)*4))
#define TW6864_R_SHSCALER_REG(idx)			(TW6864_R_SHSCALER_REG0+((idx)*4))
#define TW6864_R_VIDEO_SIZE_REG(idx)		(TW6864_R_VIDEO_SIZE_REG0+((idx)*4))
#define TW6864_R_VIDEO_SIZE_REG_F2(idx)		(TW6864_R_VIDEO_SIZE_REG0_F2+((idx)*4))
#define TW6864_R_BDMA(reg, idx)				((reg)+(idx)*0x20)

//////////////////////////////////////////////////
// external 2864 registers definitions
#define TW2864_R_I2C_ADDR0					0x50
#define TW2864_R_I2C_ADDR1					0x52
#define TW2864_R_VSTATUS_0					0x00
#define TW2864_R_VSTATUS_1					0x10
#define TW2864_R_VSTATUS_2					0x20
#define TW2864_R_VSTATUS_3					0x30
#define TW2864_R_VDELAY_0					0x08
#define TW2864_R_VDELAY_1					0x18
#define TW2864_R_VDELAY_2					0x28
#define TW2864_R_VDELAY_3					0x38
#define TW2864_R_HDELAY_0					0x0A
#define TW2864_R_HDELAY_1					0x1A
#define TW2864_R_HDELAY_2					0x2A
#define TW2864_R_HDELAY_3					0x3A
#define TW2864_R_STANDARD_0					0x0E
#define TW2864_R_STANDARD_1					0x1E
#define TW2864_R_STANDARD_2					0x2E
#define TW2864_R_STANDARD_3					0x3E
#define TW2864_R_CLK_SEL_2865				0x61 //specfic to TW2865
#define TW2864_R_VERTICAL_SHARPNESS			0x85
#define TW2864_R_VERTICAL_CTRL				0x8F
#define TW2864_R_LOOP_CTRL					0x95
#define TW2864_R_MISC_CONTROL2				0x96
#define TW2864_R_MPP_MODE0					0xC8
#define TW2864_R_MPP_MODE1					0xC9
#define TW2864_R_NOVID						0x9E
#define TW2864_R_CLKODEL					0x9F
#define TW2864_R_HFLT1						0xA8
#define TW2864_R_HFLT2						0xA9
#define TW2864_R_VIDEO_OUT_CTRL				0xCA
#define TW2864_R_SMD						0xCF
#define TW2864_R_MASTER_CTRL				0xDB
#define TW2864_R_AUDIO_GAIN0				0xD0
#define TW2864_R_AUDIO_GAIN1				0xD1
#define TW2864_R_NUM_ADUIOR					0xD2
#define TW2864_R_SEQ_ADUIOR					0xD7
#define TW2864_R_MIX_OUT_SEL				0xE0
#define TW2864_R_VSCALE_LO_0				0xE4
#define TW2864_R_VHSCALE_HI_0				0xE5
#define TW2864_R_HSCALE_LO_0				0xE6
#define TW2864_R_VSCALE_LO_1				0xE7
#define TW2864_R_VHSCALE_HI_1				0xE8
#define TW2864_R_HSCALE_LO_1				0xE9
#define TW2864_R_VSCALE_LO_2				0xEA
#define TW2864_R_VHSCALE_HI_2				0xEB
#define TW2864_R_HSCALE_LO_2				0xEC
#define TW2864_R_VSCALE_LO_3				0xED
#define TW2864_R_VHSCALE_HI_3				0xEE
#define TW2864_R_HSCALE_LO_3				0xEF
#define TW2864_R_VIDEO_MISC					0xF9
#define TW2864_R_CLKOCTRL					0xFA
#define TW2864_R_CLKOPOL					0xFB
#define TW2864_R_AVDET_ENA					0xFC
#define TW2864_R_AVDET_STATE				0xFD
#define TW2864_R_DEV_REV					0xFE
#define TW2864_R_CHANNEL(reg, ch)			((reg)+(ch)*0x10)

//0x01 0x11 0x21 0x31 BRIGHT BRIGHTNESS
#define TW2864_R_BRIGHT_0					0x01
#define TW2864_R_BRIGHT_1					0x11
#define TW2864_R_BRIGHT_2					0x21
#define TW2864_R_BRIGHT_3					0x31

//0x02 0x12 0x22 0x32 CONTRAST CONTRAST
#define TW2864_R_CONTRAST_0					0x02
#define TW2864_R_CONTRAST_1					0x12
#define TW2864_R_CONTRAST_2					0x22
#define TW2864_R_CONTRAST_3					0x32

//0x03 0x13 0x23 0x33 SHARPNESS SCURVE VSF CTI SHARPNESS
#define TW2864_R_SHARPNESS_0				0x03
#define TW2864_R_SHARPNESS_1				0x13
#define TW2864_R_SHARPNESS_2				0x23
#define TW2864_R_SHARPNESS_3				0x33

//0x04 0x14 0x24 0x34 SAT_U SAT_U
#define TW2864_R_SAT_U_0					0x04
#define TW2864_R_SAT_U_1					0x14
#define TW2864_R_SAT_U_2					0x24
#define TW2864_R_SAT_U_3					0x34

//0x05 0x15 0x25 0x35 SAT_V SAT_V
#define TW2864_R_SAT_V_0					0x05
#define TW2864_R_SAT_V_1					0x15
#define TW2864_R_SAT_V_2					0x25
#define TW2864_R_SAT_V_3					0x35

//0x06 0x16 0x26 0x36 HUE HUE
#define TW2864_R_HUE_0						0x06
#define TW2864_R_HUE_1						0x16
#define TW2864_R_HUE_2						0x26
#define TW2864_R_HUE_3						0x36

//////////////////////////////////////////////////
// internal 2864 registers definitions
#define TW6864_R_VSTATUS_0					0x400	//0x100
#define TW6864_R_VSTATUS_1					0x440	//0x110
#define TW6864_R_VSTATUS_2					0x480	//0x120
#define TW6864_R_VSTATUS_3					0x4C0	//0x130
#define TW6864_R_BRIGHT_0					0x404	//0x101
#define TW6864_R_BRIGHT_1					0x444	//0x111
#define TW6864_R_BRIGHT_2					0x484	//0x121
#define TW6864_R_BRIGHT_3					0x4C4	//0x131
#define TW6864_R_CONTRAST_0					0x408	//0x102
#define TW6864_R_CONTRAST_1					0x448	//0x112
#define TW6864_R_CONTRAST_2					0x488	//0x122
#define TW6864_R_CONTRAST_3					0x4C8	//0x132
#define TW6864_R_SHARPNESS_0				0x40C	//0x103
#define TW6864_R_SHARPNESS_1				0x44C	//0x113
#define TW6864_R_SHARPNESS_2				0x48C	//0x123
#define TW6864_R_SHARPNESS_3				0x4CC	//0x133
#define TW6864_R_SAT_U_0					0x410	//0x104
#define TW6864_R_SAT_U_1					0x450	//0x114
#define TW6864_R_SAT_U_2					0x490	//0x124
#define TW6864_R_SAT_U_3					0x4D0	//0x134
#define TW6864_R_SAT_V_0					0x414	//0x105
#define TW6864_R_SAT_V_1					0x454	//0x115
#define TW6864_R_SAT_V_2					0x494	//0x125
#define TW6864_R_SAT_V_3					0x4D4	//0x135
#define TW6864_R_HUE_0						0x418	//0x106
#define TW6864_R_HUE_1						0x458	//0x116
#define TW6864_R_HUE_2						0x498	//0x126
#define TW6864_R_HUE_3						0x4D8	//0x136
#define TW6864_R_CROPPING_0					0x41C	//0x107
#define TW6864_R_CROPPING_1					0x45C	//0x117
#define TW6864_R_CROPPING_2					0x49C	//0x127
#define TW6864_R_CROPPING_3					0x4DC	//0x137
#define TW6864_R_VDELAY_0					0x420	//0x108
#define TW6864_R_VDELAY_1					0x460	//0x118
#define TW6864_R_VDELAY_2					0x4A0	//0x128
#define TW6864_R_VDELAY_3					0x4E0	//0x138
#define TW6864_R_VACTIVE_0					0x424	//0x109
#define TW6864_R_VACTIVE_1					0x464	//0x119
#define TW6864_R_VACTIVE_2					0x4A4	//0x129
#define TW6864_R_VACTIVE_3					0x4E4	//0x139
#define TW6864_R_HDELAY_0					0x428	//0x10A
#define TW6864_R_HDELAY_1					0x468	//0x11A
#define TW6864_R_HDELAY_2					0x4A8	//0x12A
#define TW6864_R_HDELAY_3					0x4E8	//0x13A
#define TW6864_R_HACTIVE_0					0x46C	//0x10B
#define TW6864_R_HACTIVE_1					0x4AC	//0x11B
#define TW6864_R_HACTIVE_2					0x4EC	//0x12B
#define TW6864_R_HACTIVE_3					0x42C	//0x13B
#define TW6864_R_MACROVISION_0				0x430	//0x10C
#define TW6864_R_MACROVISION_1				0x470	//0x11C
#define TW6864_R_MACROVISION_2				0x4B0	//0x12C
#define TW6864_R_MACROVISION_3				0x4F0	//0x13C
#define TW6864_R_CHIPSTATUSII_0				0x434	//0x10D
#define TW6864_R_CHIPSTATUSII_1				0x474	//0x11D
#define TW6864_R_CHIPSTATUSII_2				0x4B4	//0x12D
#define TW6864_R_CHIPSTATUSII_3				0x4F4	//0x13D
#define TW6864_R_STANDARD_0					0x438	//0x10E
#define TW6864_R_STANDARD_1					0x478	//0x11E
#define TW6864_R_STANDARD_2					0x4B8	//0x12E
#define TW6864_R_STANDARD_3					0x4F8	//0x13E
#define TW6864_R_STDDETECT_0				0x43C	//0x10F
#define TW6864_R_STDDETECT_1				0x47C	//0x11F
#define TW6864_R_STDDETECT_2				0x4BC	//0x12F
#define TW6864_R_STDDETECT_3				0x4FC	//0x13F
#define TW6864_R_CROPPING_F2_0				0x51C	//0x147
#define TW6864_R_CROPPING_F2_1				0x55C	//0x157
#define TW6864_R_CROPPING_F2_2				0x59C	//0x167
#define TW6864_R_CROPPING_F2_3				0x5DC	//0x177
#define TW6864_R_VDELAY_F2_0				0x520	//0x148
#define TW6864_R_VDELAY_F2_1				0x560	//0x158
#define TW6864_R_VDELAY_F2_2				0x5A0	//0x168
#define TW6864_R_VDELAY_F2_3				0x5E0	//0x178
#define TW6864_R_VACTIVE_F2_0				0x524	//0x149
#define TW6864_R_VACTIVE_F2_1				0x564	//0x159
#define TW6864_R_VACTIVE_F2_2				0x5A4	//0x169
#define TW6864_R_VACTIVE_F2_3				0x5E4	//0x179
#define TW6864_R_HDELAY_F2_0				0x528	//0x14A
#define TW6864_R_HDELAY_F2_1				0x568	//0x15A
#define TW6864_R_HDELAY_F2_2				0x5A8	//0x16A
#define TW6864_R_HDELAY_F2_3				0x5E8	//0x17A
#define TW6864_R_HACTIVE_F2_0				0x52C	//0x14B
#define TW6864_R_HACTIVE_F2_1				0x56C	//0x15B
#define TW6864_R_HACTIVE_F2_2				0x5AC	//0x16B
#define TW6864_R_HACTIVE_F2_3				0x5EC	//0x17B
#define TW6864_R_VSCALE_LO_0				0x510	//0x144
#define TW6864_R_VHSCALE_HI_0				0x514	//0x145
#define TW6864_R_HSCALE_LO_0				0x518	//0x146
#define TW6864_R_VSCALE_LO_1				0x550	//0x154
#define TW6864_R_VHSCALE_HI_1				0x554	//0x155
#define TW6864_R_HSCALE_LO_1				0x558	//0x156
#define TW6864_R_VSCALE_LO_2				0x590	//0x164
#define TW6864_R_VHSCALE_HI_2				0x594	//0x165
#define TW6864_R_HSCALE_LO_2				0x598	//0x166
#define TW6864_R_VSCALE_LO_3				0x5D0	//0x174
#define TW6864_R_VHSCALE_HI_3				0x5D4	//0x175
#define TW6864_R_HSCALE_LO_3				0x5D8	//0x176
#define TW6864_R_VSCALE_LO_F2_0				0x530	//0x14C
#define TW6864_R_VHSCALE_HI_F2_0			0x534	//0x14D
#define TW6864_R_HSCALE_LO_F2_0				0x538	//0x14E
#define TW6864_R_VSCALE_LO_F2_1				0x570	//0x15C
#define TW6864_R_VHSCALE_HI_F2_1			0x574	//0x15D
#define TW6864_R_HSCALE_LO_F2_1				0x578	//0x15E
#define TW6864_R_VSCALE_LO_F2_2				0x5B0	//0x16C
#define TW6864_R_VHSCALE_HI_F2_2			0x5B4	//0x16D
#define TW6864_R_HSCALE_LO_F2_2				0x5B8	//0x16E
#define TW6864_R_VSCALE_LO_F2_3				0x5F0	//0x17C
#define TW6864_R_VHSCALE_HI_F2_3			0x5F4	//0x17D
#define TW6864_R_HSCALE_LO_F2_3				0x5F8	//0x17E
#define TW6864_R_F2_CNT_0					0x53C	//0x14F
#define TW6864_R_F2_CNT_1					0x57C	//0x15F
#define TW6864_R_F2_CNT_2					0x5BC	//0x16F
#define TW6864_R_F2_CNT_3					0x5FC	//0x17F
#define TW6864_R_AVSRST						0x600	//0x180
#define TW6864_R_COLORKILL_HY				0x610	//0x184
#define TW6864_R_VERTICAL_CTRL				0x63C	//0x18F
#define TW6864_R_LOOP_CTRL					0x654	//0x195
#define TW6864_R_MISC_CONTROL2				0x658	//0x196
#define TW6864_R_HFLT1						0x6A0	//0x1A8
#define TW6864_R_HFLT2						0x6A4	//0x1A9
#define TW6864_R_AUDIO_GAIN_0				0x740	//0x1D0
#define TW6864_R_AUDIO_GAIN_1				0x744	//0x1D1
#define TW6864_R_AUDIO_GAIN_2				0x748	//0x1D2
#define TW6864_R_AUDIO_GAIN_3				0x74C	//0x1D3

#define TW6864_R_VSTATUS(ch)				(TW6864_R_VSTATUS_0 + (ch)*0x40)
#define TW6864_R_BRIGHT(ch)					(TW6864_R_BRIGHT_0 + (ch)*0x40)
#define TW6864_R_CONTRAST(ch)				(TW6864_R_CONTRAST_0 + (ch)*0x40)
#define TW6864_R_SHARPNESS(ch)				(TW6864_R_SHARPNESS_0 + (ch)*0x40)
#define TW6864_R_SAT_U(ch)					(TW6864_R_SAT_U_0 + (ch)*0x40)
#define TW6864_R_SAT_V(ch)					(TW6864_R_SAT_V_0 + (ch)*0x40)
#define TW6864_R_HUE(ch)					(TW6864_R_HUE_0 + (ch)*0x40)
#define TW6864_R_CROPPING(ch)				(TW6864_R_CROPPING_0 + (ch)*0x40)
#define TW6864_R_VDELAY(ch)					(TW6864_R_VDELAY_0 + (ch)*0x40)
#define TW6864_R_VACTIVE(ch)				(TW6864_R_VACTIVE_0 + (ch)*0x40)
#define TW6864_R_HDELAY(ch)					(TW6864_R_HDELAY_0 + (ch)*0x40)
#define TW6864_R_HACTIVE(ch)				(TW6864_R_HACTIVE_0 + (ch)*0x40)
#define TW6864_R_CROPPING_F2(ch)			(TW6864_R_CROPPING_F2_0 + (ch)*0x40)
#define TW6864_R_VDELAY_F2(ch)				(TW6864_R_VDELAY_F2_0 + (ch)*0x40)
#define TW6864_R_VACTIVE_F2(ch)				(TW6864_R_VACTIVE_F2_0 + (ch)*0x40)
#define TW6864_R_HDELAY_F2(ch)				(TW6864_R_HDELAY_F2_0 + (ch)*0x40)
#define TW6864_R_HACTIVE_F2(ch)				(TW6864_R_HACTIVE_F2_0 + (ch)*0x40)
#define TW6864_R_MACROVISION(ch)			(TW6864_R_MACROVISION_0 + (ch)*0x40)
#define TW6864_R_CHIPSTATUSII(ch)			(TW6864_R_CHIPSTATUSII_0 + (ch)*0x40)
#define TW6864_R_STANDARD(ch)				(TW6864_R_STANDARD_0 + (ch)*0x40)
#define TW6864_R_STDDETECT(ch)				(TW6864_R_STDDETECT_0 + (ch)*0x40)
#define TW6864_R_CHANNEL(reg, ch)			((reg)+(ch)*0x40)

//////////////////////////////////////////////////
//NO NOT CHANGE
//These 3 definitions are matched with hardware
#define TW6864_MAX_NUM_SG_DMA				8
#define	TW6864_MAX_NUM_DATA_DMA				9
#define TW6864_MAX_NUM_DMA					(TW6864_MAX_NUM_SG_DMA+TW6864_MAX_NUM_DATA_DMA)

#define TW6864_VIDEO_GEN					0xFF  //1=External,0=internal
#define	TW6864_VIDEO_GEN_PATTERNS			0x00  //0=ColorBar, 1=SEQ DATA , 8-bit
#define TW6864_VIDEO_FORMAT_UYVY			0
#define TW6864_VIDEO_FORMAT_YUV420			1
#define TW6864_VIDEO_FORMAT_Y411			2  //Use VIDEO_FORMAT_IYU1 instead, LEAD does not accept this, even they are the same
#define TW6864_VIDEO_FORMAT_Y41P			3
#define TW6864_VIDEO_FORMAT_RGB555			4
#define TW6864_VIDEO_FORMAT_RGB565			5
#define TW6864_VIDEO_FORMAT_IYU1			0xA //same as VIDEO_FORMAT_Y411, m_nVideoFormat will be masked by 0x7
#define TW6864_VIDEO_FORMAT_YUYV			6  //YUYV=YUY2, only available for Rev.B or later
#define TW6864_VIDEO_FORMAT_UYVY_FRAME		0x8  //VideoInfoHeader2

#define TW6864_AUDIO_DMA_LENGTH				4096  //in bytes, should not > PAGE_SIZE(4096)
#define TW6864_AUDIO_GEN					1     //1=External,0=internal
#define	TW6864_AUDIO_GEN_PATTERN			0     //0=WAVE,1=SEQ DATA , 1-bit
#define TW6864_AUDIO_GEN_MIX_SEL			0     //(0~7)
#define TW6864_AUDIO_SAMPLE_RATE			8	  //in KHz
#define TW6864_AUDIO_SAMPLE_BIT				8	  //8bit or 16bit
#define TW6864_AUDIO_SAMP_RATE_INT			(125000/TW6864_AUDIO_SAMPLE_RATE)
#define TW6864_AUDIO_SAMP_RATE_EXT  		((((unsigned long long)125000)<<16)/TW6864_AUDIO_SAMPLE_RATE)

#endif // TW686XREG_H_INCLUDED
